/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.gui;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import sun.swing.SwingUtilities2;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class UtilitiesProxy {
    private static final Logger LOG = Logger.getLogger(UtilitiesProxy.class.getName());
    private static final Level DEBUG_LEVEL = Level.FINEST;
    private static final boolean DEBUG_LOG = LOG.isLoggable(DEBUG_LEVEL);

    private UtilitiesProxy() {
    }

    public static float getFontCharWidth(char c, FontMetrics fm, boolean useFPAPI) {
        return SwingUtilities2.getFontCharWidth(c, fm, useFPAPI);
    }

    public static float getFontCharsWidth(char[] chars, int offset, int length, FontMetrics fm, boolean useFPAPI) {
        float width = SwingUtilities2.getFontCharsWidth(chars, offset, length, fm, useFPAPI);
        UtilitiesProxy.debug("getFontCharsWidth", width);
        return width;
    }

    public static float drawChars(JComponent component, Graphics2D g, char[] txt, int flushIndex, int flushLen, float x, float y) {
        float width = SwingUtilities2.drawChars(component, (Graphics)g, txt, flushIndex, flushLen, x, y);
        UtilitiesProxy.debug("drawChars", width);
        return width;
    }

    public static float getTabbedTextWidth(Segment lineSegment, FontMetrics fm, float x, TabExpander tabExpander, int startOffset) {
        float width = Utilities.getTabbedTextWidth(lineSegment, fm, x, tabExpander, startOffset);
        UtilitiesProxy.debug("getTabbedTextWidth", width);
        return width;
    }

    private static void debug(String methodName, float result) {
        if (DEBUG_LOG) {
            LOG.log(DEBUG_LEVEL, String.format("%s(): %.2f", methodName, Float.valueOf(result)));
        }
    }
}

