-- Copyright (c) DbVis Software AB. All Rights Reserved.
/*
 A sample script to select some arbitrary numbers from the payments/rental data.
 Use for creating charts (etc).
*/ 
SELECT
    CATEGORY.NAME                                               AS "Category",  
    SUM(PAYMENT.AMOUNT)                                         AS "Total Paid",
    ROUND(AVG(PAYMENT.AMOUNT), 2)                               AS "Avg Paid",
    COUNT(DISTINCT RENTAL.RENTAL_ID)                            AS "Rentals",
    COUNT(DISTINCT FILM.FILM_ID)                                AS "Films",
    COUNT(DISTINCT PAYMENT.CUSTOMER_ID)                         AS "Customers",
    SUM(DATEDIFF(DAY, RENTAL.RENTAL_DATE, RENTAL.RETURN_DATE))  AS "Total Duration",
    AVG(DATEDIFF(DAY, RENTAL.RENTAL_DATE, RENTAL.RETURN_DATE))  AS "Avg Duration"
    FROM PAYMENT
        JOIN RENTAL ON PAYMENT.RENTAL_ID = RENTAL.RENTAL_ID
        JOIN INVENTORY ON RENTAL.INVENTORY_ID = INVENTORY.INVENTORY_ID
        JOIN FILM ON INVENTORY.FILM_ID = FILM.FILM_ID
        JOIN FILM_CATEGORY ON FILM_CATEGORY.FILM_ID = FILM.FILM_ID
        JOIN CATEGORY ON CATEGORY.CATEGORY_ID = FILM_CATEGORY.CATEGORY_ID

	GROUP BY CATEGORY.NAME ORDER BY CATEGORY.NAME;