/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc3;

import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.OrderType;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SDatabaseMetaData;
import com.vertica.jdbc.jdbc3.S3MetaDataProxy;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3DatabaseMetaData
extends SDatabaseMetaData {
    private static final Map<Long, String> STRING_FUNCTION_NAME_MAP = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = -962673552006335376L;
        {
            this.put(0L, null);
            this.put(8192L, "ASCII");
            this.put(524288L, "BIT_LENGTH");
            this.put(16384L, "CHAR");
            this.put(1L, "CONCAT");
            this.put(32768L, "DIFFERENCE");
            this.put(2L, "INSERT");
            this.put(64L, "LCASE");
            this.put(4L, "LEFT");
            this.put(16L, "LENGTH");
            this.put(32L, "LOCATE");
            this.put(65536L, "LOCATE2");
            this.put(8L, "LTRIM");
            this.put(128L, "REPEAT");
            this.put(256L, "REPLACE");
            this.put(512L, "RIGHT");
            this.put(1024L, "RTRIM");
            this.put(131072L, "SOUNDEX");
            this.put(262144L, "SPACE");
            this.put(2048L, "SUBSTRING");
            this.put(4096L, "UCASE");
        }
    };
    private static final Map<Long, String> TIME_FUNCTION_NAME_MAP = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = 8008545354937157107L;
        {
            this.put(0L, null);
            this.put(2L, "CURDATE");
            this.put(512L, "CURTIME");
            this.put(131072L, "CURRENT_DATE");
            this.put(262144L, "CURRENT_TIME");
            this.put(524288L, "CURRENT_TIMESTAMP");
            this.put(32768L, "DAYNAME");
            this.put(4L, "DAYOFMONTH");
            this.put(8L, "DAYOFWEEK");
            this.put(16L, "DAYOFYEAR");
            this.put(1024L, "HOUR");
            this.put(2048L, "MINUTE");
            this.put(32L, "MONTH");
            this.put(65536L, "MONTHNAME");
            this.put(1L, "NOW");
            this.put(64L, "QUARTER");
            this.put(4096L, "SECOND");
            this.put(8192L, "TIMESTAMPADD");
            this.put(16384L, "TIMESTAMPDIFF");
            this.put(128L, "WEEK");
            this.put(256L, "YEAR");
        }
    };
    private static final int JDBC_MAJOR_VERSION = 3;
    private static final int JDBC_MINOR_VERSION = 0;

    public S3DatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 3;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 0;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(104);
            return this.createListFromMap(STRING_FUNCTION_NAME_MAP, l);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(135);
            return this.createListFromMap(TIME_FUNCTION_NAME_MAP, l);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    protected synchronized ResultSet createMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = this.m_dataEngine.makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.JDBC_3);
            S3MetaDataProxy s3MetaDataProxy = new S3MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s3MetaDataProxy);
            return s3MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    protected synchronized ResultSet createNullMetaDataResult(MetadataSourceID metadataSourceID) throws SQLException {
        try {
            S3MetaDataProxy s3MetaDataProxy = new S3MetaDataProxy(this, null, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s3MetaDataProxy);
            return s3MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    protected synchronized ResultSet createUnorderedMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = this.m_dataEngine.makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.NONE);
            S3MetaDataProxy s3MetaDataProxy = new S3MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s3MetaDataProxy);
            return s3MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }
}

