/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.tree.TreePopupMenuCustomizer;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreePopupMenuInstaller
extends MouseAdapter {
    private JTree \u0102;
    public static final String CLIENT_PROPERTY_POPUP_MENU_INSTALLER = "TreePopupMenuInstaller";
    List<TreePopupMenuCustomizer> \u0101;

    public TreePopupMenuInstaller(JTree jTree) {
        this.\u0102 = jTree;
        this.installListeners();
    }

    public void addTreePopupMenuCustomizer(TreePopupMenuCustomizer treePopupMenuCustomizer) {
        if (this.\u0101 == null) {
            this.\u0101 = new ArrayList<TreePopupMenuCustomizer>();
        }
        this.\u0101.add(treePopupMenuCustomizer);
    }

    public void removeTreePopupMenuCustomizer(TreePopupMenuCustomizer treePopupMenuCustomizer) {
        if (this.\u0101 != null) {
            this.\u0101.remove(treePopupMenuCustomizer);
        }
    }

    public TreePopupMenuCustomizer[] getTreePopupMenuCustomizers() {
        return this.\u0101 != null ? this.\u0101.toArray(new TreePopupMenuCustomizer[this.\u0101.size()]) : new TreePopupMenuCustomizer[]{};
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.\u0101(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.\u0101(mouseEvent);
    }

    private void \u0101(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        if (!(mouseEvent.getComponent() instanceof JTree)) {
            return;
        }
        JTree jTree = (JTree)mouseEvent.getComponent();
        JPopupMenu jPopupMenu = this.createPopupMenu();
        TreePath[] treePathArray = this.getTargetTreePath(jTree, mouseEvent.getPoint());
        this.customizeMenuItems(jTree, jPopupMenu, treePathArray);
        if (jPopupMenu.getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jPopupMenu, jTree, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    protected void customizeMenuItems(JTree jTree, JPopupMenu jPopupMenu, TreePath[] treePathArray) {
        TreePopupMenuCustomizer[] treePopupMenuCustomizerArray;
        for (TreePopupMenuCustomizer treePopupMenuCustomizer : treePopupMenuCustomizerArray = this.getTreePopupMenuCustomizers()) {
            TableHeaderPopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            treePopupMenuCustomizer.customizePopupMenu(jTree, jPopupMenu, treePathArray);
        }
    }

    public void installListeners() {
        if (this.\u0102 != null) {
            this.\u0102.addMouseListener(this);
        }
        this.\u0101(this.\u0102, this);
    }

    public void uninstallListeners() {
        if (this.\u0102 != null) {
            this.\u0102.removeMouseListener(this);
        }
        this.\u0101(this.\u0102, null);
    }

    public static TreePopupMenuInstaller getTreePopupMenuInstaller(JTree jTree) {
        Object object = jTree.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
        if (object instanceof TreePopupMenuInstaller) {
            return (TreePopupMenuInstaller)object;
        }
        return null;
    }

    private void \u0101(JTree jTree, TreePopupMenuInstaller treePopupMenuInstaller) {
        if (jTree != null) {
            Object object = jTree.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
            if (object instanceof TreePopupMenuInstaller && object != this) {
                ((TreePopupMenuInstaller)object).uninstallListeners();
            }
            jTree.putClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER, treePopupMenuInstaller);
        }
    }

    protected TreePath[] getTargetTreePath(JTree jTree, Point point) {
        return jTree.getSelectionPaths();
    }

    public static void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n2 = jPopupMenu.getComponentCount();
        if (n2 > 0 && !(jPopupMenu.getComponent(n2 - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }
}

