/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.filter.AbstractFilter;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.GridResource;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.LabeledTextField;
import com.jidesoft.utils.DefaultWildcardSupport;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.WildcardSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class QuickFilterField
extends LabeledTextField {
    public static final String PROPERTY_SEARCH_TEXT = "searchText";
    public static final String PROPERTY_CASE_SENSITIVE = "caseSensitive";
    public static final String PROPERTY_WILDCARD_ENABLED = "wildcardEnabled";
    public static final String PROPERTY_REGEX_ENABLED = "regexEnabled";
    public static final String PROPERTY_FROM_START = "fromStart";
    public static final String PROPERTY_FROM_END = "fromEnd";
    private static Icon \u010e;
    private static Icon \u0113;
    private static Icon \u0112;
    private Icon \u0118;
    private Icon \u0111;
    private Icon \u0119;
    private boolean \u011a = false;
    private boolean \u0115 = false;
    private boolean \u0110 = false;
    protected Filter _filter;
    private int \u011b = 200;
    protected String _searchingText = "";
    private boolean \u011c = false;
    private boolean \u010d = false;
    private WildcardSupport \u0116 = null;
    private Color \u010f;
    private boolean \u0114 = false;
    private transient A \u0117;

    public QuickFilterField() {
        this.setIcon(this.getFilterIcon());
        this._filter = this.createFilter();
        this._textField.setOpaque(true);
    }

    public int getSearchingDelay() {
        return this.\u011b;
    }

    public void setSearchingDelay(int n2) {
        this.\u011b = n2;
    }

    @Override
    protected void initComponent() {
        super.initComponent();
        this.\u0117 = new A();
        this.installListeners();
        this.updateUI();
    }

    public void installListeners() {
        this.getTextField().getDocument().addDocumentListener(this.\u0117);
        this.getTextField().addActionListener(this.\u0117);
    }

    public void uninstallListeners() {
        this.getTextField().getDocument().removeDocumentListener(this.\u0117);
        this.getTextField().removeActionListener(this.\u0117);
    }

    public static Icon getDefaultResetIcon() {
        return \u010e;
    }

    public static void setDefaultResetIcon(Icon icon) {
        \u010e = icon;
    }

    public static Icon getDefaultFilterIcon() {
        return \u0112;
    }

    public static void setDefaultFilterIcon(Icon icon) {
        \u0112 = icon;
    }

    public static Icon getDefaultResetRolloverIcon() {
        return \u0113;
    }

    public static void setDefaultResetRolloverIcon(Icon icon) {
        \u0113 = icon;
    }

    public Icon getResetIcon() {
        return this.\u0118 == null ? \u010e : this.\u0118;
    }

    public void setResetIcon(Icon icon) {
        this.\u0118 = icon;
    }

    public Icon getResetRolloverIcon() {
        return this.\u0111 == null ? \u0113 : this.\u0111;
    }

    public void setResetRolloverIcon(Icon icon) {
        this.\u0111 = icon;
    }

    public Icon getFilterIcon() {
        return this.\u0119 == null ? \u0112 : this.\u0119;
    }

    public void setFilterIcon(Icon icon) {
        this.\u0119 = icon;
        this.setIcon(this.getFilterIcon());
    }

    @Override
    protected AbstractButton createButton() {
        JButton jButton = new JButton(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(QuickFilterField.this.getResetIcon().getIconWidth(), QuickFilterField.this.getResetIcon().getIconHeight());
            }

            @Override
            public void updateUI() {
                super.updateUI();
                this.setOpaque(false);
                this.setContentAreaFilled(false);
                this.setBorderPainted(false);
                this.setBorder(BorderFactory.createEmptyBorder());
            }
        };
        jButton.addActionListener(new AbstractAction(){
            private static final long \u0102 = -7589673856552696257L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuickFilterField.this._textField.setText("");
                if (QuickFilterField.this.getSearchingDelay() < 0) {
                    QuickFilterField.this.applyFilter();
                }
            }
        });
        jButton.setRequestFocusEnabled(false);
        jButton.setFocusable(false);
        return jButton;
    }

    protected Filter createFilter() {
        return new FieldFilter();
    }

    public Filter getFilter() {
        if (this._searchingText == null || this._searchingText.trim().length() == 0) {
            return null;
        }
        return this._filter;
    }

    @Override
    protected JidePopupMenu createContextMenu() {
        JidePopupMenu jidePopupMenu = super.createContextMenu();
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenuItem jMenuItem = jidePopupMenu.add(new JRadioButtonMenuItem(this.getResourceString("Filter.caseSensitive.text")));
        jMenuItem.setMnemonic(this.getResourceString("Filter.caseSensitive.mnemonic").charAt(0));
        jMenuItem.setName("Filter.caseSensitive");
        jMenuItem.setSelected(this.isCaseSensitive());
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long \u0102 = 6303911005445246594L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                QuickFilterField.this.setCaseSensitive(jMenuItem.isSelected());
            }
        });
        jMenuItem = jidePopupMenu.add(new JRadioButtonMenuItem(this.getResourceString("Filter.caseInsensitive.text")));
        jMenuItem.setMnemonic(this.getResourceString("Filter.caseInsensitive.mnemonic").charAt(0));
        jMenuItem.setName("Filter.caseInsensitive");
        jMenuItem.setSelected(!this.isCaseSensitive());
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long \u0102 = -6311946973791146482L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                QuickFilterField.this.setCaseSensitive(!jMenuItem.isSelected());
            }
        });
        jidePopupMenu.addSeparator();
        jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(this.getResourceString("Filter.useWildcards.text")));
        jMenuItem.setMnemonic(this.getResourceString("Filter.useWildcards.mnemonic").charAt(0));
        jMenuItem.setName("Filter.useWildcards");
        jMenuItem.setSelected(this.isWildcardEnabled());
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long \u0102 = -6039738571935407801L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                QuickFilterField.this.setWildcardEnabled(jMenuItem.isSelected());
            }
        });
        jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(this.getResourceString("Filter.useRegex.text")));
        jMenuItem.setMnemonic(this.getResourceString("Filter.useRegex.mnemonic").charAt(0));
        jMenuItem.setName("Filter.useRegex");
        jMenuItem.setSelected(this.isRegexEnabled());
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long \u0102 = -6899280132928742292L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                QuickFilterField.this.setRegexEnabled(jMenuItem.isSelected());
            }
        });
        jidePopupMenu.addSeparator();
        buttonGroup = new ButtonGroup();
        jMenuItem = jidePopupMenu.add(new JRadioButtonMenuItem(this.getResourceString("Filter.matchFromStart.text")));
        jMenuItem.setMnemonic(this.getResourceString("Filter.matchFromStart.mnemonic").charAt(0));
        jMenuItem.setName("Filter.matchFromStart");
        jMenuItem.setSelected(this.isFromStart() && !this.isFromEnd());
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long \u0102 = -6899280132928742292L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                QuickFilterField.this.setFromStart(jMenuItem.isSelected());
                QuickFilterField.this.setFromEnd(!jMenuItem.isSelected());
            }
        });
        jMenuItem = jidePopupMenu.add(new JRadioButtonMenuItem(this.getResourceString("Filter.matchExactly.text")));
        jMenuItem.setMnemonic(this.getResourceString("Filter.matchExactly.mnemonic").charAt(0));
        jMenuItem.setName("Filter.matchExactly");
        jMenuItem.setSelected(this.isFromStart() && this.isFromEnd());
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long \u0102 = 8104589917788738832L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                QuickFilterField.this.setFromStart(jMenuItem.isSelected());
                QuickFilterField.this.setFromEnd(jMenuItem.isSelected());
            }
        });
        jMenuItem = jidePopupMenu.add(new JRadioButtonMenuItem(this.getResourceString("Filter.matchAnywhere.text")));
        jMenuItem.setMnemonic(this.getResourceString("Filter.matchAnywhere.mnemonic").charAt(0));
        jMenuItem.setName("Filter.matchAnywhere");
        jMenuItem.setSelected(!this.isFromStart() && !this.isFromEnd());
        buttonGroup.add(jMenuItem);
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long \u0102 = 4377359184417347357L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                QuickFilterField.this.setFromStart(!jMenuItem.isSelected());
                QuickFilterField.this.setFromEnd(!jMenuItem.isSelected());
            }
        });
        return jidePopupMenu;
    }

    public abstract void applyFilter(String var1);

    public void applyFilter() {
        String string = this.getSearchingText();
        String string2 = this._searchingText;
        if (!"".equals(string2) || !"".equals(string)) {
            this._searchingText = string;
            if (this._filter != null && this._filter instanceof FieldFilter) {
                ((FieldFilter)this._filter).setSearchingText(this._searchingText);
            }
            this.applyFilter(string);
            if (this.isCaseSensitive() ? !JideSwingUtilities.equals(string2, string) : !JideSwingUtilities.equals(string2 == null ? null : string2.toLowerCase(), string == null ? null : string.toLowerCase())) {
                this.firePropertyChange(PROPERTY_SEARCH_TEXT, string2, string);
            }
        }
        this.setConfigurationChanged(false);
    }

    protected void setConfigurationChanged(boolean bl) {
        if (this._filter != null && this._filter instanceof FieldFilter) {
            ((FieldFilter)this._filter).setConfigureChanged(bl);
        }
    }

    protected boolean isConfigurationChanged() {
        return this._filter != null && this._filter instanceof FieldFilter && ((FieldFilter)this._filter).isConfigureChanged();
    }

    protected String convertElementToString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    protected boolean compare(Object object, String string) {
        String string2;
        if (string != null && !this.isCaseSensitive()) {
            string = string.toLowerCase();
        }
        return (string2 = this.convertElementToString(object)) != null && this.compare(this.isCaseSensitive() ? string2 : string2.toLowerCase(), string);
    }

    public boolean matches(Object object, String string) {
        return this.compare(object, string);
    }

    protected boolean compare(String string, String string2) {
        String string3;
        Object object;
        if (string2 == null || string2.trim().length() == 0) {
            return true;
        }
        if (!this.isCaseSensitive()) {
            string2 = string2.toLowerCase();
        }
        if (!this.isWildcardEnabled() && !this.isRegexEnabled()) {
            return this.isFromStart() ? (this.isFromEnd() ? string.equals(string2) : string.startsWith(string2)) : (this.isFromEnd() ? string.endsWith(string2) : string.indexOf(string2) != -1);
        }
        if (this.isWildcardEnabled()) {
            object = this.getWildcardSupport();
            string3 = object.convert(string2);
            if (string2.equals(string3)) {
                return this.isFromStart() ? (this.isFromEnd() ? string.equals(string2) : string.startsWith(string2)) : (this.isFromEnd() ? string.endsWith(string2) : string.indexOf(string2) != -1);
            }
        } else {
            string3 = string2;
        }
        if (this.isFromStart() && !string3.startsWith("^")) {
            string3 = "^" + string3;
        }
        if (this.isFromEnd() && !string3.endsWith("$")) {
            string3 = string3 + "$";
        }
        try {
            object = Pattern.compile(string3, this.isCaseSensitive() ? 0 : 2);
            return ((Pattern)object).matcher(string).find();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public boolean isCaseSensitive() {
        return this.\u011a;
    }

    public void setCaseSensitive(boolean bl) {
        if (this.\u011a != bl) {
            boolean bl2 = this.\u011a;
            this.\u011a = bl;
            if (this._searchingText != null && this._searchingText.length() != 0) {
                this.setConfigurationChanged(true);
                this.applyFilter();
            }
            this.firePropertyChange(PROPERTY_CASE_SENSITIVE, bl2, this.\u011a);
        }
    }

    public boolean isFromStart() {
        return this.\u0115;
    }

    public void setFromStart(boolean bl) {
        if (this.\u0115 != bl) {
            boolean bl2 = this.\u0115;
            this.\u0115 = bl;
            if (this._searchingText != null && this._searchingText.length() != 0) {
                this.setConfigurationChanged(true);
                this.applyFilter();
            }
            this.firePropertyChange(PROPERTY_FROM_START, bl2, this.\u0115);
        }
    }

    public boolean isFromEnd() {
        return this.\u0110;
    }

    public void setFromEnd(boolean bl) {
        if (this.\u0110 != bl) {
            boolean bl2 = this.\u0110;
            this.\u0110 = bl;
            if (this._searchingText != null && this._searchingText.length() != 0) {
                this.setConfigurationChanged(true);
                this.applyFilter();
            }
            this.firePropertyChange(PROPERTY_FROM_END, bl2, this.\u0110);
        }
    }

    public void setSearchingText(String string) {
        if (this.getTextField() != null) {
            this.getTextField().setText(string);
        }
    }

    public String getSearchingText() {
        if (this.getTextField() != null) {
            return this.getTextField().getText().trim();
        }
        return "";
    }

    public String getResourceString(String string) {
        if (string == null || string.startsWith("Lucene")) {
            return "";
        }
        return GridResource.getResourceBundle(this.getLocale()).getString(string);
    }

    public boolean isWildcardEnabled() {
        return this.\u010d;
    }

    public void setWildcardEnabled(boolean bl) {
        if (this.\u010d != bl) {
            boolean bl2 = this.\u010d;
            this.\u010d = bl;
            if (this.\u010d) {
                this.setRegexEnabled(false);
            }
            if (this._searchingText != null && this._searchingText.length() != 0) {
                this.setConfigurationChanged(true);
                this.applyFilter();
            }
            this.firePropertyChange(PROPERTY_WILDCARD_ENABLED, bl2, this.\u010d);
        }
    }

    public boolean isRegexEnabled() {
        return this.\u011c;
    }

    public void setRegexEnabled(boolean bl) {
        if (this.\u011c == bl) {
            return;
        }
        boolean bl2 = this.\u011c;
        this.\u011c = bl;
        if (this.\u011c) {
            this.setWildcardEnabled(false);
        }
        if (this._searchingText != null && this._searchingText.length() != 0) {
            this.setConfigurationChanged(true);
            this.applyFilter();
        }
        this.firePropertyChange(PROPERTY_REGEX_ENABLED, bl2, this.\u011c);
    }

    public WildcardSupport getWildcardSupport() {
        if (this.\u0116 == null) {
            this.\u0116 = new DefaultWildcardSupport();
        }
        return this.\u0116;
    }

    public void setWildcardSupport(WildcardSupport wildcardSupport) {
        if (this.\u0116 != wildcardSupport) {
            this.\u0116 = wildcardSupport;
            if (this.isWildcardEnabled() && this._searchingText != null && this._searchingText.length() != 0) {
                this.setConfigurationChanged(true);
                this.applyFilter();
            }
        }
    }

    protected void adjustMismatchColor(boolean bl) {
        if (this.isShowMismatchColor()) {
            if (!bl) {
                this._textField.setForeground(this.getMismatchColor());
            } else {
                this._textField.setForeground(UIDefaultsLookup.getColor("TextField.foreground"));
            }
        }
    }

    public Color getMismatchColor() {
        if (this.\u010f == null) {
            return Color.RED;
        }
        return this.\u010f;
    }

    public void setMismatchColor(Color color) {
        this.\u010f = color;
    }

    public boolean isShowMismatchColor() {
        return this.\u0114;
    }

    public void setShowMismatchColor(boolean bl) {
        this.\u0114 = bl;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(QuickFilterField.class.getName(), 4);
        }
        \u010e = IconsFactory.getImageIcon(QuickFilterField.class, "icons/quick_search_reset.png");
        \u0113 = null;
        \u0112 = IconsFactory.getImageIcon(QuickFilterField.class, "icons/quick_search.png");
    }

    public class FieldFilter
    extends AbstractFilter {
        private String \u0458;
        private boolean \u0459;
        private static final long \u045a = -1160749245490637145L;

        public String getSearchingText() {
            return this.\u0458;
        }

        public void setSearchingText(String string) {
            this.\u0458 = string;
        }

        public boolean isConfigureChanged() {
            return this.\u0459;
        }

        public void setConfigureChanged(boolean bl) {
            this.\u0459 = bl;
        }

        @Override
        public boolean isValueFiltered(Object object) {
            return !QuickFilterField.this.compare(object, this.\u0458);
        }

        @Override
        public boolean stricterThan(Filter filter) {
            if (this.isConfigureChanged()) {
                return false;
            }
            if (QuickFilterField.this.isWildcardEnabled()) {
                return false;
            }
            if (QuickFilterField.this.isRegexEnabled()) {
                return false;
            }
            if (this.getClass() != filter.getClass()) {
                return false;
            }
            String string = ((FieldFilter)filter).getSearchingText();
            if (string == null) {
                return true;
            }
            if (this.getSearchingText() == null) {
                return false;
            }
            int n2 = this.getSearchingText().indexOf(string);
            if (n2 < 0) {
                return false;
            }
            if (n2 == 0) {
                return true;
            }
            String string2 = this.getSearchingText().substring(0, n2);
            return !string2.contains("*");
        }
    }

    private class A
    implements DocumentListener,
    ActionListener {
        private Timer \u0102;

        private A() {
            this.\u0102 = new Timer(QuickFilterField.this.getSearchingDelay(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QuickFilterField.this.applyFilter();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.\u0102 != null) {
                this.\u0102.stop();
            }
            QuickFilterField.this.applyFilter();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.\u0101();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.\u0101();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.\u0101();
        }

        void \u0101() {
            if (QuickFilterField.this._button != null) {
                QuickFilterField.this._button.setIcon(QuickFilterField.this.getSearchingText().length() == 0 ? null : QuickFilterField.this.getResetIcon());
                QuickFilterField.this._button.setRolloverIcon(QuickFilterField.this.getSearchingText().length() == 0 ? null : QuickFilterField.this.getResetRolloverIcon());
            }
            if (QuickFilterField.this.getSearchingDelay() > 0) {
                this.\u0102.setInitialDelay(QuickFilterField.this.getSearchingDelay());
                if (this.\u0102.isRunning()) {
                    this.\u0102.restart();
                } else {
                    this.\u0102.setRepeats(false);
                    this.\u0102.start();
                }
            } else if (QuickFilterField.this.getSearchingDelay() == 0) {
                QuickFilterField.this.applyFilter();
            }
        }
    }
}

