/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.style;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.PointShape;
import com.jidesoft.chart.style.BarStyle;
import com.jidesoft.chart.style.LineFillExtent;
import com.jidesoft.chart.style.LineStyle;
import com.jidesoft.chart.style.PieStyle;
import com.jidesoft.chart.style.PointStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

public class ChartStyle {
    public static final ChartStyle DEFAULT_STYLE = new ChartStyle(Color.black, PointShape.DISC, 5).withPointsAndLines();
    private boolean \u0105 = true;
    private boolean \u0104 = true;
    private boolean \u0107 = false;
    private PointStyle \u0106 = new PointStyle();
    private LineStyle \u0101 = new LineStyle();
    private BarStyle \u0103 = new BarStyle();
    private PieStyle \u0102 = new PieStyle();

    public ChartStyle() {
        this.setPointsVisible(false);
    }

    public ChartStyle(ChartStyle chartStyle) {
        if (chartStyle == null) {
            chartStyle = new ChartStyle(Color.black, false, true);
        }
        this.setPointsVisible(chartStyle.isPointsVisible());
        this.setLinesVisible(chartStyle.isLinesVisible());
        this.setBarsVisible(chartStyle.isBarsVisible());
        this.setLineWidth(chartStyle.getLineWidth());
        this.setLineColor(chartStyle.getLineColor());
        this.setLineFill(chartStyle.getLineFill());
        this.setPointSize(chartStyle.getPointSize());
        this.setPointColor(chartStyle.getPointColor());
        this.setPointShape(chartStyle.getPointShape());
        this.setBarColor(chartStyle.getBarColor());
        this.setBarWidth(chartStyle.getBarWidth());
        this.setBarWidthProportion(chartStyle.getBarWidthProportion());
        this.setPieSegmentsAlwaysExploded(chartStyle.isPieSegmentsAlwaysExploded());
    }

    public ChartStyle(Color color) {
        this.setPointColor(color);
        this.setLineColor(color);
        this.setBarColor(color);
        this.setLinesVisible(true);
        this.setPointsVisible(false);
        this.setBarsVisible(false);
    }

    public ChartStyle(Color color, PointShape pointShape) {
        this.setPointColor(color);
        this.setLineColor(color);
        this.setLinesVisible(false);
        this.setPointsVisible(true);
        this.setPointShape(pointShape);
    }

    public ChartStyle(Color color, PointShape pointShape, int n2) {
        this.setPointColor(color);
        this.setLineColor(color);
        this.setLinesVisible(false);
        this.setPointsVisible(true);
        this.setPointSize(n2);
        this.setPointShape(pointShape);
    }

    public ChartStyle(Color color, boolean bl, boolean bl2) {
        this.setPointColor(color);
        this.setLineColor(color);
        this.setBarColor(color);
        this.setPointsVisible(bl);
        this.setLinesVisible(bl2);
    }

    public ChartStyle(Color color, boolean bl, boolean bl2, boolean bl3) {
        this.setPointColor(color);
        this.setLineColor(color);
        this.setBarColor(color);
        this.setPointsVisible(bl);
        this.setLinesVisible(bl2);
        this.setBarsVisible(bl3);
    }

    public ChartStyle(Color color, PointShape pointShape, Color color2) {
        this.setPointColor(color);
        this.setLineColor(color2);
        this.setLinesVisible(true);
        this.setPointsVisible(true);
        this.setPointShape(pointShape);
        this.setPointShape(pointShape);
    }

    public ChartStyle withPoints() {
        this.setPointsVisible(true);
        this.setLinesVisible(false);
        this.setBarsVisible(false);
        return this;
    }

    public ChartStyle withLines() {
        this.setPointsVisible(false);
        this.setLinesVisible(true);
        this.setBarsVisible(false);
        return this;
    }

    public ChartStyle withLineFill(Paint paint) {
        this.setLinesVisible(true);
        this.setLineFill(paint);
        return this;
    }

    public ChartStyle withNothing() {
        this.setPointsVisible(false);
        this.setLinesVisible(false);
        this.setBarsVisible(false);
        return this;
    }

    public ChartStyle withBars() {
        this.setPointsVisible(false);
        this.setLinesVisible(false);
        this.setBarsVisible(true);
        return this;
    }

    public ChartStyle withBars(Paint paint) {
        this.setPointsVisible(false);
        this.setLinesVisible(false);
        this.setBarsVisible(true);
        this.setBarPaint(paint);
        return this;
    }

    public ChartStyle withPointsAndLines() {
        this.setPointsVisible(true);
        this.setLinesVisible(true);
        this.setBarsVisible(false);
        return this;
    }

    @XmlTransient
    public Color getPointColor() {
        return this.\u0106.getColor();
    }

    public void setPointColor(Color color) {
        this.\u0106.setColor(color);
    }

    @XmlTransient
    public int getPointSize() {
        return this.\u0106.getSize();
    }

    public void setPointSize(int n2) {
        this.\u0106.setSize(n2);
    }

    @XmlTransient
    public PointShape getPointShape() {
        return this.\u0106.getShape();
    }

    public void setPointShape(PointShape pointShape) {
        this.\u0106.setShape(pointShape);
    }

    @XmlTransient
    public Color getLineColor() {
        return this.\u0101.getColor();
    }

    public void setLineColor(Color color) {
        this.\u0101.setColor(color);
    }

    @XmlAttribute
    public boolean isLinesVisible() {
        return this.\u0105;
    }

    public void setLinesVisible(boolean bl) {
        this.\u0105 = bl;
    }

    @XmlAttribute
    public boolean isPointsVisible() {
        return this.\u0104;
    }

    public void setPointsVisible(boolean bl) {
        this.\u0104 = bl;
    }

    @XmlTransient
    public boolean isBarVisible() {
        return this.\u0107;
    }

    @XmlAttribute
    public boolean isBarsVisible() {
        return this.\u0107;
    }

    public void setBarVisible(boolean bl) {
        this.\u0107 = bl;
    }

    public void setBarsVisible(boolean bl) {
        this.\u0107 = bl;
    }

    @XmlTransient
    public Color getBarColor() {
        return this.\u0103.getColor();
    }

    @XmlTransient
    public Paint getBarPaint() {
        return this.\u0103.getPaint();
    }

    public void setBarColor(Color color) {
        this.\u0103.setColor(color);
    }

    public void setBarPaint(Paint paint) {
        this.\u0103.setPaint(paint);
    }

    public Integer getBarWidth() {
        return this.\u0103.getBarWidth();
    }

    public void setBarWidth(Integer n2) {
        this.\u0103.setBarWidth(n2);
    }

    public Double getBarWidthProportion() {
        return this.\u0103.getBarWidthProportion();
    }

    public void setBarWidthProportion(Double d2) {
        this.\u0103.setBarWidthProportion(d2);
    }

    @XmlTransient
    public PointShape getShape() {
        return this.\u0106.getShape();
    }

    public void setShape(PointShape pointShape) {
        this.\u0106.setShape(pointShape);
    }

    public LineStyle getLineStyle() {
        return this.\u0101;
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.\u0101 = lineStyle;
    }

    public BarStyle getBarStyle() {
        return this.\u0103;
    }

    public void setBarStyle(BarStyle barStyle) {
        this.\u0103 = barStyle;
    }

    public Paint getLinePaint() {
        return this.getLineFill();
    }

    @XmlTransient
    public Paint getLineFill() {
        if (this.\u0101 == null) {
            return null;
        }
        return this.\u0101.getFill();
    }

    public void setLineFill(Paint paint) {
        if (this.\u0101 == null) {
            this.\u0101 = new LineStyle();
        }
        this.\u0101.setFill(paint);
    }

    public Orientation getLineFillOrientation() {
        if (this.\u0101 == null) {
            return null;
        }
        return this.\u0101.getFillOrientation();
    }

    public void setLineFillOrientation(Orientation orientation) {
        if (this.\u0101 == null) {
            this.\u0101 = new LineStyle();
        }
        this.\u0101.setFillOrientation(orientation);
    }

    public LineFillExtent getLineFillExtent() {
        if (this.\u0101 == null) {
            return null;
        }
        return this.\u0101.getFillExtent();
    }

    public void setLineFillExtent(LineFillExtent lineFillExtent) {
        if (this.\u0101 == null) {
            this.\u0101 = new LineStyle();
        }
        this.\u0101.setFillExtent(lineFillExtent);
    }

    @XmlTransient
    public int getLineWidth() {
        if (this.\u0101 == null) {
            return 1;
        }
        return this.\u0101.getWidth();
    }

    public void setLineWidth(int n2) {
        if (this.\u0101 == null) {
            this.\u0101 = new LineStyle(n2);
        } else {
            this.\u0101.setWidth(n2);
        }
    }

    public void setLineStroke(BasicStroke basicStroke) {
        if (this.\u0101 == null) {
            this.\u0101 = new LineStyle(basicStroke);
        } else {
            this.\u0101.setStroke(basicStroke);
        }
    }

    @XmlTransient
    public BasicStroke getLineStroke() {
        if (this.\u0101 == null) {
            return LineStyle.DEFAULT_STROKE;
        }
        return this.\u0101.getStroke();
    }

    public PointStyle getPointStyle() {
        return this.\u0106;
    }

    public void setPointStyle(PointStyle pointStyle) {
        this.\u0106 = pointStyle;
    }

    @XmlTransient
    public Orientation getBarOrientation() {
        return this.\u0103.getOrientation();
    }

    public void setBarOrientation(Orientation orientation) {
        this.\u0103.setOrientation(orientation);
    }

    public float getPieOffsetAngle() {
        return this.\u0102.getOffsetAngle();
    }

    public void setPieOffsetAngle(float f2) {
        this.\u0102.setOffsetAngle(f2);
    }

    public float getPieExplosionRatio() {
        return this.\u0102.getExplosionRatio();
    }

    public void setPieExplosionRatio(float f2) {
        this.\u0102.setExplosionRatio(f2);
    }

    public void setPieSegmentsAlwaysExploded(boolean bl) {
        this.\u0102.setAlwaysExplodeSegments(bl);
    }

    public boolean isPieSegmentsAlwaysExploded() {
        return this.\u0102.isAlwaysExplodeSegments();
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.\u0103 == null ? 0 : this.\u0103.hashCode());
        n2 = 31 * n2 + (this.\u0107 ? 1231 : 1237);
        n2 = 31 * n2 + (this.\u0101 == null ? 0 : this.\u0101.hashCode());
        n2 = 31 * n2 + (this.\u0105 ? 1231 : 1237);
        n2 = 31 * n2 + (this.\u0106 == null ? 0 : this.\u0106.hashCode());
        n2 = 31 * n2 + (this.\u0104 ? 1231 : 1237);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChartStyle chartStyle = (ChartStyle)object;
        if (this.\u0103 == null ? chartStyle.\u0103 != null : !this.\u0103.equals(chartStyle.\u0103)) {
            return false;
        }
        if (this.\u0107 != chartStyle.\u0107) {
            return false;
        }
        if (this.\u0101 == null ? chartStyle.\u0101 != null : !this.\u0101.equals(chartStyle.\u0101)) {
            return false;
        }
        if (this.\u0105 != chartStyle.\u0105) {
            return false;
        }
        if (this.\u0106 == null ? chartStyle.\u0106 != null : !this.\u0106.equals(chartStyle.\u0106)) {
            return false;
        }
        return this.\u0104 == chartStyle.\u0104;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("#<ChartStyle ");
        stringBuilder.append("pointsVisible=");
        stringBuilder.append(this.\u0104);
        stringBuilder.append(" pointStyle= ");
        stringBuilder.append(this.\u0106);
        stringBuilder.append(" linesVisible=");
        stringBuilder.append(this.\u0105);
        stringBuilder.append(" lineStyle=");
        stringBuilder.append(this.\u0101);
        stringBuilder.append(" barVisible=");
        stringBuilder.append(this.\u0107);
        stringBuilder.append(" barStyle=");
        stringBuilder.append(this.\u0103);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

