/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.AnnotatedChartModelAdapter;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelIterator;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractDelegatingChartModel
implements AnnotatedChartModel,
ChartModelListener {
    private static AtomicInteger \u0198;
    private String \u0195;
    private List<AnnotatedChartModel> \u0196 = new ArrayList<AnnotatedChartModel>();
    private final CopyOnWriteArrayList<ChartModelListener> \u0197 = new CopyOnWriteArrayList();

    public AbstractDelegatingChartModel() {
        this.\u0196 = new ArrayList<AnnotatedChartModel>();
        this.init();
    }

    public AbstractDelegatingChartModel(ChartModel ... chartModelArray) {
        this.setDelegates(chartModelArray);
        this.init();
    }

    public AbstractDelegatingChartModel(Collection<ChartModel> collection) {
        this.setDelegates(collection, true);
        this.init();
    }

    static Highlight \u0103(List<Highlight> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Highlight highlight = list.get(0);
        for (int i2 = 1; i2 < list.size(); ++i2) {
            if (!(highlight == null ? list.get(i2) != null : !highlight.equals(list.get(i2)))) continue;
            return null;
        }
        return highlight;
    }

    protected void init() {
        int n2 = \u0198.incrementAndGet();
        this.\u0195 = this.getClass().getName() + "@" + Integer.toHexString(n2);
    }

    @Override
    public abstract int getAnnotationCount();

    @Override
    public abstract Annotation getAnnotation(int var1);

    @Override
    public abstract Chartable getPoint(int var1);

    @Override
    public abstract int getPointCount();

    protected abstract void update();

    @Override
    public String getName() {
        return this.\u0195;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("Cannot set the name of a ChartModel to null");
        }
        this.\u0195 = string;
    }

    public AnnotatedChartModel getDelegate() {
        AnnotatedChartModel[] annotatedChartModelArray = this.getDelegates();
        if (annotatedChartModelArray.length > 0) {
            return annotatedChartModelArray[0];
        }
        return null;
    }

    public AnnotatedChartModel getDelegate(int n2) {
        return this.\u0196.get(n2);
    }

    public AnnotatedChartModel[] getDelegates() {
        return this.\u0196.toArray(new AnnotatedChartModel[this.\u0196.size()]);
    }

    public void setDelegate(ChartModel chartModel) {
        this.setDelegates(chartModel);
    }

    public void setDelegates(Collection<ChartModel> collection, boolean bl) {
        if (this.\u0196 == null) {
            this.\u0196 = new ArrayList<AnnotatedChartModel>();
        } else {
            for (ChartModel chartModel : this.\u0196) {
                if (chartModel == null) continue;
                chartModel.removeChartModelListener(this);
            }
            this.\u0196.clear();
        }
        if (collection != null) {
            for (ChartModel chartModel : collection) {
                if (chartModel instanceof AnnotatedChartModel) {
                    this.\u0196.add((AnnotatedChartModel)chartModel);
                    continue;
                }
                AnnotatedChartModelAdapter annotatedChartModelAdapter = new AnnotatedChartModelAdapter(chartModel);
                this.\u0196.add(annotatedChartModelAdapter);
            }
        }
        if (this.\u0196 != null && bl) {
            for (ChartModel chartModel : this.\u0196) {
                if (chartModel == null) continue;
                chartModel.addChartModelListener(this);
            }
        }
        this.update();
    }

    public void setDelegates(ChartModel ... chartModelArray) {
        if (this.\u0196 == null) {
            this.\u0196 = new ArrayList<AnnotatedChartModel>();
        } else {
            for (ChartModel chartModel : this.\u0196) {
                if (chartModel == null) continue;
                chartModel.removeChartModelListener(this);
            }
            this.\u0196.clear();
        }
        if (chartModelArray != null) {
            for (ChartModel chartModel : chartModelArray) {
                if (chartModel instanceof AnnotatedChartModel) {
                    this.\u0196.add((AnnotatedChartModel)chartModel);
                    continue;
                }
                AnnotatedChartModelAdapter annotatedChartModelAdapter = new AnnotatedChartModelAdapter(chartModel);
                this.\u0196.add(annotatedChartModelAdapter);
            }
        }
        if (this.\u0196 != null) {
            for (ChartModel chartModel : this.\u0196) {
                if (chartModel == null) continue;
                chartModel.addChartModelListener(this);
            }
        }
        this.update();
    }

    @Override
    public boolean isCyclical() {
        return false;
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        this.\u0197.addIfAbsent(chartModelListener);
        if (!this.\u0197.contains(chartModelListener)) {
            this.\u0197.add(chartModelListener);
        }
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.\u0197.remove(chartModelListener);
    }

    protected void fireModelChanged() {
        for (ChartModelListener chartModelListener : this.\u0197) {
            chartModelListener.chartModelChanged();
        }
    }

    @Override
    public void chartModelChanged() {
        this.update();
        this.fireModelChanged();
    }

    @Override
    public Iterator<Chartable> iterator() {
        return new ChartModelIterator(this);
    }

    public int hashCode() {
        int n2 = this.getDelegate() == null ? 1 : this.getDelegate().hashCode();
        n2 = 31 * n2 + (this.\u0195 == null ? 0 : this.\u0195.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractDelegatingChartModel abstractDelegatingChartModel = (AbstractDelegatingChartModel)object;
        return !(this.\u0195 == null ? abstractDelegatingChartModel.\u0195 != null : !this.\u0195.equals(abstractDelegatingChartModel.\u0195));
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(AbstractDelegatingChartModel.class.getName(), 4096);
        }
        \u0198 = new AtomicInteger(0);
    }
}

