/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.table;

import de.javasoft.swing.table.AbstractTableCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SliderTableCellEditor
extends AbstractTableCellEditor<JSlider> {
    public SliderTableCellEditor(TableCellEditor tableCellEditor) {
        super(tableCellEditor);
    }

    @Override
    public JSlider createEditorComponent() {
        JSlider jSlider = new JSlider();
        jSlider.putClientProperty("Synthetica.paintFocus", false);
        return jSlider;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.setCellEditorValue(object);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add(this.editorComponent);
        jPanel.setBorder(this.getEditorComponentBorder(jTable, object, bl, n, n2));
        ((JSlider)this.editorComponent).setBounds(jTable.getCellRect(n, n2, false));
        ((JSlider)this.editorComponent).updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((JSlider)SliderTableCellEditor.this.editorComponent).requestFocusInWindow();
            }
        });
        return jPanel;
    }

    @Override
    public void setCellEditorValue(Object object) {
        this.modelDriven = object instanceof BoundedRangeModel;
        DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel();
        if (this.modelDriven) {
            BoundedRangeModel boundedRangeModel = (BoundedRangeModel)object;
            defaultBoundedRangeModel.setRangeProperties(boundedRangeModel.getValue(), boundedRangeModel.getExtent(), boundedRangeModel.getMinimum(), boundedRangeModel.getMaximum(), false);
        } else {
            BoundedRangeModel boundedRangeModel = ((JSlider)this.editorComponent).getModel();
            defaultBoundedRangeModel.setRangeProperties((Integer)object, boundedRangeModel.getExtent(), boundedRangeModel.getMinimum(), boundedRangeModel.getMaximum(), false);
        }
        ((JSlider)this.editorComponent).setModel(defaultBoundedRangeModel);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.modelDriven) {
            return ((JSlider)this.editorComponent).getModel();
        }
        return ((JSlider)this.editorComponent).getValue();
    }
}

