/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.monitor;

import com.ibm.db2.cmx.internal.core.CMXConnection;
import com.ibm.db2.cmx.internal.core.JSONHelper;
import com.ibm.db2.cmx.internal.core.LogLookupInfo;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.core.ProcessingException;
import com.ibm.db2.cmx.internal.core.Processor;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.server.DatabaseNotRegisteredException;
import com.ibm.db2.cmx.server.EventHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MonitorProcessorAS
implements Processor {
    public int minClientLevel_ = 1;
    public int maxClientLevel_ = this.getVersion();
    private static Logger logger__ = Log.getCMXServerLogger();
    EventHandler eventHandler_ = null;

    MonitorProcessorAS(int n2, int n3) {
        this.minClientLevel_ = n2;
        this.maxClientLevel_ = n3;
    }

    @Override
    public void processAsynchronousMessage(Message message, CMXConnection cMXConnection) throws Exception {
        block14: {
            try {
                int n2 = -1;
                JSONArray jSONArray = JSONHelper.convertJSONByteBuffer(message);
                String string = jSONArray.get(0).toString();
                if (string.equals("peri")) {
                    String string2 = cMXConnection.getUID();
                    String string3 = cMXConnection.getUrl();
                    JSONArray jSONArray2 = null;
                    if (this.eventHandler_ == null) {
                        return;
                    }
                    int n3 = cMXConnection.getNegotiatedProcessorVersion("Monitor");
                    if (n3 >= 4) {
                        n2 = ((Number)jSONArray.get(1)).intValue();
                        jSONArray2 = (JSONArray)jSONArray.get(2);
                    } else {
                        jSONArray2 = (JSONArray)jSONArray.get(1);
                    }
                    Object[] objectArray = n3 == 7 ? this.convertJSONtoObjectArrayHack(jSONArray2) : this.convertJSONtoObjectArray(jSONArray2);
                    try {
                        if (n3 >= 4) {
                            this.eventHandler_.handleEvent(n2, string2, string3, n3, objectArray);
                            break block14;
                        }
                        this.eventHandler_.handleEvent(string2, string3, n3, objectArray);
                    }
                    catch (DatabaseNotRegisteredException databaseNotRegisteredException) {
                        if (logger__.isLoggable(Level.FINEST)) {
                            DataLogger.logTrappedMonitoringException(logger__, this, "processAsynchronousMessage", databaseNotRegisteredException, "closing connection: " + cMXConnection);
                        }
                        try {
                            cMXConnection.close();
                            break block14;
                        }
                        catch (Throwable throwable) {
                            if (logger__.isLoggable(Level.FINEST)) {
                                DataLogger.logTrappedMonitoringException(logger__, this, "processAsynchronousMessage", throwable, "error closing connection: " + cMXConnection);
                            }
                            break block14;
                        }
                    }
                }
                throw new Exception("message not supported");
            }
            catch (Exception exception) {
                if (logger__.isLoggable(Level.FINER)) {
                    logger__.throwing(DataLogger.getShortName(this), "processAsynchronousMessage", exception);
                }
                throw new Exception(exception);
            }
        }
    }

    public void register(EventHandler eventHandler) {
        this.eventHandler_ = eventHandler;
    }

    @Override
    public int getVersion() {
        return 12;
    }

    @Override
    public String getProcessorName() {
        return "Monitor";
    }

    @Override
    public Message processRequest(Message message, CMXConnection cMXConnection) throws ProcessingException {
        return null;
    }

    private Object[] convertJSONtoObjectArray(JSONArray jSONArray) {
        Object[] objectArray = new Object[jSONArray.size()];
        for (int i10 = 0; i10 < jSONArray.size(); ++i10) {
            Object object = jSONArray.get(i10);
            if (object instanceof JSONArray) {
                object = this.convertJSONtoObjectArray((JSONArray)object);
            }
            objectArray[i10] = object;
        }
        return objectArray;
    }

    private Object[] convertJSONtoObjectArrayHack(JSONArray jSONArray) {
        Object[] objectArray;
        Object object;
        int n2;
        Object object2;
        Object[] objectArray2 = new Object[jSONArray.size()];
        for (int i10 = 0; i10 < jSONArray.size(); ++i10) {
            object2 = jSONArray.get(i10);
            if (object2 instanceof JSONArray) {
                object2 = this.convertJSONtoObjectArray((JSONArray)object2);
            }
            objectArray2[i10] = object2;
        }
        if (objectArray2.length >= 9) {
            Object[] objectArray3 = (Object[])objectArray2[8];
            object2 = null;
            if (objectArray3 != null) {
                for (n2 = 0; n2 < objectArray3.length; ++n2) {
                    object = objectArray3[n2];
                    if (!(object instanceof Object[]) || (objectArray = (Object[])object).length != 25) continue;
                    object2 = new Object[26];
                    System.arraycopy(objectArray, 0, object2, 0, 25);
                    Long l8 = (Long)object2[24];
                    if (l8 == 1L) {
                        object2[24] = 0L;
                        object2[25] = 1L;
                    } else if (l8 == 10L) {
                        object2[24] = 1L;
                        object2[25] = 0L;
                    } else if (l8 == 11L) {
                        object2[24] = 1L;
                        object2[25] = 1L;
                    } else if (l8 == 0L) {
                        object2[24] = 0L;
                        object2[25] = 0L;
                    }
                    objectArray3[n2] = object2;
                }
            }
        }
        if (objectArray2.length >= 10) {
            Object[] objectArray4 = (Object[])objectArray2[9];
            object2 = null;
            if (objectArray4 != null) {
                for (n2 = 0; n2 < objectArray4.length; ++n2) {
                    object = objectArray4[n2];
                    if (!(object instanceof Object[])) continue;
                    objectArray = (Object[])object;
                    if (objectArray.length == 30) {
                        object2 = new Object[31];
                        System.arraycopy(objectArray, 0, object2, 0, 30);
                        object2[30] = new Object[0];
                        objectArray4[n2] = object2;
                        continue;
                    }
                    if (objectArray.length <= 30 || objectArray[30] != null) continue;
                    object2[30] = new Object[0];
                }
            }
        }
        return objectArray2;
    }

    @Override
    public int getNegotiatedVersion(int n2) {
        int n3 = Math.min(n2, Math.min(this.maxClientLevel_, this.getVersion()));
        if (n3 < this.minClientLevel_) {
            return -1;
        }
        return n3;
    }

    @Override
    public Message processRequest(Message message, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, LogLookupInfo logLookupInfo) throws Exception {
        return null;
    }

    @Override
    public void processMessage(Message message, HttpServletRequest httpServletRequest) throws Exception {
    }

    @Override
    public void invokeLogLookup(LogLookupInfo logLookupInfo) {
    }
}

