/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;

public class ConditionInSelect
extends Condition {
    private final Database database;
    private Expression left;
    private final Query query;
    private final boolean all;
    private final int compareType;

    public ConditionInSelect(Database database, Expression expression, Query query, boolean bl, int n) {
        this.database = database;
        this.left = expression;
        this.query = query;
        query.setRandomAccessResult(true);
        this.all = bl;
        this.compareType = n;
    }

    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        this.query.setNeverLazy(true);
        this.query.setDistinctIfPossible();
        LocalResult localResult = (LocalResult)this.query.query(0);
        Value value = this.left.getValue(session);
        if (!localResult.hasNext()) {
            return ValueBoolean.get(this.all);
        }
        if (value.containsNull()) {
            return ValueNull.INSTANCE;
        }
        if (!this.database.getSettings().optimizeInSelect) {
            return this.getValueSlow(localResult, value);
        }
        if (this.all || this.compareType != 0 && this.compareType != 16) {
            return this.getValueSlow(localResult, value);
        }
        int n = this.query.getColumnCount();
        if (n != 1) {
            Value[] valueArray = ((ValueRow)(value = value.convertTo(39))).getList();
            if (n == valueArray.length && localResult.containsDistinct(valueArray)) {
                return ValueBoolean.TRUE;
            }
        } else {
            TypeInfo typeInfo = localResult.getColumnType(0);
            if (typeInfo.getValueType() == 0) {
                return ValueBoolean.FALSE;
            }
            if (value.getValueType() == 39) {
                Value[] valueArray = ((ValueRow)value).getList();
                if (valueArray.length != 1) {
                    throw DbException.get(21002);
                }
                value = valueArray[0];
            }
            if (localResult.containsDistinct(new Value[]{value = value.convertTo(typeInfo, this.database.getMode(), null)})) {
                return ValueBoolean.TRUE;
            }
        }
        if (localResult.containsNull()) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.FALSE;
    }

    private Value getValueSlow(ResultInterface resultInterface, Value value) {
        boolean bl = false;
        if (this.all) {
            while (resultInterface.next()) {
                Value value2 = this.compare(value, resultInterface);
                if (value2 == ValueNull.INSTANCE) {
                    bl = true;
                    continue;
                }
                if (value2 != ValueBoolean.FALSE) continue;
                return value2;
            }
        } else {
            while (resultInterface.next()) {
                Value value3 = this.compare(value, resultInterface);
                if (value3 == ValueNull.INSTANCE) {
                    bl = true;
                    continue;
                }
                if (value3 != ValueBoolean.TRUE) continue;
                return value3;
            }
        }
        if (bl) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(this.all);
    }

    private Value compare(Value value, ResultInterface resultInterface) {
        Value[] valueArray = resultInterface.currentRow();
        ValueRow valueRow = value.getValueType() != 39 && this.query.getColumnCount() == 1 ? valueArray[0] : ValueRow.get(valueArray);
        return Comparison.compare(this.database, value, valueRow, this.compareType);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        this.query.mapColumns(columnResolver, n + 1);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        session.optimizeQueryExpression(this.query);
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.query.setEvaluatable(tableFilter, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl).append(' ');
        if (this.all) {
            stringBuilder.append(Comparison.getCompareOperator(this.compareType)).append(" ALL");
        } else if (this.compareType == 0) {
            stringBuilder.append("IN");
        } else {
            stringBuilder.append(Comparison.getCompareOperator(this.compareType)).append(" ANY");
        }
        stringBuilder.append("(\n");
        return StringUtils.indent(stringBuilder, this.query.getPlanSQL(bl), 4, false).append("))");
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.query.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.query.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.query.getCostAsExpression();
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!session.getDatabase().getSettings().optimizeInList) {
            return;
        }
        if (this.compareType != 0) {
            return;
        }
        if (this.query.getColumnCount() != 1) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
        if (!this.query.isEverything(expressionVisitor)) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInQuery(expressionColumn, this.query));
    }
}

