/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.parser;

import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.db.LiteralsInfo;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInfoArray;
import com.ibm.db2.cmx.runtime.internal.metadata.SqlParameterInfo;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EscapeLexer {
    private int currentPos_;
    private boolean inSingleQuotedString_;
    private boolean inDoubleQuotedString_;
    private int blockCommentDepth_ = 0;
    private boolean inLineComment_ = false;
    private int curlyNestingDepth_ = 0;
    private char currentChar_;
    private char prevChar_;
    private char nextChar_;
    private char prevPrevChar_;
    private int blockIndicatorEndIndex_;
    private boolean foundSearchedValue_ = false;
    boolean isCurrentLitSubTokenArithmeticUnary_ = false;
    boolean isPriorLitSubTokenArithmeticUnary_ = false;
    int lastArithmeticTokenBuilderIndex_ = 0;
    int parenDepth_ = 0;
    ArrayList<ParenthesizedLevelDetail> openParenLitSubDetails_ = new ArrayList();
    String currentLitSubToken_ = null;
    String priorLitSubToken_ = null;
    boolean isLexingPossibleCastFunction_ = false;
    private int maxPos_;
    private String lexStr_;
    private String delimiters_;
    private boolean sqlHasParameterMarkerBeforeFirstWord_ = false;
    private boolean returnDelims_ = true;
    private SqlStatementType statementType_ = SqlStatementType.OTHERSQL;
    protected boolean nonPositionalParameterExists_ = false;
    protected boolean positionalParameterExists_ = false;
    static final Pattern floatZeroPat_ = Pattern.compile("^0*[.]?0*(?i:e).*");
    static final String BEAN_PROPERTY_REFERENCE = "\\?([0-9]?\\..*)";
    static final String VTI_PARAM_PATTERN_WITH_NUM = "\\?([0-9])\\.(.*)";
    static final String VTI_PARAM_PATTERN_WITHOUT_NUM = "\\?([a-zA-Z].*)";
    public static Pattern regExPatternBeanRef = Pattern.compile("\\?([0-9]?\\..*)");
    public static Pattern regExPatternVtiWithNum = Pattern.compile("\\?([0-9])\\.(.*)");
    public static Pattern regExPatternVtiWithoutNum = Pattern.compile("\\?([a-zA-Z].*)");
    public static final char isLexingPossibleCastFunctionBit_ = '\u0001';
    public static final char isLabeledDurationBit_ = '\u0010';
    public static final String delimitersThatDontPrecedeUnaryOperators_ = ")]}\"'";
    public static final String delimitersThatMightEndSelectExpressionList_ = "*)]}\"'";
    private static final HashMap<String, Integer> selectAndPredicateTokenList_ = new HashMap();
    private static final HashMap<String, Integer> generalNonFunctionTokenList_ = new HashMap();
    private static final HashMap<String, Integer> tableReferenceTerminator_ = new HashMap();
    private static final HashMap<String, Integer> tokenSequenceIntroducer_ = new HashMap();
    private static final int quote__ = 1;
    private static final int doubleQuote__ = 2;
    private static final int hyphen__ = 3;
    private static final int plusSign__ = 4;
    private static final int curlyLeftBrace__ = 5;
    private static final int questionMark__ = 6;
    private static final int CASE__ = 7;
    private static final int CAST__ = 8;
    private static final int DATE__ = 9;
    private static final int TIME__ = 10;
    private static final int TIMESTAMP__ = 11;
    private static final int FETCH__ = 12;
    private static final int OPTIMIZE__ = 13;
    private static final int IS__ = 14;
    private static final int NULL__ = 15;
    private static final int ORDER__ = 16;
    private static final int QUERYNO__ = 17;
    private static final String significantOneCharacterTokens__ = "'\"-+{?";
    private static final HashMap<String, SqlStatementType> lowerCaseTokenToTypeMap_;

    public SqlStatementType getSqlStatementType() {
        return this.statementType_;
    }

    public boolean foundSearchedValue() {
        return this.foundSearchedValue_;
    }

    public EscapeLexer(String string) {
        this(string, " \n\t\r'\"{},()\\[]:=", true);
    }

    public EscapeLexer(String string, boolean bl2) {
        this(string, " \n\t\r'\"{},()\\[]:=", bl2);
    }

    public EscapeLexer(String string, String string2) {
        this(string, string2, true);
    }

    private EscapeLexer(String string, String string2, boolean bl2) {
        this.returnDelims_ = bl2;
        this.init(string, string2);
    }

    public void reinit() {
        this.init(this.lexStr_, this.delimiters_);
    }

    private void init(String string, String string2) {
        this.currentPos_ = 0;
        this.maxPos_ = string.length() - 1;
        this.lexStr_ = string;
        this.prevPrevChar_ = '\u0000';
        this.prevChar_ = '\u0000';
        this.currentChar_ = string.length() > 0 ? string.charAt(this.currentPos_) : (char)'\u0000';
        this.nextChar_ = this.currentPos_ + 1 <= this.maxPos_ ? this.lexStr_.charAt(this.currentPos_ + 1) : (char)'\u0000';
        this.delimiters_ = string2;
        this.inSingleQuotedString_ = false;
        this.inDoubleQuotedString_ = false;
        this.curlyNestingDepth_ = 0;
        this.statementType_ = SqlStatementType.OTHERSQL;
        this.nonPositionalParameterExists_ = false;
        this.positionalParameterExists_ = false;
        this.blockCommentDepth_ = 0;
        this.inLineComment_ = false;
        this.blockIndicatorEndIndex_ = 0;
        if (this.maxPos_ >= 0) {
            this.inSingleQuotedString_ = this.currentChar_ == '\'';
            boolean bl2 = this.inDoubleQuotedString_ = this.currentChar_ == '\"';
            if (this.currentChar_ == '/' && this.nextChar_ == '*' && !this.inSingleQuotedString_ && !this.inDoubleQuotedString_) {
                ++this.blockCommentDepth_;
                this.blockIndicatorEndIndex_ = this.currentPos_ + 1;
            }
            if (this.currentChar_ == '-' && this.nextChar_ == '-' && !this.inSingleQuotedString_ && !this.inDoubleQuotedString_) {
                this.inLineComment_ = true;
            }
            this.curlyNestingDepth_ = this.currentChar_ == '{' ? 1 : 0;
        }
    }

    public int getCurrentPos() {
        return this.currentPos_;
    }

    private synchronized boolean advance() {
        ++this.currentPos_;
        if (this.currentPos_ > this.maxPos_) {
            return false;
        }
        this.prevPrevChar_ = this.prevChar_;
        this.prevChar_ = this.currentChar_;
        this.currentChar_ = this.nextChar_;
        char c10 = this.nextChar_ = this.currentPos_ + 1 <= this.maxPos_ ? this.lexStr_.charAt(this.currentPos_ + 1) : (char)'\u0000';
        if (this.currentChar_ == '\'' && this.blockCommentDepth_ == 0 && !this.inLineComment_) {
            boolean bl2 = this.inSingleQuotedString_ = !this.inSingleQuotedString_;
        }
        if (!this.inSingleQuotedString_ && this.currentChar_ == '\"' && this.blockCommentDepth_ == 0 && !this.inLineComment_) {
            boolean bl3 = this.inDoubleQuotedString_ = !this.inDoubleQuotedString_;
        }
        if (!(this.currentPos_ <= this.blockIndicatorEndIndex_ || this.inDoubleQuotedString_ || this.inSingleQuotedString_ || this.inLineComment_)) {
            if (this.prevPrevChar_ == '*' && this.prevChar_ == '/' && this.blockCommentDepth_ > 0) {
                --this.blockCommentDepth_;
            }
            if (this.currentChar_ == '/' && this.nextChar_ == '*') {
                ++this.blockCommentDepth_;
                this.blockIndicatorEndIndex_ = this.currentPos_ + 1;
            } else if (this.currentChar_ == '*' && this.nextChar_ == '/' && this.blockCommentDepth_ > 0) {
                this.blockIndicatorEndIndex_ = this.currentPos_ + 1;
            }
        }
        if (this.currentChar_ == '-' && this.nextChar_ == '-' && !this.inSingleQuotedString_ && !this.inDoubleQuotedString_ && this.blockCommentDepth_ == 0) {
            this.inLineComment_ = true;
        } else if (this.inLineComment_ && this.currentChar_ == '\n') {
            this.inLineComment_ = false;
        }
        if (!this.inSingleQuotedString_ && !this.inDoubleQuotedString_) {
            if (this.currentChar_ == '{' && this.prevChar_ != '\\') {
                ++this.curlyNestingDepth_;
            }
            if (this.currentChar_ == '}' && this.prevChar_ != '\\' && this.curlyNestingDepth_ > 0) {
                --this.curlyNestingDepth_;
            }
        }
        return true;
    }

    private boolean isWhiteSpace(char c10) {
        return c10 == ' ' || c10 == '\n' || c10 == '\t' || c10 == '\r';
    }

    private boolean isDelimChar(char c10) {
        for (int i10 = 0; i10 < this.delimiters_.length(); ++i10) {
            if (this.delimiters_.charAt(i10) != c10) continue;
            return true;
        }
        return false;
    }

    private boolean isDelimChar(char c10, String string) {
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) != c10) continue;
            return true;
        }
        return false;
    }

    private boolean isDoubleQuote(char c10) {
        return '\"' == c10;
    }

    private synchronized boolean skipWhiteSpaces() {
        while (this.isWhiteSpace(this.currentChar_) || this.inLineComment_ || this.blockCommentDepth_ > 0) {
            if (this.advance()) continue;
            return false;
        }
        return true;
    }

    private synchronized boolean skipDelimsAndWhiteSpace() {
        while (this.isWhiteSpace(this.currentChar_) || this.inLineComment_ || this.blockCommentDepth_ > 0 || this.isDelimChar(this.currentChar_)) {
            if (this.advance()) continue;
            return false;
        }
        return true;
    }

    private synchronized boolean skipDelimsRecognizeDoubleQuotedStrings(String string) {
        while (!this.inDoubleQuotedString_ && this.isDelimChar(this.currentChar_, string)) {
            if (this.advance()) continue;
            return false;
        }
        return true;
    }

    public synchronized int findNextNotInQuotedString(char c10, char c11, boolean bl2, boolean bl3) {
        do {
            if (this.currentChar_ != c10 && this.currentChar_ != c11 || this.inSingleQuotedString_ || this.inDoubleQuotedString_ || bl3 && (this.inLineComment_ || this.blockCommentDepth_ != 0)) continue;
            int n2 = this.currentPos_;
            if (bl2) {
                this.advance();
            }
            return n2;
        } while (this.advance());
        return -1;
    }

    public String getUpToNextNotInQuotedStringOrRemainder(char c10, char c11, boolean bl2, boolean bl3) {
        String string = "" + c10 + c11;
        int n2 = this.currentPos_;
        String string2 = null;
        int n3 = this.findNextNotInQuotedString(c10, c11, bl2, bl3);
        if (n3 != -1) {
            this.foundSearchedValue_ = true;
            string2 = this.subString(n2, n3);
        } else {
            this.foundSearchedValue_ = false;
            string2 = this.subString(n2);
        }
        String string3 = this.returnDelims_ ? string2 : this.trimDelimitersFromEnds(string, string2);
        return string3;
    }

    public String getUpToNextNotInSingleQuotedStringOrRemainder(char c10, boolean bl2) {
        String string = "" + c10;
        int n2 = this.currentPos_;
        int n3 = this.findNextNotInSingleQuotedString(c10, bl2);
        String string2 = null;
        if (n3 != -1) {
            this.foundSearchedValue_ = true;
            string2 = this.subString(n2, n3);
        } else {
            this.foundSearchedValue_ = false;
            string2 = this.subString(n2);
        }
        String string3 = this.returnDelims_ ? string2 : this.trimDelimitersFromEnds(string, string2);
        return string3;
    }

    private String trimDelimitersFromEnds(String string, String string2) {
        char c10;
        int n2;
        int n3 = string2.length() - 1;
        for (n2 = 0; n2 <= n3 && (this.isDelimChar(c10 = string2.charAt(n2), string) || this.isDoubleQuote(c10)); ++n2) {
        }
        while (n2 <= n3 && (this.isDelimChar(c10 = string2.charAt(n3), string) || this.isDoubleQuote(c10))) {
            --n3;
        }
        String string3 = string2.substring(n2, n3 + 1);
        return string3;
    }

    synchronized int findNextNotInSingleQuotedString(char c10, boolean bl2) {
        do {
            if (this.currentChar_ != c10 || this.inSingleQuotedString_ || this.inLineComment_ || this.blockCommentDepth_ != 0) continue;
            int n2 = this.currentPos_;
            if (bl2) {
                this.advance();
            }
            return n2;
        } while (this.advance());
        return -1;
    }

    public synchronized String getNextTokenInReplacerOptions() throws DataSQLException {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.currentPos_ > this.maxPos_) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_NO_NEXT_STR", new Object[0]), null, 11181);
        }
        if (!this.skipWhiteSpaces()) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_NO_NEXT_STR", new Object[0]), null, 11182);
        }
        do {
            if (this.inLineComment_ || this.blockCommentDepth_ != 0) continue;
            if (this.isDelimChar(this.currentChar_) && !this.withinQuotes()) {
                if (stringBuilder.length() == 0) {
                    if (!this.returnDelims_) continue;
                    stringBuilder.append(this.currentChar_);
                    this.advance();
                    return stringBuilder.toString();
                }
                return stringBuilder.toString();
            }
            stringBuilder.append(this.currentChar_);
        } while (this.advance());
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    public synchronized String nextToken() throws DataSQLException {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.currentPos_ > this.maxPos_) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_NO_NEXT_STR", new Object[0]), null, 10257);
        }
        if (!this.skipWhiteSpaces()) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_NO_NEXT_STR", new Object[0]), null, 10258);
        }
        String string = "?:";
        boolean bl2 = !this.inLineComment_ && this.blockCommentDepth_ == 0 && -1 < string.indexOf(this.currentChar_);
        boolean bl3 = false;
        do {
            if (this.inLineComment_ || this.blockCommentDepth_ != 0) continue;
            if (bl2) {
                if (0 == stringBuilder.length()) {
                    stringBuilder.append(this.currentChar_);
                    continue;
                }
                if (bl3 && '.' == this.currentChar_) {
                    stringBuilder.append(this.currentChar_);
                    continue;
                }
                if (Character.isJavaIdentifierPart(this.currentChar_)) {
                    stringBuilder.append(this.currentChar_);
                    if (bl3) continue;
                    bl3 = true;
                    continue;
                }
                return stringBuilder.toString();
            }
            if (this.isDelimChar(this.currentChar_)) {
                if (stringBuilder.length() == 0) {
                    if (!this.returnDelims_) continue;
                    stringBuilder.append(this.currentChar_);
                    this.advance();
                    return stringBuilder.toString();
                }
                return stringBuilder.toString();
            }
            stringBuilder.append(this.currentChar_);
        } while (this.advance());
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    private boolean withinQuotes() {
        return this.inSingleQuotedString_ || this.inDoubleQuotedString_;
    }

    synchronized String subString(int n2, int n3) throws StringIndexOutOfBoundsException {
        return this.lexStr_.substring(n2, n3);
    }

    synchronized String subString(int n2) throws StringIndexOutOfBoundsException {
        return this.lexStr_.substring(n2);
    }

    public synchronized boolean hasMoreTokens() {
        if (this.currentPos_ > this.maxPos_) {
            return false;
        }
        return !(this.returnDelims_ ? !this.skipWhiteSpaces() : !this.skipDelimsAndWhiteSpace());
    }

    private synchronized boolean peekChar(char c10) {
        if (this.currentPos_ > this.maxPos_) {
            return false;
        }
        return this.currentChar_ == c10;
    }

    public synchronized boolean hasMoreTokensRecognizeDoubleQuotedStrings(String string) {
        if (this.currentPos_ > this.maxPos_) {
            return false;
        }
        if (!this.returnDelims_) {
            return this.skipDelimsRecognizeDoubleQuotedStrings(string);
        }
        return true;
    }

    public String parseSql(ParameterInfoArray parameterInfoArray, int n2) throws DataSQLException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        String string = null;
        int n4 = 0;
        if (this.hasMoreTokens()) {
            string = this.nextToken();
            string = this.processEscapedStoredProc(stringBuilder, string, n4, parameterInfoArray, n2);
            while ("(".equals(string)) {
                stringBuilder.append(string);
                string = this.nextToken();
            }
            n3 = this.currentPos_ - string.length();
            this.setStatementType(string);
            parameterInfoArray.setSqlStatementType(this.statementType_);
        }
        if (this.statementType_ != SqlStatementType.XQUERY) {
            do {
                n4 = parameterInfoArray.getSqlParameterInfo().size();
                object = new SqlParameterInfo();
                int n5 = this.findNextNotInQuotedString(':', '?', false, true);
                if (n5 == -1) continue;
                stringBuilder.append(this.subString(n3, n5));
                string = this.nextToken();
                if (string.startsWith(":")) {
                    this.handleHostVariable(stringBuilder, (SqlParameterInfo)object, string, parameterInfoArray);
                } else if (string.equals("?")) {
                    this.handleNonPositionalParm(stringBuilder, (SqlParameterInfo)object, string, n4);
                } else if (string.startsWith("?")) {
                    this.handlePositionalParm(stringBuilder, (SqlParameterInfo)object, string, n4, parameterInfoArray);
                } else {
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_LEX_TOKEN", string), null, 10126);
                }
                parameterInfoArray.setSqlParameterInfo((SqlParameterInfo)object, this.lexStr_, n2);
                n3 = this.currentPos_;
                if (!this.positionalParameterExists_ || !this.nonPositionalParameterExists_) continue;
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_LEX_PARM_MIXED", new Object[0]), null, 10127);
            } while (this.hasMoreTokens());
        }
        if (n3 <= this.maxPos_) {
            object = this.subString(n3);
            stringBuilder.append((String)object);
        }
        parameterInfoArray.setProcessedSql(stringBuilder.toString());
        return parameterInfoArray.getProcessedSql();
    }

    private String processEscapedStoredProc(StringBuilder stringBuilder, String string, int n2, ParameterInfoArray parameterInfoArray, int n3) throws DataSQLException {
        String string2 = string;
        if (this.isEscaped(string2)) {
            stringBuilder.append(string2);
            do {
                SqlParameterInfo sqlParameterInfo;
                if ((string2 = this.nextToken()).startsWith(":")) {
                    sqlParameterInfo = new SqlParameterInfo();
                    this.handleHostVariable(stringBuilder, sqlParameterInfo, string2, parameterInfoArray);
                    parameterInfoArray.setSqlParameterInfo(sqlParameterInfo, this.lexStr_, n3);
                    string2 = this.nextToken();
                    this.sqlHasParameterMarkerBeforeFirstWord_ = true;
                }
                if (string2.equals("?")) {
                    sqlParameterInfo = new SqlParameterInfo();
                    this.handleNonPositionalParm(stringBuilder, sqlParameterInfo, string2, n2);
                    parameterInfoArray.setSqlParameterInfo(sqlParameterInfo, this.lexStr_, n3);
                    this.sqlHasParameterMarkerBeforeFirstWord_ = true;
                    continue;
                }
                if (string2.startsWith("?")) {
                    sqlParameterInfo = new SqlParameterInfo();
                    this.handlePositionalParm(stringBuilder, sqlParameterInfo, string2, n2, parameterInfoArray);
                    parameterInfoArray.setSqlParameterInfo(sqlParameterInfo, this.lexStr_, n3);
                    this.sqlHasParameterMarkerBeforeFirstWord_ = true;
                    continue;
                }
                if (!string2.equals("=")) continue;
                stringBuilder.append(string2);
                this.sqlHasParameterMarkerBeforeFirstWord_ = true;
            } while (this.isLeadingParm(string2));
            if (string2.startsWith("=")) {
                stringBuilder.append("=");
                string2 = string2.substring(1);
            }
        }
        return string2;
    }

    private void setStatementType(String string) throws DataSQLException {
        String string2 = string.toLowerCase();
        this.statementType_ = lowerCaseTokenToTypeMap_.get(string2);
        if (this.sqlHasParameterMarkerBeforeFirstWord_ && SqlStatementType.CALL != this.statementType_) {
            this.statementType_ = SqlStatementType.OTHERSQL;
        }
        if (null == this.statementType_ && string2.equals("declare")) {
            LexerContext lexerContext = new LexerContext();
            if (this.hasMoreTokens() && "global".equalsIgnoreCase(this.nextToken()) && this.hasMoreTokens() && "temporary".equalsIgnoreCase(this.nextToken()) && this.hasMoreTokens() && "table".equalsIgnoreCase(this.nextToken())) {
                this.statementType_ = SqlStatementType.DECLAREGLOBALTEMPTABLE;
            }
            lexerContext.restoreLexerContext();
        }
        if (null == this.statementType_) {
            this.statementType_ = SqlStatementType.OTHERSQL;
        }
    }

    public void handleHostVariable(StringBuilder stringBuilder, SqlParameterInfo sqlParameterInfo, String string, ParameterInfoArray parameterInfoArray) throws DataSQLException {
        if (1 >= string.length()) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_LEX_TOKEN", string), null, 10833);
        }
        stringBuilder.append(" ? ");
        sqlParameterInfo.setSqlParameterInfo(SqlParameterInfo.ParameterEntryInfoInSQL.isHostVariable__, 0, string.substring(1));
        parameterInfoArray.setHasHostVariable(true);
    }

    private void handleNonPositionalParm(StringBuilder stringBuilder, SqlParameterInfo sqlParameterInfo, String string, int n2) {
        stringBuilder.append(string);
        sqlParameterInfo.setSqlParameterInfo(SqlParameterInfo.ParameterEntryInfoInSQL.isNonPositionalParameterMarker__, n2, null);
        this.nonPositionalParameterExists_ = true;
    }

    protected void handlePositionalParm(StringBuilder stringBuilder, SqlParameterInfo sqlParameterInfo, String string, int n2, ParameterInfoArray parameterInfoArray) throws DataSQLException {
        stringBuilder.append(" ? ");
        String string2 = null;
        String string3 = null;
        if (string.contains(".")) {
            int n3 = string.indexOf(".");
            if (n3 == 1) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_LEX_INV_PARM", string), null, 10128);
            }
            string2 = string.substring(1, n3);
            string3 = string.substring(n3 + 1, string.length());
        } else {
            string2 = string.substring(1);
        }
        try {
            n2 = Integer.valueOf(string2);
            if (string3 != null) {
                sqlParameterInfo.setSqlParameterInfo(SqlParameterInfo.ParameterEntryInfoInSQL.isBean_OR_Map__, n2 - 1, string3);
                parameterInfoArray.setHasHostVariable(true);
            } else {
                sqlParameterInfo.setSqlParameterInfo(SqlParameterInfo.ParameterEntryInfoInSQL.isPositionalParameterMarker__, n2 - 1, null);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_LEX_QMARK", new Object[0]), numberFormatException, 10129);
        }
        this.positionalParameterExists_ = true;
    }

    public SqlStatementType parseSqlAndGetSqlType() throws DataSQLException {
        if (this.hasMoreTokens()) {
            String string = this.nextToken();
            if (this.isEscaped(string)) {
                do {
                    if (null == (string = this.nextToken()) || !string.startsWith(":")) continue;
                    string = this.nextToken();
                    this.sqlHasParameterMarkerBeforeFirstWord_ = true;
                } while (this.isLeadingParm(string));
            }
            while ("(".equals(string)) {
                string = this.nextToken();
            }
            this.setStatementType(string);
        }
        return this.statementType_;
    }

    public Integer[] parseSqlAndGetStoredProcParamIndexes() throws DataSQLException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        int n3 = 1;
        while (this.hasMoreTokens()) {
            String string = this.nextToken();
            if (string.equals("(")) {
                ++n2;
                continue;
            }
            if (string.equals(")")) {
                --n2;
                continue;
            }
            if (string.equals(",")) {
                if (n2 != 1) continue;
                ++n3;
                continue;
            }
            if (!string.equals("?")) continue;
            if (n2 == 1) {
                arrayList.add(n3);
                continue;
            }
            if (n2 == 0) {
                arrayList.add(n3++);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    private boolean isEscaped(String string) {
        return string.equals("{") || this.lexStr_.trim().startsWith("{");
    }

    private boolean isLeadingParm(String string) {
        if (string.startsWith("?") || string.equalsIgnoreCase("=")) {
            this.sqlHasParameterMarkerBeforeFirstWord_ = true;
            return true;
        }
        return false;
    }

    public boolean isVTIParam(TypeInfo typeInfo) {
        JavaType javaType = typeInfo.getJavaType();
        return javaType == JavaType.ITERATOR || javaType == JavaType.ITERABLE || javaType == JavaType.ARRAY || javaType == JavaType.LIST || javaType == JavaType.DERIVEDLIST || javaType == JavaType.COLLECTION;
    }

    public String parseSQLTextForStaticExecution() throws DataSQLException {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        do {
            int n3;
            if ((n3 = this.findNextNotInQuotedString('?', '?', false, true)) == -1) continue;
            stringBuilder.append(this.subString(n2, n3));
            string = this.nextToken();
            if (string.equals("?")) {
                stringBuilder.append(":H:H");
            } else {
                stringBuilder.append(string);
            }
            n2 = this.currentPos_;
        } while (this.hasMoreTokens());
        if (n2 <= this.maxPos_) {
            stringBuilder.append(this.subString(n2));
        }
        return stringBuilder.toString();
    }

    public String upperCaseSQLNotInQuotedString() {
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if (!(this.inSingleQuotedString_ || this.inDoubleQuotedString_ || this.inLineComment_ || this.blockCommentDepth_ != 0)) {
                stringBuilder.append(Character.toUpperCase(this.currentChar_));
                continue;
            }
            stringBuilder.append(this.currentChar_);
        } while (this.advance());
        return stringBuilder.toString();
    }

    public String escapeUnescapedQuotes() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        block4: for (int i10 = 0; i10 < this.lexStr_.length(); ++i10) {
            char c10 = this.lexStr_.charAt(i10);
            switch (c10) {
                case '\\': {
                    stringBuilder.append(c10);
                    ++n2;
                    continue block4;
                }
                case '\"': {
                    if (n2 % 2 == 0) {
                        stringBuilder.append("\\\"");
                    } else {
                        stringBuilder.append(c10);
                    }
                    n2 = 0;
                    continue block4;
                }
                default: {
                    stringBuilder.append(c10);
                    n2 = 0;
                }
            }
        }
        return stringBuilder.toString();
    }

    public boolean parseSQLTextForUpdate() throws DataSQLException {
        String string = null;
        while (this.hasMoreTokens()) {
            string = this.nextToken();
            if (!string.equalsIgnoreCase("FOR") || !this.hasMoreTokens() || !(string = this.nextToken()).equalsIgnoreCase("UPDATE")) continue;
            return true;
        }
        return false;
    }

    public LiteralsInfo parseAndSubstituteParameterMarkersforLiterals(LiteralsInfo literalsInfo) throws DataSQLException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        String string = null;
        boolean bl2 = false;
        String string2 = null;
        String[] stringArray = new String[1];
        short[] sArray = new short[1];
        ParenthesizedLevelDetail parenthesizedLevelDetail = null;
        ParenthesizedLevelDetail parenthesizedLevelDetail2 = new ParenthesizedLevelDetail(null, null);
        this.openParenLitSubDetails_.add(parenthesizedLevelDetail2);
        if (this.hasMoreTokens()) {
            object = this.literalSub_nextToken();
            if (this.isEscaped((String)object)) {
                do {
                    if (!":".equals(object = this.literalSub_nextToken())) continue;
                    object = this.literalSub_nextToken();
                    object = this.literalSub_nextToken();
                    this.sqlHasParameterMarkerBeforeFirstWord_ = true;
                } while (this.isLeadingParm((String)object));
            }
            while ("(".equals(object)) {
                stringBuilder.append((String)object);
                object = this.literalSub_nextToken();
            }
            this.setStatementType((String)object);
            stringBuilder.append((String)object);
        }
        this.openParenLitSubDetails_.get((int)this.parenDepth_).currentLevelStatementType_ = this.getSqlStatementType();
        if (!LiteralsInfo.isLiteralSubstitutionAllowedForStatementType(this.getSqlStatementType())) {
            literalsInfo.disallowLiteralSubstitution(false, null, null);
            return literalsInfo;
        }
        block18: do {
            if (this.isWhiteSpace(this.currentChar_) || this.isWhiteSpace(this.prevChar_) || this.prevChar_ == '/' && this.prevPrevChar_ == '*') {
                stringBuilder.append(' ');
            }
            if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string = this.literalSub_nextToken())) {
                literalsInfo.disallowLiteralSubstitution(false, null, null);
                return literalsInfo;
            }
            object = null;
            int n3 = significantOneCharacterTokens__.indexOf(string);
            object = n3 < 0 ? tokenSequenceIntroducer_.get(string.toUpperCase()) : Integer.valueOf(++n3);
            if (object == null) {
                if (!this.checkAndSubstituteParametersForNumericLiterals(string, stringBuilder, literalsInfo)) continue;
                bl2 = true;
                continue;
            }
            LiteralSubLexerContext literalSubLexerContext = null;
            int n4 = (Integer)object;
            switch (n4) {
                case 1: {
                    bl2 |= this.litSubHandleQuotedString(literalsInfo, stringBuilder);
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    do {
                        this.litSubHandleOneQuotedPair(stringBuilder, '\"');
                        if (this.peekChar('\"')) {
                            string = this.literalSub_nextToken();
                            continue;
                        }
                        bl3 = true;
                    } while (!bl3);
                    break;
                }
                case 3: 
                case 4: {
                    if (null != this.priorLitSubToken_ && this.priorLitSubToken_.length() == 1) {
                        boolean bl4 = this.isCurrentLitSubTokenArithmeticUnary_ = this.isDelimChar(this.priorLitSubToken_.charAt(0)) && -1 == delimitersThatDontPrecedeUnaryOperators_.indexOf(this.priorLitSubToken_);
                        if (this.isCurrentLitSubTokenArithmeticUnary_) {
                            this.lastArithmeticTokenBuilderIndex_ = stringBuilder.length();
                        }
                    }
                    stringBuilder.append(string);
                    break;
                }
                case 5: {
                    String string3;
                    int n5;
                    int n6;
                    CharSequence charSequence;
                    literalSubLexerContext = new LiteralSubLexerContext(literalsInfo);
                    boolean bl5 = true;
                    if (this.hasMoreTokens()) {
                        String string4;
                        charSequence = this.literalSub_nextToken();
                        if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens((String)charSequence)) {
                            literalsInfo.disallowLiteralSubstitution(false, null, null);
                            return literalsInfo;
                        }
                        if (this.hasMoreTokens() && (string4 = this.literalSub_nextToken()).equals("'")) {
                            String string5;
                            n6 = this.currentPos_;
                            n5 = this.findNextNotInQuotedString('\'', '\'', false, false);
                            string2 = this.subString(n6, n5);
                            this.literalSub_nextToken();
                            sArray[0] = 0;
                            if (this.hasMoreTokens() && (string5 = this.literalSub_nextToken()).equals("}")) {
                                bl5 = false;
                                boolean bl6 = true;
                                if (((String)charSequence).equalsIgnoreCase("D")) {
                                    sArray[0] = 37;
                                } else if (((String)charSequence).equalsIgnoreCase("T")) {
                                    sArray[0] = 38;
                                } else if (((String)charSequence).equalsIgnoreCase("TS")) {
                                    sArray[0] = 39;
                                    bl6 = literalsInfo.testIsTimestampSubstitutionOK(string2);
                                } else if (((String)charSequence).equalsIgnoreCase("ESCAPE")) {
                                    sArray[0] = 40;
                                    string3 = " ESCAPE ";
                                    stringBuilder.append(string3);
                                } else {
                                    bl6 = false;
                                }
                                if (bl6) {
                                    parenthesizedLevelDetail = this.openParenLitSubDetails_.get(this.parenDepth_);
                                    if (literalsInfo.isSuccessfulLiteralReplacement(string2, sArray[0], stringBuilder, '\u0000', parenthesizedLevelDetail)) {
                                        bl2 = true;
                                    } else {
                                        bl6 = false;
                                    }
                                }
                                if (!bl6) {
                                    if (((String)charSequence).equalsIgnoreCase("ESCAPE")) {
                                        int n7 = stringBuilder.length();
                                        stringBuilder.delete(n7 - 8, n7);
                                    }
                                    stringBuilder.append(string);
                                    stringBuilder.append((String)charSequence).append(' ').append('\'');
                                    stringBuilder.append(string2).append('\'').append(string5);
                                }
                            }
                        }
                    }
                    if (!bl5) break;
                    stringBuilder.append("{");
                    literalSubLexerContext.restoreLiteralSubLexerContext();
                    break;
                }
                case 6: {
                    stringBuilder.append(string);
                    literalsInfo.recordParameterMarkerUse();
                    break;
                }
                case 7: {
                    String string3;
                    CharSequence charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(string);
                    int n8 = 1;
                    int n6 = 0;
                    literalSubLexerContext = new LiteralSubLexerContext(literalsInfo);
                    while (n8 > 0 && this.hasMoreTokens()) {
                        String string6;
                        if (this.isWhiteSpace(this.currentChar_) || this.isWhiteSpace(this.prevChar_) || this.prevChar_ == '/' && this.prevPrevChar_ == '*') {
                            ((StringBuilder)charSequence).append(' ');
                        }
                        if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string6 = this.nextToken())) {
                            literalsInfo.disallowLiteralSubstitution(false, null, null);
                            return literalsInfo;
                        }
                        if (string6.length() == 1 && this.isDelimChar(string6.charAt(0))) {
                            if (string6.equals("'")) {
                                this.litSubHandleOneQuotedPair((StringBuilder)charSequence, '\'');
                                continue;
                            }
                            if (string6.equals("\"")) {
                                this.litSubHandleOneQuotedPair((StringBuilder)charSequence, '\"');
                                continue;
                            }
                            if (string6.equals("{")) {
                                int n9;
                                ((StringBuilder)charSequence).append(string6);
                                n2 = this.currentPos_;
                                if (!this.hasMoreTokens() || (n9 = this.findNextNotInQuotedString('}', '}', false, true)) <= -1) continue;
                                String string7 = this.subString(n2, n9);
                                ((StringBuilder)charSequence).append(string7);
                                string3 = this.nextToken();
                                ((StringBuilder)charSequence).append(string3);
                                continue;
                            }
                            if (string6.equals("(")) {
                                ((StringBuilder)charSequence).append(string6);
                                ++n6;
                                continue;
                            }
                            if (string6.equals(")")) {
                                ((StringBuilder)charSequence).append(string6);
                                --n6;
                                continue;
                            }
                            if (string6.equals("?")) {
                                ((StringBuilder)charSequence).append(string6);
                                literalsInfo.recordParameterMarkerUse();
                                continue;
                            }
                            ((StringBuilder)charSequence).append(string6);
                            continue;
                        }
                        String string8 = string6.toUpperCase();
                        if (string8.equals("CASE")) {
                            ++n8;
                        } else if (string8.equals("END")) {
                            --n8;
                        }
                        ((StringBuilder)charSequence).append(string6);
                    }
                    if (n8 > 0 || n6 != 0) {
                        literalSubLexerContext.restoreLiteralSubLexerContext();
                        stringBuilder.append(string);
                        break;
                    }
                    stringBuilder.append(charSequence);
                    break;
                }
                case 8: {
                    String string9;
                    this.isLexingPossibleCastFunction_ = true;
                    stringBuilder.append(string);
                    literalSubLexerContext = new LiteralSubLexerContext(literalsInfo);
                    if (!this.hasMoreTokens()) break;
                    String string10 = this.literalSub_nextToken();
                    if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string10)) {
                        literalsInfo.disallowLiteralSubstitution(false, null, null);
                        return literalsInfo;
                    }
                    if (string10.equals("(")) {
                        stringBuilder.append(string10);
                        String string11 = this.literalSub_nextToken();
                        if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string11)) {
                            literalsInfo.disallowLiteralSubstitution(false, null, null);
                            return literalsInfo;
                        }
                        if (string11.equals("'")) {
                            bl2 |= this.litSubHandleQuotedString(literalsInfo, stringBuilder);
                            stringBuilder.append(' ');
                        } else if (string11.equalsIgnoreCase("NULL")) {
                            parenthesizedLevelDetail = this.openParenLitSubDetails_.get(this.parenDepth_);
                            if (literalsInfo.isSuccessfulLiteralReplacement(null, (short)41, stringBuilder, '\u0001', parenthesizedLevelDetail)) {
                                bl2 = true;
                            } else {
                                stringBuilder.append(string11);
                            }
                        } else if (string11.equals("?")) {
                            stringBuilder.append(string11);
                            literalsInfo.recordParameterMarkerUse();
                        } else if ("-".equals(string11) || "+".equals(string11)) {
                            this.isCurrentLitSubTokenArithmeticUnary_ = true;
                            this.lastArithmeticTokenBuilderIndex_ = stringBuilder.length();
                            stringBuilder.append(string11);
                            string11 = this.literalSub_nextToken();
                            if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string11)) {
                                literalsInfo.disallowLiteralSubstitution(false, null, null);
                                return literalsInfo;
                            }
                            if (string11.equals("?")) {
                                stringBuilder.append(string11);
                                literalsInfo.recordParameterMarkerUse();
                            } else if (this.checkAndSubstituteParametersForNumericLiterals(string11, stringBuilder, literalsInfo)) {
                                bl2 = true;
                                stringBuilder.append(' ');
                            }
                        } else if (this.checkAndSubstituteParametersForNumericLiterals(string11, stringBuilder, literalsInfo)) {
                            bl2 = true;
                            stringBuilder.append(' ');
                        }
                        int n10 = this.currentPos_;
                        int n11 = this.findNextPairedBracket('(', ')', true);
                        if (n11 != -1) {
                            string9 = this.subString(n10, n11 + 1);
                            stringBuilder.append(string9);
                            --this.parenDepth_;
                        }
                    } else {
                        literalSubLexerContext.restoreLiteralSubLexerContext();
                    }
                    this.isLexingPossibleCastFunction_ = false;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    literalSubLexerContext = new LiteralSubLexerContext(literalsInfo);
                    if (this.hasMoreTokens()) {
                        String string12 = this.literalSub_nextToken();
                        if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string12)) {
                            literalsInfo.disallowLiteralSubstitution(false, null, null);
                            return literalsInfo;
                        }
                        if (string12.equals("'")) {
                            int n12 = this.currentPos_;
                            int n13 = this.findNextNotInQuotedString('\'', '\'', false, false);
                            string2 = this.subString(n12, n13);
                            this.literalSub_nextToken();
                            boolean bl7 = true;
                            short s2 = 0;
                            if (n4 == 9) {
                                s2 = 37;
                            } else if (n4 == 10) {
                                s2 = 38;
                            } else {
                                s2 = 39;
                                bl7 = literalsInfo.testIsTimestampSubstitutionOK(string2);
                            }
                            if (bl7) {
                                parenthesizedLevelDetail = this.openParenLitSubDetails_.get(this.parenDepth_);
                                if (literalsInfo.isSuccessfulLiteralReplacement(string2, s2, stringBuilder, '\u0000', parenthesizedLevelDetail)) {
                                    bl2 = true;
                                } else {
                                    bl7 = false;
                                }
                            }
                            if (bl7) continue block18;
                            stringBuilder.append(string);
                            stringBuilder.append(' ').append('\'');
                            stringBuilder.append(string2).append('\'');
                            break;
                        }
                        if (string12.equals("?")) {
                            stringBuilder.append(string12);
                            literalsInfo.recordParameterMarkerUse();
                            break;
                        }
                        stringBuilder.append(string);
                        literalSubLexerContext.restoreLiteralSubLexerContext();
                        break;
                    }
                    stringBuilder.append(string);
                    break;
                }
                case 12: {
                    stringBuilder.append(string);
                    literalSubLexerContext = new LiteralSubLexerContext(literalsInfo);
                    int n5 = 1;
                    stringArray[0] = null;
                    sArray[0] = 0;
                    String string13 = null;
                    if (!this.hasMoreTokens()) break;
                    String string14 = this.literalSub_nextToken();
                    if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string14)) {
                        literalsInfo.disallowLiteralSubstitution(false, null, null);
                        return literalsInfo;
                    }
                    if (string14.equalsIgnoreCase("FIRST")) {
                        string13 = string14;
                        string14 = this.literalSub_nextToken();
                        if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string14)) {
                            literalsInfo.disallowLiteralSubstitution(false, null, null);
                            return literalsInfo;
                        }
                    } else {
                        n5 = 0;
                    }
                    if (n5 != 0) {
                        boolean bl8 = this.isTokenNumericLiteral(string14, stringArray, sArray);
                        if (bl8) {
                            string14 = this.literalSub_nextToken();
                            if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string14)) {
                                literalsInfo.disallowLiteralSubstitution(false, null, null);
                                return literalsInfo;
                            }
                        } else {
                            n5 = 0;
                        }
                    }
                    if (n5 != 0 && !string14.equalsIgnoreCase("ROW") && !string14.equalsIgnoreCase("ROWS")) {
                        n5 = 0;
                    }
                    if (n5 != 0) {
                        stringBuilder.append(' ').append(string13).append(' ');
                        stringBuilder.append(stringArray[0]);
                        stringBuilder.append(' ');
                        stringBuilder.append(string14);
                        parenthesizedLevelDetail = this.openParenLitSubDetails_.get(this.parenDepth_);
                        parenthesizedLevelDetail.inOrderByExpressionList_ = false;
                        break;
                    }
                    literalSubLexerContext.restoreLiteralSubLexerContext();
                    break;
                }
                case 13: {
                    stringBuilder.append(string);
                    literalSubLexerContext = new LiteralSubLexerContext(literalsInfo);
                    boolean bl9 = true;
                    stringArray[0] = null;
                    sArray[0] = 0;
                    String string3 = null;
                    if (!this.hasMoreTokens()) break;
                    String string9 = this.literalSub_nextToken();
                    if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string9)) {
                        literalsInfo.disallowLiteralSubstitution(false, null, null);
                        return literalsInfo;
                    }
                    if (string9.equalsIgnoreCase("FOR")) {
                        string3 = string9;
                        string9 = this.literalSub_nextToken();
                        if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string9)) {
                            literalsInfo.disallowLiteralSubstitution(false, null, null);
                            return literalsInfo;
                        }
                    } else {
                        bl9 = false;
                    }
                    if (bl9) {
                        boolean bl10 = this.isTokenNumericLiteral(string9, stringArray, sArray);
                        if (bl10) {
                            string9 = this.literalSub_nextToken();
                            if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string9)) {
                                literalsInfo.disallowLiteralSubstitution(false, null, null);
                                return literalsInfo;
                            }
                        } else {
                            bl9 = false;
                        }
                    }
                    if (bl9 && !string9.equalsIgnoreCase("ROW") && !string9.equalsIgnoreCase("ROWS")) {
                        bl9 = false;
                    }
                    if (bl9) {
                        stringBuilder.append(' ').append(string3).append(' ');
                        stringBuilder.append(stringArray[0]);
                        stringBuilder.append(' ');
                        stringBuilder.append(string9);
                        parenthesizedLevelDetail = this.openParenLitSubDetails_.get(this.parenDepth_);
                        parenthesizedLevelDetail.inOrderByExpressionList_ = false;
                        break;
                    }
                    literalSubLexerContext.restoreLiteralSubLexerContext();
                    break;
                }
                case 14: {
                    stringBuilder.append(string);
                    literalSubLexerContext = new LiteralSubLexerContext(literalsInfo);
                    if (!this.hasMoreTokens()) break;
                    String string9 = this.literalSub_nextToken();
                    if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string9)) {
                        literalsInfo.disallowLiteralSubstitution(false, null, null);
                        return literalsInfo;
                    }
                    String string15 = null;
                    if (string9.equalsIgnoreCase("NOT")) {
                        string15 = string9;
                        string9 = this.literalSub_nextToken();
                        if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string9)) {
                            literalsInfo.disallowLiteralSubstitution(false, null, null);
                            return literalsInfo;
                        }
                    }
                    if (string9.equalsIgnoreCase("NULL")) {
                        stringBuilder.append(' ');
                        if (null != string15) {
                            stringBuilder.append(string15);
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(string9);
                        break;
                    }
                    literalSubLexerContext.restoreLiteralSubLexerContext();
                    break;
                }
                case 15: {
                    parenthesizedLevelDetail = this.openParenLitSubDetails_.get(this.parenDepth_);
                    if (literalsInfo.isSuccessfulLiteralReplacement(null, (short)41, stringBuilder, '\u0000', parenthesizedLevelDetail)) {
                        bl2 = true;
                        break;
                    }
                    stringBuilder.append(string);
                    break;
                }
                case 16: {
                    stringBuilder.append(string);
                    literalSubLexerContext = new LiteralSubLexerContext(literalsInfo);
                    if (!this.hasMoreTokens()) break;
                    String string16 = this.literalSub_nextToken();
                    if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string16)) {
                        literalsInfo.disallowLiteralSubstitution(false, null, null);
                        return literalsInfo;
                    }
                    if (string16.equalsIgnoreCase("BY")) {
                        stringBuilder.append(' ');
                        stringBuilder.append(string16);
                        parenthesizedLevelDetail = this.openParenLitSubDetails_.get(this.parenDepth_);
                        parenthesizedLevelDetail.inOrderByExpressionList_ = true;
                        break;
                    }
                    literalSubLexerContext.restoreLiteralSubLexerContext();
                    break;
                }
                case 17: {
                    stringBuilder.append(string);
                    stringArray[0] = null;
                    sArray[0] = 0;
                    literalSubLexerContext = new LiteralSubLexerContext(literalsInfo);
                    if (!this.hasMoreTokens()) break;
                    String string17 = this.literalSub_nextToken();
                    if (!literalsInfo.isLiteralSubstitutionAllowedForTheseTokens(string17)) {
                        literalsInfo.disallowLiteralSubstitution(false, null, null);
                        return literalsInfo;
                    }
                    boolean bl11 = this.isTokenNumericLiteral(string17, stringArray, sArray);
                    if (bl11) {
                        stringBuilder.append(' ').append(stringArray[0]);
                        stringBuilder.append(' ');
                        parenthesizedLevelDetail = this.openParenLitSubDetails_.get(this.parenDepth_);
                        parenthesizedLevelDetail.inOrderByExpressionList_ = false;
                        break;
                    }
                    literalSubLexerContext.restoreLiteralSubLexerContext();
                }
            }
        } while (this.hasMoreTokens());
        if (bl2) {
            literalsInfo.setLiteralReplacedSql(stringBuilder.toString());
            literalsInfo.allowLiteralSubstitution();
        } else {
            literalsInfo.disallowLiteralSubstitution(false, null, null);
        }
        return literalsInfo;
    }

    private void litSubHandleOneQuotedPair(StringBuilder stringBuilder, char c10) throws DataSQLException {
        int n2;
        stringBuilder.append(c10);
        int n3 = this.currentPos_;
        if (this.hasMoreTokens() && (n2 = this.findNextNotInQuotedString(c10, c10, false, false)) > -1) {
            String string = this.subString(n3, n2);
            stringBuilder.append(string);
            String string2 = this.nextToken();
            stringBuilder.append(string2);
        }
    }

    private boolean litSubHandleQuotedString(LiteralsInfo literalsInfo, StringBuilder stringBuilder) throws DataSQLException {
        char c10;
        Object object;
        int n2 = 0;
        String string = null;
        boolean bl2 = false;
        String string2 = null;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        int n3 = this.currentPos_;
        n2 = this.currentPos_;
        while (this.hasMoreTokens() && !bl3) {
            int c102 = this.findNextNotInQuotedString('\'', '\'', false, false);
            object = this.subString(n2, c102);
            stringBuilder2.append((String)object);
            string = this.nextToken();
            if (string.equals("'")) {
                if (this.peekChar('\'')) {
                    string = this.nextToken();
                    stringBuilder2.append(string);
                } else {
                    bl3 = true;
                }
            }
            n2 = this.currentPos_;
        }
        string2 = stringBuilder2.toString();
        if (literalsInfo.isSuccessfulLiteralReplacement(string2, (short)40, stringBuilder, c10 = this.isLexingPossibleCastFunction_ ? (char)'\u0001' : '\u0000', (ParenthesizedLevelDetail)(object = this.openParenLitSubDetails_.get(this.parenDepth_)))) {
            bl2 = true;
        } else {
            stringBuilder.append('\'');
            stringBuilder.append(this.subString(n3, n2));
        }
        return bl2;
    }

    int findNextPairedBracket(char c10, char c11, boolean bl2) {
        int n2 = 0;
        do {
            if (this.currentChar_ == c11 && n2 == 0) {
                int n3 = this.currentPos_;
                if (bl2) {
                    this.advance();
                }
                return n3;
            }
            if (this.currentChar_ == c10) {
                ++n2;
            }
            if (this.currentChar_ == c11) {
                --n2;
            }
            this.advance();
        } while (this.findNextNotInQuotedString('(', ')', false, true) != -1);
        return -1;
    }

    private short guessNumericLiteralValueType(String string) {
        int n2 = 0;
        int n3 = string.indexOf(".");
        int n4 = string.indexOf("E");
        int n5 = string.indexOf("e");
        if (n3 == -1 && n4 == -1 && n5 == -1) {
            if (string.length() <= 19) {
                n2 = 33;
                try {
                    Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 34;
                }
            } else {
                n2 = string.length() <= 31 ? 34 : 35;
            }
        } else if (n3 != -1 && n4 == -1 && n5 == -1) {
            n2 = string.length() <= 32 ? 34 : 35;
        } else {
            n2 = 36;
            try {
                Matcher matcher;
                Double d10 = Double.valueOf(string);
                if (d10.isInfinite() || d10.isNaN()) {
                    n2 = 35;
                } else if (d10 < Double.MIN_VALUE && !(matcher = floatZeroPat_.matcher(string)).matches()) {
                    n2 = 35;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 35;
            }
        }
        return (short)n2;
    }

    private boolean checkAndSubstituteParametersForNumericLiterals(String string, StringBuilder stringBuilder, LiteralsInfo literalsInfo) throws DataSQLException {
        boolean bl2 = false;
        String[] stringArray = new String[1];
        short[] sArray = new short[1];
        boolean bl3 = this.isTokenNumericLiteral(string, stringArray, sArray);
        if (bl3) {
            Object object;
            char c10 = '\u0000';
            if (this.hasMoreTokens()) {
                object = new LexerContext();
                String string2 = this.nextToken().toUpperCase();
                ((LexerContext)object).restoreLexerContext();
                if (string2.equals("YEAR") || string2.equals("YEARS") || string2.equals("MONTH") || string2.equals("MONTHS") || string2.equals("DAY") || string2.equals("DAYS") || string2.equals("HOUR") || string2.equals("HOURS") || string2.equals("MINUTE") || string2.equals("MINUTES") || string2.equals("SECOND") || string2.equals("SECONDS") || string2.equals("MICROSECOND") || string2.equals("MICROSECONDS")) {
                    c10 = (char)16;
                }
            }
            if (this.isPriorLitSubTokenArithmeticUnary_) {
                int n2 = stringBuilder.length();
                stringBuilder.delete(this.lastArithmeticTokenBuilderIndex_, n2);
                if ("-".equals(this.priorLitSubToken_)) {
                    stringArray[0] = this.priorLitSubToken_ + stringArray[0];
                }
            }
            if (literalsInfo.isSuccessfulLiteralReplacement(stringArray[0], sArray[0], stringBuilder, c10 = (char)(c10 | (this.isLexingPossibleCastFunction_ ? 1 : 0)), (ParenthesizedLevelDetail)(object = this.openParenLitSubDetails_.get(this.parenDepth_)))) {
                bl2 = true;
            } else {
                stringBuilder.append(stringArray[0]);
            }
        } else {
            stringBuilder.append(string);
        }
        return bl2;
    }

    private boolean isTokenNumericLiteral(String string, String[] stringArray, short[] sArray) throws DataSQLException {
        boolean bl2;
        block6: {
            bl2 = false;
            String string2 = string;
            char c10 = string2.charAt(0);
            if (!Character.isDigit(c10) && c10 != '.') {
                stringArray[0] = string;
                return false;
            }
            LexerContext lexerContext = null;
            if (string2.endsWith("E") || string2.endsWith("e")) {
                lexerContext = new LexerContext();
                StringBuilder stringBuilder = new StringBuilder(string2);
                if (this.hasMoreTokens()) {
                    string2 = this.nextToken();
                    stringBuilder.append(string2);
                    if ((string2.equals("-") || string2.equals("+")) && this.hasMoreTokens()) {
                        string2 = this.nextToken();
                        stringBuilder.append(string2);
                    }
                }
                string2 = stringBuilder.toString();
            }
            try {
                Double.parseDouble(string2);
                sArray[0] = this.guessNumericLiteralValueType(string2);
                stringArray[0] = string2;
                bl2 = true;
            }
            catch (NumberFormatException numberFormatException) {
                stringArray[0] = string;
                if (lexerContext == null) break block6;
                lexerContext.restoreLexerContext();
            }
        }
        return bl2;
    }

    private String literalSub_nextToken() throws DataSQLException {
        this.isPriorLitSubTokenArithmeticUnary_ = this.isCurrentLitSubTokenArithmeticUnary_;
        this.isCurrentLitSubTokenArithmeticUnary_ = false;
        this.priorLitSubToken_ = this.currentLitSubToken_;
        this.currentLitSubToken_ = this.nextToken();
        String string = this.currentLitSubToken_.toUpperCase();
        ParenthesizedLevelDetail parenthesizedLevelDetail = this.openParenLitSubDetails_.get(this.parenDepth_);
        if ("(".equals(this.currentLitSubToken_)) {
            if (parenthesizedLevelDetail.containsSELECTQuery_ && "SELECT".equalsIgnoreCase(this.priorLitSubToken_)) {
                parenthesizedLevelDetail.inSelectExpressionList_ = true;
                parenthesizedLevelDetail.isFunctionInvocation_ = false;
                parenthesizedLevelDetail.inOrderByExpressionList_ = false;
            } else if (SqlStatementType.VALUES == parenthesizedLevelDetail.currentLevelStatementType_ && (",".equals(this.priorLitSubToken_) || "VALUES".equalsIgnoreCase(this.priorLitSubToken_))) {
                parenthesizedLevelDetail.inSelectExpressionList_ = true;
                parenthesizedLevelDetail.isFunctionInvocation_ = false;
                parenthesizedLevelDetail.inOrderByExpressionList_ = false;
            } else if ("TABLE".equalsIgnoreCase(this.priorLitSubToken_)) {
                parenthesizedLevelDetail.hasTableReference_ = true;
                parenthesizedLevelDetail.isAfterTableReference_ = false;
                parenthesizedLevelDetail.isTableReferenceCorrelationClause_ = false;
            }
            ParenthesizedLevelDetail parenthesizedLevelDetail2 = new ParenthesizedLevelDetail(parenthesizedLevelDetail, this.priorLitSubToken_);
            if (parenthesizedLevelDetail.isAfterTableReference_) {
                parenthesizedLevelDetail2.isTableReferenceCorrelationClause_ = true;
                parenthesizedLevelDetail.hasTableReference_ = false;
                parenthesizedLevelDetail.isAfterTableReference_ = false;
            }
            if (this.parenDepth_ + 1 < this.openParenLitSubDetails_.size()) {
                this.openParenLitSubDetails_.set(this.parenDepth_ + 1, parenthesizedLevelDetail2);
            } else {
                this.openParenLitSubDetails_.add(parenthesizedLevelDetail2);
            }
            ++this.parenDepth_;
        } else if (")".equals(this.currentLitSubToken_)) {
            --this.parenDepth_;
            ParenthesizedLevelDetail parenthesizedLevelDetail3 = this.openParenLitSubDetails_.get(this.parenDepth_);
            if (parenthesizedLevelDetail3.hasTableReference_) {
                parenthesizedLevelDetail3.isAfterTableReference_ = true;
            }
        } else if (("(".equals(this.priorLitSubToken_) || null == this.priorLitSubToken_) && ("SELECT".equals(string) || "WITH".equals(string) || "VALUES".equals(string) || "INSERT".equals(string))) {
            if ("SELECT".equals(string) || "WITH".equals(string)) {
                parenthesizedLevelDetail.containsQuery_ = true;
                parenthesizedLevelDetail.currentLevelStatementType_ = SqlStatementType.QUERY;
                if ("SELECT".equals(string)) {
                    parenthesizedLevelDetail.containsSELECTQuery_ = true;
                } else {
                    parenthesizedLevelDetail.containsWITHQuery_ = true;
                }
            } else if ("VALUES".equals(string)) {
                if (SqlStatementType.MERGE != parenthesizedLevelDetail.currentLevelStatementType_) {
                    parenthesizedLevelDetail.containsQuery_ = true;
                    parenthesizedLevelDetail.currentLevelStatementType_ = SqlStatementType.VALUES;
                    parenthesizedLevelDetail.containsVALUESQuery_ = true;
                }
            } else {
                parenthesizedLevelDetail.currentLevelStatementType_ = SqlStatementType.INSERT;
            }
            if (parenthesizedLevelDetail.isFunctionInvocation_) {
                parenthesizedLevelDetail.isFunctionInvocation_ = false;
            }
        } else if (parenthesizedLevelDetail.currentLevelStatementType_ == SqlStatementType.INSERT && ("SELECT".equals(string) || "WITH".equals(string))) {
            if ("SELECT".equals(string)) {
                parenthesizedLevelDetail.containsQuery_ = true;
                parenthesizedLevelDetail.currentLevelStatementType_ = SqlStatementType.QUERY;
                parenthesizedLevelDetail.containsSELECTQuery_ = true;
            } else if ("WITH".equals(string)) {
                parenthesizedLevelDetail.containsQuery_ = true;
                parenthesizedLevelDetail.currentLevelStatementType_ = SqlStatementType.QUERY;
                parenthesizedLevelDetail.containsWITHQuery_ = true;
            }
            if (parenthesizedLevelDetail.isFunctionInvocation_) {
                parenthesizedLevelDetail.isFunctionInvocation_ = false;
            }
        } else if ("SELECT".equals(string) && parenthesizedLevelDetail.containsWITHQuery_) {
            parenthesizedLevelDetail.containsQuery_ = true;
            parenthesizedLevelDetail.containsSELECTQuery_ = true;
            if (parenthesizedLevelDetail.isFunctionInvocation_) {
                parenthesizedLevelDetail.isFunctionInvocation_ = false;
            }
        } else if (parenthesizedLevelDetail.containsQuery_) {
            if (parenthesizedLevelDetail.inSelectExpressionList_) {
                if ("FROM".equals(string)) {
                    boolean bl2 = false;
                    if (this.priorLitSubToken_.length() == 1) {
                        bl2 = this.isDelimChar(this.priorLitSubToken_.charAt(0));
                    }
                    if (bl2 && -1 != delimitersThatMightEndSelectExpressionList_.indexOf(this.priorLitSubToken_)) {
                        parenthesizedLevelDetail.inSelectExpressionList_ = false;
                    } else if (!bl2) {
                        parenthesizedLevelDetail.inSelectExpressionList_ = false;
                    }
                }
            } else if (parenthesizedLevelDetail.containsSELECTQuery_ && "SELECT".equalsIgnoreCase(this.priorLitSubToken_)) {
                if (!"ALL".equals(string) && !"DISTINCT".equals(string)) {
                    parenthesizedLevelDetail.inSelectExpressionList_ = true;
                    parenthesizedLevelDetail.inOrderByExpressionList_ = false;
                } else {
                    parenthesizedLevelDetail.hasAllOrDistinct_ = true;
                }
            } else if (parenthesizedLevelDetail.hasAllOrDistinct_ && ("ALL".equalsIgnoreCase(this.priorLitSubToken_) || "DISTINCT".equalsIgnoreCase(this.priorLitSubToken_))) {
                parenthesizedLevelDetail.inSelectExpressionList_ = true;
                parenthesizedLevelDetail.inOrderByExpressionList_ = false;
                parenthesizedLevelDetail.hasAllOrDistinct_ = false;
            }
        }
        if (parenthesizedLevelDetail.isAfterTableReference_ && null != tableReferenceTerminator_.get(string)) {
            parenthesizedLevelDetail.isAfterTableReference_ = false;
            parenthesizedLevelDetail.hasTableReference_ = false;
            parenthesizedLevelDetail.isTableReferenceCorrelationClause_ = false;
        }
        return this.currentLitSubToken_;
    }

    public static String filterComments(String string, boolean bl2) {
        String string2;
        string = string.trim();
        if (!bl2 ? !string.startsWith("/*") && !string.startsWith("--") : (string2 = string.toUpperCase()).startsWith("XQUERY")) {
            return string;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        try {
            while (!bl3) {
                n2 = 0;
                if (!bl4) {
                    n6 = string.indexOf("--", n4);
                    if (n6 > -1) {
                        n2 = 1;
                        n3 = n6;
                    } else {
                        bl4 = true;
                    }
                }
                if (!bl5) {
                    n7 = string.indexOf("/*", n4);
                    if (n7 > -1) {
                        if (n7 < n3 || n2 == 0) {
                            n2 = 2;
                            n3 = n7;
                        }
                    } else {
                        bl5 = true;
                    }
                }
                if (!bl6) {
                    n8 = string.indexOf("\"", n4);
                    if (n8 > -1) {
                        if (n8 < n3 || n2 == 0) {
                            n2 = 3;
                            n3 = n8;
                        }
                    } else {
                        bl6 = true;
                    }
                }
                if (!bl7) {
                    n9 = string.indexOf("'", n4);
                    if (n9 > -1) {
                        if (n9 < n3 || n2 == 0) {
                            n2 = 4;
                            n3 = n9;
                        }
                    } else {
                        bl7 = true;
                    }
                }
                if (n3 > n4) {
                    stringBuilder = stringBuilder.append(string.substring(n4, n3));
                } else if (n2 == 0 && n4 < string.length()) {
                    stringBuilder = stringBuilder.append(string.substring(n4));
                }
                n4 = n3 + 1;
                switch (n2) {
                    case 0: {
                        bl3 = true;
                        break;
                    }
                    case 1: {
                        int n10 = string.indexOf("\n", n4);
                        int n11 = string.indexOf("\r", n4);
                        if (n11 > -1 && n10 > -1) {
                            n4 = n11 < n10 ? n11 : n10;
                            break;
                        }
                        if (n11 > -1) {
                            n4 = n11;
                            break;
                        }
                        if (n10 > -1) {
                            n4 = n10;
                            break;
                        }
                        bl3 = true;
                        break;
                    }
                    case 2: {
                        n4 = EscapeLexer.locateBracketCommentEnd(string, n4);
                        stringBuilder = stringBuilder.append(' ');
                        break;
                    }
                    case 3: {
                        n5 = EscapeLexer.findMatchQuote(string, n4, "\"");
                        stringBuilder = stringBuilder.append(string.substring(n4 - 1, n5));
                        n4 = n5;
                        break;
                    }
                    case 4: {
                        n5 = EscapeLexer.findMatchQuote(string, n4, "'");
                        stringBuilder = stringBuilder.append(string.substring(n4 - 1, n5));
                        n4 = n5;
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuilder = stringBuilder.append(string.substring(n4 - 1));
        }
        return stringBuilder.toString();
    }

    private static int locateBracketCommentEnd(String string, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = string.indexOf("*/", n2);
        int n6 = string.indexOf("/*", n2);
        if (n6 != -1 && n6 <= n5) {
            n3 = n6 + 2;
            n4 = 2;
            while (n4 > 0) {
                n5 = string.indexOf("*/", n3);
                n6 = string.indexOf("/*", n3);
                if (n6 == -1 && n5 == -1) {
                    throw new IllegalArgumentException();
                }
                if (n6 == -1 || n6 > n5) {
                    --n4;
                    n3 = n5 + 2;
                    continue;
                }
                ++n4;
                n3 = n6 + 2;
            }
        }
        return n5 + 2;
    }

    private static int findMatchQuote(String string, int n2, String string2) {
        boolean bl2 = false;
        int n3 = n2;
        while (!bl2) {
            int n4 = string.indexOf(string2, n3);
            if (n4 > -1) {
                if (string.substring(n4).startsWith(string2.concat(string2))) {
                    n3 = n4 + 2;
                    continue;
                }
                n3 = n4 + 1;
                bl2 = true;
                continue;
            }
            throw new IllegalArgumentException();
        }
        return n3;
    }

    static {
        selectAndPredicateTokenList_.put("SELECT", 1);
        selectAndPredicateTokenList_.put("UNION", 2);
        selectAndPredicateTokenList_.put("EXCEPT", 3);
        selectAndPredicateTokenList_.put("INTERSECT", 4);
        selectAndPredicateTokenList_.put("DISTINCT", 5);
        selectAndPredicateTokenList_.put("ALL", 6);
        selectAndPredicateTokenList_.put("WHERE", 7);
        selectAndPredicateTokenList_.put("ON", 8);
        selectAndPredicateTokenList_.put("HAVING", 9);
        selectAndPredicateTokenList_.put("AND", 10);
        selectAndPredicateTokenList_.put("OR", 11);
        selectAndPredicateTokenList_.put("NOT", 12);
        selectAndPredicateTokenList_.put("TABLE", 13);
        generalNonFunctionTokenList_.put("SELECT", 1);
        generalNonFunctionTokenList_.put("VALUES", 2);
        generalNonFunctionTokenList_.put("WHERE", 3);
        generalNonFunctionTokenList_.put("ON", 4);
        generalNonFunctionTokenList_.put("AND", 5);
        generalNonFunctionTokenList_.put("OR", 6);
        generalNonFunctionTokenList_.put("NOT", 7);
        generalNonFunctionTokenList_.put("TABLE", 8);
        tableReferenceTerminator_.put(",", 1);
        tableReferenceTerminator_.put("WHERE", 2);
        tableReferenceTerminator_.put("GROUP", 3);
        tableReferenceTerminator_.put("HAVING", 4);
        tableReferenceTerminator_.put("ORDER", 5);
        tableReferenceTerminator_.put("FETCH", 6);
        tableReferenceTerminator_.put("WITH", 7);
        tableReferenceTerminator_.put(";", 8);
        tableReferenceTerminator_.put("JOIN", 9);
        tableReferenceTerminator_.put("ON", 10);
        tableReferenceTerminator_.put("USING", 11);
        tokenSequenceIntroducer_.put("CASE", 7);
        tokenSequenceIntroducer_.put("CAST", 8);
        tokenSequenceIntroducer_.put("DATE", 9);
        tokenSequenceIntroducer_.put("TIME", 10);
        tokenSequenceIntroducer_.put("TIMESTAMP", 11);
        tokenSequenceIntroducer_.put("FETCH", 12);
        tokenSequenceIntroducer_.put("OPTIMIZE", 13);
        tokenSequenceIntroducer_.put("IS", 14);
        tokenSequenceIntroducer_.put("NULL", 15);
        tokenSequenceIntroducer_.put("ORDER", 16);
        tokenSequenceIntroducer_.put("QUERYNO", 17);
        lowerCaseTokenToTypeMap_ = new HashMap();
        lowerCaseTokenToTypeMap_.put("alter", SqlStatementType.ALTER);
        lowerCaseTokenToTypeMap_.put("begin", SqlStatementType.COMPOUND);
        lowerCaseTokenToTypeMap_.put("call", SqlStatementType.CALL);
        lowerCaseTokenToTypeMap_.put("comment", SqlStatementType.COMMENT);
        lowerCaseTokenToTypeMap_.put("create", SqlStatementType.CREATE);
        lowerCaseTokenToTypeMap_.put("delete", SqlStatementType.DELETE);
        lowerCaseTokenToTypeMap_.put("drop", SqlStatementType.DROP);
        lowerCaseTokenToTypeMap_.put("grant", SqlStatementType.GRANT);
        lowerCaseTokenToTypeMap_.put("insert", SqlStatementType.INSERT);
        lowerCaseTokenToTypeMap_.put("label", SqlStatementType.LABEL);
        lowerCaseTokenToTypeMap_.put("merge", SqlStatementType.MERGE);
        lowerCaseTokenToTypeMap_.put("rename", SqlStatementType.RENAME);
        lowerCaseTokenToTypeMap_.put("revoke", SqlStatementType.REVOKE);
        lowerCaseTokenToTypeMap_.put("select", SqlStatementType.QUERY);
        lowerCaseTokenToTypeMap_.put("set", SqlStatementType.SET);
        lowerCaseTokenToTypeMap_.put("update", SqlStatementType.UPDATE);
        lowerCaseTokenToTypeMap_.put("values", SqlStatementType.VALUES);
        lowerCaseTokenToTypeMap_.put("with", SqlStatementType.QUERY);
        lowerCaseTokenToTypeMap_.put("xquery", SqlStatementType.XQUERY);
    }

    private class LiteralSubLexerContext
    extends LexerContext {
        private int parenDepthLC_;
        private ArrayList<ParenthesizedLevelDetail> openParenLitSubDetailsLC_;
        private String currentLitSubTokenLC_;
        private String priorLitSubTokenLC_;
        private boolean isCurrentLitSubTokenArithmeticUnaryLC_;
        private boolean isPriorLitSubTokenArithmeticUnaryLC_;
        private int lastArithmeticTokenBuilderIndexLC_;
        private LiteralsInfo currentLiteralInfo_;

        private LiteralSubLexerContext(LiteralsInfo literalsInfo) {
            this.parenDepthLC_ = 0;
            this.openParenLitSubDetailsLC_ = new ArrayList();
            this.currentLitSubTokenLC_ = null;
            this.priorLitSubTokenLC_ = null;
            this.isCurrentLitSubTokenArithmeticUnaryLC_ = false;
            this.isPriorLitSubTokenArithmeticUnaryLC_ = false;
            this.lastArithmeticTokenBuilderIndexLC_ = 0;
            this.currentLiteralInfo_ = null;
            this.parenDepthLC_ = EscapeLexer.this.parenDepth_;
            this.openParenLitSubDetailsLC_ = new ArrayList(EscapeLexer.this.parenDepth_ + 1);
            for (int i10 = 0; i10 < EscapeLexer.this.parenDepth_ + 1; ++i10) {
                this.openParenLitSubDetailsLC_.add(new ParenthesizedLevelDetail(EscapeLexer.this.openParenLitSubDetails_.get(i10)));
            }
            this.currentLitSubTokenLC_ = EscapeLexer.this.currentLitSubToken_;
            this.priorLitSubTokenLC_ = EscapeLexer.this.priorLitSubToken_;
            this.isCurrentLitSubTokenArithmeticUnaryLC_ = EscapeLexer.this.isCurrentLitSubTokenArithmeticUnary_;
            this.isPriorLitSubTokenArithmeticUnaryLC_ = EscapeLexer.this.isPriorLitSubTokenArithmeticUnary_;
            this.lastArithmeticTokenBuilderIndexLC_ = EscapeLexer.this.lastArithmeticTokenBuilderIndex_;
            this.currentLiteralInfo_ = literalsInfo;
            literalsInfo.setRecoveryPoint();
        }

        private void restoreLiteralSubLexerContext() {
            ((LexerContext)this).restoreLexerContext();
            EscapeLexer.this.parenDepth_ = this.parenDepthLC_;
            EscapeLexer.this.openParenLitSubDetails_ = this.openParenLitSubDetailsLC_;
            EscapeLexer.this.currentLitSubToken_ = this.currentLitSubTokenLC_;
            EscapeLexer.this.priorLitSubToken_ = this.priorLitSubTokenLC_;
            EscapeLexer.this.isCurrentLitSubTokenArithmeticUnary_ = this.isCurrentLitSubTokenArithmeticUnaryLC_;
            EscapeLexer.this.isPriorLitSubTokenArithmeticUnary_ = this.isPriorLitSubTokenArithmeticUnaryLC_;
            EscapeLexer.this.lastArithmeticTokenBuilderIndex_ = this.lastArithmeticTokenBuilderIndexLC_;
            this.currentLiteralInfo_.returnToRecoveryPoint();
        }
    }

    private class LexerContext {
        private int currentPosLC_;
        private boolean inSingleQuotedStringLC_;
        private boolean inDoubleQuotedStringLC_;
        private int blockCommentDepthLC_;
        private boolean inLineCommentLC_;
        private int curlyNestingDepthLC_;
        private char currentCharLC_;
        private char prevCharLC_;
        private char nextCharLC_;
        private char prevPrevCharLC_;
        private int blockIndicatorEndIndexLC_;
        private boolean foundSearchedValueLC_;
        private boolean sqlHasParameterMarkerBeforeFirstWordLC_;

        private LexerContext() {
            this.currentPosLC_ = EscapeLexer.this.currentPos_;
            this.inSingleQuotedStringLC_ = EscapeLexer.this.inSingleQuotedString_;
            this.inDoubleQuotedStringLC_ = EscapeLexer.this.inDoubleQuotedString_;
            this.blockCommentDepthLC_ = EscapeLexer.this.blockCommentDepth_;
            this.inLineCommentLC_ = EscapeLexer.this.inLineComment_;
            this.curlyNestingDepthLC_ = EscapeLexer.this.curlyNestingDepth_;
            this.currentCharLC_ = EscapeLexer.this.currentChar_;
            this.prevCharLC_ = EscapeLexer.this.prevChar_;
            this.nextCharLC_ = EscapeLexer.this.nextChar_;
            this.prevPrevCharLC_ = EscapeLexer.this.prevPrevChar_;
            this.blockIndicatorEndIndexLC_ = EscapeLexer.this.blockIndicatorEndIndex_;
            this.foundSearchedValueLC_ = EscapeLexer.this.foundSearchedValue_;
            this.sqlHasParameterMarkerBeforeFirstWordLC_ = EscapeLexer.this.sqlHasParameterMarkerBeforeFirstWord_;
        }

        private void restoreLexerContext() {
            EscapeLexer.this.currentPos_ = this.currentPosLC_;
            EscapeLexer.this.inSingleQuotedString_ = this.inSingleQuotedStringLC_;
            EscapeLexer.this.inDoubleQuotedString_ = this.inDoubleQuotedStringLC_;
            EscapeLexer.this.blockCommentDepth_ = this.blockCommentDepthLC_;
            EscapeLexer.this.inLineComment_ = this.inLineCommentLC_;
            EscapeLexer.this.curlyNestingDepth_ = this.curlyNestingDepthLC_;
            EscapeLexer.this.currentChar_ = this.currentCharLC_;
            EscapeLexer.this.prevChar_ = this.prevCharLC_;
            EscapeLexer.this.nextChar_ = this.nextCharLC_;
            EscapeLexer.this.prevPrevChar_ = this.prevPrevCharLC_;
            EscapeLexer.this.blockIndicatorEndIndex_ = this.blockIndicatorEndIndexLC_;
            EscapeLexer.this.foundSearchedValue_ = this.foundSearchedValueLC_;
            EscapeLexer.this.sqlHasParameterMarkerBeforeFirstWord_ = this.sqlHasParameterMarkerBeforeFirstWordLC_;
        }
    }

    public class ParenthesizedLevelDetail {
        public SqlStatementType containingStatementType_;
        public SqlStatementType currentLevelStatementType_;
        public String openParensPreviousToken_ = null;
        public boolean containsQuery_ = false;
        public boolean containsWITHQuery_ = false;
        public boolean containsSELECTQuery_ = false;
        public boolean containsVALUESQuery_ = false;
        public boolean inSelectExpressionList_ = false;
        public boolean hasAllOrDistinct_ = false;
        public boolean isFunctionInvocation_ = false;
        public boolean inOrderByExpressionList_ = false;
        public boolean hasTableReference_ = false;
        public boolean isAfterTableReference_ = false;
        public boolean isTableReferenceCorrelationClause_ = false;

        public ParenthesizedLevelDetail(ParenthesizedLevelDetail parenthesizedLevelDetail, String string) {
            boolean bl2 = false;
            if (null == parenthesizedLevelDetail) {
                this.containingStatementType_ = SqlStatementType.OTHERSQL;
            } else {
                this.containingStatementType_ = parenthesizedLevelDetail.currentLevelStatementType_;
                bl2 = parenthesizedLevelDetail.containsWITHQuery_ && !parenthesizedLevelDetail.containsSELECTQuery_;
                this.inSelectExpressionList_ = parenthesizedLevelDetail.inSelectExpressionList_;
                this.isFunctionInvocation_ = parenthesizedLevelDetail.isFunctionInvocation_;
            }
            this.currentLevelStatementType_ = SqlStatementType.INSERT == this.containingStatementType_ || SqlStatementType.QUERY == this.containingStatementType_ || SqlStatementType.VALUES == this.containingStatementType_ || SqlStatementType.MERGE == this.containingStatementType_ ? this.containingStatementType_ : SqlStatementType.OTHERSQL;
            this.openParensPreviousToken_ = string;
            if (null != parenthesizedLevelDetail) {
                this.isTableReferenceCorrelationClause_ = parenthesizedLevelDetail.isTableReferenceCorrelationClause_;
            }
            if (null != string) {
                if (string.length() == 1) {
                    this.isFunctionInvocation_ |= !EscapeLexer.this.isDelimChar(string.charAt(0));
                } else {
                    String string2 = this.openParensPreviousToken_.toUpperCase();
                    if (string2.equals("IN")) {
                        this.isFunctionInvocation_ = false;
                    } else if (this.currentLevelStatementType_ == SqlStatementType.INSERT || this.currentLevelStatementType_ == SqlStatementType.VALUES) {
                        if (!string2.equals("VALUES") && !string2.equals("SELECT")) {
                            this.isFunctionInvocation_ = true;
                        }
                    } else if (this.currentLevelStatementType_ == SqlStatementType.QUERY) {
                        if (!bl2 && null == selectAndPredicateTokenList_.get(string2)) {
                            this.isFunctionInvocation_ = true;
                        }
                    } else if (null == generalNonFunctionTokenList_.get(string2)) {
                        this.isFunctionInvocation_ = true;
                    }
                }
                if (this.isFunctionInvocation_ && this.inSelectExpressionList_) {
                    this.inSelectExpressionList_ = false;
                }
            }
        }

        public ParenthesizedLevelDetail(ParenthesizedLevelDetail parenthesizedLevelDetail) {
            this.containingStatementType_ = parenthesizedLevelDetail.containingStatementType_;
            this.currentLevelStatementType_ = parenthesizedLevelDetail.currentLevelStatementType_;
            this.openParensPreviousToken_ = parenthesizedLevelDetail.openParensPreviousToken_;
            this.containsQuery_ = parenthesizedLevelDetail.containsQuery_;
            if (this.containsQuery_) {
                this.containsWITHQuery_ = parenthesizedLevelDetail.containsWITHQuery_;
                this.containsSELECTQuery_ = parenthesizedLevelDetail.containsSELECTQuery_;
                this.containsVALUESQuery_ = parenthesizedLevelDetail.containsVALUESQuery_;
                this.inSelectExpressionList_ = parenthesizedLevelDetail.inSelectExpressionList_;
                this.hasAllOrDistinct_ = parenthesizedLevelDetail.hasAllOrDistinct_;
                this.inOrderByExpressionList_ = parenthesizedLevelDetail.inOrderByExpressionList_;
            }
            this.isFunctionInvocation_ = parenthesizedLevelDetail.isFunctionInvocation_;
            this.hasTableReference_ = parenthesizedLevelDetail.hasTableReference_;
            this.isAfterTableReference_ = parenthesizedLevelDetail.isAfterTableReference_;
            this.isTableReferenceCorrelationClause_ = parenthesizedLevelDetail.isTableReferenceCorrelationClause_;
        }
    }

    public static enum sqlMode {
        isQuery__,
        isCall__,
        isUpdate__,
        isInvalidSql__;

    }
}

