-- Copyright (c) DbVis Software AB. All Rights Reserved.
/*
 A sample script to select some arbitrary numbers from the payments/rental data.
 Use for creating charts (etc).
*/ 
SELECT
    COUNTRY,  
    SUM(payment.amount)                                         AS "Total Paid",
    ROUND(AVG(payment.amount), 2)                               AS "Avg Paid",
    COUNT(DISTINCT rental.RENTAL_ID)                            AS "Rentals",
    COUNT(DISTINCT film.FILM_ID)                                AS "Films",
    COUNT(DISTINCT PAYMENT.CUSTOMER_ID)                         AS "Customers",
    SUM(DATEDIFF(DAY, RENTAL.RENTAL_DATE, RENTAL.RETURN_DATE))  AS "Total Duration"
    FROM payment
	JOIN customer ON payment.customer_id = customer.customer_id
	JOIN address ON customer.ADDRESS_ID = address.ADDRESS_ID
	JOIN city ON address.CITY_ID = city.CITY_ID
        JOIN country ON city.COUNTRY_ID = country.COUNTRY_ID
        JOIN rental ON payment.RENTAL_ID = rental.RENTAL_ID
        JOIN inventory ON rental.INVENTORY_ID = INVENTORY.INVENTORY_ID
        JOIN film ON inventory.FILM_ID = film.FILM_ID

	GROUP BY COUNTRY ORDER BY COUNTRY;