/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32.wininet;

import com.install4j.runtime.installer.platform.win32.wininet.Headers;
import com.install4j.runtime.installer.platform.win32.wininet.WinInet;
import com.install4j.runtime.installer.platform.win32.wininet.WinInetAuthenticator;
import com.install4j.runtime.installer.platform.win32.wininet.WinInetCall;
import com.install4j.runtime.installer.platform.win32.wininet.WinInetInputStream;
import com.install4j.runtime.installer.platform.win32.wininet.WinInetOutputStream;
import com.install4j.runtime.installer.platform.win32.wininet.WinInetUnavailableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CallImpl
implements WinInetCall {
    private static final int MAX_RETRIES = 10;
    private static final int UNAUTHORIZED = 401;
    private static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    private long address;
    private final URI uri;
    private String requestHeaders;
    private final WinInetAuthenticator authenticator;
    private final byte[] buffer = new byte[1];
    @Nullable
    private WinInetOutputStream outputStream;
    private final WinInetInputStream inputStream = new WinInetInputStream(this);
    private boolean eof;
    private final Headers headers = new Headers();

    public CallImpl(long address, URI uri, long contentLength, String requestHeaders, WinInetAuthenticator authenticator) throws IOException {
        this.address = address;
        this.uri = uri;
        this.requestHeaders = requestHeaders;
        this.authenticator = authenticator;
        if (contentLength > 0L) {
            this.outputStream = new WinInetOutputStream(this, contentLength);
        }
        this.checkExceptionAndClose();
    }

    synchronized long getAddress() {
        return this.address;
    }

    synchronized boolean checkExceptionAndClose() throws IOException {
        int errorLocation = WinInet.getErrorLocation0(this.address);
        int errorCode = WinInet.getErrorCode0(this.address);
        if (errorCode == 12032) {
            WinInet.clearError0(this.address);
            return true;
        }
        if (errorLocation != 0) {
            this.close();
            if (errorCode == 12007) {
                throw new UnknownHostException(this.uri.getHost());
            }
            if (errorCode == 12002) {
                throw new SocketTimeoutException("timeout (loc: " + errorLocation + ")");
            }
            if (errorCode == 12164) {
                throw new SocketException("server unreachable (loc:  " + errorLocation + ")");
            }
            if (errorCode == 12023) {
                throw new SocketException("direct network access cannot be made at this time (loc:  " + errorLocation + ")");
            }
            if (errorCode == 12020) {
                throw new SocketException("the request cannot be made via a proxy (loc:  " + errorLocation + ")");
            }
            if (errorCode == 12165) {
                throw new SocketException("the designated proxy server cannot be reached (loc:  " + errorLocation + ")");
            }
            if (WinInet.isSslError(errorCode)) {
                throw new SSLException(WinInet.getDefaultExceptionMessage(errorLocation, errorCode));
            }
            if (errorLocation == 1) {
                throw new WinInetUnavailableException(WinInet.getDefaultExceptionMessage(errorLocation, errorCode));
            }
            throw new IOException(WinInet.getDefaultExceptionMessage(errorLocation, errorCode));
        }
        return false;
    }

    @Override
    @Nullable
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.address == 0L) {
            throw new IOException("request to " + this.uri + " already read");
        }
        return this.outputStream;
    }

    @Override
    @NotNull
    public synchronized InputStream getInputStream() throws IOException {
        this.checkSent();
        if (this.address == 0L) {
            throw new IOException("request to " + this.uri + " already read");
        }
        return this.inputStream;
    }

    private void checkSent() throws IOException {
        WinInetOutputStream outputStream = this.outputStream;
        if (outputStream != null) {
            outputStream.close();
        }
    }

    synchronized void sendRequest() throws IOException {
        byte[] body = null;
        if (this.outputStream != null) {
            body = this.outputStream.toByteArray();
            this.outputStream = null;
        }
        int count = 0;
        int statusCode = WinInet.sendRequest0(this.address, this.requestHeaders, body);
        while (this.checkExceptionAndClose() || this.isAuthenticationRequired(statusCode)) {
            boolean proxyAuth;
            boolean bl = proxyAuth = statusCode == 407;
            if (count++ >= 10 && (!this.authenticator.isShowUi(proxyAuth) || !this.isAuthenticationRequired(statusCode))) break;
            this.checkExceptionAndClose();
            if (this.isAuthenticationRequired(statusCode)) {
                WinInet.handleAuthentication(proxyAuth, this.authenticator, this);
            }
            statusCode = WinInet.sendRequest0(this.address, this.requestHeaders, body);
        }
        this.checkExceptionAndClose();
        byte[] headerData = WinInet.getHeaders0(this.address);
        this.checkExceptionAndClose();
        if (headerData != null) {
            this.headers.parse(headerData);
        }
    }

    private boolean isAuthenticationRequired(int statusCode) {
        return statusCode == 407 || statusCode == 401;
    }

    @Override
    public synchronized void close() {
        if (this.address != 0L) {
            WinInet.destroy0(this.address);
            this.address = 0L;
        }
    }

    int read() throws IOException {
        this.checkSent();
        int read = this.read(this.buffer, 0, 1);
        if (read == 1) {
            return Byte.toUnsignedInt(this.buffer[0]);
        }
        return -1;
    }

    int read(byte[] b, int off, int len) throws IOException {
        this.checkSent();
        if (this.eof) {
            return -1;
        }
        if (this.address == 0L) {
            throw new IOException("already closed");
        }
        int ret = WinInet.read0(this.address, b, off, len);
        this.checkExceptionAndClose();
        if (ret == -1) {
            this.eof = true;
            this.close();
        }
        return ret;
    }

    @Override
    public int getResponseCode() throws IOException {
        this.checkSent();
        return this.headers.getCode();
    }

    @Override
    @Nullable
    public String getResponseMessage() throws IOException {
        this.checkSent();
        return this.headers.getMessage();
    }

    @Override
    @Nullable
    public String getLastHeader(String name) {
        List<String> list = this.getHeaders(name);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Override
    @NotNull
    public List<String> getHeaders(String name) {
        try {
            this.checkSent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        List<String> list = this.headers.getLowerCaseHeaders().get(name.toLowerCase(Locale.ROOT));
        return list != null ? list : Collections.emptyList();
    }

    @Override
    @NotNull
    public Map<String, List<String>> getAllHeaders() {
        try {
            this.checkSent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.headers.getHeaders();
    }

    public String toString() {
        return "CallImpl{uri=" + this.uri + ", headers=" + this.headers + '}';
    }
}

