-- Copyright (c) DbVis Software AB. All Rights Reserved.
SELECT 
    cust.first_name, 
    cust.last_name, 
    SUM(pay.amount) AS Total
    
FROM 
    payment pay
JOIN 
    customer cust
ON 
    pay.customer_id = cust.customer_id
GROUP BY 
    cust.first_name, 
    cust.last_name
ORDER BY 
    cust.last_name;