/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import com.jidesoft.dashboard.B;
import com.jidesoft.dashboard.Dashboard;
import com.jidesoft.dashboard.DashboardEvent;
import com.jidesoft.dashboard.DashboardHolder;
import com.jidesoft.dashboard.DashboardListener;
import com.jidesoft.dashboard.GadgetEvent;
import com.jidesoft.dashboard.GadgetListener;
import com.jidesoft.dashboard.GadgetManager;
import com.jidesoft.dashboard.GadgetPalette;
import com.jidesoft.dashboard.GadgetPaletteInstaller;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.TabEditingEvent;
import com.jidesoft.swing.TabEditingListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;

public class DashboardTabbedPane
extends JideTabbedPane
implements TabEditingListener,
GadgetListener,
DashboardListener,
GadgetPaletteInstaller,
DashboardHolder {
    private Container \u01ec;
    private GadgetManager \u01ef;
    private transient GadgetPalette \u01ed;
    protected JideButton _showPaletteButton;
    private boolean \u01ea = false;
    private int \u01ee = 5;
    private static final String \u01eb = "Dashboard.titlePropertyChangeListener";
    public static final String BUTTON_NAME_ADD_DASHBOARD = "Dashboard.add";
    public static final String BUTTON_NAME_SHOW_GADGET_PALETTE = "GadgetPalette.show";

    public DashboardTabbedPane() {
        this.\u01ef = new GadgetManager();
        this.initComponents();
    }

    public DashboardTabbedPane(GadgetManager gadgetManager) {
        this.\u01ef = gadgetManager;
        this.initComponents();
    }

    public DashboardTabbedPane(int n2) {
        super(n2, 1);
        this.initComponents();
    }

    @Override
    public void editingStarted(TabEditingEvent tabEditingEvent) {
    }

    @Override
    public void editingStopped(TabEditingEvent tabEditingEvent) {
        Dashboard dashboard = this.getGadgetManager().getDashboard(tabEditingEvent.getTabIndex());
        dashboard.setTitle(tabEditingEvent.getNewTitle());
    }

    @Override
    public void editingCanceled(TabEditingEvent tabEditingEvent) {
    }

    @Override
    public GadgetManager getGadgetManager() {
        return this.\u01ef;
    }

    @Override
    public void removeTabAt(int n2) {
        this.\u01ef.removeDashboard(this.getTitleAt(n2));
    }

    protected void initComponents() {
        this.\u01ef.addDashboardListener(this);
        this.\u01ef.addGadgetListener(this);
        this.setTabEditingAllowed(true);
        this.addTabEditingListener(this);
        this.setShowCloseButton(true);
        this.setShowCloseButtonOnTab(true);
        this.setShowCloseButtonOnSelectedTab(true);
        this.\u01ec = this.createToolBarComponent();
        this.setTabLeadingComponent(this.\u01ec);
        this.addKeyListener(this.\u01ef.getCancelDragAndDropKeyListener());
        this.setCloseAction(new AbstractAction(){
            private static final long \u0102 = -6321245600238187486L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dashboard dashboard;
                int n2 = DashboardTabbedPane.this.getSelectedIndex();
                if (n2 >= 0 && n2 < DashboardTabbedPane.this.\u01ef.getDashboardCount() && (dashboard = DashboardTabbedPane.this.\u01ef.getDashboard(n2)) != null) {
                    DashboardTabbedPane.this.getGadgetManager().removeDashboard(dashboard.getKey());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){
            boolean \u0102 = false;

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DashboardTabbedPane.this.\u011c();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                super.componentMoved(componentEvent);
                DashboardTabbedPane.this.\u011c();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                super.componentShown(componentEvent);
                if (this.\u0102) {
                    this.\u0102 = false;
                    DashboardTabbedPane.this.showPalette();
                }
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                super.componentHidden(componentEvent);
                if (DashboardTabbedPane.this.isPaletteVisible()) {
                    this.\u0102 = true;
                    DashboardTabbedPane.this.hidePalette();
                }
            }
        });
    }

    protected Container createToolBarComponent() {
        JideButton jideButton = new JideButton();
        jideButton.putClientProperty("hideActionText", Boolean.TRUE);
        jideButton.setAction(new AbstractAction(this.getResourceString(BUTTON_NAME_ADD_DASHBOARD), this.getImageIcon("icons/add.png")){
            private static final long \u0102 = -8651408051308635053L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n2 = 1;
                while (true) {
                    object = MessageFormat.format(DashboardTabbedPane.this.getResourceString("Dashboard.untitled"), n2);
                    if (DashboardTabbedPane.this.getGadgetManager().getDashboard((String)object) == null) break;
                    ++n2;
                }
                object = DashboardTabbedPane.this.createDashboard(MessageFormat.format(DashboardTabbedPane.this.getResourceString("Dashboard.untitled"), n2));
                DashboardTabbedPane.this.getGadgetManager().addDashboard((Dashboard)object);
                DashboardTabbedPane.this.setSelectedIndex(DashboardTabbedPane.this.getTabCount() - 1);
            }
        });
        jideButton.setName(BUTTON_NAME_ADD_DASHBOARD);
        this._showPaletteButton = new JideButton(new AbstractAction(this.getResourceString(BUTTON_NAME_SHOW_GADGET_PALETTE), this.getImageIcon("icons/property.png")){
            private static final long \u0102 = 353336825344755865L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DashboardTabbedPane.this.togglePalette(DashboardTabbedPane.this);
            }
        });
        this._showPaletteButton.setName(BUTTON_NAME_SHOW_GADGET_PALETTE);
        A a2 = new A();
        a2.setOpaque(false);
        a2.setRollover(true);
        a2.setFloatable(false);
        a2.putClientProperty("Synthetica.opaque", false);
        a2.add(jideButton);
        a2.add(this._showPaletteButton);
        return a2;
    }

    @Override
    public Dashboard createDashboard(String string) {
        return new Dashboard(string);
    }

    private void \u011c() {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null && this.\u01ed != null) {
            JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
            this.\u0102(jLayeredPane);
        }
    }

    @Override
    public void eventHappened(GadgetEvent gadgetEvent) {
    }

    @Override
    public void eventHappened(DashboardEvent dashboardEvent) {
        if (dashboardEvent.getID() == 13099) {
            final Dashboard dashboard = (Dashboard)dashboardEvent.getSource();
            JScrollPane jScrollPane = new JScrollPane(dashboard);
            this.insertTab(dashboard.getTitle(), dashboard.getIcon(), jScrollPane, null, dashboardEvent.getIndex());
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if ("title".equals(string)) {
                        DashboardTabbedPane.this.setTitleAt(DashboardTabbedPane.this.getGadgetManager().getDashboardIndex(dashboard.getKey()), (String)propertyChangeEvent.getNewValue());
                    }
                }
            };
            dashboard.addPropertyChangeListener("title", propertyChangeListener);
            dashboard.putClientProperty(\u01eb, propertyChangeListener);
        } else if (dashboardEvent.getID() == 13100) {
            Dashboard dashboard = (Dashboard)dashboardEvent.getSource();
            if (dashboard == null) {
                return;
            }
            String string = dashboard.getKey();
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)dashboard.getClientProperty(\u01eb);
            if (propertyChangeListener != null) {
                dashboard.removePropertyChangeListener("title", propertyChangeListener);
                dashboard.putClientProperty(\u01eb, null);
            }
            super.removeTabAt(dashboardEvent.getIndex());
            int n2 = this.getSelectedIndex();
            if (JideSwingUtilities.equals(this.\u01ef.getActiveDashboardKey(), string) && n2 >= 0 && n2 < this.getTabCount()) {
                this.\u01ef.setActiveDashboardKey(this.getTitleAt(n2));
            }
        } else if (dashboardEvent.getID() == 13101) {
            Dashboard dashboard = (Dashboard)dashboardEvent.getSource();
            int n3 = this.indexOfDashboard(dashboard);
            if (n3 >= 0 && n3 <= this.getTabCount() - 1) {
                Component component = this.getComponentAt(n3);
                String string = this.getTitleAt(n3);
                Icon icon = this.getIconAt(n3);
                String string2 = this.getToolTipTextAt(n3);
                super.removeTabAt(n3);
                this.insertTab(string, icon, component, string2, dashboardEvent.getIndex());
            }
        } else if (dashboardEvent.getID() == 13102 && this.getSelectedIndex() != dashboardEvent.getIndex()) {
            this.setSelectedIndex(dashboardEvent.getIndex());
        }
    }

    @Override
    public void setSelectedIndex(int n2) {
        super.setSelectedIndex(n2);
        this.getGadgetManager().setActiveDashboardKey(this.getGadgetManager().getDashboard(n2).getKey());
    }

    public int getDashboardCount() {
        return this.getTabCount();
    }

    public Dashboard getDashboardAt(int n2) {
        Component component;
        Component component2 = this.getComponentAt(n2);
        if (component2 instanceof JScrollPane && (component = ((JScrollPane)component2).getViewport().getView()) instanceof Dashboard) {
            return (Dashboard)component;
        }
        return null;
    }

    public int indexOfDashboard(Dashboard dashboard) {
        for (int i2 = 0; i2 < this.getTabCount(); ++i2) {
            Dashboard dashboard2 = this.getDashboardAt(i2);
            if ((dashboard2 == null || !dashboard2.equals(dashboard)) && (dashboard2 != null || dashboard2 != dashboard)) continue;
            return i2;
        }
        return -1;
    }

    public void togglePalette(Component component) {
        if (this.isPaletteVisible()) {
            this.hidePalette();
        } else {
            this.showPalette(component);
        }
    }

    private void \u0102(JLayeredPane jLayeredPane) {
        if (this.\u01ed != null) {
            if (!this.isUseFloatingPalette() && this.\u01ed.getParent() != null && this.\u01ed.getParent().getLayout() instanceof BorderLayout) {
                this.\u01ed.validate();
            } else {
                Rectangle rectangle = this.getBounds();
                rectangle = SwingUtilities.convertRectangle(this.getParent(), rectangle, jLayeredPane);
                Insets insets = this.getContentBorderInsets();
                Dimension dimension = this.\u01ed.getPreferredSize();
                switch (this.getPaletteSide()) {
                    case 7: {
                        rectangle.width = dimension.width;
                        rectangle.y += insets.top + 1;
                        rectangle.height -= insets.top + insets.bottom + 2;
                        break;
                    }
                    case 3: {
                        rectangle.x = rectangle.x + rectangle.width - dimension.width;
                        rectangle.width = dimension.width;
                        rectangle.y += insets.top + 1;
                        rectangle.height -= insets.top + insets.bottom + 2;
                        break;
                    }
                    case 1: {
                        rectangle.y = 0;
                        rectangle.height = dimension.height;
                        rectangle.x += insets.left + 1;
                        rectangle.width -= insets.left + insets.right + 2;
                        rectangle.y += insets.top;
                        break;
                    }
                    default: {
                        rectangle.y = rectangle.y + rectangle.height - dimension.height;
                        rectangle.height = dimension.height;
                        rectangle.x += insets.left + 1;
                        rectangle.width -= insets.left + insets.right + 2;
                        rectangle.y -= insets.bottom;
                    }
                }
                this.\u01ed.setBounds(rectangle);
                this.\u01ed.validate();
            }
        }
    }

    public Container getValidParent(Component component) {
        do {
            if (component.getParent() == null || !(component.getParent().getLayout() instanceof BorderLayout)) continue;
            return component.getParent();
        } while ((component = component.getParent()) != null);
        return null;
    }

    public boolean isPaletteVisible() {
        return this.\u01ed != null && this.\u01ed.isVisible();
    }

    public void setPaletteSide(int n2) {
        if (this.\u01ee != n2) {
            this.\u01ee = n2;
            boolean bl = this.isPaletteVisible();
            if (bl) {
                this.hidePalette();
            }
            this.\u01ed = null;
            if (bl) {
                this.showPalette();
            }
        }
    }

    @Override
    public int getPaletteSide() {
        return this.\u01ee;
    }

    public void showPalette() {
        this.showPalette(this);
    }

    @Override
    public void showPalette(Component component) {
        Container container = this.getValidParent(component);
        if (!this.isUseFloatingPalette() && container != null) {
            if (this.\u01ed == null) {
                this.\u01ed = this.createGadgetPalette();
                if (this._showPaletteButton != null) {
                    this._showPaletteButton.setSelected(true);
                }
                switch (this.getPaletteSide()) {
                    case 3: {
                        container.add((Component)this.\u01ed, "After");
                        break;
                    }
                    case 7: {
                        container.add((Component)this.\u01ed, "Before");
                        break;
                    }
                    case 1: {
                        container.add((Component)this.\u01ed, "First");
                        break;
                    }
                    default: {
                        container.add((Component)this.\u01ed, "Last");
                    }
                }
                container.validate();
            }
        } else {
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null && this.\u01ed == null) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                this.\u01ed = this.createGadgetPalette();
                jLayeredPane.add((Component)this.\u01ed, JLayeredPane.PALETTE_LAYER);
                this.\u0102(jLayeredPane);
                if (this._showPaletteButton != null) {
                    this._showPaletteButton.setSelected(true);
                }
            }
        }
    }

    protected GadgetPalette createGadgetPalette() {
        return new GadgetPalette(this.\u01ef, this);
    }

    @Override
    public void hidePalette() {
        Container container = this.getValidParent(this);
        if (!this.isUseFloatingPalette() && container != null) {
            if (this.\u01ed != null) {
                container.remove(this.\u01ed);
                this.\u01ed.setVisible(false);
                this.\u01ed = null;
                if (this._showPaletteButton != null) {
                    this._showPaletteButton.setSelected(false);
                }
                container.validate();
            }
        } else {
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null && this.\u01ed != null) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.remove(this.\u01ed);
                this.\u01ed.setVisible(false);
                this.\u01ed = null;
                jLayeredPane.repaint();
                if (this._showPaletteButton != null) {
                    this._showPaletteButton.setSelected(false);
                }
            }
        }
    }

    public Container getToolBarComponent() {
        return this.\u01ec;
    }

    public void setToolBar(JToolBar jToolBar) {
        this.\u01ec = jToolBar;
    }

    @Override
    public Dashboard getActiveDashboard() {
        int n2 = this.getSelectedIndex();
        if (n2 < 0 || n2 >= this.getDashboardCount()) {
            return null;
        }
        return this.getDashboardAt(n2);
    }

    public boolean isUseFloatingPalette() {
        return this.\u01ea;
    }

    public void setUseFloatingPalette(boolean bl) {
        this.\u01ea = bl;
    }

    public void setToolBarAlignment(int n2) {
        if (n2 == 10) {
            this.setTabTrailingComponent(null);
            this.setTabLeadingComponent(this.\u01ec);
        } else if (n2 == 11) {
            this.setTabLeadingComponent(null);
            this.setTabTrailingComponent(this.\u01ec);
        }
    }

    public int getToolBarAlignment() {
        if (this.getTabTrailingComponent() == this.\u01ec) {
            return 11;
        }
        if (this.getTabLeadingComponent() == this.\u01ec) {
            return 10;
        }
        return -1;
    }

    protected ImageIcon getImageIcon(String string) {
        return IconsFactory.getImageIcon(DashboardTabbedPane.class, string);
    }

    @Override
    public String getResourceString(String string) {
        if (string != null && string.startsWith("JideTabbedPane")) {
            return super.getResourceString(string);
        }
        return B.\u0101(this.getLocale()).getString(string);
    }

    class A
    extends JToolBar
    implements UIResource {
    }
}

