/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.ResizeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class DockbarSlidePanel
extends JPanel {
    private static final long serialVersionUID = 4911695333060445893L;
    public static final String uiClassID = "JYDockingDockbarSlidePanelUI";
    public static final int UNSPECIFIED_PREFERRED_SIZE = -1;
    private static final Dimension RESIZE_DIMENSION = new Dimension(3, 3);
    private DockbarManager manager;
    private JPanel dragEdge;
    private int prefSize;
    private boolean locked;
    private int placement = 2;

    public DockbarSlidePanel(DockbarManager dockbarManager) {
        super(new BorderLayout(0, 0));
        this.manager = dockbarManager;
        this.prefSize = -1;
        this.dragEdge = new JPanel();
        this.dragEdge.setOpaque(false);
        this.dragEdge.setPreferredSize(RESIZE_DIMENSION);
        ResizeListener resizeListener = new ResizeListener(dockbarManager);
        this.dragEdge.addMouseListener(resizeListener);
        this.dragEdge.addMouseMotionListener(resizeListener);
        this.updatePlacement();
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){};
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateContents() {
        JComponent jComponent;
        Object object;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = componentArray[n2];
            if (object != this.dragEdge) {
                this.remove((Component)object);
            }
            ++n2;
        }
        object = this.manager.getActiveDockable();
        JComponent jComponent2 = jComponent = object == null ? null : object.getComponent();
        if (jComponent != null) {
            this.add((Component)jComponent, "Center");
        }
    }

    public void updatePlacement() {
        this.setPlacement(this.manager.getActivePlacement());
        this.remove(this.dragEdge);
        this.add((Component)this.dragEdge, this.getEdgeRegion());
        this.dragEdge.setCursor(this.getResizeCursor());
        this.revalidate();
    }

    private void setPlacement(int n) {
        int n2 = this.placement;
        this.placement = n;
        this.firePropertyChange("placement", n2, n);
    }

    public int getPlacement() {
        return this.placement;
    }

    private String getEdgeRegion() {
        int n = this.manager.getActivePlacement();
        switch (n) {
            case 1: {
                return "South";
            }
            case 3: {
                return "North";
            }
            case 4: {
                return "West";
            }
        }
        return "East";
    }

    public Cursor getResizeCursor() {
        int n = this.manager.getActivePlacement();
        return n == 3 ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(11);
    }

    public int getPrefSize() {
        return this.prefSize;
    }

    public void setPrefSize(int n) {
        this.prefSize = n;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }
}

