/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.controller;

import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.MonitorInterface;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.TransportPoolStatistics;
import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.internal.controller.ControllerMessageHelper;
import com.ibm.db2.cmx.internal.core.JSONHelper;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.jcc.am.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.serial.SerialClob;

public class NPXControllerAgentImpl
implements ControllerAgent {
    Map<Integer, Connection> monconnectionMap = null;
    private static Logger logger__ = Log.getCMXClientLogger();
    private static NPXControllerAgentImpl instance_;
    private static String logStreamName;

    public void writeToLogStream(JSONArray jSONArray, int n2, int n3) throws SQLException {
        Connection connection = this.monconnectionMap.get(n2);
        if (connection == null) {
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "writeToLogStream", "No connection found to for sending monitored data to NPX for dsid=" + n2 + " payload_prop=" + n3 + " : " + jSONArray);
            }
            return;
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "writeToLogStream", "Sending monitored data to NPX for dsid=" + n2 + " payload_prop=" + n3 + " : " + jSONArray);
        }
        CallableStatement callableStatement = (CallableStatement)connection.prepareCall("call NEWTON.WRITE_TO_LOGSTREAM(?,?,?,?)");
        SerialClob serialClob = new SerialClob(jSONArray.toString().toCharArray());
        callableStatement.setString(1, NPXControllerAgentImpl.getLogStreamName());
        callableStatement.setClob(2, (Clob)serialClob);
        callableStatement.setInt(3, n3);
        callableStatement.registerOutParameter(4, 12);
        callableStatement.execute();
        String string = callableStatement.getString(4);
        System.out.print("CALL NEWTON.WRITE_TO_LOGSTREAM returns: " + string);
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "writeToLogStream", "Result from NPX LogStream write : " + string);
        }
    }

    public String fetchConfigNPX(String string, int n2, int n3) throws SQLException {
        String string2 = null;
        String string3 = null;
        Connection connection = this.monconnectionMap.get(n2);
        if (connection == null) {
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "fetchConfigNPX", "No connection found to for calling fetchConfig for dsid=" + n2 + " data= " + string);
            }
            return null;
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "fetchConfigNPX", "calling stored procedure for dsid: " + n2 + " requestID: " + n3 + " data: " + string);
        }
        CallableStatement callableStatement = (CallableStatement)connection.prepareCall("call  NEWTON.GET_EI_CONFIG(?,?,?,?)");
        SerialClob serialClob = new SerialClob(string.toCharArray());
        callableStatement.setClob(1, (Clob)serialClob);
        callableStatement.setInt(2, n3);
        callableStatement.registerOutParameter(3, 12);
        callableStatement.registerOutParameter(4, 12);
        callableStatement.execute();
        string3 = callableStatement.getString(3);
        NPXControllerAgentImpl.setLogStreamName(string3);
        System.out.printf("logStreamName set after GET_EI_CONFIG call: %s \n", NPXControllerAgentImpl.getLogStreamName());
        string2 = callableStatement.getString(4);
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "fetchConfigNPX", "returned result=" + string2);
        }
        return string2;
    }

    @Override
    public void lookupOverNetwork(ControlDataSourceImpl controlDataSourceImpl) throws Exception {
    }

    @Override
    public void registerDriverOverNetwork(Map<String, Object> map, String string, String string2, long l8) throws Exception {
    }

    @Override
    public void getControllerInfo(StringBuilder stringBuilder) {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void registerMonitorDataSource(String string, String string2, String[] stringArray, int n2, String string3, String[] stringArray2, int n3, int n4, int n5, int n6, boolean bl2, int[] nArray, String[] stringArray3, String string4, int n7, int n8) throws Exception {
    }

    @Override
    public void deregisterMonitorDataSource(String string, String string2, int n2, String string3, String string4, int n3) throws Exception {
    }

    @Override
    public void sendDeregisterDriver(String string) throws Exception {
    }

    @Override
    public void sendDeregisterDataSource(String string) throws Exception {
    }

    @Override
    public void sendAndReceiveChainedMessages(ArrayList<ControlDriver.RequestInfo> arrayList) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ControllerMessageHelper controllerMessageHelper = null;
        controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "sendAndReceiveChainedMessages", "Sending chained registration requests to NPX");
        }
        for (ControlDriver.RequestInfo requestInfo : arrayList) {
            hashMap.put(requestInfo.getMessageType(), this.fetchConfigNPX(JSONHelper.decodeJSONMessage(requestInfo.getMessage().getPayload()).toString(), 1, Integer.parseInt(requestInfo.getMessageType())));
        }
        for (ControlDriver.RequestInfo requestInfo : arrayList) {
            ControlDataSourceImpl controlDataSourceImpl;
            if (requestInfo.getMessageType().equals("4")) {
                controllerMessageHelper.parseRegisterDriverReply(null, 12, (String)hashMap.get("4"));
                continue;
            }
            if (requestInfo.getMessageType().equals("5")) {
                controllerMessageHelper.parseLookupDatabaseReply(requestInfo.getLogicalDatabaseName(), null, 12);
                continue;
            }
            if (requestInfo.getMessageType().equals("6")) {
                controlDataSourceImpl = requestInfo.getCDS();
                controllerMessageHelper.parseRegisterDataSourceReply(null, controlDataSourceImpl, 12, (String)hashMap.get("6"));
                controllerMessageHelper.processCMXProperties(controlDataSourceImpl);
                continue;
            }
            if (!requestInfo.getMessageType().equals("1")) continue;
            controlDataSourceImpl = requestInfo.getCDS();
            controllerMessageHelper.parseLookupReply(null, controlDataSourceImpl, (String)hashMap.get("1"));
            controlDataSourceImpl.initialLookupOccurred();
        }
    }

    @Override
    public void logLookup(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) throws Exception {
    }

    @Override
    public void logStatistics(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String[] stringArray3, Set<ClientInfo>[] setArray, HashMap<String, TransportPoolStatistics> hashMap, long[][] lArray, Long[] longArray, Object[][] objectArray, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, long[][] lArray2) throws Exception {
    }

    @Override
    public void logPushDownErrors(String string, String string2, String string3, MonitorInterface.ClientRuntime clientRuntime, ArrayList<PushDownError> arrayList) throws Exception {
    }

    @Override
    public void logApplicationException(String string, String string2, String string3, MonitorInterface.ClientRuntime clientRuntime, SQLException sQLException) throws Exception {
    }

    @Override
    public void logPushDownApplication(String string, String string2, Map<String, Object> map, String string3, String string4, String string5, String string6, String[] stringArray, Map<String, Object>[] mapArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, HashMap<String, String>[] hashMapArray) throws Exception {
    }

    @Override
    public int getNegotiatedVersion() {
        return 12;
    }

    public static NPXControllerAgentImpl getInstance() {
        if (instance_ == null) {
            instance_ = new NPXControllerAgentImpl();
        }
        return instance_;
    }

    public void setConnectionMap(Map<Integer, Connection> map) {
        this.monconnectionMap = map;
    }

    public static String getLogStreamName() {
        return logStreamName;
    }

    public static void setLogStreamName(String string) {
        logStreamName = string;
    }

    static {
        logStreamName = null;
    }
}

