/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.security;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TLSMode {
    DISABLE("disable"),
    REQUIRE("require"),
    VERIFY_CA("verify-ca"),
    VERIFY_FULL("verify-full");

    public static final TLSMode[] VALUES;
    public final String value;

    private TLSMode(String string2) {
        this.value = string2;
    }

    public static TLSMode fromString(String string) throws IllegalArgumentException {
        for (TLSMode tLSMode : VALUES) {
            if (!tLSMode.value.equalsIgnoreCase(string)) continue;
            return tLSMode;
        }
        throw new IllegalArgumentException("Invalid tlsmode value: " + string);
    }

    public static List<String> stringValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TLSMode tLSMode : VALUES) {
            arrayList.add(tLSMode.value);
        }
        return arrayList;
    }

    public boolean requireEncryption() {
        return this.compareTo(REQUIRE) >= 0;
    }

    public boolean verifyCertificate() {
        return this == VERIFY_CA || this == VERIFY_FULL;
    }

    public boolean verifyPeerName() {
        return this == VERIFY_FULL;
    }

    static {
        VALUES = TLSMode.values();
    }
}

