/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.LeanChartModel;
import com.jidesoft.chart.util.Immutable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Immutable
public final class LeanMemoryChartModel
implements LeanChartModel {
    private static int \u0135 = 0;
    private String \u0132;
    private boolean \u0136;
    private List<double[]> \u0134 = new CopyOnWriteArrayList<double[]>();
    private final List<ChartModelListener> \u0133 = Collections.synchronizedList(new ArrayList());

    public LeanMemoryChartModel(List<double[]> list) {
        this(null, list);
    }

    public LeanMemoryChartModel(double[][] dArray) {
        this(null, dArray);
    }

    public LeanMemoryChartModel(String string, List<double[]> list) {
        this.\u0132 = string;
        this.init();
        this.\u0101(list);
    }

    public LeanMemoryChartModel(String string, double[][] dArray) {
        this.\u0132 = string;
        this.init();
        this.\u0101(dArray);
    }

    protected void init() {
        ++\u0135;
    }

    @Override
    public String getName() {
        if (this.\u0132 == null) {
            return this.getClass().getName() + "@" + Integer.toHexString(\u0135);
        }
        return this.\u0132;
    }

    @Override
    public Chartable getPoint(int n2) {
        double[] dArray = this.\u0134.get(n2);
        return new ChartPoint(dArray[0], dArray[1]);
    }

    @Override
    public double[] getPointPositions(int n2) {
        return this.\u0134.get(n2);
    }

    @Override
    public int getPointCount() {
        return this.\u0134.size();
    }

    private void \u0101(List<double[]> list) {
        this.\u0134 = list == null ? new CopyOnWriteArrayList<double[]>() : new CopyOnWriteArrayList<double[]>(list);
        this.fireModelChanged();
    }

    private void \u0101(double[][] dArray) {
        LinkedList<double[]> linkedList = new LinkedList<double[]>();
        Collections.addAll(linkedList, dArray);
        this.\u0101(linkedList);
    }

    public void setCyclical(boolean bl) {
        this.\u0136 = bl;
        this.fireModelChanged();
    }

    @Override
    public boolean isCyclical() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelChanged() {
        List<ChartModelListener> list = this.\u0133;
        synchronized (list) {
            for (ChartModelListener chartModelListener : this.\u0133) {
                chartModelListener.chartModelChanged();
            }
        }
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        if (!this.\u0133.contains(chartModelListener)) {
            this.\u0133.add(chartModelListener);
        }
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.\u0133.remove(chartModelListener);
    }

    @Override
    public Iterator<Chartable> iterator() {
        return new Iterator<Chartable>(){
            private int \u0102 = 0;

            @Override
            public boolean hasNext() {
                return this.\u0102 < LeanMemoryChartModel.this.\u0134.size();
            }

            public Chartable \u0101() {
                double[] dArray = (double[])LeanMemoryChartModel.this.\u0134.get(this.\u0102++);
                return new ChartPoint(dArray[0], dArray[1]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove an element of an array.");
            }
        };
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.\u0132 == null ? 0 : this.\u0132.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LeanMemoryChartModel leanMemoryChartModel = (LeanMemoryChartModel)object;
        return !(this.\u0132 == null ? leanMemoryChartModel.\u0132 != null : !this.\u0132.equals(leanMemoryChartModel.\u0132));
    }
}

