/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.Cipher;
import java.nio.ByteBuffer;
import java.security.Key;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AESGCM
implements Cipher {
    private static final int ivsize = 16;
    private static final int tagsize = 16;
    private javax.crypto.Cipher cipher;
    private SecretKeySpec keyspec;
    private int mode;
    private ByteBuffer iv;
    private long initcounter;

    @Override
    public int getIVSize() {
        return 16;
    }

    @Override
    public int getTagSize() {
        return 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(int mode, byte[] key, byte[] iv) throws Exception {
        int bsize;
        byte[] tmp;
        String pad = "NoPadding";
        if (iv.length > 12) {
            tmp = new byte[12];
            System.arraycopy(iv, 0, tmp, 0, tmp.length);
            iv = tmp;
        }
        if (key.length > (bsize = this.getBlockSize())) {
            tmp = new byte[bsize];
            System.arraycopy(key, 0, tmp, 0, tmp.length);
            key = tmp;
        }
        this.mode = mode == 0 ? 1 : 2;
        this.iv = ByteBuffer.wrap(iv);
        this.initcounter = this.iv.getLong(4);
        try {
            this.keyspec = new SecretKeySpec(key, "AES");
            this.cipher = javax.crypto.Cipher.getInstance("AES/GCM/" + pad);
            Class<javax.crypto.Cipher> clazz = javax.crypto.Cipher.class;
            synchronized (javax.crypto.Cipher.class) {
                this.cipher.init(this.mode, (Key)this.keyspec, new GCMParameterSpec(128, iv));
                // ** MonitorExit[var7_7] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            this.cipher = null;
            this.keyspec = null;
            this.iv = null;
            throw e;
        }
        {
            return;
        }
    }

    @Override
    public void update(int foo) throws Exception {
    }

    @Override
    public void update(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
        this.cipher.update(foo, s1, len, bar, s2);
    }

    @Override
    public void updateAAD(byte[] foo, int s1, int len) throws Exception {
        this.cipher.updateAAD(foo, s1, len);
    }

    @Override
    public void doFinal(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
        this.cipher.doFinal(foo, s1, len, bar, s2);
        long newcounter = this.iv.getLong(4) + 1L;
        if (newcounter == this.initcounter) {
            throw new IllegalStateException("GCM IV would be reused");
        }
        this.iv.putLong(4, newcounter);
        this.cipher.init(this.mode, (Key)this.keyspec, new GCMParameterSpec(128, this.iv.array()));
    }

    @Override
    public boolean isCBC() {
        return false;
    }

    @Override
    public boolean isAEAD() {
        return true;
    }

    @Override
    public boolean isChaCha20() {
        return false;
    }
}

