/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.io.input;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ReadAheadBufferedStream
extends FilterInputStream {
    private static final int BUF_SIZE = 16384;
    private volatile byte[] buf = new byte[16384];
    private int end;
    private int pos;

    public ReadAheadBufferedStream(InputStream in) {
        super(in);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.pos >= this.end) {
            this.fillBuffer(1);
            if (this.pos >= this.end) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] externalBuf, int off, int len) throws IOException {
        int copyLength;
        if (len == 0) {
            return 0;
        }
        int totalReads = 0;
        do {
            if (this.end - this.pos <= 0) {
                if (len - totalReads >= this.buf.length) {
                    int reads = super.read(externalBuf, off + totalReads, len - totalReads);
                    if (reads <= 0) {
                        return totalReads == 0 ? -1 : totalReads;
                    }
                    return totalReads + reads;
                }
                this.fillBuffer(len - totalReads);
                if (this.end <= 0) {
                    return totalReads == 0 ? -1 : totalReads;
                }
            }
            copyLength = Math.min(len - totalReads, this.end - this.pos);
            System.arraycopy(this.buf, this.pos, externalBuf, off + totalReads, copyLength);
            this.pos += copyLength;
        } while ((totalReads += copyLength) < len && super.available() > 0);
        return totalReads;
    }

    private void fillBuffer(int minNeededBytes) throws IOException {
        int lengthToReallyRead = Math.min(16384, Math.max(super.available(), minNeededBytes));
        this.end = super.read(this.buf, 0, lengthToReallyRead);
        this.pos = 0;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        throw new IOException("Skip from socket not implemented");
    }

    @Override
    public synchronized int available() throws IOException {
        throw new IOException("available from socket not implemented");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("reset from socket not implemented");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

