/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.shortcut.A;
import com.jidesoft.shortcut.KeyboardShortcut;
import com.jidesoft.shortcut.MouseShortcut;
import com.jidesoft.shortcut.Shortcut;
import com.jidesoft.shortcut.ShortcutIconsFactory;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.LabeledTextField;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShortcutField
extends LabeledTextField {
    public static final int TYPE_KEYBOARD = 1;
    public static final int TYPE_MOUSE = 2;
    private int \u0145 = 3;
    private int \u0143 = 1;
    private int \u0141 = 3;
    private int \u0144 = 1;
    private int \u0146 = 1;
    protected KeyListener _keyListener = this.\u010a();
    protected MouseListener _mouseListener = this.\u010e();
    private Shortcut \u0142;
    protected transient ChangeEvent changeEvent = null;

    public ShortcutField() {
        this(3, 1);
    }

    public ShortcutField(int n2) {
        this(n2, n2 == 2 ? 2 : 1);
    }

    public ShortcutField(int n2, int n3) {
        super(n3 == 1 ? ShortcutField.\u010c() : ShortcutField.\u010d());
        this.setType(n3);
        this.setAllowedType(n2);
    }

    private static ImageIcon \u010d() {
        return ShortcutIconsFactory.\u0101("icons/mouse_menu.png");
    }

    private static ImageIcon \u010c() {
        return ShortcutIconsFactory.\u0101("icons/keyboard_menu.png");
    }

    private static ImageIcon \u010b() {
        return ShortcutIconsFactory.\u0101("icons/mouse.png");
    }

    private static ImageIcon \u0109() {
        return ShortcutIconsFactory.\u0101("icons/keyboard.png");
    }

    public int getType() {
        return this.\u0143;
    }

    public void setType(int n2) {
        if (1 != n2 && 2 != n2) {
            throw new IllegalArgumentException("Illegal type: must be TYPE_KEYBOARD, or TYPE_MOUSE");
        }
        this.\u0143 = n2;
        if (this.\u0143 == 2) {
            this.setIcon(ShortcutField.\u010d());
            this.getTextField().setCursor(Cursor.getDefaultCursor());
            this.getTextField().setCaretColor(this.getTextField().getBackground());
            this.getTextField().removeKeyListener(this._keyListener);
            if (!JideSwingUtilities.isMouseListenerRegistered(this.getTextField(), this._mouseListener)) {
                this.getTextField().addMouseListener(this._mouseListener);
            }
            this.getTextField().setEditable(false);
        } else {
            this.setIcon(ShortcutField.\u010c());
            this.getTextField().setCursor(Cursor.getPredefinedCursor(2));
            this.getTextField().setCaretColor(new JTextField().getCaretColor());
            if (!JideSwingUtilities.isKeyListenerRegistered(this.getTextField(), this._keyListener)) {
                this.getTextField().addKeyListener(this._keyListener);
            }
            this.getTextField().removeMouseListener(this._mouseListener);
            this.getTextField().setEditable(true);
        }
        this.clearShortcut();
    }

    public int getAllowedType() {
        return this.\u0145;
    }

    public void setAllowedType(int n2) {
        this.\u0145 = n2;
        if (this.\u0145 == 1) {
            this.setType(1);
        } else if (this.\u0145 == 2) {
            this.setType(2);
        }
    }

    public int getMaximumAllowedKeystrokes() {
        return this.\u0141;
    }

    public void setMaximumAllowedKeystrokes(int n2) {
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > 3) {
            n2 = 3;
        }
        this.\u0141 = n2;
    }

    public int getAllowedKeystrokes() {
        return this.\u0144;
    }

    public void setAllowedKeystrokes(int n2) {
        this.\u0144 = n2;
        if (this.\u0144 > this.getMaximumAllowedKeystrokes()) {
            this.\u0144 = this.getMaximumAllowedKeystrokes();
        }
    }

    @Override
    protected JidePopupMenu createContextMenu() {
        ResourceBundle resourceBundle = A.\u0101(Locale.getDefault());
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        if (this.getType() == 1) {
            JMenuItem jMenuItem;
            if ((this.getAllowedType() & 2) != 0) {
                jMenuItem = jidePopupMenu.add(new JMenuItem(resourceBundle.getString("Shortcut.field.switchMouse"), ShortcutField.\u010b()));
                jMenuItem.addActionListener(new AbstractAction(){
                    private static final long \u0102 = -4295891063363680876L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShortcutField.this.setType(2);
                    }
                });
                jidePopupMenu.addSeparator();
            }
            jMenuItem = jidePopupMenu.add(new JMenuItem(KeyEvent.getKeyText(8)));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long \u0102 = -5270380275809225947L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(8, 0));
                }
            });
            jMenuItem = jidePopupMenu.add(new JMenuItem(KeyEvent.getKeyText(27)));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long \u0102 = -8327643435951037432L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(27, 0));
                }
            });
            jMenuItem = jidePopupMenu.add(new JMenuItem(KeyEvent.getKeyText(9)));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long \u0102 = 3690483347569179861L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(9, 0));
                }
            });
            jMenuItem = jidePopupMenu.add(new JMenuItem(KeyEvent.getKeyText(16) + "+" + KeyEvent.getKeyText(9)));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long \u0102 = 6801274149072387013L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(9, 1));
                }
            });
            jMenuItem = jidePopupMenu.add(new JMenuItem(KeyEvent.getKeyText(17) + "+" + KeyEvent.getKeyText(16) + "+" + KeyEvent.getKeyText(9)));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long \u0102 = -4950906064567642880L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(9, 3));
                }
            });
            final KeyStroke keyStroke = this.getContextMenuKeyStroke();
            if (keyStroke != null) {
                jMenuItem = jidePopupMenu.add(new JMenuItem((keyStroke.getModifiers() != 0 ? KeyEvent.getKeyModifiersText(keyStroke.getModifiers()) + "+" : "") + KeyEvent.getKeyText(keyStroke.getKeyCode())));
                jMenuItem.addActionListener(new AbstractAction(){
                    private static final long \u0103 = 7033988711280267468L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShortcutField.this.addKeyStroke(keyStroke);
                    }
                });
            }
            int n2 = this.getAllowedKeystrokes();
            if (this.getMaximumAllowedKeystrokes() >= 2) {
                jidePopupMenu.addSeparator();
                ButtonGroup buttonGroup = new ButtonGroup();
                jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("Shortcut.field.limit1")));
                jMenuItem.setSelected(n2 == 1);
                jMenuItem.addActionListener(new AbstractAction(){
                    private static final long \u0102 = 2939459387148417603L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShortcutField.this.setAllowedKeystrokes(1);
                    }
                });
                buttonGroup.add(jMenuItem);
                jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("Shortcut.field.limit2")));
                jMenuItem.setSelected(n2 == 2);
                jMenuItem.addActionListener(new AbstractAction(){
                    private static final long \u0102 = 8746540550003281294L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShortcutField.this.setAllowedKeystrokes(2);
                    }
                });
                buttonGroup.add(jMenuItem);
                if (this.getMaximumAllowedKeystrokes() >= 3) {
                    jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("Shortcut.field.limit3")));
                    jMenuItem.setSelected(n2 == 3);
                    jMenuItem.addActionListener(new AbstractAction(){
                        private static final long \u0102 = 6334981399606392609L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ShortcutField.this.setAllowedKeystrokes(3);
                        }
                    });
                    buttonGroup.add(jMenuItem);
                }
            } else {
                this.setAllowedKeystrokes(1);
            }
        } else if (this.getType() == 2) {
            JMenuItem jMenuItem;
            if ((this.getAllowedType() & 1) != 0) {
                jMenuItem = jidePopupMenu.add(new JMenuItem(resourceBundle.getString("Shortcut.field.switchKeyboard"), ShortcutField.\u0109()));
                jMenuItem.addActionListener(new AbstractAction(){
                    private static final long \u0102 = -1317879568995887083L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShortcutField.this.setType(1);
                    }
                });
                jidePopupMenu.addSeparator();
            }
            ButtonGroup buttonGroup = new ButtonGroup();
            jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("Shortcut.field.singleClick")));
            jMenuItem.setSelected(this.\u0146 == 1);
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long \u0102 = -5761477398878605686L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.\u0146 = 1;
                }
            });
            buttonGroup.add(jMenuItem);
            jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("Shortcut.field.doubleClick")));
            jMenuItem.setSelected(this.\u0146 == 2);
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long \u0102 = -8548470359087281776L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.\u0146 = 2;
                }
            });
            buttonGroup.add(jMenuItem);
        }
        return jidePopupMenu;
    }

    public void addKeyStroke(KeyStroke keyStroke) {
        if (this.\u0142 == null) {
            this.\u0142 = this.createKeyboardShortcut();
        }
        if (((KeyboardShortcut)this.\u0142).getCount() >= this.\u0144) {
            ((KeyboardShortcut)this.\u0142).clear();
        }
        ((KeyboardShortcut)this.\u0142).addKeyStroke(keyStroke);
        this.getTextField().setText(this.convertShortcutToString(this.\u0142));
        this.getTextField().requestFocus();
        this.fireStateChanged();
    }

    protected KeyboardShortcut createKeyboardShortcut() {
        return new KeyboardShortcut();
    }

    protected MouseShortcut createMouseShortcut() {
        return new MouseShortcut();
    }

    KeyListener \u010a() {
        return new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    return;
                }
                KeyStroke keyStroke = ShortcutField.this.getContextMenuKeyStroke();
                if (keyStroke != null && keyEvent.getKeyCode() == keyStroke.getKeyCode() && (keyEvent.getModifiers() | keyEvent.getModifiersEx()) == keyStroke.getModifiers()) {
                    return;
                }
                keyEvent.consume();
                switch (keyEvent.getKeyCode()) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 157: 
                    case 65406: {
                        return;
                    }
                }
                if (ShortcutField.this.\u0142 == null) {
                    ShortcutField.this.\u0142 = ShortcutField.this.createKeyboardShortcut();
                }
                JTextField jTextField = (JTextField)keyEvent.getSource();
                if (keyEvent.getKeyCode() == 8 && ((KeyboardShortcut)ShortcutField.this.\u0142).getCount() > 0) {
                    ((KeyboardShortcut)ShortcutField.this.\u0142).removeLastKeyStroke();
                } else {
                    if (((KeyboardShortcut)ShortcutField.this.\u0142).getCount() >= ShortcutField.this.\u0144) {
                        ((KeyboardShortcut)ShortcutField.this.\u0142).clear();
                    }
                    ((KeyboardShortcut)ShortcutField.this.\u0142).addKeyStroke(KeyStroke.getKeyStrokeForEvent(keyEvent));
                }
                jTextField.setText(ShortcutField.this.convertShortcutToString(ShortcutField.this.\u0142));
                ShortcutField.this.fireStateChanged();
            }
        };
    }

    protected String convertShortcutToString(Shortcut shortcut) {
        return ObjectConverterManager.toString(shortcut);
    }

    MouseListener \u010e() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ShortcutField.this.isEnabled()) {
                    mouseEvent.consume();
                    JTextField jTextField = (JTextField)mouseEvent.getSource();
                    ShortcutField.this.\u0142 = ShortcutField.this.createMouseShortcut();
                    ((MouseShortcut)ShortcutField.this.\u0142).setButton(mouseEvent.getButton());
                    ((MouseShortcut)ShortcutField.this.\u0142).setClickCount(ShortcutField.this.\u0146);
                    ((MouseShortcut)ShortcutField.this.\u0142).setModifiers(mouseEvent.getModifiersEx());
                    jTextField.setText(ShortcutField.this.convertShortcutToString(ShortcutField.this.\u0142));
                    ShortcutField.this.fireStateChanged();
                }
            }
        };
    }

    public void clearShortcut() {
        this.\u0142 = null;
        this.getTextField().setText("");
        this.fireStateChanged();
    }

    public Shortcut getShortcut() {
        if (this.\u0142 == null) {
            return null;
        }
        try {
            return (Shortcut)this.\u0142.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(64)) {
            Lm.showInvalidProductMessage(ShortcutField.class.getName(), 64);
        }
    }
}

