/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class GSSPrivilegedAction
implements PrivilegedAction<Exception> {
    private final EXAConnection connection;
    private final boolean useSpnego;
    private final GSSCredential credentials;

    public GSSPrivilegedAction(EXAConnection eXAConnection, GSSCredential gSSCredential, boolean bl) {
        this.credentials = gSSCredential;
        this.connection = eXAConnection;
        this.useSpnego = bl;
    }

    private static boolean canUseSPNEGO(GSSManager gSSManager) throws GSSException {
        Oid[] oidArray;
        Oid oid = new Oid("1.3.6.1.5.5.2");
        for (Oid oid2 : oidArray = gSSManager.getMechs()) {
            if (!oid2.equals(oid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Exception run() {
        try {
            GSSName gSSName;
            GSSManager gSSManager = GSSManager.getInstance();
            GSSCredential gSSCredential = null;
            Oid[] oidArray = new Oid[1];
            if (this.credentials == null) {
                oidArray[0] = this.useSpnego && GSSPrivilegedAction.canUseSPNEGO(gSSManager) ? new Oid("1.3.6.1.5.5.2") : new Oid("1.2.840.113554.1.2.2");
                gSSName = gSSManager.createName(this.connection.getKerberosUserName(), GSSName.NT_USER_NAME);
                gSSCredential = gSSManager.createCredential(gSSName, 28800, oidArray, 1);
            } else {
                oidArray[0] = new Oid("1.2.840.113554.1.2.2");
                gSSCredential = this.credentials;
            }
            gSSName = gSSManager.createName(this.connection.getKerberosTargetNameGSS(), GSSName.NT_HOSTBASED_SERVICE);
            this.connection.log("GSSPrivilegedAction: GSSName=" + gSSName + ", Oid=" + oidArray[0].toString());
            GSSContext gSSContext = gSSManager.createContext(gSSName, oidArray[0], gSSCredential, 0);
            gSSContext.requestMutualAuth(true);
            byte[] byArray = new byte[]{};
            byte[] byArray2 = null;
            boolean bl = false;
            while (!bl) {
                byArray2 = gSSContext.initSecContext(byArray, 0, byArray.length);
                if (gSSContext.isEstablished()) {
                    this.connection.getAttributes();
                    bl = true;
                }
                if (byArray2 != null) {
                    byArray = this.connection.exchangeTicket(byArray2);
                }
                byArray2 = null;
            }
        }
        catch (IOException iOException) {
            this.connection.log("GSSPrivilegedAction: IOException: " + iOException.getMessage());
            this.connection.logStackTrace(iOException);
            return iOException;
        }
        catch (GSSException gSSException) {
            this.connection.log("GSSPrivilegedAction: GSSException: " + gSSException.getMessage());
            this.connection.logStackTrace(gSSException);
            return gSSException;
        }
        catch (SQLException sQLException) {
            this.connection.log("GSSPrivilegedAction: SQLException: " + sQLException.getSQLState() + " - " + sQLException.getMessage());
            this.connection.logStackTrace(sQLException);
            return sQLException;
        }
        return null;
    }
}

