/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchAuthCancelException;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.JSchPartialAuthException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserAuth;
import com.jcraft.jsch.Util;
import java.util.Vector;

class UserAuthPublicKey
extends UserAuth {
    UserAuthPublicKey() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(Session session) throws Exception {
        super.start(session);
        Vector<Identity> identities = session.getIdentityRepository().getIdentities();
        byte[] _username = null;
        Vector<Identity> vector = identities;
        synchronized (vector) {
            if (identities.size() <= 0) {
                return false;
            }
            String pkmethods = session.getConfig("PubkeyAcceptedKeyTypes");
            String[] not_available_pks = session.getUnavailableSignatures();
            if (not_available_pks != null && not_available_pks.length > 0 && (pkmethods = Util.diffString(pkmethods, not_available_pks)) == null) {
                throw new JSchException("There are not any available sig algorithm.");
            }
            String[] pkmethoda = Util.split(pkmethods, ",");
            if (pkmethoda.length == 0) {
                return false;
            }
            String rsamethods = null;
            String nonrsamethods = null;
            for (int i = 0; i < pkmethoda.length; ++i) {
                if (pkmethoda[i].equals("ssh-rsa") || pkmethoda[i].equals("rsa-sha2-256") || pkmethoda[i].equals("rsa-sha2-512")) {
                    if (rsamethods == null) {
                        rsamethods = pkmethoda[i];
                        continue;
                    }
                    rsamethods = rsamethods + "," + pkmethoda[i];
                    continue;
                }
                nonrsamethods = nonrsamethods == null ? pkmethoda[i] : nonrsamethods + "," + pkmethoda[i];
            }
            String[] rsamethoda = Util.split(rsamethods, ",");
            String[] nonrsamethoda = Util.split(nonrsamethods, ",");
            _username = Util.str2byte(this.username);
            for (int i = 0; i < identities.size(); ++i) {
                int j;
                int command;
                if (session.auth_failures >= session.max_auth_tries) {
                    return false;
                }
                Identity identity = identities.elementAt(i);
                this.decryptKey(session, identity);
                String ipkmethod = identity.getAlgName();
                String[] ipkmethoda = null;
                if (ipkmethod.equals("ssh-rsa")) {
                    ipkmethoda = rsamethoda;
                } else if (nonrsamethoda != null && nonrsamethoda.length > 0) {
                    for (int j2 = 0; j2 < nonrsamethoda.length; ++j2) {
                        if (!ipkmethod.equals(nonrsamethoda[j2])) continue;
                        ipkmethoda = new String[]{ipkmethod};
                        break;
                    }
                }
                if (ipkmethoda == null) {
                    if (!JSch.getLogger().isEnabled(0)) continue;
                    JSch.getLogger().log(0, ipkmethod + " cannot be used as public key type for identity " + identity.getName());
                    continue;
                }
                byte[] pubkeyblob = identity.getPublicKeyBlob();
                String[] pkmethodsuccess = null;
                if (pubkeyblob != null) {
                    command = 51;
                    block6: for (j = 0; j < ipkmethoda.length; ++j) {
                        this.packet.reset();
                        this.buf.putByte((byte)50);
                        this.buf.putString(_username);
                        this.buf.putString(Util.str2byte("ssh-connection"));
                        this.buf.putString(Util.str2byte("publickey"));
                        this.buf.putByte((byte)0);
                        this.buf.putString(Util.str2byte(ipkmethoda[j]));
                        this.buf.putString(pubkeyblob);
                        session.write(this.packet);
                        while (true) {
                            this.buf = session.read(this.buf);
                            command = this.buf.getCommand() & 0xFF;
                            if (command == 60) {
                                if (JSch.getLogger().isEnabled(0)) {
                                    JSch.getLogger().log(0, ipkmethoda[j] + " preauth success");
                                }
                                pkmethodsuccess = new String[]{ipkmethoda[j]};
                                break block6;
                            }
                            if (command == 51) {
                                if (!JSch.getLogger().isEnabled(0)) continue block6;
                                JSch.getLogger().log(0, ipkmethoda[j] + " preauth failure");
                                continue block6;
                            }
                            if (command != 53) break;
                            this.buf.getInt();
                            this.buf.getByte();
                            this.buf.getByte();
                            byte[] _message = this.buf.getString();
                            byte[] lang = this.buf.getString();
                            String message = Util.byte2str(_message);
                            if (this.userinfo == null) continue;
                            this.userinfo.showMessage(message);
                        }
                        if (!JSch.getLogger().isEnabled(0)) continue;
                        JSch.getLogger().log(0, ipkmethoda[j] + " preauth failure command (" + command + ")");
                    }
                    if (command != 60) continue;
                }
                if (identity.isEncrypted()) continue;
                if (pubkeyblob == null) {
                    pubkeyblob = identity.getPublicKeyBlob();
                }
                if (pubkeyblob == null) continue;
                if (pkmethodsuccess == null) {
                    pkmethodsuccess = ipkmethoda;
                }
                for (j = 0; j < pkmethodsuccess.length; ++j) {
                    this.packet.reset();
                    this.buf.putByte((byte)50);
                    this.buf.putString(_username);
                    this.buf.putString(Util.str2byte("ssh-connection"));
                    this.buf.putString(Util.str2byte("publickey"));
                    this.buf.putByte((byte)1);
                    this.buf.putString(Util.str2byte(pkmethodsuccess[j]));
                    this.buf.putString(pubkeyblob);
                    byte[] sid = session.getSessionId();
                    int sidlen = sid.length;
                    byte[] tmp = new byte[4 + sidlen + this.buf.index - 5];
                    tmp[0] = (byte)(sidlen >>> 24);
                    tmp[1] = (byte)(sidlen >>> 16);
                    tmp[2] = (byte)(sidlen >>> 8);
                    tmp[3] = (byte)sidlen;
                    System.arraycopy(sid, 0, tmp, 4, sidlen);
                    System.arraycopy(this.buf.buffer, 5, tmp, 4 + sidlen, this.buf.index - 5);
                    byte[] signature = identity.getSignature(tmp, pkmethodsuccess[j]);
                    if (signature == null) {
                        if (!JSch.getLogger().isEnabled(0)) continue;
                        JSch.getLogger().log(0, pkmethodsuccess[j] + " signature failure");
                        continue;
                    }
                    this.buf.putString(signature);
                    session.write(this.packet);
                    while (true) {
                        this.buf = session.read(this.buf);
                        command = this.buf.getCommand() & 0xFF;
                        if (command == 52) {
                            if (JSch.getLogger().isEnabled(0)) {
                                JSch.getLogger().log(0, pkmethodsuccess[j] + " auth success");
                            }
                            return true;
                        }
                        if (command != 53) break;
                        this.buf.getInt();
                        this.buf.getByte();
                        this.buf.getByte();
                        byte[] _message = this.buf.getString();
                        byte[] lang = this.buf.getString();
                        String message = Util.byte2str(_message);
                        if (this.userinfo == null) continue;
                        this.userinfo.showMessage(message);
                    }
                    if (command == 51) {
                        this.buf.getInt();
                        this.buf.getByte();
                        this.buf.getByte();
                        byte[] foo = this.buf.getString();
                        int partial_success = this.buf.getByte();
                        if (partial_success != 0) {
                            throw new JSchPartialAuthException(Util.byte2str(foo));
                        }
                        ++session.auth_failures;
                        if (!JSch.getLogger().isEnabled(0)) continue;
                        JSch.getLogger().log(0, pkmethodsuccess[j] + " auth failure");
                        continue;
                    }
                    if (!JSch.getLogger().isEnabled(0)) continue;
                    JSch.getLogger().log(0, pkmethodsuccess[j] + " auth failure command (" + command + ")");
                }
            }
        }
        return false;
    }

    private void decryptKey(Session session, Identity identity) throws JSchException {
        byte[] passphrase = null;
        int count = 5;
        do {
            if (identity.isEncrypted() && passphrase == null) {
                if (this.userinfo == null) {
                    throw new JSchException("USERAUTH fail");
                }
                if (identity.isEncrypted() && !this.userinfo.promptPassphrase("Passphrase for " + identity.getName())) {
                    throw new JSchAuthCancelException("publickey");
                }
                String _passphrase = this.userinfo.getPassphrase();
                if (_passphrase != null) {
                    passphrase = Util.str2byte(_passphrase);
                }
            }
            if ((!identity.isEncrypted() || passphrase != null) && identity.setPassphrase(passphrase)) {
                if (passphrase == null || !(session.getIdentityRepository() instanceof IdentityRepository.Wrapper)) break;
                ((IdentityRepository.Wrapper)session.getIdentityRepository()).check();
                break;
            }
            Util.bzero(passphrase);
            passphrase = null;
        } while (--count != 0);
        Util.bzero(passphrase);
        passphrase = null;
    }
}

