/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.navigation;

import com.jidesoft.icons.RolloverIcon;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.NavigationComponentHelper;
import com.jidesoft.tooltip.ExpandedTipUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NavigationTree
extends JTree
implements NavigationComponent,
RolloverIcon.IconRolloverSupport {
    private NavigationComponentHelper \u1e14;
    private float \u1e15 = 0.0f;
    private Animator \u1e13;
    private Animator \u1e0f;
    public static final String PROPERTY_SHOW_TREE_LINES = "showTreeLines";
    public static final String PROPERTY_WIDE_SELECTION = "wideSelection";
    public static final String PROPERTY_FADE_ICON = "fadeIcon";
    public static final String PROPERTY_EXPANDED_TIP = "expandedTip";
    private boolean \u1e16 = false;
    private boolean \u1e10 = true;
    private boolean \u1e12 = true;
    private boolean \u1e11 = true;

    public NavigationTree() {
        this.\u029a();
    }

    public NavigationTree(Object[] objectArray) {
        super(objectArray);
        this.\u029a();
    }

    public NavigationTree(Vector<?> vector) {
        super(vector);
        this.\u029a();
    }

    public NavigationTree(Hashtable<?, ?> hashtable) {
        super(hashtable);
        this.\u029a();
    }

    public NavigationTree(TreeNode treeNode) {
        super(treeNode);
        this.\u029a();
    }

    public NavigationTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.\u029a();
    }

    public NavigationTree(TreeModel treeModel) {
        super(treeModel);
        this.\u029a();
    }

    @Override
    public void updateUI() {
        boolean bl = UIManager.getBoolean("Tree.paintLines");
        if (!this.isShowTreeLines()) {
            UIManager.put("Tree.paintLines", Boolean.FALSE);
        }
        super.updateUI();
        ((BasicTreeUI)this.getUI()).setExpandedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 0));
        ((BasicTreeUI)this.getUI()).setCollapsedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 1));
        if (!this.isShowTreeLines()) {
            UIManager.put("Tree.paintLines", bl);
        }
    }

    private void \u029a() {
        this.\u1e13 = new Animator(this, 100, 30, 30);
        this.\u1e13.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                float f2 = 1.0f * (float)(n2 - n3) / (float)n2;
                if (f2 <= NavigationTree.this.getIconAlpha()) {
                    NavigationTree.this.setIconAlpha(f2);
                }
                NavigationTree.this.repaint();
            }

            @Override
            public void animationEnds(Component component) {
                NavigationTree.this.setIconAlpha(0.0f);
                NavigationTree.this.repaint();
            }
        });
        this.\u1e0f = new Animator(this, 100, 5, 10);
        this.\u1e0f.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                float f2 = 1.0f * (float)n3 / (float)n2;
                if (f2 >= NavigationTree.this.getIconAlpha()) {
                    NavigationTree.this.setIconAlpha(f2);
                }
                NavigationTree.this.repaint();
            }

            @Override
            public void animationEnds(Component component) {
                NavigationTree.this.setIconAlpha(1.0f);
                NavigationTree.this.repaint();
            }
        });
        this.\u1e14 = this.createNavigationHelper();
        this.\u1e14.setup(this);
        if (this.\u1e11) {
            ExpandedTipUtils.install(this);
        }
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new NavigationTreeHelper();
    }

    @Override
    public boolean isIconRollover(int n2, int n3, int n4, int n5) {
        Point point = this.\u1e14.getMousePosition();
        return point != null && point.x >= n2 && point.x <= n2 + n4 && point.y >= n3 && point.y <= n3 + n5;
    }

    private TreePath \u0119(int n2, int n3) {
        Rectangle rectangle;
        TreePath treePath = this.getClosestPathForLocation(n2, n3);
        if (treePath != null && (rectangle = this.\u0101(treePath)) != null && n2 >= rectangle.x && n2 < rectangle.x + rectangle.width && n3 >= rectangle.y && n3 < rectangle.y + rectangle.height) {
            return treePath;
        }
        return null;
    }

    private int \u011a(int n2, int n3) {
        return this.getRowForPath(this.\u0119(n2, n3));
    }

    private Rectangle \u0101(TreePath treePath) {
        Rectangle rectangle = super.getPathBounds(treePath);
        if (rectangle != null && this.isWideSelection()) {
            rectangle.x = 0;
            rectangle.width = this.getWidth();
        }
        return rectangle;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.\u1e14.paint(graphics, this);
    }

    private Rectangle \u0141(int n2) {
        Rectangle rectangle = this.getRowBounds(n2);
        if (rectangle != null) {
            if (this.isWideSelection()) {
                rectangle.x = 0;
                rectangle.width = this.getWidth();
            }
            return rectangle;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public boolean isRowSelected(int n2) {
        return false;
    }

    public boolean isRowSelectedOriginal(int n2) {
        return super.isRowSelected(n2);
    }

    @Override
    public float getIconAlpha() {
        return this.\u1e15;
    }

    public void setIconAlpha(float f2) {
        this.\u1e15 = f2;
    }

    public boolean isShowTreeLines() {
        return this.\u1e16;
    }

    public void setShowTreeLines(boolean bl) {
        boolean bl2 = this.\u1e16;
        if (bl != this.\u1e16) {
            this.\u1e16 = bl;
            this.firePropertyChange(PROPERTY_SHOW_TREE_LINES, bl2, this.\u1e16);
            this.updateUI();
        }
    }

    public boolean isWideSelection() {
        return this.\u1e10;
    }

    public void setWideSelection(boolean bl) {
        boolean bl2 = this.\u1e10;
        if (bl != this.\u1e10) {
            this.\u1e10 = bl;
            this.firePropertyChange(PROPERTY_WIDE_SELECTION, bl2, this.\u1e10);
            this.\u1e14.repaintSelections(this);
        }
    }

    @Override
    public boolean isIconFade() {
        return this.\u1e12;
    }

    public void setFadeIcon(boolean bl) {
        boolean bl2 = this.\u1e12;
        if (bl != this.\u1e12) {
            this.\u1e12 = bl;
            this.firePropertyChange(PROPERTY_FADE_ICON, bl2, this.\u1e12);
            this.repaint();
        }
    }

    public boolean isExpandedTip() {
        return this.\u1e11;
    }

    public void setExpandedTip(boolean bl) {
        boolean bl2 = this.\u1e11;
        if (bl != this.\u1e11) {
            this.\u1e11 = bl;
            this.firePropertyChange(PROPERTY_EXPANDED_TIP, bl2, this.\u1e11);
            if (this.\u1e11) {
                ExpandedTipUtils.install(this);
            } else {
                ExpandedTipUtils.uninstall(this);
            }
        }
    }

    public int getNavigationRolloverRow() {
        return this.\u1e14.getRolloverRow();
    }

    public void setNavigationRolloverRow(int n2) {
        int n3 = this.\u1e14.getRolloverRow();
        if (n3 != n2) {
            this.\u1e14.setRolloverRow(n2);
            Rectangle rectangle = this.getRowBounds(n3);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
            if ((rectangle = this.getRowBounds(n2)) != null) {
                this.repaint(rectangle);
            }
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(NavigationTree.class.getName(), 2);
        }
    }

    public class NavigationTreeHelper
    extends NavigationComponentHelper {
        @Override
        public Rectangle getRowBounds(int n2) {
            return NavigationTree.this.\u0141(n2);
        }

        @Override
        public int rowAtPoint(Point point) {
            return NavigationTree.this.\u011a(point.x, point.y);
        }

        @Override
        public int[] getSelectedRows() {
            return NavigationTree.this.getSelectionRows();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (NavigationTree.this.isIconFade() && !NavigationTree.this.hasFocus()) {
                NavigationTree.this.\u1e0f.stop();
                NavigationTree.this.\u1e13.start();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (NavigationTree.this.isIconFade() && !NavigationTree.this.hasFocus()) {
                NavigationTree.this.\u1e13.stop();
                NavigationTree.this.\u1e0f.start();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (NavigationTree.this.isWideSelection()) {
                Object object;
                int n2 = this.rowAtPoint(mouseEvent.getPoint());
                if (n2 < 0) {
                    return;
                }
                Rectangle rectangle = NavigationTree.this.getRowBounds(n2);
                TreePath treePath = NavigationTree.this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                Object object2 = null;
                try {
                    object = (BasicTreeUI)NavigationTree.this.getUI();
                    Method method = BasicTreeUI.class.getDeclaredMethod("isLocationInExpandControl", TreePath.class, Integer.TYPE, Integer.TYPE);
                    method.setAccessible(true);
                    object2 = method.invoke(object, treePath, mouseEvent.getX(), mouseEvent.getY());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!Boolean.TRUE.equals(object2) && !rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    object = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), rectangle.x + rectangle.width - 1, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                    NavigationTree.this.dispatchEvent((AWTEvent)object);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (NavigationTree.this.isIconFade()) {
                NavigationTree.this.\u1e13.stop();
                NavigationTree.this.\u1e0f.start();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (NavigationTree.this.isIconFade()) {
                NavigationTree.this.\u1e0f.stop();
                NavigationTree.this.\u1e13.start();
            }
        }
    }
}

