/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class InstallationProperties
implements Serializable {
    private static final String INSTALLATION_PROP_FILE_NAME = "install.prop";
    public static final String PROP_NAME_LAUNCHER = "launcher";
    public static final String PROP_NAME_SERVICE = "service";
    public static final String PROP_NAME_SERVICE_NAME = "serviceName";
    private static final String PROP_LANGUAGE_ID = "languageId";
    private static final String PROP_MSI_ALL_USERS = "msiAllUsers";
    private Properties props = new Properties();

    public InstallationProperties(File runtimeDir) {
        File file = new File(runtimeDir, INSTALLATION_PROP_FILE_NAME);
        if (file.exists()) {
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                this.props.load(in);
                ((InputStream)in).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getPropertyList(String baseName) {
        String value;
        ArrayList<String> ret = new ArrayList<String>();
        int index = 0;
        while ((value = this.props.getProperty(baseName + index++)) != null) {
            ret.add(value);
        }
        return ret;
    }

    public Set<File> getCanonicalFilePropertySet(String baseName) {
        HashSet<File> ret = new HashSet<File>();
        List<String> stringList = this.getPropertyList(baseName);
        for (String fileName : stringList) {
            ret.add(new File(InstallationProperties.getCanoncialPath(fileName)));
        }
        return ret;
    }

    public Set<String> getCanonicalPathPropertySet(String baseName) throws IOException {
        HashSet<String> ret = new HashSet<String>();
        List<String> stringList = this.getPropertyList(baseName);
        for (String fileName : stringList) {
            ret.add(InstallationProperties.getCanoncialPath(fileName));
        }
        return ret;
    }

    private static String getCanoncialPath(String fileName) {
        try {
            return new File(fileName).getCanonicalPath();
        }
        catch (IOException e) {
            return new File(fileName).getAbsolutePath();
        }
    }

    public void store(File runtimeDir) throws IOException {
        File file = new File(runtimeDir, INSTALLATION_PROP_FILE_NAME);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        this.props.store(out, "");
        ((OutputStream)out).close();
        FileInstaller.getInstance().registerUninstallFile(file);
    }

    public void addFileToSet(String baseName, File file) throws IOException {
        File canonicalFile;
        Set<File> currentSet = this.getCanonicalFilePropertySet(baseName);
        if (!currentSet.contains(canonicalFile = file.getCanonicalFile())) {
            this.addToList(baseName, canonicalFile.getAbsolutePath());
        }
    }

    public void addStringToSet(String baseName, String entry) throws IOException {
        List<String> currentList = this.getPropertyList(baseName);
        if (!currentList.contains(entry)) {
            this.addToList(baseName, entry);
        }
    }

    private void addToList(String baseName, String value) {
        int index = -1;
        while (this.props.getProperty(baseName + ++index) != null) {
        }
        this.props.setProperty(baseName + index, value);
    }

    public void setLanguageId(String languageId) {
        this.props.setProperty(PROP_LANGUAGE_ID, languageId);
    }

    public String getLanguageId() {
        return this.props.getProperty(PROP_LANGUAGE_ID);
    }

    public void setMsiAllUsers(boolean allUsers) {
        this.props.setProperty(PROP_MSI_ALL_USERS, String.valueOf(allUsers));
    }

    public boolean isMsiAllUsers() {
        return Boolean.parseBoolean(this.props.getProperty(PROP_MSI_ALL_USERS));
    }
}

