/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.folding;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.folding.DefaultFoldingSpan;
import com.jidesoft.editor.folding.FoldingModel;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

public class DefaultFoldingModel
implements FoldingModel,
DocumentListener {
    private A \u0102;
    private CodeEditor \u0101;
    private boolean \u0106;
    private boolean \u0105;
    private int \u0108;
    private int \u0107;
    private boolean \u0103;
    private boolean \u0104;
    protected EventListenerList _listenerList = new EventListenerList();

    public DefaultFoldingModel(CodeEditor codeEditor) {
        this.\u0102 = new A();
        this.\u0101 = codeEditor;
        this.\u0103 = false;
    }

    @Override
    public synchronized FoldingSpan addFoldingSpan(int n2, int n3, String string) {
        if (this.isEnabled()) {
            FoldingSpan foldingSpan = this.createFoldingSpan(n2, n3, string);
            this.\u0103 = true;
            this.\u0102.\u0101(foldingSpan);
            if (!this.isAdjusting()) {
                this.rebuild();
            }
            this.fireFoldingSpanChanged(foldingSpan, 0, this.isAdjusting());
            return foldingSpan;
        }
        return null;
    }

    protected FoldingSpan createFoldingSpan(int n2, int n3, String string) {
        return new DefaultFoldingSpan(this.\u0101, n2, n3, string);
    }

    @Override
    public synchronized boolean removeFoldingSpan(FoldingSpan foldingSpan) {
        this.expandFoldingSpan(foldingSpan);
        boolean bl = this.\u0102.\u0102(foldingSpan);
        if (bl) {
            if (!this.isAdjusting()) {
                this.rebuild();
            }
            this.fireFoldingSpanChanged(foldingSpan, 1, this.isAdjusting());
            this.\u0103 = true;
        }
        return bl;
    }

    @Override
    public synchronized void removeAllFoldingSpans() {
        this.\u0102.\u0104();
        if (!this.isAdjusting()) {
            this.rebuild();
        }
        this.\u0103 = true;
    }

    @Override
    public boolean isAdjusting() {
        return this.\u0105;
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (this.\u0105 != bl) {
            this.\u0105 = bl;
            if (!this.\u0105) {
                if (this.\u0103) {
                    this.rebuild();
                }
                this.fireFoldingSpanChanged(null, 6, this.isAdjusting());
            } else {
                this.fireFoldingSpanChanged(null, 5, this.isAdjusting());
            }
        }
    }

    @Override
    public synchronized void expandFoldingSpan(FoldingSpan foldingSpan) {
        int n2;
        FoldingSpan[] foldingSpanArray;
        if (foldingSpan.isExpanded()) {
            return;
        }
        if (this.\u0104 && (foldingSpanArray = this.\u0102.\u0103(n2 = this.\u0101.modelPositionToOffset(new CaretPosition(this.\u0107, this.\u0108)))).length == 1 && foldingSpanArray[0] == foldingSpan) {
            CaretPosition caretPosition = new CaretPosition(this.\u0107, this.\u0108);
            this.\u0101.getCaretModel().setModelPosition(caretPosition);
        }
        this.\u0103 = true;
        if (foldingSpan instanceof DefaultFoldingSpan) {
            ((DefaultFoldingSpan)foldingSpan).\u0101(true);
        } else {
            foldingSpan.setExpanded(true);
        }
        if (!this.isAdjusting()) {
            this.rebuild();
        }
        this.fireFoldingSpanChanged(foldingSpan, 3, this.isAdjusting());
    }

    @Override
    public synchronized void collapseFoldingSpan(FoldingSpan foldingSpan) {
        if (!foldingSpan.isExpanded()) {
            return;
        }
        CaretPosition caretPosition = this.\u0101.getCaretModel().getModelPosition();
        int n2 = this.\u0101.modelPositionToOffset(caretPosition);
        if (this.\u0102.\u0101(foldingSpan, n2) && !this.\u0104) {
            this.\u0108 = caretPosition.column;
            this.\u0107 = caretPosition.line;
            this.\u0104 = true;
        }
        int n3 = this.\u0101.getSelectionModel().getSelectionStart();
        int n4 = this.\u0101.getSelectionModel().getSelectionEnd();
        if (this.\u0102.\u0101(foldingSpan, n3 - 1) || this.\u0102.\u0101(foldingSpan, n4)) {
            this.\u0101.getSelectionModel().clearSelection();
        }
        this.\u0103 = true;
        ((DefaultFoldingSpan)foldingSpan).\u0101(false);
        if (!this.isAdjusting()) {
            this.rebuild();
        }
        this.fireFoldingSpanChanged(foldingSpan, 4, this.isAdjusting());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void expandAll(boolean bl) {
        FoldingSpan[] foldingSpanArray = this.getFoldingSpans();
        try {
            this.setAdjusting(true);
            for (FoldingSpan foldingSpan : foldingSpanArray) {
                foldingSpan.setExpanded(bl);
            }
        }
        finally {
            this.setAdjusting(false);
        }
    }

    @Override
    public synchronized void expandAll() {
        this.expandAll(true);
    }

    @Override
    public synchronized void collapseAll() {
        this.expandAll(false);
    }

    @Override
    public synchronized void foldingSpanUpdated(FoldingSpan foldingSpan) {
        if (!this.isAdjusting()) {
            this.rebuild();
        }
        this.fireFoldingSpanChanged(foldingSpan, 2, this.isAdjusting());
    }

    @Override
    public synchronized FoldingSpan[] getFoldingSpans() {
        return this.\u0102.\u0102();
    }

    @Override
    public synchronized void setEnabled(boolean bl) {
        this.\u0106 = bl;
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.\u0106;
    }

    protected void fireFoldingSpanChanged(FoldingSpan foldingSpan, int n2, boolean bl) {
        Object[] objectArray = this._listenerList.getListenerList();
        FoldingSpanEvent foldingSpanEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != FoldingSpanListener.class) continue;
            if (foldingSpanEvent == null) {
                foldingSpanEvent = new FoldingSpanEvent(this, foldingSpan, n2, bl);
            }
            ((FoldingSpanListener)objectArray[i2 + 1]).foldingSpanChanged(foldingSpanEvent);
        }
    }

    @Override
    public void addFoldingSpanListener(FoldingSpanListener foldingSpanListener) {
        this._listenerList.add(FoldingSpanListener.class, foldingSpanListener);
    }

    @Override
    public void removeFoldingSpanListener(FoldingSpanListener foldingSpanListener) {
        this._listenerList.remove(FoldingSpanListener.class, foldingSpanListener);
    }

    @Override
    public FoldingSpanListener[] getFoldingSpanListeners() {
        return (FoldingSpanListener[])this._listenerList.getListeners(FoldingSpanListener.class);
    }

    private int \u0101(int n2) {
        char c2;
        int n3;
        String string = this.\u0101.getLineText(n2);
        for (n3 = string.length(); n3 > 0 && ((c2 = string.charAt(n3 - 1)) == '\r' || c2 == '\n'); --n3) {
        }
        return n3;
    }

    public String toString() {
        return this.\u0102 == null ? "(empty)" : this.\u0102.toString();
    }

    public void rebuild() {
        this.\u0102.\u0106();
    }

    public int getLastTopLevelIndexBefore(int n2) {
        return this.\u0102.\u0104(n2);
    }

    public int getFoldedLinesCountBefore(int n2) {
        return this.\u0102.\u0101(n2);
    }

    public FoldingSpan[] getTopLevelSpans() {
        return this.\u0102.\u0107();
    }

    public FoldingSpan getOutermostSpanAtViewPosition(CaretPosition caretPosition) {
        return this.\u0102.\u0101(caretPosition);
    }

    public FoldingSpan getOutermostSpanAtOffset(int n2) {
        return this.\u0102.\u0102(n2);
    }

    public FoldingSpan[] getFoldedSpansAtOffset(int n2) {
        return this.\u0102.\u0103(n2);
    }

    public boolean hasAnySpan(int n2, int n3) {
        return this.\u0102.\u0101(n2, n3);
    }

    public FoldingSpan[] getVisibleSpans() {
        return this.\u0102.\u0105();
    }

    private void \u0101() {
        this.\u0102.\u0101();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.\u0102.\u0103(documentEvent.getOffset(), documentEvent.getLength());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.\u0102.\u0102(documentEvent.getOffset(), documentEvent.getLength());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.\u0101();
    }

    public void resetCaretPosition() {
        this.\u0104 = false;
    }

    public static FoldingSpan findFoldingSpanStartingAtLine(CodeEditor codeEditor, int n2) {
        FoldingSpan[] foldingSpanArray = codeEditor.getFoldingModel().getFoldingSpans();
        FoldingSpan foldingSpan = null;
        for (FoldingSpan foldingSpan2 : foldingSpanArray) {
            if (codeEditor.getLineNumber(foldingSpan2.getStartOffset()) != n2) continue;
            if (foldingSpan != null) {
                return null;
            }
            foldingSpan = foldingSpan2;
        }
        return foldingSpan;
    }

    public static FoldingSpan[] getFoldingSpanAtOffset(CodeEditor codeEditor, int n2) {
        FoldingSpan[] foldingSpanArray;
        ArrayList<FoldingSpan> arrayList = new ArrayList<FoldingSpan>();
        for (FoldingSpan foldingSpan : foldingSpanArray = codeEditor.getFoldingModel().getFoldingSpans()) {
            if (foldingSpan.getStartOffset() > n2 || n2 >= foldingSpan.getEndOffset()) continue;
            arrayList.add(foldingSpan);
        }
        foldingSpanArray = arrayList.toArray(new FoldingSpan[arrayList.size()]);
        Arrays.sort(foldingSpanArray, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                FoldingSpan foldingSpan = (FoldingSpan)object;
                FoldingSpan foldingSpan2 = (FoldingSpan)object2;
                return foldingSpan2.getStartOffset() - foldingSpan.getStartOffset();
            }
        });
        return foldingSpanArray;
    }

    private class A {
        private FoldingSpan[] \u0105 = null;
        private FoldingSpan[] \u0108;
        private int[] \u0104;
        private int[] \u0106;
        private int[] \u0103;
        private CaretPosition[] \u0102;
        private final LinkedList<FoldingSpan> \u0107 = new LinkedList();

        public boolean \u0103() {
            return DefaultFoldingModel.this.isEnabled() && this.\u0105 != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void \u0106() {
            FoldingSpan[] foldingSpanArray;
            FoldingSpan[] foldingSpanArray2;
            ArrayList<FoldingSpan[]> arrayList;
            ArrayList<FoldingSpan[]> arrayList2;
            Object object = this.\u0107;
            synchronized (object) {
                arrayList2 = new ArrayList<FoldingSpan[]>(this.\u0107.size() / 2);
                arrayList = new ArrayList<FoldingSpan[]>(this.\u0107.size());
                foldingSpanArray2 = this.\u0107.toArray(new FoldingSpan[this.\u0107.size()]);
            }
            object = null;
            FoldingSpan[] foldingSpanArray3 = foldingSpanArray2;
            int n2 = foldingSpanArray3.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                FoldingSpan[] foldingSpanArray4 = foldingSpanArray3[i2];
                if (!foldingSpanArray4.isValid()) continue;
                arrayList.add(foldingSpanArray4);
                if (foldingSpanArray4.isExpanded() || object != null && object.getEndOffset() >= foldingSpanArray4.getStartOffset()) continue;
                object = foldingSpanArray4;
                arrayList2.add(foldingSpanArray4);
            }
            this.\u0108 = arrayList2.toArray(new FoldingSpan[arrayList2.size()]);
            Arrays.sort(this.\u0108, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    int n2;
                    FoldingSpan foldingSpan = (FoldingSpan)object;
                    FoldingSpan foldingSpan2 = (FoldingSpan)object2;
                    int n3 = foldingSpan.getEndOffset();
                    if (n3 < (n2 = foldingSpan2.getEndOffset())) {
                        return -1;
                    }
                    return n3 <= n2 ? 0 : 1;
                }
            });
            block4: for (FoldingSpan foldingSpan : foldingSpanArray = (foldingSpanArray3 = arrayList.toArray(new FoldingSpan[arrayList.size()]))) {
                FoldingSpan[] foldingSpanArray5 = this.\u0108;
                for (int i3 = 0; i3 < foldingSpanArray5.length; ++i3) {
                    FoldingSpan foldingSpan2 = foldingSpanArray5[i3];
                    if (!this.\u0102(foldingSpan2, foldingSpan)) continue;
                    arrayList.remove(foldingSpan);
                    continue block4;
                }
            }
            this.\u0105 = arrayList.toArray(new FoldingSpan[arrayList.size()]);
            Arrays.sort(this.\u0105, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    int n2;
                    FoldingSpan foldingSpan = (FoldingSpan)object;
                    FoldingSpan foldingSpan2 = (FoldingSpan)object2;
                    int n3 = foldingSpan.getEndOffset();
                    if (n3 < (n2 = foldingSpan2.getEndOffset())) {
                        return 1;
                    }
                    return n3 <= n2 ? 0 : -1;
                }
            });
            this.\u0101();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void \u0103(int n2, int n3) {
            LinkedList<FoldingSpan> linkedList = this.\u0107;
            synchronized (linkedList) {
                for (FoldingSpan foldingSpan : this.\u0107) {
                    if (!(foldingSpan instanceof DefaultFoldingSpan)) continue;
                    if (foldingSpan.getStartOffset() >= n2) {
                        DefaultFoldingModel.this.setAdjusting(true);
                        ((DefaultFoldingSpan)foldingSpan).setStartOffset(foldingSpan.getStartOffset() + n3);
                        ((DefaultFoldingSpan)foldingSpan).setEndOffset(foldingSpan.getEndOffset() + n3);
                        continue;
                    }
                    if (foldingSpan.getEndOffset() <= n2) continue;
                    DefaultFoldingModel.this.setAdjusting(true);
                    ((DefaultFoldingSpan)foldingSpan).setEndOffset(foldingSpan.getEndOffset() + n3);
                }
                if (DefaultFoldingModel.this.isAdjusting()) {
                    this.\u0101();
                }
                DefaultFoldingModel.this.setAdjusting(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void \u0102(int n2, int n3) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            LinkedList<FoldingSpan> linkedList = this.\u0107;
            synchronized (linkedList) {
                for (int i2 = 0; i2 < this.\u0107.size(); ++i2) {
                    FoldingSpan foldingSpan = this.\u0107.get(i2);
                    if (!(foldingSpan instanceof DefaultFoldingSpan)) continue;
                    if (foldingSpan.getStartOffset() > n2 + n3 - 1) {
                        DefaultFoldingModel.this.setAdjusting(true);
                        ((DefaultFoldingSpan)foldingSpan).setStartOffset(foldingSpan.getStartOffset() - n3);
                        ((DefaultFoldingSpan)foldingSpan).setEndOffset(foldingSpan.getEndOffset() - n3);
                        continue;
                    }
                    if (foldingSpan.getEndOffset() <= n2) continue;
                    DefaultFoldingModel.this.setAdjusting(true);
                    if (foldingSpan.getStartOffset() >= n2) {
                        if (foldingSpan.getEndOffset() > n2 + n3 - 1) {
                            ((DefaultFoldingSpan)foldingSpan).setStartOffset(n2);
                            ((DefaultFoldingSpan)foldingSpan).setEndOffset(foldingSpan.getEndOffset() - n3);
                            continue;
                        }
                        arrayList.add(i2);
                        continue;
                    }
                    if (foldingSpan.getEndOffset() > n2 + n3 - 1) {
                        ((DefaultFoldingSpan)foldingSpan).setEndOffset(foldingSpan.getEndOffset() - n3);
                        continue;
                    }
                    ((DefaultFoldingSpan)foldingSpan).setEndOffset(n2 - 1);
                }
                LinkedList<FoldingSpan> linkedList2 = this.\u0107;
                synchronized (linkedList2) {
                    for (int i3 = arrayList.size() - 1; i3 >= 0; --i3) {
                        int n4 = (Integer)arrayList.get(i3);
                        this.\u0107.remove(n4);
                    }
                }
                if (DefaultFoldingModel.this.isAdjusting()) {
                    this.\u0101();
                }
                DefaultFoldingModel.this.setAdjusting(false);
            }
        }

        public void \u0101() {
            if (this.\u0103()) {
                FoldingSpan[] foldingSpanArray;
                FoldingSpan[] foldingSpanArray2 = foldingSpanArray = this.\u0105;
                int n2 = foldingSpanArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    FoldingSpan foldingSpan = foldingSpanArray2[i2];
                    if (foldingSpan.isValid()) continue;
                    this.\u0106();
                    return;
                }
                int n3 = 0;
                if (this.\u0104 == null || this.\u0104.length != this.\u0108.length) {
                    this.\u0104 = new int[this.\u0108.length];
                    this.\u0106 = new int[this.\u0108.length];
                    this.\u0103 = new int[this.\u0108.length];
                    this.\u0102 = new CaretPosition[this.\u0108.length];
                }
                for (n2 = 0; n2 < this.\u0108.length; ++n2) {
                    FoldingSpan foldingSpan = this.\u0108[n2];
                    this.\u0106[n2] = foldingSpan.getStartOffset();
                    this.\u0104[n2] = foldingSpan.getEndOffset() - 1;
                    int n4 = DefaultFoldingModel.this.\u0101.getLineNumber(this.\u0104[n2]);
                    int n5 = DefaultFoldingModel.this.\u0101(n4) + DefaultFoldingModel.this.\u0101.getLineStartOffset(n4);
                    if (this.\u0104[n2] >= n5) {
                        this.\u0104[n2] = n5 - 1;
                    }
                    this.\u0103[n2] = n3 += DefaultFoldingModel.this.\u0101.getLineNumber(foldingSpan.getEndOffset()) - DefaultFoldingModel.this.\u0101.getLineNumber(foldingSpan.getStartOffset());
                }
                for (n2 = 0; n2 < this.\u0108.length; ++n2) {
                    CaretPosition caretPosition = DefaultFoldingModel.this.\u0101.offsetToViewPosition(this.\u0106[n2]);
                    this.\u0102[n2] = new CaretPosition(caretPosition.line, caretPosition.column + (this.\u0108[n2].getDescription() == null ? 0 : this.\u0108[n2].getDescription().length()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean \u0101(FoldingSpan foldingSpan) {
            LinkedList<FoldingSpan> linkedList = this.\u0107;
            synchronized (linkedList) {
                for (int i2 = 0; i2 < this.\u0107.size(); ++i2) {
                    FoldingSpan foldingSpan2 = this.\u0107.get(i2);
                    if (foldingSpan2.isValid() && this.\u0101(foldingSpan2, foldingSpan)) {
                        return false;
                    }
                    if (foldingSpan.getStartOffset() >= foldingSpan2.getStartOffset() && (foldingSpan.getStartOffset() != foldingSpan2.getStartOffset() || foldingSpan.getEndOffset() <= foldingSpan2.getEndOffset())) continue;
                    for (int i3 = i2 + 1; i3 < this.\u0107.size(); ++i3) {
                        FoldingSpan foldingSpan3 = this.\u0107.get(i3);
                        if (foldingSpan3.getEndOffset() < foldingSpan.getEndOffset() || !foldingSpan3.isValid()) continue;
                        if (foldingSpan3.getStartOffset() >= foldingSpan.getStartOffset()) break;
                        return false;
                    }
                    this.\u0107.add(i2, foldingSpan);
                    return true;
                }
                this.\u0107.addLast(foldingSpan);
            }
            return true;
        }

        public FoldingSpan \u0102(int n2) {
            if (!this.\u0103()) {
                return null;
            }
            int n3 = 0;
            int n4 = this.\u0104.length - 1;
            while (n3 <= n4) {
                int n5 = (n3 + n4) / 2;
                if (n2 < this.\u0106[n5]) {
                    n4 = n5 - 1;
                    continue;
                }
                if (n2 > this.\u0104[n5]) {
                    n3 = n5 + 1;
                    continue;
                }
                return this.\u0108[n5];
            }
            return null;
        }

        public FoldingSpan \u0101(CaretPosition caretPosition) {
            if (this.\u0102 == null) {
                return null;
            }
            int n2 = 0;
            int n3 = this.\u0102.length - 1;
            int n4 = 0;
            while (n2 <= n3) {
                n4 = (n2 + n3) / 2;
                CaretPosition caretPosition2 = this.\u0102[n4];
                if (caretPosition2.line < caretPosition.line) {
                    n2 = n4 + 1;
                    continue;
                }
                if (caretPosition2.line > caretPosition.line) {
                    n3 = n4 - 1;
                    continue;
                }
                if (caretPosition2.column < caretPosition.column) {
                    n2 = n4 + 1;
                    continue;
                }
                if (caretPosition2.column >= caretPosition.column) break;
                n3 = n4 - 1;
            }
            if (n4 >= 0 && n4 < this.\u0102.length) {
                if (this.\u0102[n4].line > caretPosition.line || this.\u0102[n4].line == caretPosition.line && this.\u0102[n4].column - (this.\u0108[n4].getDescription() == null ? 0 : this.\u0108[n4].getDescription().length()) >= caretPosition.column) {
                    if (--n4 >= 0) {
                        return this.\u0108[n4];
                    }
                    return null;
                }
                return this.\u0108[n4];
            }
            return null;
        }

        public FoldingSpan[] \u0105() {
            if (!this.\u0103()) {
                return new FoldingSpan[0];
            }
            return this.\u0105;
        }

        public FoldingSpan[] \u0107() {
            if (!this.\u0103()) {
                return null;
            }
            return this.\u0108;
        }

        private boolean \u0102(FoldingSpan foldingSpan, FoldingSpan foldingSpan2) {
            return foldingSpan.getStartOffset() < foldingSpan2.getStartOffset() && foldingSpan.getEndOffset() > foldingSpan2.getStartOffset();
        }

        private boolean \u0101(FoldingSpan foldingSpan, FoldingSpan foldingSpan2) {
            int n2 = foldingSpan.getStartOffset();
            int n3 = foldingSpan2.getStartOffset();
            int n4 = foldingSpan.getEndOffset();
            int n5 = foldingSpan2.getEndOffset();
            return n2 == n3 && n4 == n5 || n2 < n3 && n3 < n4 && n4 < n5 || n3 < n2 && n2 < n5 && n5 < n4;
        }

        private boolean \u0101(FoldingSpan foldingSpan, int n2) {
            return foldingSpan.getStartOffset() <= n2 && foldingSpan.getEndOffset() > n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FoldingSpan[] \u0103(int n2) {
            if (!this.\u0103()) {
                return new FoldingSpan[0];
            }
            ArrayList<FoldingSpan> arrayList = new ArrayList<FoldingSpan>();
            LinkedList<FoldingSpan> linkedList = this.\u0107;
            synchronized (linkedList) {
                for (FoldingSpan foldingSpan : this.\u0107) {
                    if (foldingSpan.isExpanded() || !this.\u0101(foldingSpan, n2)) continue;
                    arrayList.add(foldingSpan);
                }
            }
            return arrayList.toArray(new FoldingSpan[arrayList.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean \u0101(int n2, int n3) {
            if (!DefaultFoldingModel.this.isEnabled()) {
                return true;
            }
            LinkedList<FoldingSpan> linkedList = this.\u0107;
            synchronized (linkedList) {
                for (FoldingSpan foldingSpan : this.\u0107) {
                    boolean bl = this.\u0101(foldingSpan, n2);
                    boolean bl2 = this.\u0101(foldingSpan, n3);
                    if ((!bl || bl2) && (bl || !bl2)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FoldingSpan[] \u0102() {
            LinkedList<FoldingSpan> linkedList = this.\u0107;
            synchronized (linkedList) {
                if (!this.\u0103()) {
                    return new FoldingSpan[0];
                }
                return this.\u0107.toArray(new FoldingSpan[this.\u0107.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean \u0102(FoldingSpan foldingSpan) {
            LinkedList<FoldingSpan> linkedList = this.\u0107;
            synchronized (linkedList) {
                return this.\u0107.remove(foldingSpan);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void \u0104() {
            LinkedList<FoldingSpan> linkedList = this.\u0107;
            synchronized (linkedList) {
                this.\u0107.clear();
            }
        }

        public int \u0101(int n2) {
            int n3 = this.\u0104(n2);
            if (n3 == -1) {
                return 0;
            }
            return this.\u0103[n3];
        }

        public int \u0104(int n2) {
            if (!this.\u0103()) {
                return -1;
            }
            int n3 = 0;
            int n4 = this.\u0104.length - 1;
            while (n3 <= n4) {
                int n5 = (n3 + n4) / 2;
                if (n2 < this.\u0104[n5]) {
                    n4 = n5 - 1;
                    continue;
                }
                if (n2 > this.\u0104[n5]) {
                    n3 = n5 + 1;
                    continue;
                }
                return n5;
            }
            return n4;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.\u0108 != null) {
                for (int i2 = 0; i2 < this.\u0108.length; ++i2) {
                    stringBuffer.append("Folded Span (").append(this.\u0108[i2].getStartOffset()).append(",").append(this.\u0108[i2].getEndOffset()).append(").");
                    if (i2 < this.\u0106.length) {
                        stringBuffer.append("Start at: ").append(this.\u0106[i2]).append(".");
                    }
                    if (i2 < this.\u0104.length) {
                        stringBuffer.append("End at: ").append(this.\u0104[i2]).append(".");
                    }
                    if (i2 < this.\u0103.length) {
                        stringBuffer.append("Occupies ").append(this.\u0103[i2]).append(" lines.");
                    }
                    if (i2 < this.\u0102.length) {
                        stringBuffer.append("View Position is:(").append(this.\u0102[i2].line).append(",").append(this.\u0102[i2].column).append(").");
                    }
                    stringBuffer.append("\r\n");
                }
            }
            return stringBuffer.toString();
        }
    }
}

