/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.exe4j.runtime.util.ResourceHelper;
import com.exe4j.runtime.util.WinDel;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.Application;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MsiScope;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.SplashProgressInterface;
import com.install4j.runtime.installer.frontend.WizardScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.platform.macos.MacAuthorization;
import com.install4j.runtime.installer.platform.win32.MsiCommunication;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import com.install4j.runtime.launcher.integration.gui.AwtAndFxWindowChecker;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public abstract class AbstractPrivilegesAction
extends SystemInstallOrUninstallAction {
    private static boolean helperStarted = false;

    protected boolean startOnMac(Context context) {
        if (!Util.isMacosInstaller()) {
            return false;
        }
        if (helperStarted) {
            return true;
        }
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        String identifier = helperCommunication.createListener();
        if (identifier == null) {
            return false;
        }
        String classPath = InstallerUtil.isInProcess() ? new File(ResourceHelper.getRuntimeDir(), "i4jruntime.jar").getAbsolutePath() : System.getProperty("java.class.path");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(System.getProperty("install4j.helperMaxHeap", "-Xmx256m"));
        String debugArgument = this.getHelperDebugArgument("", false);
        if (debugArgument.length() > 0) {
            arguments.add(debugArgument);
        }
        arguments.add("-classpath");
        arguments.add(classPath);
        arguments.add("-Duser.language=" + context.getLanguageId());
        arguments.add("-Dinstall4j.language=" + context.getLanguageId());
        arguments.add("-Dinstall4j.systemLanguage=" + System.getProperty("install4j.systemLanguage"));
        arguments.add("-Dinstall4j.commIdentifier=" + identifier);
        arguments.add("-Dinstall4j.helperAppId=" + InstallerConfig.getCurrentApplicationId());
        arguments.add("-Dinstall4j.helperLog=" + Boolean.getBoolean("install4j.helperLog"));
        arguments.add("-Dinstall4j.dontUninstallServices=" + Boolean.getBoolean("install4j.dontUninstallServices"));
        if (System.getProperty("exe4j.moduleName") != null) {
            arguments.add("-Dexe4j.moduleName=" + System.getProperty("exe4j.moduleName"));
        }
        if (System.getProperty("i4j.jreBundle") != null) {
            arguments.add("-Di4j.jreBundle=" + System.getProperty("i4j.jreBundle"));
        }
        if (System.getProperty("i4j.tarFile") != null) {
            arguments.add("-Di4j.tarFile=" + System.getProperty("i4j.tarFile"));
        }
        arguments.add("-Dapple.awt.UIElement=true");
        arguments.add(HelperCommunication.class.getName());
        String prompt = MacAuthorization.getDefaultPrompt(InstallerConfig.getCurrentInstance() == null ? null : InstallerConfig.getCurrentInstance().getApplicationName());
        Logger.getInstance().info(null, "args: " + ((Object)arguments).toString());
        try {
            MacAuthorization.execute(prompt, new File(System.getProperty("java.home"), "bin/java").getAbsolutePath(), arguments);
            helperStarted = helperCommunication.connect();
        }
        catch (MacAuthorization.BaseAuthorizationException e) {
            Logger.getInstance().log(e);
        }
        return helperStarted;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startOnWindows(Context context) {
        Window parentWindow = Util.getParentWindow();
        if (parentWindow != null) {
            parentWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            boolean bl = this.startOnWindowsUnguarded(context);
            return bl;
        }
        finally {
            if (parentWindow != null) {
                parentWindow.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private boolean startOnWindowsUnguarded(Context context) {
        if (!Util.isAtLeastWindowsVista()) {
            return false;
        }
        if (helperStarted) {
            return true;
        }
        if (MsiHelper.isStartedFromMsi()) {
            if (!MsiHelper.isMsiAllUsers(context) && MsiHelper.getMsiScope() == MsiScope.PER_USER) {
                return false;
            }
            if (context.isUnattended()) {
                return false;
            }
        }
        if (Win32UserInfo.isUACDisabled()) {
            return false;
        }
        String moduleName = this.getModuleName();
        if (moduleName == null) {
            return true;
        }
        if (!new File(moduleName).exists()) {
            Util.showMessage(Messages.format(Messages.getString(".ErrorInternal2"), "Could not start elevated: " + moduleName), 0);
            return false;
        }
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        String identifier = helperCommunication.createListener();
        if (identifier == null) {
            return false;
        }
        SplashProgressInterface splashProgressInterface = this.checkSplashScreen(context);
        InstallerUtil.storeJreInfoForInstaller();
        String maxHeap = System.getProperty("install4j.helperMaxHeap", "-Xmx128m");
        String arguments = "__i4j_lang_restart" + (Installer.getManualTempDir() == null ? "" : " -temp \"" + Installer.getManualTempDir() + "\"") + this.getHelperDebugArgument("-J", true) + " -J" + maxHeap + " -J-D" + "install4j.commIdentifier" + "=" + identifier + " -J-D" + "install4j.helperAppId" + "=" + InstallerConfig.getCurrentApplicationId() + " -J-Duser.language=" + context.getLanguageId() + " -J-D" + "install4j.language" + "=" + context.getLanguageId() + " -J-D" + "install4j.systemLanguage" + "=" + System.getProperty("install4j.systemLanguage") + " -J-D" + "exe4j.unextractedPositionRestart" + "=" + Integer.getInteger("exe4j.unextractedPositionRestart", Integer.getInteger("exe4j.unextractedPosition", 0)) + " -J-D" + "install4j.helperLog" + "=" + Boolean.getBoolean("install4j.helperLog") + " -J-D" + "install4j.dontUninstallServices" + "=" + Boolean.getBoolean("install4j.dontUninstallServices") + (WinDel.SEMAPHORE_NAME == null ? "" : " \"-J-Dexe4j.semaphoreName=" + WinDel.SEMAPHORE_NAME + "\"") + (System.getProperty("windel.logfile") == null ? "" : " \"-J-Dwindel.logfile=" + System.getProperty("windel.logfile") + "\"");
        if (MsiCommunication.isConnected()) {
            if (InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().getMsiScope() == MsiScope.PER_USER) {
                MsiCommunication.sendElevationRequested();
            } else {
                helperStarted = MsiCommunication.executeElevated("\"" + moduleName + "\" " + MsiHelper.addMsiArguments(arguments), new File(System.getProperty("user.dir")));
                if (helperStarted) {
                    MsiHelper.setMsiAllUsers(true);
                }
            }
        } else {
            helperStarted = Win32UserInfo.executeElevated(moduleName, arguments, System.getProperty("user.dir"));
        }
        boolean bl = helperStarted = helperStarted && helperCommunication.connect();
        if (helperStarted && !AbstractPrivilegesAction.checkFullAdminRights()) {
            Logger.getInstance().error(this, "The elevated helper does not have full admin rights");
            helperCommunication.terminate();
            helperStarted = false;
        }
        if (splashProgressInterface != null) {
            splashProgressInterface.setVisible(false);
        }
        return helperStarted;
    }

    protected void setAdminRightsVariable() {
        InstallerVariables.setAdminRightsFromPrivilegesAction(Util.isAdminGroup() && Util.hasFullAdminRights() || HelperCommunication.getInstance().hasElevatedHelper());
    }

    private static boolean checkFullAdminRights() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.MAXIMUM, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                return Util.hasFullAdminRights();
            }
        });
    }

    private String getModuleName() {
        String moduleName;
        if (InstallerUtil.isInProcess()) {
            moduleName = Application.getExeFile((ApplicationWithPath)InstallerConfig.getCurrentApplication()).getAbsolutePath();
        } else {
            moduleName = System.getProperty("exe4j.moduleName");
            if (moduleName == null) {
                Util.showMessage("No elevation can be performed for debug installers. Continuing without elevation.", 1);
            }
        }
        return moduleName;
    }

    private SplashProgressInterface checkSplashScreen(Context context) {
        SplashProgressInterface ret = null;
        if (!(InstallerConfig.isInstaller() && !((InstallerApplication)InstallerConfig.getCurrentApplication()).isSuppressProgressDialog() || context.isConsole() || context.isUnattended() || AwtAndFxWindowChecker.hasVisibleWindows())) {
            SplashProgressInterface splashProgressInterface;
            String title = "install4j";
            if (context.getWizardContext() instanceof WizardScreenExecutor) {
                title = ((WizardScreenExecutor)context.getWizardContext()).getWindowTitle();
            }
            ret = splashProgressInterface = new SplashProgressInterface(title, false, false, false, null, false, null);
            splashProgressInterface.setStatusMessage(Messages.getString(".ProcessElevationTitle"));
            try {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        splashProgressInterface.setIndeterminateProgress(true);
                        splashProgressInterface.setVisible(true);
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    protected void showFailureMessage(Context context) throws UserCanceledException {
        String message = context instanceof InstallerContext ? (InstallerConfig.getCurrentApplication() instanceof InstallerApplication ? (Util.isWindows() ? Messages.getString(".AdminPrivilegesRequired") : Messages.getString(".RootPrivilegesRequired")) : (Util.isWindows() ? Messages.getString(".AdminPrivilegesRequiredExecute") : Messages.getString(".RootPrivilegesRequiredExecute"))) : Messages.getString(".OnlyAdminCanUninstall");
        Util.showMessage(message, 0);
        throw new UserCanceledException("not admin");
    }

    private String getHelperDebugArgument(String prefix, boolean withSpace) {
        int debugPort = Integer.getInteger("install4j.helperDebugPort", 0);
        if (debugPort > 0) {
            return (withSpace ? " " : "") + prefix + "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + debugPort;
        }
        return "";
    }
}

