/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNamespaceContext;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

class XSLImportSchema
extends XSLNode
implements XSLConstants {
    String nsvalue;
    String slvalue;
    XMLSchema schema;
    EntityResolver entityResolver;
    int importprecedence = 0;
    XMLDocument embededom;

    XSLImportSchema(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 6;
    }

    XMLElement convert2XMLElement(XMLDocument xMLDocument) {
        XMLElement xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:import");
        if (this.nsvalue != null && this.nsvalue.length() > 0) {
            xMLElement.setAttribute("namespace", this.nsvalue);
        }
        if (this.slvalue != null && this.slvalue.length() > 0) {
            xMLElement.setAttribute("schemaLocation", this.slvalue);
        }
        return xMLElement;
    }

    String getNamespaceValue() {
        return this.nsvalue;
    }

    String getSchemaLocationvalue() {
        return this.slvalue;
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "" && string3 == "namespace") {
            this.nsvalue = string4;
        }
        if (string == "" && string3 == "schema-location") {
            this.slvalue = string4;
        }
        super.setAttribute(string, string2, string3, string4);
    }

    @Override
    public void startContent() throws XSLException {
        super.startContent();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    void endContent() throws XSLException, XQException {
        super.endContent();
        try {
            this.schema = this.createXMLSchema();
        }
        catch (XSDException xSDException) {
            this.xss.err.error0(24000, 1);
        }
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        super.finalizeXSLNode();
    }

    void setXMLSchema(XMLSchema xMLSchema) {
        this.schema = xMLSchema;
    }

    void setEmbededSchemaDOM(XMLDocument xMLDocument) {
        this.embededom = xMLDocument;
    }

    XMLDocument getEmbededSchemaDOM() {
        return this.embededom;
    }

    private XMLSchema createXMLSchema() throws XSDException {
        if (this.schema != null) {
            return this.schema;
        }
        if (this.nsvalue != null && this.slvalue != null) {
            XSDBuilder xSDBuilder = new XSDBuilder();
            xSDBuilder.setXMLProperty("XDK_Namespace_Context", new XSDNamespaceContext(this.getPrefixHash()));
            URL uRL = null;
            try {
                if (this.entityResolver != null) {
                    this.entityResolver.resolveEntity("", this.slvalue);
                } else {
                    uRL = this.baseURL != null ? new URL(this.baseURL, this.slvalue) : new URL(this.slvalue);
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.xss.err.error0(24000, 1);
            }
            catch (IOException iOException) {
                this.xss.err.error0(24000, 1);
            }
            catch (SAXException sAXException) {
                this.xss.err.error0(24000, 1);
            }
            XMLSchema xMLSchema = xSDBuilder.build(this.nsvalue, uRL);
            return xMLSchema;
        }
        return null;
    }

    int validateImportSchemaNode() {
        String string;
        if (this.embededom != null && this.slvalue != null) {
            this.xss.err.error0(1130, 1);
            return -1;
        }
        if (this.embededom != null && this.nsvalue != null && (string = this.embededom.getNamespaceURI()) != null && !string.equals(this.nsvalue)) {
            this.xss.err.error2(1131, 1, "namespace", "xs:schema");
            return -1;
        }
        return 0;
    }
}

