/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.DB2Struct;
import COM.ibm.db2.app.DB2StructConstant;
import COM.ibm.db2.app.DereferencedNativeArray;
import COM.ibm.db2.app.NativeArray;
import COM.ibm.db2.app.TypeMapTableElement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;

public class DB2StructOutput
extends DB2Struct
implements SQLOutput {
    public DB2StructOutput(DereferencedNativeArray dereferencedNativeArray, HashMap hashMap, int n2, ClassLoader classLoader) throws SQLException {
        super(dereferencedNativeArray, hashMap, n2, classLoader);
    }

    public DB2StructOutput() {
    }

    @Override
    public void reset(DereferencedNativeArray dereferencedNativeArray, HashMap hashMap, int n2) throws SQLException {
        super.reset(dereferencedNativeArray, hashMap, n2);
    }

    @Override
    public void reset() throws SQLException {
        super.reset();
    }

    public void writeStructTypeHeader(Object object) throws SQLException {
        Object object2;
        this.nativeStructTypeBuff.putByte((byte)1, this.indexof_currStructTypeFrame + 0);
        this.nativeStructTypeBuff.putByte((byte)0, this.indexof_currStructTypeFrame + 1 + 0);
        this.nativeStructTypeBuff.putByte((byte)0, this.indexof_currStructTypeFrame + 1 + 1);
        this.nativeStructTypeBuff.putByte((byte)0, this.indexof_currStructTypeFrame + 1 + 2);
        this.nativeStructTypeBuff.putShort((short)32639, this.indexof_currStructTypeFrame + 4);
        String string = null;
        try {
            object2 = object.getClass();
            string = ((Class)object2).getName();
        }
        catch (Exception exception) {
            DB2StructOutput.error(exception.getMessage());
        }
        object2 = (TypeMapTableElement)this.typeMapTable.get(string);
        if (object2 == null) {
            DB2StructOutput.error("Can't find class name entry in the type map");
        }
        this.numAttr = ((TypeMapTableElement)object2).numAttr;
        this.nativeStructTypeBuff.putShort(this.numAttr, this.indexof_currStructTypeFrame + 6);
        this.totalLength = 32 + this.numAttr * 10;
        this.nativeStructTypeBuff.putInt(this.totalLength, this.indexof_currStructTypeFrame + 8);
        this.typeTag = ((TypeMapTableElement)object2).typeTag;
        this.nativeStructTypeBuff.putInt(this.typeTag, this.indexof_currStructTypeFrame + 12);
        this.nativeStructTypeBuff.putLong(0L, this.indexof_currStructTypeFrame + 24);
        this.nativeStructTypeBuff.putLong(0L, this.indexof_currStructTypeFrame + 16);
        super.nextAttr();
        this.indexof_currAttrData = this.totalLength;
        DB2StructConstant.print("indexof_currAttrData = " + this.indexof_currAttrData);
    }

    public static HashMap loadTypeMap(NativeArray nativeArray) throws SQLException {
        return DB2Struct.loadTypeMap(nativeArray, false);
    }

    @Override
    public void writeString(String string) throws SQLException {
        DB2StructConstant.print("Beginning writeString");
        if (string == null) {
            this.nativeStructTypeBuff.putShort((short)64, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putLong(0L, this.indexof_currStructTypeFrame + this.indexof_srp);
        } else {
            this.nativeStructTypeBuff.putShort((short)1536, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putDereferencedString(string, this.indexof_currStructTypeFrame + this.indexof_srp, this.indexof_currStructTypeFrame + this.indexof_currAttrData);
            this.indexof_currAttrData += 2 + string.length();
            this.nativeStructTypeBuff.putLong(this.indexof_currAttrData, this.indexof_currStructTypeFrame + this.indexof_totalLength);
        }
        super.nextAttr();
        DB2StructConstant.print("Ending writeString");
    }

    @Override
    public void writeBoolean(boolean bl2) throws SQLException {
        DB2StructOutput.error("DB2 does not support boolean data types !!");
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        DB2StructOutput.error("DB2 does not support DATALINK data types !!");
    }

    @Override
    public void writeByte(byte by2) throws SQLException {
        DB2StructOutput.error("DB2 does not currently support the Byte Datatype");
    }

    @Override
    public void writeShort(short s2) throws SQLException {
        DB2StructConstant.print("Beginning writeShort");
        this.nativeStructTypeBuff.putShort((short)8192, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
        this.nativeStructTypeBuff.putShort(s2, this.indexof_currStructTypeFrame + this.indexof_srp);
        super.nextAttr();
        DB2StructConstant.print("Ending writeShort");
    }

    @Override
    public void writeInt(int n2) throws SQLException {
        DB2StructConstant.print("Beginning writeInt");
        this.nativeStructTypeBuff.putShort((short)8448, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
        this.nativeStructTypeBuff.putInt(n2, this.indexof_currStructTypeFrame + this.indexof_srp);
        super.nextAttr();
        DB2StructConstant.print("Ending writeInteger");
    }

    @Override
    public void writeLong(long l8) throws SQLException {
        DB2StructConstant.print("Beginning  writeLong");
        this.nativeStructTypeBuff.putShort((short)8704, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
        this.nativeStructTypeBuff.putLong(l8, this.indexof_currStructTypeFrame + this.indexof_srp);
        super.nextAttr();
        DB2StructConstant.print("Ending  writeLong");
    }

    @Override
    public void writeFloat(float f10) throws SQLException {
        DB2StructConstant.print("Beginning  writefloat");
        this.nativeStructTypeBuff.putShort((short)8960, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
        this.nativeStructTypeBuff.putFloat(f10, this.indexof_currStructTypeFrame + this.indexof_srp);
        super.nextAttr();
        DB2StructConstant.print("Ending  writefloat");
    }

    @Override
    public void writeDouble(double d10) throws SQLException {
        DB2StructConstant.print("Beginning  writedouble");
        this.nativeStructTypeBuff.putShort((short)9216, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
        this.nativeStructTypeBuff.putDouble(d10, this.indexof_currStructTypeFrame + this.indexof_srp);
        super.nextAttr();
        DB2StructConstant.print("Ending  writedouble");
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        DB2StructConstant.print("Beginning writeDecimal");
        if (bigDecimal == null) {
            this.nativeStructTypeBuff.putShort((short)64, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putLong(0L, this.indexof_currStructTypeFrame + this.indexof_srp);
        } else {
            this.nativeStructTypeBuff.putShort((short)0, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putBigDecimal(bigDecimal, this.indexof_currStructTypeFrame + this.indexof_srp);
        }
        super.nextAttr();
        DB2StructConstant.print("Ending writeDecimal");
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        DB2StructOutput.error("DB2 does not currently support Time data types");
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        if (date == null) {
            this.nativeStructTypeBuff.putShort((short)64, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putLong(0L, this.indexof_currStructTypeFrame + this.indexof_srp);
        } else {
            this.nativeStructTypeBuff.putShort((short)9728, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putDate(date, this.indexof_currStructTypeFrame + this.indexof_srp);
        }
        super.nextAttr();
        DB2StructConstant.print("Ending writeDate");
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        if (time == null) {
            this.nativeStructTypeBuff.putShort((short)64, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putLong(0L, this.indexof_currStructTypeFrame + this.indexof_srp);
        } else {
            this.nativeStructTypeBuff.putShort((short)9984, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putTime(time, this.indexof_currStructTypeFrame + this.indexof_srp);
        }
        super.nextAttr();
        DB2StructConstant.print("Ending writeTime");
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.nativeStructTypeBuff.putShort((short)64, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putLong(0L, this.indexof_currStructTypeFrame + this.indexof_srp);
        } else {
            this.nativeStructTypeBuff.putShort((short)768, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putTimestamp(timestamp, this.indexof_currStructTypeFrame + this.indexof_srp);
        }
        super.nextAttr();
        DB2StructConstant.print("Ending writeTimeStamp");
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        DB2StructOutput.error("DB2 does not currently support CharacterStream data types");
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        DB2StructOutput.error("DB2 does not currently support AsciiStream data types");
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        DB2StructOutput.error("DB2 does not currently support BinaryStream data types");
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        DB2StructConstant.print("Beginning writeObject");
        if (!this.isStructTypeHeaderProcessed) {
            this.isStructTypeHeaderProcessed = true;
            this.writeStructTypeHeader(sQLData);
            sQLData.writeSQL(this);
            super.nextAttr();
        } else {
            this.nativeStructTypeBuff.putShort((short)4096, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putLong(this.indexof_currAttrData - this.indexof_srp, this.indexof_currStructTypeFrame + this.indexof_srp);
            DB2StructOutput dB2StructOutput = new DB2StructOutput(this.nativeStructTypeBuff, this.typeMapTable, this.indexof_currStructTypeFrame + this.indexof_currAttrData, this.classLoader);
            dB2StructOutput.writeObject(sQLData);
            this.nativeStructTypeBuff.putInt(this.totalLength += dB2StructOutput.totalLength, this.indexof_currStructTypeFrame + 8);
            this.indexof_currAttrData += dB2StructOutput.totalLength;
            super.nextAttr();
        }
        DB2StructConstant.print("Ending writeObject");
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        DB2StructOutput.error("DB2 does not currently support Ref data types");
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        DB2StructConstant.print("Beginning writeBlob");
        if (blob == null) {
            this.nativeStructTypeBuff.putShort((short)64, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putLong(0L, this.indexof_currStructTypeFrame + this.indexof_srp);
        } else {
            this.nativeStructTypeBuff.putShort((short)12544, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putDereferencedBlob(blob, this.indexof_currStructTypeFrame + this.indexof_srp, this.indexof_currStructTypeFrame + this.indexof_currAttrData);
            this.indexof_currAttrData = (int)((long)this.indexof_currAttrData + (8L + blob.length()));
            this.nativeStructTypeBuff.putLong(this.indexof_currAttrData, this.indexof_currStructTypeFrame + this.indexof_totalLength);
        }
        super.nextAttr();
        DB2StructConstant.print("Ending writeBlob");
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        DB2StructConstant.print("Beginning writeClob");
        if (clob == null) {
            this.nativeStructTypeBuff.putShort((short)64, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putLong(0L, this.indexof_currStructTypeFrame + this.indexof_srp);
        } else {
            this.nativeStructTypeBuff.putShort((short)12288, this.indexof_currStructTypeFrame + this.indexof_metaFlag);
            this.nativeStructTypeBuff.putDereferencedClob(clob, this.indexof_currStructTypeFrame + this.indexof_srp, this.indexof_currStructTypeFrame + this.indexof_currAttrData);
            this.indexof_currAttrData = (int)((long)this.indexof_currAttrData + (8L + clob.length()));
            this.nativeStructTypeBuff.putLong(this.indexof_currAttrData, this.indexof_currStructTypeFrame + this.indexof_totalLength);
        }
        super.nextAttr();
        DB2StructConstant.print("Ending writeclob");
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        DB2StructOutput.error("DB2 does not currently support Struct data types");
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        DB2StructOutput.error("DB2 does not currently support Array data types");
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        DB2StructOutput.error("writeNClob not supported");
    }

    @Override
    public void writeNString(String string) throws SQLException {
        DB2StructOutput.error("writeNString not supported");
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        DB2StructOutput.error("writeRowId not supported");
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        DB2StructOutput.error("writeSQLXML not supported");
    }
}

