/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.jydocking;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.swing.JYButtonIcon;
import de.javasoft.swing.plaf.jydocking.DockingButton;
import de.javasoft.swing.plaf.jydocking.DockingViewTitlebar;
import de.javasoft.swing.plaf.jydocking.IDockingButtonFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.synth.SynthContext;

public class DockingButtonFactory
implements IDockingButtonFactory,
SwingConstants {
    private Icon minimizeIcon;
    private Icon minimizeIconActive;
    private Icon maximizeIcon;
    private Icon maximizeIconActive;
    private Icon floatIcon;
    private Icon floatIconActive;
    private Icon closeIcon;
    private Icon closeIconActive;

    public DockingButton createMinimizeButton(Action action) {
        DockingButton dockingButton = new DockingButton(action){

            public Icon getIcon() {
                if (this.getParent() instanceof DockingViewTitlebar) {
                    return ((DockingViewTitlebar)this.getParent()).isActive() ? DockingButtonFactory.this.minimizeIconActive : DockingButtonFactory.this.minimizeIcon;
                }
                return DockingButtonFactory.this.minimizeIcon;
            }

            public void updateUI() {
                super.updateUI();
                DockingButtonFactory.this.setMinimizeButtonDefaults(this);
            }
        };
        dockingButton.setName("JYDocking.titlebar.MinimizeButton");
        this.setMinimizeButtonDefaults(dockingButton);
        return dockingButton;
    }

    private void setMinimizeButtonDefaults(DockingButton dockingButton) {
        this.minimizeIcon = this.createMinimizeIcon(dockingButton, false);
        this.minimizeIconActive = this.createMinimizeIcon(dockingButton, true);
        Insets insets = SyntheticaLookAndFeel.getInsets("JYDocking.titlebar.minimizeButton.insets", dockingButton);
        if (insets != null) {
            dockingButton.setBorder(new EmptyBorder(insets));
        }
    }

    private Icon createMinimizeIcon(DockingButton dockingButton, final boolean bl) {
        String string = "JYDocking.titlebar." + (bl ? "active." : "") + "minimizeButton.icon";
        return new JYButtonIcon(dockingButton, string, 16, 16){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                graphics2D.setPaint(DockingButtonFactory.this.getPaintColor(syntheticaState, false));
                GeneralPath generalPath = new GeneralPath();
                if (!syntheticaState.isSet(SyntheticaState.State.SELECTED)) {
                    generalPath.moveTo(3.0f, 10.0f);
                    generalPath.lineTo(11.0f, 10.0f);
                    generalPath.moveTo(3.0f, 11.0f);
                    generalPath.lineTo(11.0f, 11.0f);
                } else {
                    generalPath.moveTo(3.0f, 3.0f);
                    generalPath.lineTo(11.0f, 3.0f);
                    generalPath.moveTo(3.0f, 4.0f);
                    generalPath.lineTo(11.0f, 4.0f);
                    generalPath.lineTo(11.0f, 11.0f);
                    generalPath.lineTo(3.0f, 11.0f);
                    generalPath.lineTo(3.0f, 4.0f);
                    generalPath.moveTo(7.0f, 4.0f);
                    generalPath.lineTo(7.0f, 11.0f);
                    generalPath.moveTo(7.0f, 7.0f);
                    generalPath.lineTo(11.0f, 7.0f);
                }
                graphics2D.draw(generalPath);
            }

            public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
                int n4 = super.getCacheHash(synthContext, n, n2, n3, string);
                n4 = 31 * n4 + (bl ? 0 : 1);
                return n4;
            }
        };
    }

    public DockingButton createMaximizeButton(Action action) {
        DockingButton dockingButton = new DockingButton(action){

            public Icon getIcon() {
                if (this.getParent() instanceof DockingViewTitlebar) {
                    return ((DockingViewTitlebar)this.getParent()).isActive() ? DockingButtonFactory.this.maximizeIconActive : DockingButtonFactory.this.maximizeIcon;
                }
                return DockingButtonFactory.this.maximizeIcon;
            }

            public void updateUI() {
                super.updateUI();
                DockingButtonFactory.this.setMaximizeButtonDefaults(this);
            }
        };
        dockingButton.setName("JYDocking.titlebar.MaximizeButton");
        this.setMaximizeButtonDefaults(dockingButton);
        return dockingButton;
    }

    private void setMaximizeButtonDefaults(DockingButton dockingButton) {
        this.maximizeIcon = this.createMaximizeIcon(dockingButton, false);
        this.maximizeIconActive = this.createMaximizeIcon(dockingButton, true);
        Insets insets = SyntheticaLookAndFeel.getInsets("JYDocking.titlebar.maximizeButton.insets", dockingButton);
        if (insets != null) {
            dockingButton.setBorder(new EmptyBorder(insets));
        }
    }

    private Icon createMaximizeIcon(DockingButton dockingButton, final boolean bl) {
        String string = "JYDocking.titlebar." + (bl ? "active." : "") + "maximizeButton.icon";
        return new JYButtonIcon(dockingButton, string, 16, 16){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                graphics2D.setPaint(DockingButtonFactory.this.getPaintColor(syntheticaState, false));
                GeneralPath generalPath = new GeneralPath();
                if (!syntheticaState.isSet(SyntheticaState.State.SELECTED)) {
                    generalPath.moveTo(3.0f, 3.0f);
                    generalPath.lineTo(11.0f, 3.0f);
                    generalPath.moveTo(3.0f, 4.0f);
                    generalPath.lineTo(11.0f, 4.0f);
                    generalPath.lineTo(11.0f, 11.0f);
                    generalPath.lineTo(3.0f, 11.0f);
                    generalPath.lineTo(3.0f, 4.0f);
                } else {
                    generalPath.moveTo(3.0f, 3.0f);
                    generalPath.lineTo(11.0f, 3.0f);
                    generalPath.moveTo(3.0f, 4.0f);
                    generalPath.lineTo(11.0f, 4.0f);
                    generalPath.lineTo(11.0f, 11.0f);
                    generalPath.lineTo(3.0f, 11.0f);
                    generalPath.lineTo(3.0f, 4.0f);
                    generalPath.moveTo(7.0f, 4.0f);
                    generalPath.lineTo(7.0f, 11.0f);
                    generalPath.moveTo(7.0f, 7.0f);
                    generalPath.lineTo(11.0f, 7.0f);
                }
                graphics2D.draw(generalPath);
            }

            public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
                int n4 = super.getCacheHash(synthContext, n, n2, n3, string);
                n4 = 31 * n4 + (bl ? 0 : 1);
                return n4;
            }
        };
    }

    public DockingButton createFloatButton(Action action) {
        DockingButton dockingButton = new DockingButton(action){

            public Icon getIcon() {
                if (this.getParent() instanceof DockingViewTitlebar) {
                    return ((DockingViewTitlebar)this.getParent()).isActive() ? DockingButtonFactory.this.floatIconActive : DockingButtonFactory.this.floatIcon;
                }
                return DockingButtonFactory.this.floatIcon;
            }

            public void updateUI() {
                super.updateUI();
                DockingButtonFactory.this.setFloatButtonDefaults(this);
            }
        };
        dockingButton.setName("JYDocking.titlebar.FloatButton");
        this.setFloatButtonDefaults(dockingButton);
        return dockingButton;
    }

    private void setFloatButtonDefaults(DockingButton dockingButton) {
        this.floatIcon = this.createFloatIcon(dockingButton, false);
        this.floatIconActive = this.createFloatIcon(dockingButton, true);
        Insets insets = SyntheticaLookAndFeel.getInsets("JYDocking.titlebar.floatButton.insets", dockingButton);
        if (insets != null) {
            dockingButton.setBorder(new EmptyBorder(insets));
        }
    }

    private Icon createFloatIcon(DockingButton dockingButton, final boolean bl) {
        String string = "JYDocking.titlebar." + (bl ? "active." : "") + "floatButton.icon";
        return new JYButtonIcon(dockingButton, string, 16, 16){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                graphics2D.setPaint(DockingButtonFactory.this.getPaintColor(syntheticaState, false));
                GeneralPath generalPath = new GeneralPath();
                if (!syntheticaState.isSet(SyntheticaState.State.SELECTED)) {
                    generalPath.moveTo(4.0f, 3.0f);
                    generalPath.lineTo(9.0f, 3.0f);
                    generalPath.lineTo(9.0f, 8.0f);
                    generalPath.lineTo(4.0f, 3.0f);
                } else {
                    generalPath.moveTo(5.0f, 11.0f);
                    generalPath.lineTo(5.0f, 6.0f);
                    generalPath.lineTo(10.0f, 11.0f);
                    generalPath.lineTo(5.0f, 11.0f);
                }
                graphics2D.draw(generalPath);
                graphics2D.fill(generalPath);
            }

            public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
                int n4 = super.getCacheHash(synthContext, n, n2, n3, string);
                n4 = 31 * n4 + (bl ? 0 : 1);
                return n4;
            }
        };
    }

    public DockingButton createCloseButton(Action action) {
        DockingButton dockingButton = new DockingButton(action){

            public Icon getIcon() {
                if (this.getParent() instanceof DockingViewTitlebar) {
                    return ((DockingViewTitlebar)this.getParent()).isActive() ? DockingButtonFactory.this.closeIconActive : DockingButtonFactory.this.closeIcon;
                }
                return DockingButtonFactory.this.closeIcon;
            }

            public void updateUI() {
                super.updateUI();
                DockingButtonFactory.this.setCloseButtonDefaults(this);
            }
        };
        dockingButton.setName("JYDocking.titlebar.CloseButton");
        this.setCloseButtonDefaults(dockingButton);
        return dockingButton;
    }

    private void setCloseButtonDefaults(DockingButton dockingButton) {
        this.closeIcon = this.createCloseIcon(dockingButton, false);
        this.closeIconActive = this.createCloseIcon(dockingButton, true);
        Insets insets = SyntheticaLookAndFeel.getInsets("JYDocking.titlebar.closeButton.insets", dockingButton);
        if (insets != null) {
            dockingButton.setBorder(new EmptyBorder(insets));
        }
    }

    private Icon createCloseIcon(DockingButton dockingButton, final boolean bl) {
        String string = "JYDocking.titlebar." + (bl ? "active." : "") + "closeButton.icon";
        return new JYButtonIcon(dockingButton, string, 16, 16){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                graphics2D.setPaint(DockingButtonFactory.this.getPaintColor(syntheticaState, true));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(4.0f, 3.0f);
                generalPath.lineTo(11.0f, 11.0f);
                generalPath.moveTo(5.0f, 3.0f);
                generalPath.lineTo(12.0f, 11.0f);
                generalPath.moveTo(11.0f, 3.0f);
                generalPath.lineTo(4.0f, 11.0f);
                generalPath.moveTo(12.0f, 3.0f);
                generalPath.lineTo(5.0f, 11.0f);
                graphics2D.draw(generalPath);
            }

            public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
                int n4 = super.getCacheHash(synthContext, n, n2, n3, string);
                n4 = 31 * n4 + (bl ? 0 : 1);
                return n4;
            }
        };
    }

    private Color getPaintColor(SyntheticaState syntheticaState, boolean bl) {
        Color color = new Color(0x505050);
        if (syntheticaState.isSet(SyntheticaState.State.DISABLED)) {
            color = new Color(0xAAAAAA);
        } else if (!syntheticaState.isSet(SyntheticaState.State.PRESSED) && syntheticaState.isSet(SyntheticaState.State.HOVER)) {
            color = bl ? new Color(0xE00000) : new Color(0x888888);
        }
        return color;
    }
}

