/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.DateTimeColumn;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.exaTimestamp;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimestampColumn
extends DateTimeColumn {
    private exaTimestamp[] values;
    private int precision = 0;

    TimestampColumn(String string, exaTimestamp[] exaTimestampArray) {
        super(string);
        this.values = exaTimestampArray;
    }

    TimestampColumn() {
        this.values = new exaTimestamp[initialBatchCapacity];
    }

    @Override
    void resize(int n) {
        int n2;
        exaTimestamp[] exaTimestampArray = new exaTimestamp[n];
        boolean[] blArray = new boolean[n];
        int n3 = this.values.length;
        if (n3 > n) {
            n3 = n;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            exaTimestampArray[n2] = this.values[n2];
            blArray[n2] = this.validMask[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            blArray[n2] = false;
        }
        this.values = exaTimestampArray;
        this.validMask = blArray;
    }

    @Override
    int getPrecision() throws SQLException {
        return this.precision;
    }

    @Override
    void setPrecision(int n) throws SQLException {
        this.precision = n;
    }

    @Override
    void setScale(int n) throws SQLException {
        throw new SQLException("Not implemented for TimestampColumn - setScale()");
    }

    @Override
    String getClassName() throws SQLException {
        return "java.sql.TimeStamp";
    }

    @Override
    int getDisplaySize(EXAConnection eXAConnection) throws SQLException {
        if (eXAConnection != null) {
            String string = eXAConnection.getTimestampFormat();
            return EXAConnection.getTimestampFormatWidth(string);
        }
        return 23;
    }

    @Override
    int getType() throws SQLException {
        return 93;
    }

    @Override
    String getTypeName() throws SQLException {
        return "TIMESTAMP";
    }

    @Override
    Object getObject(int n) throws SQLException {
        return this.getTimestamp(n);
    }

    @Override
    Date getDate(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("TimestampColumn::getDate: " + Translator.Accessed_null_value());
        }
        return this.dateFromCalendar(this.values[n], this.defCal);
    }

    @Override
    Date getDate(int n, Calendar calendar) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("TimestampColumn::getDate: " + Translator.Accessed_null_value());
        }
        return this.dateFromCalendar(this.values[n], calendar);
    }

    @Override
    long getLong(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("TimestampColumn::getLong: " + Translator.Accessed_null_value());
        }
        return this.values[n].getTimestamp(this.defCal).getTime();
    }

    @Override
    Time getTime(int n, Calendar calendar) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("TimestampColumn::getTime: " + Translator.Accessed_null_value());
        }
        return this.timeFromCalendar(this.values[n], calendar);
    }

    @Override
    Time getTime(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("TimestampColumn::getTime: " + Translator.Accessed_null_value());
        }
        return this.timeFromCalendar(this.values[n], this.defCal);
    }

    @Override
    Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("TimestampColumn::getTimestamp: " + Translator.Accessed_null_value());
        }
        return this.timestampFromCalendar(this.values[n], calendar);
    }

    @Override
    Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, this.defCal);
    }

    @Override
    void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.values[n] = this.exaTimestampFromCalendar(date.getTime(), calendar);
        this.validMask[n] = true;
    }

    @Override
    void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, this.defCal);
    }

    @Override
    void setLong(int n, long l) throws SQLException {
        this.values[n] = this.exaTimestampFromCalendar(l, this.defCal);
        this.validMask[n] = true;
    }

    @Override
    void setObject(int n, Object object) throws SQLException {
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else {
            super.setObject(n, object);
        }
    }

    @Override
    String getString(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        String string = this.values[n].getTimestamp(this.defCal).toString();
        for (int i = string.length(); i < 26; ++i) {
            string = string + "0";
        }
        return string;
    }

    @Override
    void setString(int n, String string) throws SQLException {
        this.values[n] = this.exaTimestampFromCalendar(Timestamp.valueOf(string).getTime(), this.defCal);
        this.validMask[n] = true;
    }

    @Override
    void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.values[n] = this.exaTimestampFromCalendar(time.getTime(), calendar);
        this.validMask[n] = true;
    }

    @Override
    void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, this.defCal);
    }

    @Override
    void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.values[n] = this.exaTimestampFromCalendar(timestamp.getTime(), calendar);
        this.values[n].setNanos(timestamp.getNanos());
        this.validMask[n] = true;
    }

    @Override
    void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, this.defCal);
    }

    static Column from_jdbc_type(EXAInputStream eXAInputStream) {
        return new TimestampColumn();
    }

    @Override
    void value_to_jdbc(EXAOutputStream eXAOutputStream, int n) throws SQLException, IOException {
        if (this.validMask[n]) {
            eXAOutputStream.writeByte((byte)1);
            eXAOutputStream.writeTimestamp(this.values[n]);
        } else {
            eXAOutputStream.writeByte((byte)0);
        }
    }

    @Override
    void value_from_jdbc(EXAInputStream eXAInputStream, int n) throws SQLException, IOException {
        if (eXAInputStream.nextIsNull()) {
            this.validMask[n] = false;
        } else {
            this.values[n] = eXAInputStream.readTimestamp();
            this.validMask[n] = true;
        }
    }

    @Override
    int getEXAType() {
        return 21;
    }
}

