/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;

class AnimationThreadFactory {
    static final int DISABLED_TYPE = -1;
    static final int DEFAULT_TYPE = 0;
    static final int HOVER_IN_TYPE = 1;
    static final int HOVER_OUT_TYPE = 2;
    static final int FOCUSED_TYPE = 3;
    static final int DISPOSABLE_TYPE = 4;
    static final int ACTIVE_TYPE = 5;
    static final int INACTIVE_TYPE = 6;
    private static HashMap<Integer, AnimationThread> threads = new HashMap();
    private static AnimationThreadFactory instance = new AnimationThreadFactory();

    private AnimationThreadFactory() {
    }

    public static AnimationThread createThread(int n) {
        if (threads.containsKey(n)) {
            return threads.get(n);
        }
        return instance.newThread(n);
    }

    private AnimationThread newThread(int n) {
        AnimationThread animationThread = new AnimationThread(n);
        threads.put(n, animationThread);
        animationThread.setDaemon(true);
        animationThread.start();
        return animationThread;
    }

    static class AnimationThread
    extends Thread {
        private int delay = 0;
        private HashMap<ComponentKey, ComponentAnimation> componentAnimations = new HashMap();
        private ReferenceQueue<JComponent> queue = new ReferenceQueue();

        public AnimationThread(int n) {
            this.delay = n;
            this.setPriority(7);
            this.setName("SyntheticaAnimation " + n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    AnimationThread.sleep(this.delay);
                    HashMap<ComponentKey, ComponentAnimation> hashMap = null;
                    HashMap<ComponentKey, ComponentAnimation> hashMap2 = this.componentAnimations;
                    synchronized (hashMap2) {
                        Object object = this.queue.poll();
                        while (object != null) {
                            this.componentAnimations.remove(((WeakComponent)object).key);
                            object = this.queue.poll();
                        }
                        hashMap = new HashMap<ComponentKey, ComponentAnimation>(this.componentAnimations);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        JComponent jComponent = (JComponent)((ComponentKey)entry.getKey()).wc.get();
                        if (jComponent == null) continue;
                        ComponentAnimation componentAnimation = (ComponentAnimation)entry.getValue();
                        if (jComponent == null || componentAnimation == null) continue;
                        Component component = null;
                        if (jComponent instanceof JScrollPane) {
                            component = ((JScrollPane)jComponent).getViewport().getView();
                        }
                        boolean bl = false;
                        Rectangle rectangle = null;
                        ComponentAnimation componentAnimation2 = componentAnimation;
                        synchronized (componentAnimation2) {
                            boolean bl2 = (componentAnimation.state & 2) > 0;
                            boolean bl3 = jComponent.hasFocus();
                            rectangle = componentAnimation.repaintRect;
                            switch (componentAnimation.type) {
                                case 4: 
                                case 5: 
                                case 6: {
                                    if (!componentAnimation.next()) break;
                                    bl = true;
                                    break;
                                }
                                case 1: {
                                    if (componentAnimation.state != -1 && bl2 && componentAnimation.next()) {
                                        bl = true;
                                        break;
                                    }
                                    if (componentAnimation.state == -1 || bl2) break;
                                    componentAnimation.reset();
                                    break;
                                }
                                case 2: {
                                    if (componentAnimation.state != -1 && !bl2 && componentAnimation.next()) {
                                        bl = true;
                                        break;
                                    }
                                    if (componentAnimation.state == -1 || !bl2) break;
                                    componentAnimation.reset();
                                    break;
                                }
                                case 3: {
                                    Component component2;
                                    if (jComponent instanceof JComboBox && ((JComboBox)jComponent).isEditable() && ((JComboBox)jComponent).getEditor() != null) {
                                        component2 = ((JComboBox)jComponent).getEditor().getEditorComponent();
                                        if (component2 != null) {
                                            bl3 = component2.hasFocus();
                                        }
                                    } else if (jComponent instanceof JSpinner) {
                                        component2 = SyntheticaLookAndFeel.findComponent("Spinner.formattedTextField", (Container)jComponent);
                                        if (component2 != null) {
                                            bl3 = component2.hasFocus();
                                        }
                                    } else if (jComponent instanceof JScrollPane) {
                                        component2 = (JScrollPane)jComponent;
                                        if (component != null) {
                                            bl3 = component.hasFocus();
                                        }
                                        int n = SyntheticaLookAndFeel.getInt("Synthetica.focus.scrollPane.animation.maxWidth", component2, 400);
                                        int n2 = SyntheticaLookAndFeel.getInt("Synthetica.focus.scrollPane.animation.maxHeight", component2, 200);
                                        if (((JComponent)component2).getWidth() > n || ((JComponent)component2).getHeight() > n2) break;
                                    }
                                    if (componentAnimation.next() && bl3 && this.isActive(jComponent)) {
                                        bl = true;
                                        break;
                                    }
                                    if (bl3) break;
                                    componentAnimation.reset();
                                    break;
                                }
                                default: {
                                    if (!componentAnimation.next() || !this.isActive(jComponent)) break;
                                    bl = true;
                                }
                            }
                        }
                        if (!bl) continue;
                        this.repaint(jComponent, rectangle);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
            }
        }

        private void repaint(JComponent jComponent, Rectangle rectangle) {
            if (rectangle == null) {
                jComponent.repaint();
            } else {
                jComponent.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        private boolean isActive(JComponent jComponent) {
            Container container = jComponent.getTopLevelAncestor();
            if (container instanceof Window && !"###focusableSwingPopup###".equals(container.getName())) {
                return ((Window)container).isActive();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComponent(JComponent jComponent, String string, int n, int n2, String[] stringArray, int n3, Rectangle rectangle) {
            boolean bl = (n & 2) > 0;
            ComponentKey componentKey = new ComponentKey(jComponent, string);
            if (this.componentAnimations.containsKey(componentKey)) {
                ComponentAnimation componentAnimation = this.componentAnimations.get(componentKey);
                componentAnimation.repaintRect = rectangle;
                if (componentAnimation.type != n2 || !Arrays.toString(stringArray).equals(Arrays.toString(componentAnimation.imagePaths))) {
                    componentAnimation.type = n2;
                    componentAnimation.imagePaths = stringArray;
                    componentAnimation.cyles = n3;
                    componentAnimation.reset();
                }
                if (componentAnimation.state != -1 || bl) {
                    componentAnimation.state = n;
                }
                return;
            }
            componentKey.setComponent(jComponent);
            ComponentAnimation componentAnimation = new ComponentAnimation();
            componentAnimation.imagePaths = stringArray;
            componentAnimation.cyles = n3;
            componentAnimation.repaintRect = rectangle;
            componentAnimation.type = n2;
            if (bl) {
                componentAnimation.state = n;
            } else if (n2 == 6) {
                componentAnimation.cylesDone = n3;
            }
            HashMap<ComponentKey, ComponentAnimation> hashMap = this.componentAnimations;
            synchronized (hashMap) {
                this.componentAnimations.put(componentKey, componentAnimation);
            }
        }

        void rotateRepaintRect(JComponent jComponent, String string) {
            ComponentKey componentKey = new ComponentKey(jComponent, string);
            ComponentAnimation componentAnimation = this.componentAnimations.get(componentKey);
            if (componentAnimation != null) {
                int n = ((ComponentAnimation)componentAnimation).repaintRect.height;
                ((ComponentAnimation)componentAnimation).repaintRect.height = ((ComponentAnimation)componentAnimation).repaintRect.width;
                ((ComponentAnimation)componentAnimation).repaintRect.width = n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getImagePath(JComponent jComponent, String string) {
            ComponentAnimation componentAnimation = this.componentAnimations.get(new ComponentKey(jComponent, string));
            String string2 = null;
            ComponentAnimation componentAnimation2 = componentAnimation;
            synchronized (componentAnimation2) {
                string2 = componentAnimation.type == 2 && (componentAnimation.state == -1 || componentAnimation.isComplete()) ? componentAnimation.imagePaths[componentAnimation.imagePaths.length - 1] : (componentAnimation.type == 6 && componentAnimation.isComplete() ? componentAnimation.imagePaths[componentAnimation.imagePaths.length - 1] : componentAnimation.imagePaths[componentAnimation.index]);
            }
            return string2;
        }

        private static class ComponentAnimation {
            private int state = -1;
            private int type = 0;
            private int index = 0;
            private String[] imagePaths;
            private Rectangle repaintRect;
            private long cyles = 0L;
            private long cylesDone = 0L;

            private ComponentAnimation() {
            }

            boolean next() {
                if (this.cyles == 0L || this.cylesDone == this.cyles || this.imagePaths.length == 1) {
                    return false;
                }
                ++this.index;
                if (this.index == this.imagePaths.length - 1) {
                    ++this.cylesDone;
                } else if (this.index == this.imagePaths.length) {
                    this.index = 0;
                }
                return true;
            }

            void reset() {
                this.index = 0;
                this.cylesDone = 0L;
            }

            boolean isComplete() {
                return this.cyles == this.cylesDone;
            }
        }

        private class ComponentKey {
            private int hashCode;
            private WeakComponent wc;

            ComponentKey(JComponent jComponent, String string) {
                this.hashCode = jComponent.hashCode() * 31 + string.hashCode();
            }

            void setComponent(JComponent jComponent) {
                this.wc = new WeakComponent(jComponent, this);
            }

            public boolean equals(Object object) {
                ComponentKey componentKey = (ComponentKey)object;
                return componentKey.hashCode == this.hashCode;
            }

            public int hashCode() {
                return this.hashCode;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class WeakComponent
        extends WeakReference<JComponent> {
            private ComponentKey key;

            public WeakComponent(JComponent jComponent, ComponentKey componentKey) {
                super(jComponent, AnimationThread.this.queue);
                this.key = componentKey;
            }
        }
    }
}

