/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aebuilder.relation;

import com.amazon.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.amazon.sqlengine.aeprocessor.aebuilder.bool.AEBooleanExprBuilder;
import com.amazon.sqlengine.aeprocessor.aebuilder.bool.AEBooleanExprOuterRefProcessor;
import com.amazon.sqlengine.aeprocessor.aebuilder.bool.AEBooleanExprProcessor;
import com.amazon.sqlengine.aeprocessor.aebuilder.bool.AEWhereConditionBuilder;
import com.amazon.sqlengine.aeprocessor.aebuilder.relation.AESortBuilder;
import com.amazon.sqlengine.aeprocessor.aebuilder.relation.AETableRefListBuilder;
import com.amazon.sqlengine.aeprocessor.aebuilder.value.AEGroupByListBuilder;
import com.amazon.sqlengine.aeprocessor.aebuilder.value.AESelectListBuilder;
import com.amazon.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.amazon.sqlengine.aeprocessor.aebuilder.value.AEValueExprComposer;
import com.amazon.sqlengine.aeprocessor.aebuilder.value.AEValueExprOuterRefProcessor;
import com.amazon.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.AESortSpec;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEDistinct;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESort;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETop;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.amazon.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AERename;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.parser.parsetree.IPTNode;
import com.amazon.sqlengine.parser.parsetree.PTFlagNode;
import com.amazon.sqlengine.parser.parsetree.PTListNode;
import com.amazon.sqlengine.parser.parsetree.PTNonterminalNode;
import com.amazon.sqlengine.parser.type.PTFlagType;
import com.amazon.sqlengine.parser.type.PTListType;
import com.amazon.sqlengine.parser.type.PTNonterminalType;
import com.amazon.sqlengine.parser.type.PTPositionalType;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.DiagState;
import com.amazon.support.exceptions.ErrorException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AEQuerySpecBuilder
extends AEBuilderBase<AERelationalExpr> {
    private static final String EXPR_COL_NAME = "EXPR_";
    private AEValueExprList m_groupByExprList = null;
    private AEBooleanExpr m_havingExpr = null;
    private Map<Integer, Integer> m_groupingListOrdinalReferenceMap;
    private AEValueExprList m_selectList;
    private int m_numSelectedCols = -1;
    private boolean m_hasAggregate;
    private AEAggregate m_aggregate;

    protected AEQuerySpecBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
    }

    @Override
    public AERelationalExpr visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        IPTNode iPTNode;
        if (pTNonterminalNode.getNonterminalType() != PTNonterminalType.SELECT_STATEMENT) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.TABLE_REF_LIST);
        AERelationalExpr aERelationalExpr = this.processFrom(iPTNode2);
        IPTNode iPTNode3 = pTNonterminalNode.getChild(PTPositionalType.WHERE);
        aERelationalExpr = this.processWhere(aERelationalExpr, iPTNode3);
        IPTNode iPTNode4 = pTNonterminalNode.getChild(PTPositionalType.GROUP_BY);
        IPTNode iPTNode5 = pTNonterminalNode.getChild(PTPositionalType.SELECT_LIST);
        AEBuilderCheck.checkThat(iPTNode5, AEBuilderCheck.list(PTListType.SELECT_LIST));
        this.processGroupBy(aERelationalExpr, iPTNode4, (PTListNode)iPTNode5);
        IPTNode iPTNode6 = pTNonterminalNode.getChild(PTPositionalType.HAVING);
        if (iPTNode6 != null && !iPTNode6.isEmptyNode()) {
            this.processHaving(iPTNode6);
        }
        if (null != (iPTNode = pTNonterminalNode.getChild(PTPositionalType.SET_QUANTIFIER)) && !iPTNode.isEmptyNode()) {
            if (!(iPTNode instanceof PTFlagNode)) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            if (PTFlagType.DISTINCT == ((PTFlagNode)iPTNode).getFlagType()) {
                this.getQueryScope().setHasDistinct(true);
            }
        }
        aERelationalExpr = this.processSelectList(aERelationalExpr, iPTNode5);
        AEProject aEProject = this.createProject(aERelationalExpr);
        aERelationalExpr = this.processOrderBy(aEProject);
        this.composeAggregatesInSelList();
        this.nameUnnamedExpressions(aEProject);
        if (this.getQueryScope().hasDistinct()) {
            aERelationalExpr = new AEDistinct(aERelationalExpr);
        }
        aERelationalExpr = this.processSelectLimit(aERelationalExpr, pTNonterminalNode.getChild(PTPositionalType.SELECT_LIMIT));
        return aERelationalExpr;
    }

    private void nameUnnamedExpressions(AEProject aEProject) throws ErrorException {
        AEValueExprList aEValueExprList = aEProject.getProjectionList();
        Iterator iterator = aEValueExprList.getChildItr();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            AEValueExpr aEValueExpr = (AEValueExpr)iterator.next();
            if (aEValueExpr.isUnnamed()) continue;
            hashSet.add(aEValueExpr.getName().toUpperCase());
        }
        if (0 > this.m_numSelectedCols) {
            this.m_numSelectedCols = aEValueExprList.getNumChildren();
        }
        iterator = aEValueExprList.getChildItr();
        int n = 0;
        for (int i = 0; i < this.m_numSelectedCols; ++i) {
            AEValueExpr aEValueExpr = (AEValueExpr)iterator.next();
            if (!aEValueExpr.isUnnamed()) continue;
            String string = EXPR_COL_NAME + n;
            while (hashSet.contains(string)) {
                string = EXPR_COL_NAME + ++n;
            }
            ++n;
            AERename aERename = new AERename(string, aEValueExpr);
            aEValueExprList.replaceNode(aERename, i);
        }
    }

    private AEProject createProject(AERelationalExpr aERelationalExpr) {
        if (this.m_hasAggregate) {
            AEAggregate aEAggregate;
            this.m_aggregate = aEAggregate = new AEAggregate(aERelationalExpr, this.m_groupByExprList, this.m_groupingListOrdinalReferenceMap, this.getQueryScope().getAggregateList(), this.getQueryScope());
            aERelationalExpr = this.m_havingExpr != null ? new AESelect(aEAggregate, this.m_havingExpr) : aEAggregate;
        }
        return new AEProject(this.m_selectList, aERelationalExpr);
    }

    private void updateProxyColumns(AERelationalExpr aERelationalExpr) {
        for (AEProxyColumn aEProxyColumn : this.getQueryScope().getProxyColumns()) {
            assert (aEProxyColumn.getResolvedQueryScope() == this.getQueryScope());
            aEProxyColumn.setRelationalExpr(aERelationalExpr);
        }
    }

    private AERelationalExpr processSelectList(AERelationalExpr aERelationalExpr, IPTNode iPTNode) throws ErrorException {
        AEQueryScope aEQueryScope = this.getQueryScope();
        aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.SELECT_LIST);
        this.m_selectList = (AEValueExprList)new AESelectListBuilder(aEQueryScope).build(iPTNode);
        this.m_hasAggregate = !this.getQueryScope().hasAggregate() ? this.checkAggrFnInSelectList() : true;
        aEQueryScope.setSelectItemCount(this.m_selectList.getNumChildren());
        return aERelationalExpr;
    }

    private void composeAggregatesInSelList() throws ErrorException {
        if (!this.getQueryScope().isTopMost()) {
            AEValueExprOuterRefProcessor.process(this.m_selectList, this.getQueryScope());
        }
        if (this.getQueryScope().hasAggregate() || this.m_hasAggregate) {
            AEValueExprComposer.compose(this.m_selectList, this.getQueryScope());
            if (null != this.m_aggregate) {
                this.updateProxyColumns(this.m_aggregate);
            }
        }
    }

    private AERelationalExpr processOrderBy(AEProject aEProject) throws ErrorException {
        AEQueryScope aEQueryScope = this.getQueryScope();
        IPTNode iPTNode = aEQueryScope.getPtSortSpecList();
        if (null == iPTNode) {
            return aEProject;
        }
        AESortBuilder aESortBuilder = new AESortBuilder(this.getQueryScope(), aEProject);
        List<AESortSpec> list = aESortBuilder.buildSortSpecificationList((PTListNode)iPTNode);
        if (aEQueryScope.shouldHandleSortOuter()) {
            aEQueryScope.setSortSpec(list);
            return aEProject;
        }
        AESort aESort = new AESort(aEProject, list, aEQueryScope.getSelectItemCount());
        this.m_numSelectedCols = aESort.getColumnCount();
        return aESort;
    }

    private void processGroupBy(AERelationalExpr aERelationalExpr, IPTNode iPTNode, PTListNode pTListNode) throws ErrorException {
        if (!iPTNode.isEmptyNode()) {
            AEBuilderCheck.checkThat(iPTNode, AEBuilderCheck.nonTerminal(PTNonterminalType.GROUP_BY).withExactChildren(PTPositionalType.GROUP_BY_EXPRESSION_LIST, AEBuilderCheck.instanceOf(IPTNode.class)));
            this.getQueryScope().setCurrentClause(AEQueryScope.ClauseType.GROUP_BY);
            AEGroupByListBuilder aEGroupByListBuilder = new AEGroupByListBuilder(this.getQueryScope(), pTListNode);
            this.m_groupByExprList = (AEValueExprList)aEGroupByListBuilder.build(((PTNonterminalNode)iPTNode).getChild(PTPositionalType.GROUP_BY_EXPRESSION_LIST));
            this.m_groupingListOrdinalReferenceMap = aEGroupByListBuilder.getGroupingListOrdinalReferenceMap();
        }
    }

    private void processHaving(IPTNode iPTNode) throws ErrorException {
        AEBuilderCheck.checkThat(iPTNode, AEBuilderCheck.nonTerminal().withExactChildren(PTPositionalType.SEARCH_COND, AEBuilderCheck.nonEmpty()));
        AEQueryScope aEQueryScope = this.getQueryScope();
        aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.HAVING);
        aEQueryScope.setImpliedGroupBy(true);
        this.m_havingExpr = (AEBooleanExpr)new AEBooleanExprBuilder(aEQueryScope).build(((PTNonterminalNode)iPTNode).getChild(PTPositionalType.SEARCH_COND));
        if (!aEQueryScope.isTopMost()) {
            AEBooleanExprOuterRefProcessor.process(this.m_havingExpr, aEQueryScope);
        }
        AEBooleanExprProcessor.process(this.m_havingExpr, aEQueryScope);
    }

    private AERelationalExpr processFrom(IPTNode iPTNode) throws ErrorException {
        AEQueryScope aEQueryScope = this.getQueryScope();
        aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.FROM);
        if (iPTNode.isEmptyNode()) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Empty table list in select statement is not supported.");
        }
        return (AERelationalExpr)new AETableRefListBuilder(aEQueryScope).build(iPTNode);
    }

    private AERelationalExpr processWhere(AERelationalExpr aERelationalExpr, IPTNode iPTNode) throws ErrorException {
        AEQueryScope aEQueryScope = this.getQueryScope();
        aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.WHERE);
        if (iPTNode.isEmptyNode()) {
            return aERelationalExpr;
        }
        AEBooleanExpr aEBooleanExpr = (AEBooleanExpr)new AEWhereConditionBuilder(this.getQueryScope()).build(iPTNode);
        if (!this.getQueryScope().isTopMost()) {
            AEBooleanExprOuterRefProcessor.process(aEBooleanExpr, aEQueryScope);
        }
        return new AESelect(aERelationalExpr, aEBooleanExpr);
    }

    private AERelationalExpr processSelectLimit(AERelationalExpr aERelationalExpr, IPTNode iPTNode) throws ErrorException {
        AEQueryScope aEQueryScope = this.getQueryScope();
        if (iPTNode.isEmptyNode()) {
            return aERelationalExpr;
        }
        AEBuilderCheck.checkThat(iPTNode, AEBuilderCheck.eitherOf(AEBuilderCheck.nonTerminal(PTNonterminalType.SELECT_LIMIT).withExactChildren(PTPositionalType.TOP_VALUE_SPEC, AEBuilderCheck.instanceOf(IPTNode.class)), AEBuilderCheck.nonTerminal(PTNonterminalType.SELECT_LIMIT_SKIP).withExactChildren(PTPositionalType.SKIP_VALUE_SPEC, AEBuilderCheck.instanceOf(IPTNode.class), PTPositionalType.TOP_VALUE_SPEC, AEBuilderCheck.instanceOf(IPTNode.class))));
        PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode;
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.TOP_VALUE_SPEC);
        aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.NONE);
        AEValueExpr aEValueExpr = (AEValueExpr)new AEValueExprBuilder(aEQueryScope).build(iPTNode2);
        if (PTNonterminalType.SELECT_LIMIT_SKIP == pTNonterminalNode.getNonterminalType()) {
            IPTNode iPTNode3 = pTNonterminalNode.getChild(PTPositionalType.SKIP_VALUE_SPEC);
            aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.NONE);
            AEValueExpr aEValueExpr2 = (AEValueExpr)new AEValueExprBuilder(aEQueryScope).build(iPTNode3);
            return new AETop(aERelationalExpr, aEValueExpr, aEValueExpr2, false);
        }
        return new AETop(aERelationalExpr, aEValueExpr, false);
    }

    private boolean checkAggrFnInSelectList() throws ErrorException {
        AEDefaultVisitor<Boolean> aEDefaultVisitor = new AEDefaultVisitor<Boolean>(){
            boolean m_hasRowExpr = false;
            boolean m_hasAggr = false;
            boolean m_aggrColOuterRef = false;
            String m_exceptionCol = null;

            @Override
            public Boolean visit(AEColumnReference aEColumnReference) throws ErrorException {
                if (!this.m_hasRowExpr && !this.m_aggrColOuterRef && aEColumnReference.getResolvedQueryScope() == AEQuerySpecBuilder.this.getQueryScope()) {
                    this.m_hasRowExpr = true;
                    this.m_exceptionCol = aEColumnReference.getLogString();
                }
                return this.m_hasAggr;
            }

            @Override
            public Boolean visit(AEProxyColumn aEProxyColumn) throws ErrorException {
                if (!this.m_hasRowExpr && !this.m_aggrColOuterRef && aEProxyColumn.getResolvedQueryScope() == AEQuerySpecBuilder.this.getQueryScope()) {
                    this.m_hasRowExpr = true;
                    this.m_exceptionCol = aEProxyColumn.getLogString();
                }
                return this.m_hasAggr;
            }

            @Override
            public Boolean visit(AECountStarAggrFn aECountStarAggrFn) {
                this.m_hasAggr = true;
                return this.m_hasAggr;
            }

            @Override
            public Boolean visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
                AEDefaultVisitor<Void> aEDefaultVisitor = new AEDefaultVisitor<Void>(){

                    @Override
                    public Void visit(AEColumnReference aEColumnReference) {
                        m_aggrColOuterRef = aEColumnReference.getResolvedQueryScope() != AEQuerySpecBuilder.this.getQueryScope();
                        m_hasAggr = !m_aggrColOuterRef;
                        return null;
                    }

                    @Override
                    public Void visit(AEProxyColumn aEProxyColumn) {
                        m_aggrColOuterRef = aEProxyColumn.getResolvedQueryScope() != AEQuerySpecBuilder.this.getQueryScope();
                        m_hasAggr = !m_aggrColOuterRef;
                        return null;
                    }

                    @Override
                    public Void visit(AELiteral aELiteral) {
                        m_hasAggr = true;
                        return null;
                    }

                    @Override
                    protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                        Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                        while (iterator.hasNext()) {
                            IAENode iAENode2 = iterator.next();
                            iAENode2.acceptVisitor(this);
                        }
                        return null;
                    }
                };
                aEGeneralAggrFn.acceptVisitor(aEDefaultVisitor);
                return this.m_hasAggr;
            }

            @Override
            public Boolean visit(AEValueSubQuery aEValueSubQuery) throws ErrorException {
                if (aEValueSubQuery.isCorrelated()) {
                    aEValueSubQuery.getQueryExpression().acceptVisitor(this);
                }
                return this.m_hasAggr;
            }

            @Override
            protected Boolean defaultVisit(IAENode iAENode) throws ErrorException {
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    iterator.next().acceptVisitor(this);
                    if (!this.m_hasRowExpr || !this.m_hasAggr) continue;
                    assert (this.m_exceptionCol != null);
                    throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.NON_GROUPING_COLUMN_IN_SEL_LIST.name(), new String[]{this.m_exceptionCol});
                }
                return this.m_hasAggr;
            }
        };
        return this.m_selectList.acceptVisitor(aEDefaultVisitor);
    }
}

