/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.http.apache.client.impl;

import com.amazon.redshift.amazonaws.http.AmazonHttpClient;
import com.amazon.redshift.amazonaws.http.IdleConnectionReaper;
import com.amazon.redshift.amazonaws.http.apache.SdkProxyRoutePlanner;
import com.amazon.redshift.amazonaws.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.amazon.redshift.amazonaws.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import com.amazon.redshift.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import com.amazon.redshift.amazonaws.http.apache.client.impl.SdkHttpClient;
import com.amazon.redshift.amazonaws.http.apache.utils.ApacheUtils;
import com.amazon.redshift.amazonaws.http.client.ConnectionManagerFactory;
import com.amazon.redshift.amazonaws.http.client.HttpClientFactory;
import com.amazon.redshift.amazonaws.http.conn.ClientConnectionManagerFactory;
import com.amazon.redshift.amazonaws.http.conn.SdkConnectionKeepAliveStrategy;
import com.amazon.redshift.amazonaws.http.protocol.SdkHttpRequestExecutor;
import com.amazon.redshift.amazonaws.http.settings.HttpClientSettings;
import com.amazon.redshift.shaded.apache.commons.logging.Log;
import com.amazon.redshift.shaded.apache.commons.logging.LogFactory;
import com.amazon.redshift.shaded.apache.http.conn.ConnectionKeepAliveStrategy;
import com.amazon.redshift.shaded.apache.http.conn.HttpClientConnectionManager;
import com.amazon.redshift.shaded.apache.http.impl.client.HttpClientBuilder;
import com.amazon.redshift.shaded.apache.http.impl.client.HttpClients;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings settings) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(settings);
        builder.setRequestExecutor(new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(settings)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        if (!settings.useGzip()) {
            builder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor itcp = new CRC32ChecksumResponseInterceptor();
        if (settings.calculateCRC32FromCompressedData()) {
            builder.addInterceptorFirst(itcp);
        } else {
            builder.addInterceptorLast(itcp);
        }
        this.addProxyConfig(builder, settings);
        SdkHttpClient httpClient = new SdkHttpClient(builder.build(), cm);
        if (settings.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(cm, settings.getMaxIdleConnectionTime());
        }
        return httpClient;
    }

    private void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings) {
        if (this.isProxyEnabled(settings)) {
            LOG.info("Configuring Proxy. Proxy Host: " + settings.getProxyHost() + " Proxy Port: " + settings.getProxyPort());
            builder.setRoutePlanner(new SdkProxyRoutePlanner(settings.getProxyHost(), settings.getProxyPort(), settings.getNonProxyHosts()));
            if (this.isAuthenticatedProxy(settings)) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings settings) {
        return settings.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(settings.getMaxIdleConnectionTime()) : null;
    }

    private boolean isAuthenticatedProxy(HttpClientSettings settings) {
        return settings.getProxyUsername() != null && settings.getProxyPassword() != null;
    }

    private boolean isProxyEnabled(HttpClientSettings settings) {
        return settings.getProxyHost() != null && settings.getProxyPort() > 0;
    }
}

