/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.service;

import com.install4j.runtime.launcher.service.CommonHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class PidHandler
extends CommonHandler {
    PidHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isRunning() {
        File watcherFile = this.getWatcherFile();
        if (!watcherFile.exists()) return false;
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(watcherFile));
            try {
                int pid;
                int status = in.read();
                if (status == 43 && (pid = in.readInt()) > 0) {
                    boolean bl = PidHandler.isProcessRunning(pid);
                    return bl;
                }
            }
            finally {
                in.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (System.currentTimeMillis() - watcherFile.lastModified() >= 10000L) return false;
        return true;
    }

    private static boolean isProcessRunning(int pid) throws InterruptedException, IOException {
        return Runtime.getRuntime().exec("ps -p " + pid).waitFor() == 0;
    }

    @Override
    protected void updateWatcherFile(File watcherFile) {
        watcherFile.setLastModified(System.currentTimeMillis());
    }

    @Override
    protected void finishStartFileCreation(File watcherFile, DataOutputStream out, FileOutputStream fout) throws IOException {
        out.close();
    }
}

