/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class BooleanCheckBoxCellEditor
extends ContextSensitiveCellEditor
implements TableCellEditor,
ItemListener {
    public static EditorContext CONTEXT = new EditorContext("CheckBox");
    protected JCheckBox _checkBox = this.createCheckBox();
    private static final long \u054f = -4447001569059923173L;

    public BooleanCheckBoxCellEditor() {
        this.configureCheckBox();
    }

    protected JCheckBox createCheckBox() {
        return new JCheckBox();
    }

    protected void configureCheckBox() {
        this._checkBox.setHorizontalAlignment(0);
    }

    @Override
    public Object getCellEditorValue() {
        return this._checkBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setCellEditorValue(Object object) {
        this._checkBox.setSelected(Boolean.TRUE.equals(object));
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        if (jTable != null) {
            this.customizeCheckBox();
            if (bl) {
                JideSwingUtilities.installColorsAndFont(this._checkBox, jTable.getSelectionBackground(), jTable.getSelectionForeground(), jTable.getFont());
            } else {
                JideSwingUtilities.installColorsAndFont(this._checkBox, jTable.getBackground(), jTable.getForeground(), jTable.getFont());
            }
        }
        this.setCellEditorValue(object);
        if (jTable != null) {
            this._checkBox.addItemListener(this);
        }
        return this._checkBox;
    }

    protected void customizeCheckBox() {
        this._checkBox.setOpaque(true);
        this._checkBox.setBorder(UIDefaultsLookup.getBorder("Table.focusCellHighlightBorder"));
    }

    @Override
    public boolean stopCellEditing() {
        this._checkBox.getModel().setArmed(false);
        return super.stopCellEditing();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isAutoStopCellEditing()) {
            this._checkBox.removeItemListener(this);
            this.stopCellEditing();
        }
    }
}

