/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleUtils {
    private static boolean JAVA6_OR_ABOVE = !System.getProperty("java.version").startsWith("1.5.");

    public static ResourceBundle loadResourceBundle(Class<?> clazz, Locale locale, String string) {
        String string2 = String.valueOf(string) + "/" + clazz.getSimpleName();
        ClassLoader classLoader = clazz.getClassLoader();
        return JAVA6_OR_ABOVE ? ResourceBundle.getBundle(string2, locale, classLoader, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES)) : ResourceBundle.getBundle(string2, locale, classLoader);
    }

    public static void addResourceBundleToDefaults(ResourceBundle resourceBundle, boolean bl) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = resourceBundle.getString(string);
            if (!bl && uIDefaults.containsKey(string)) continue;
            uIDefaults.put(string, string2);
        }
    }

    public static String loadTextResource(String string) throws URISyntaxException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ResourceBundleUtils.class.getResourceAsStream(string)));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuilder.append(String.valueOf(string2) + "\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }
}

