/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.alert.Alert;
import com.install4j.runtime.alert.AlertOptionPane;
import com.install4j.runtime.alert.AlertResult;
import com.install4j.runtime.alert.AlertType;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.beans.applications.UninstallerApplication;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.launcher.util.LauncherUtil;
import com.install4j.runtime.util.RetinaIcon;
import com.install4j.runtime.util.VersionCheck;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GUIHelper {
    public static final ImageIcon DEFAULT_ICON_FRAME_16 = GUIHelper.loadIcon("install4j_icon_16.png");
    public static final ImageIcon DEFAULT_ICON_FRAME_32 = GUIHelper.loadIcon("install4j_icon_32.png");
    public static final Icon ICON_FOLDER_OPEN = GUIHelper.loadIcon("folder_open_16.png");
    public static final Icon ICON_FOLDER_CLOSED = GUIHelper.loadIcon("folder_closed_16.png");
    private static final String ICONS_DIRECTORY = "icons/";
    public static final int BASELINE_LEADING = 512;
    private static boolean lafSet = false;
    private static String browserExecutable = "";
    private static Boolean retina;
    private static double scaleFactor;
    private static Map<File, ImageIcon> iconCache;

    public static String getBrowserExecutable() {
        return browserExecutable;
    }

    public static void setBrowserExecutable(String browserExecutable) {
        GUIHelper.browserExecutable = browserExecutable;
    }

    public static void setLanguage(String languageId) {
        HelperCommunication.helperUnsupported();
        if (InstallerUtil.isInProcess()) {
            return;
        }
        if (languageId != null) {
            String country;
            int index = languageId.indexOf("_");
            if (index > -1) {
                country = languageId.substring(index + 1);
                languageId = languageId.substring(0, index);
            } else {
                country = "";
            }
            try {
                Locale.setDefault(new Locale(languageId, country));
            }
            catch (Exception exception) {}
        } else {
            languageId = Locale.getDefault().getLanguage();
        }
        GUIHelper.setLaF();
        if (Objects.equals(languageId, "ja") || Objects.equals(languageId, "ko") || languageId.startsWith("zh")) {
            Font font = UIManager.getFont("Label.font");
            UIManager.put("OptionPane.font", font);
            UIManager.put("OptionPane.messageFont", font);
            UIManager.put("OptionPane.buttonFont", font);
        }
        String fontOffset = System.getProperty("install4j.font.offset");
        String javaVersion = System.getProperty("java.version");
        if (fontOffset != null) {
            GUIHelper.adjustFontSize(Integer.parseInt(fontOffset));
        } else if (Objects.equals(languageId, "zh_TW") && javaVersion.startsWith("1.4")) {
            GUIHelper.adjustFontSize(2);
        }
    }

    public static void setLaF() {
        if (!InstallerUtil.isInProcess()) {
            GUIHelper.setLafUnconditional();
        }
    }

    public static void setLafUnconditional() {
        HelperCommunication.helperUnsupported();
        if (!lafSet) {
            lafSet = true;
            if (!Boolean.getBoolean("install4j.nolaf") && !Boolean.getBoolean("java.awt.headless") && System.getProperty("swing.defaultlaf") == null) {
                try {
                    if (Util.isWindows() || Util.isMacOS() || !InstallerUtil.isJava9Plus() || !GUIHelper.isRetina()) {
                        System.setProperty("jdk.gtk.version", "2");
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isWindowsLaF() {
        HelperCommunication.helperUnsupported();
        return Objects.equals(UIManager.getLookAndFeel().getID(), "Windows");
    }

    public static boolean isMetalLaF() {
        HelperCommunication.helperUnsupported();
        return Objects.equals(UIManager.getLookAndFeel().getID(), "Metal");
    }

    public static boolean isWindowsXpLaF() {
        HelperCommunication.helperUnsupported();
        return GUIHelper.isWindowsLaF() && Objects.equals(Boolean.TRUE, Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) && !Boolean.getBoolean("swing.noxp");
    }

    public static boolean isWindowsClassicLaF() {
        HelperCommunication.helperUnsupported();
        return GUIHelper.isWindowsLaF() && (!Objects.equals(Boolean.TRUE, Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) || Boolean.getBoolean("swing.noxp") || UIManager.getLookAndFeel().getClass().getName().endsWith("WindowsClassicLookAndFeel"));
    }

    public static boolean isGtkLaF() {
        HelperCommunication.helperUnsupported();
        return Objects.equals(UIManager.getLookAndFeel().getID(), "GTK");
    }

    private static void adjustFontSize(int adjustment) {
        HelperCommunication.helperUnsupported();
        UIDefaults defaults = UIManager.getDefaults();
        LinkedList<Object> newDefaults = new LinkedList<Object>();
        HashMap<Font, Font> newFonts = new HashMap<Font, Font>();
        for (Object key : defaults.keySet()) {
            Object value = defaults.get(key);
            if (!(value instanceof Font)) continue;
            Font oldFont = (Font)value;
            Font newFont = (Font)newFonts.get(oldFont);
            if (newFont == null) {
                newFont = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() + adjustment);
                newFonts.put(oldFont, newFont);
            }
            newDefaults.add(key);
            newDefaults.add(newFont);
        }
        defaults.putDefaults(newDefaults.toArray());
    }

    @NotNull
    public static ImageIcon loadIcon(String fileName) {
        URL iconUrl;
        String retinaFileName;
        HelperCommunication.helperUnsupported();
        ImageIcon imageIcon = new ImageIcon(GUIHelper.getIconUrl(fileName));
        if (GUIHelper.isRetina() && (retinaFileName = GUIHelper.toRetinaPath(fileName)) != null && (iconUrl = GUIHelper.getIconUrl(retinaFileName)) != null) {
            return new RetinaIcon(iconUrl, imageIcon);
        }
        return imageIcon;
    }

    public static void withIcon(ExternalFile file, Context context, IconConsumer<?> iconConsumer) {
        GUIHelper.withIcon(file, null, context, iconConsumer);
    }

    public static <T> T withIcon(ExternalFile file, T defaultReturnValue, Context context, IconConsumer<T> iconConsumer) {
        File actualFile = context.getExternalFile(file, false);
        ImageIcon imageIcon = GUIHelper.loadIcon(actualFile);
        if (imageIcon != null) {
            return iconConsumer.call(imageIcon);
        }
        return defaultReturnValue;
    }

    @Nullable
    public static ImageIcon loadIcon(File file) {
        HelperCommunication.helperUnsupported();
        ImageIcon icon = iconCache.get(file);
        if (icon == null) {
            try {
                icon = GUIHelper.loadIconNoCache(file);
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
            }
            iconCache.put(file, icon);
        }
        return icon;
    }

    @Nullable
    public static ImageIcon loadIconNoCache(File file) {
        File retinaFile;
        String retinaFileName;
        String path = file.getPath();
        if (path.startsWith("icon:")) {
            return GUIHelper.loadIcon(path);
        }
        if (!file.exists()) {
            Logger.getInstance().log(null, "File " + file + " does not exist", false);
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
        if (GUIHelper.isRetina() && (retinaFileName = GUIHelper.toRetinaPath(path)) != null && (retinaFile = new File(retinaFileName)).exists()) {
            return new RetinaIcon(retinaFile.getAbsolutePath(), imageIcon);
        }
        return imageIcon;
    }

    private static String toRetinaPath(String path) {
        int index = path.toLowerCase(Locale.ENGLISH).lastIndexOf(46);
        if (index > -1) {
            return path.substring(0, index) + "@2x" + path.substring(index);
        }
        return null;
    }

    public static URL getIconUrl(String fileName) {
        if (fileName.startsWith("icon:")) {
            fileName = fileName.substring("icon:".length());
        }
        String fileNameWithDirectory = ICONS_DIRECTORY + fileName;
        Class<GUIHelper> builtinClass = GUIHelper.class;
        String resourcePath = builtinClass.getPackage().getName().replace('.', '/') + "/" + fileNameWithDirectory;
        URL resource = Install4jClassLoader.getInstance().getResourceWithoutParent(resourcePath);
        if (resource != null) {
            return resource;
        }
        return builtinClass.getResource(fileNameWithDirectory);
    }

    public static boolean isRetina() {
        if (retina == null) {
            retina = GUIHelper.checkRetina();
        }
        return retina;
    }

    public static double getScaleFactor() {
        return scaleFactor;
    }

    private static boolean checkRetina() {
        GraphicsDevice device;
        if (Boolean.getBoolean("java.awt.headless")) {
            return false;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment != null && (device = graphicsEnvironment.getDefaultScreenDevice()) != null) {
            AffineTransform defaultTransform;
            GraphicsConfiguration defaultConfiguration = device.getDefaultConfiguration();
            if (defaultConfiguration != null && (defaultTransform = defaultConfiguration.getDefaultTransform()) != null) {
                scaleFactor = defaultTransform.getScaleX();
            }
            if (scaleFactor >= 1.2) {
                return true;
            }
            if (VersionCheck.checkCompatible("1.7.0_40", System.getProperty("java.version")) && !LauncherUtil.isJava9Plus()) {
                try {
                    try {
                        Field field = device.getClass().getDeclaredField("scale");
                        field.setAccessible(true);
                        Object scale = field.get(device);
                        if (scale instanceof Integer && (Integer)scale == 2) {
                            scaleFactor = 2.0;
                            return true;
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static int showOptionDialog(Component parent, final String mainMessage, final String contentMessage, final String[] options, final int messageType) throws UserCanceledException {
        String[] keys = new String[options.length];
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            int index = option.indexOf(38);
            if (index > -1 && index < option.length() - 1) {
                keys[i] = option.substring(index + 1, index + 2).toLowerCase(Locale.ENGLISH);
            } else {
                String key = option.substring(0, 1).toLowerCase(Locale.ENGLISH);
                boolean found = false;
                for (int j = 0; j < i; ++j) {
                    if (!Objects.equals(keys[j], key)) continue;
                    found = true;
                    break;
                }
                keys[i] = !found ? key : String.valueOf(i);
            }
            options[i] = option.replaceAll("&", "");
        }
        if (InstallerUtil.isUnattended()) {
            return -1;
        }
        if (InstallerUtil.isConsole()) {
            return ConsoleImpl.getInstance().askOption(GUIHelper.toSingleAlertMessage(mainMessage, contentMessage), options, keys, 0);
        }
        GUIHelper.setLaF();
        final Component nonNullParent = GUIHelper.getNonNullParent(parent);
        try {
            return GUIHelper.invokeOnEDT(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return GUIHelper.showOptionDialogInternal(nonNullParent, mainMessage, contentMessage, messageType, options);
                }
            });
        }
        catch (Exception e) {
            InstallerUtil.reportException(e);
            return -1;
        }
    }

    private static String toSingleAlertMessage(String mainMessage, String contentMessage) {
        return contentMessage == null ? mainMessage : contentMessage;
    }

    private static int showOptionDialogInternal(Component parent, String mainMessage, String contentMessage, int messageType, String[] options) {
        HelperCommunication.helperUnsupported();
        Alert<String> alert = Alert.create(parent, Messages.getString(".SetupAppTitle"), mainMessage, contentMessage).addButtons(options).defaultButton(options[0]).cancelButton(options[options.length - 1]).alertType(AlertType.fromOptionType(messageType, AlertType.QUESTION));
        AlertResult<String> alertResult = alert.show();
        return alertResult.getSelectedIndex();
    }

    public static Window getParentWindow() {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return null;
        }
        HelperCommunication.helperUnsupported();
        Window[] windows = Window.getWindows();
        if (windows != null) {
            Window showingWindow = null;
            Window nonTempFrame = null;
            for (Window window : windows) {
                if (!GUIHelper.isDialogOrFrame(window)) continue;
                if (window.isShowing()) {
                    showingWindow = window;
                    if (window.isActive()) {
                        return window;
                    }
                }
                if (window instanceof AlertOptionPane.TempFrame) continue;
                nonTempFrame = window;
            }
            if (showingWindow != null) {
                return showingWindow;
            }
            if (nonTempFrame != null) {
                return nonTempFrame;
            }
        }
        return null;
    }

    private static boolean isDialogOrFrame(Window window) {
        return window instanceof Dialog || window instanceof Frame;
    }

    public static void showMessage(Component parent, String message, int messageType) {
        GUIHelper.showMessage(parent, message, null, messageType);
    }

    public static void showMessage(Component parent, final String message, final String contentMessage, final int messageType) {
        if (InstallerUtil.isUnattended()) {
            Logger.getInstance().log(null, message, messageType != 0);
            ConsoleImpl.getInstance().println(message);
        } else if (InstallerUtil.isConsole()) {
            ConsoleImpl.getInstance().println(message);
        } else {
            GUIHelper.setLaF();
            final Component nonNullParent = GUIHelper.getNonNullParent(parent);
            try {
                GUIHelper.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        GUIHelper.showMessageInternal(nonNullParent, message, contentMessage, messageType);
                    }
                });
            }
            catch (Exception e) {
                InstallerUtil.reportException(e);
            }
        }
    }

    @NotNull
    private static Component getNonNullParent(@Nullable Component parent) {
        if (parent != null) {
            return parent;
        }
        Window parentWindow = GUIHelper.getParentWindow();
        if (parentWindow != null) {
            return parentWindow;
        }
        return new AlertOptionPane.TempFrame();
    }

    private static void showMessageInternal(Component parent, String mainMessage, String contentMessage, int messageType) {
        HelperCommunication.helperUnsupported();
        Alert alert = Alert.create(parent, Messages.getString(".SetupAppTitle"), mainMessage, contentMessage).alertType(AlertType.fromOptionType(messageType, AlertType.INFORMATION));
        alert.show();
    }

    public static boolean showURL(String urlSpec) {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return true;
        }
        Window window = GUIHelper.getParentWindow();
        try {
            if (!GUIHelper.showUrlWithDesktop(urlSpec)) {
                GUIHelper.showBrowserError(window);
                return false;
            }
        }
        catch (IOException e) {
            GUIHelper.showBrowserError(window);
            return false;
        }
        return true;
    }

    private static boolean showUrlWithDesktop(String urlSpec) throws IOException {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            return false;
        }
        try {
            desktop.browse(new URI(GUIHelper.encodeSpaces(urlSpec)));
            return true;
        }
        catch (IOException e) {
            Logger.getInstance().error(null, "The URI " + urlSpec + " cannot be shown.");
            Logger.getInstance().log(e);
            throw e;
        }
        catch (Throwable t) {
            Logger.getInstance().error(null, "The URI " + urlSpec + " cannot be shown.");
            Logger.getInstance().log(t);
            throw new IOException(t);
        }
    }

    public static Color getSeparatorColor() {
        HelperCommunication.helperUnsupported();
        return UIManager.getColor("Separator.foreground");
    }

    public static boolean confirmCancel(Component parent) {
        HelperCommunication.helperUnsupported();
        int result = 0;
        try {
            String message = null;
            Application application = InstallerConfig.getCurrentApplication();
            if (application instanceof InstallerApplication) {
                message = Messages.getString(".ExitSetupMessage");
            } else if (application instanceof UninstallerApplication) {
                message = Messages.getString(".ExitUninstallerMessage");
            } else if (application instanceof CustomApplication) {
                CustomApplication customApplication = (CustomApplication)application;
                if (customApplication.isShowCancelMessage()) {
                    message = customApplication.getCancelMessage();
                }
            } else {
                message = Messages.getString(".ExitApplication");
            }
            if (message != null) {
                result = GUIHelper.showOptionDialog(parent, message, null, new String[]{Messages.getString(".ButtonExit"), Messages.getString(".ButtonContinue")}, 3);
            }
        }
        catch (UserCanceledException userCanceledException) {
            // empty catch block
        }
        return result == 0;
    }

    public static String encodeSpaces(String url) {
        StringBuilder buffer = new StringBuilder();
        int urlLen = url.length();
        for (int i = 0; i < urlLen; ++i) {
            if (url.charAt(i) == ' ') {
                buffer.append("%20");
                continue;
            }
            buffer.append(url.charAt(i));
        }
        return buffer.toString();
    }

    private static void showBrowserError(Window window) {
        if (!Boolean.getBoolean("install4j.noBrowserError")) {
            GUIHelper.showMessage(window, Messages.getString(".ErrorStartingBrowser"), 0);
        }
    }

    public static List<Image> getFrameIconImages() {
        HelperCommunication.helperUnsupported();
        ArrayList<Image> icons = new ArrayList<Image>();
        Application currentApplication = InstallerConfig.getCurrentApplication();
        if (currentApplication != null && currentApplication.isUseCustomIcon()) {
            try {
                for (ExternalFile iconFile : currentApplication.getCustomIconImageFiles()) {
                    ImageIcon icon = GUIHelper.loadIcon(InstallerUtil.getInstallerFile(iconFile.getPath()));
                    if (icon == null || icon.getIconWidth() <= 0) continue;
                    icons.add(icon.getImage());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (icons.size() == 0) {
            icons.add(DEFAULT_ICON_FRAME_16.getImage());
            icons.add(GUIHelper.loadIcon("install4j_icon_24@n.png").getImage());
            icons.add(DEFAULT_ICON_FRAME_32.getImage());
            icons.add(GUIHelper.loadIcon("install4j_icon_48@n.png").getImage());
            icons.add(GUIHelper.loadIcon("install4j_icon_64@n.png").getImage());
            icons.add(GUIHelper.loadIcon("install4j_icon_128@n.png").getImage());
        }
        return icons;
    }

    public static void makeTransparent(JComponent component) {
        HelperCommunication.helperUnsupported();
        if (component.getBackground() instanceof UIResource && (component instanceof JPanel || component instanceof JRadioButton || component instanceof JCheckBox || component instanceof JSlider || component instanceof JSplitPane || !GUIHelper.isWindowsClassicLaF() && component instanceof JButton)) {
            component.setOpaque(false);
        }
        int componentCount = component.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component child = component.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            GUIHelper.makeTransparent((JComponent)child);
        }
    }

    public static void setIconImages(Window window) {
        HelperCommunication.helperUnsupported();
        window.setIconImages(GUIHelper.getFrameIconImages());
    }

    public static void invokeLater(Runnable runnable) {
        HelperCommunication.helperUnsupported();
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static void showPath(String path) {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return;
        }
        File file = new File(path);
        boolean directory = file.isDirectory();
        if (InstallerUtil.isMacOS()) {
            String[] stringArray;
            LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File("/usr/bin/open"));
            if (directory) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = file.getAbsolutePath();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "-R";
                stringArray = stringArray3;
                stringArray3[1] = file.getAbsolutePath();
            }
            LaunchHelper.launchApplication(launchDescriptor.arguments(stringArray));
        } else {
            String[] commandArray;
            File workingDirectory = null;
            if (InstallerUtil.isWindows()) {
                if (path.indexOf(32) > -1) {
                    path = FolderInfo.getShortPathName(path);
                }
                commandArray = new String[]{"explorer.exe", (directory ? "" : "/select,") + path};
            } else {
                commandArray = new String[]{"/bin/sh", "-c", "xdg-open .;  if [ $? -ne 0 ]; then xterm; fi"};
                workingDirectory = directory ? file : file.getParentFile();
            }
            try {
                new ProcessBuilder(commandArray).directory(workingDirectory).start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static JSeparator createHorizontalSeparator() {
        JSeparator separator = new JSeparator(0);
        if (Util.isMacOS()) {
            separator.setUI(new BasicSeparatorUI());
        }
        return separator;
    }

    public static void setEmptyBorder(final JComponent component, final int top, final int left, final int bottom, final int right) {
        component.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
        component.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (Objects.equals(event.getPropertyName(), "componentOrientation")) {
                    boolean leftToRight = component.getComponentOrientation().isLeftToRight();
                    component.setBorder(BorderFactory.createEmptyBorder(top, leftToRight ? left : right, bottom, leftToRight ? right : left));
                }
            }
        });
    }

    public static void applyComponentOrientation(Component c) {
        c.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    public static void invokeOnEDT(Runnable runnable) {
        HelperCommunication.helperUnsupported();
        HelperCommunication.checkEdtWaiting();
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <V> V invokeOnEDT(final Callable<V> callable) {
        HelperCommunication.helperUnsupported();
        HelperCommunication.checkEdtWaiting();
        if (EventQueue.isDispatchThread()) {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        final Throwable[] throwable = new Throwable[1];
        final Object[] result = new Object[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        result[0] = callable.call();
                    }
                    catch (Throwable t) {
                        throwable[0] = t;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (throwable[0] != null) {
            throw new RuntimeException(throwable[0]);
        }
        return (V)result[0];
    }

    public static <T extends AbstractButton> T adjustButton(T button) {
        if (GUIHelper.isGtkLaF()) {
            button.setBorder(BorderFactory.createEmptyBorder(7, 16, 7, 16));
        }
        return button;
    }

    public static boolean isIntelliJLaF() {
        return GUIHelper.isNativeIntelliJLaF() || GUIHelper.isDarculaLaF();
    }

    public static boolean isNativeIntelliJLaF() {
        return UIManager.getLookAndFeel().getID().equals("IntelliJ");
    }

    public static boolean isDarculaLaF() {
        return UIManager.getLookAndFeel().getID().equals("Darcula");
    }

    public static int getIconSize(File file) throws IOException {
        int height;
        BufferedImage bimg = ImageIO.read(file);
        int width = bimg.getWidth();
        if (width != (height = bimg.getHeight())) {
            throw new IOException(file + " is not square: " + width + " != " + height);
        }
        return width;
    }

    static {
        scaleFactor = 1.0;
        iconCache = new HashMap<File, ImageIcon>();
    }

    public static interface IconConsumer<T> {
        public T call(@NotNull ImageIcon var1);
    }
}

