/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TimeoutInterruptHandler;

class TimeoutSocketChannel
extends SocketChannelWrapper {
    private final Pattern PAT_STATUS_LINE = Pattern.compile("^HTTP/1.[01]\\s+(\\d+)\\s+(.*)", 2);
    private int soTimeout = 0;
    TimeoutInterruptHandler.InterruptTask interruptTask;
    NetStatImpl netStat = null;

    public TimeoutSocketChannel(SocketAddress socketAddress, int n2, NetStatImpl netStatImpl) throws IOException {
        super((SocketChannel)null);
        this.netStat = netStatImpl;
        this.connect(socketAddress, n2);
    }

    public TimeoutSocketChannel(InetSocketAddress inetSocketAddress, int n2, NetStatImpl netStatImpl, InetSocketAddress inetSocketAddress2) throws IOException {
        super((SocketChannel)null);
        this.netStat = netStatImpl;
        if (inetSocketAddress2 == null) {
            this.connect(inetSocketAddress, n2);
        } else {
            this.connect(inetSocketAddress2, n2);
            this.doHTTPTunneling(inetSocketAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(SocketAddress socketAddress, int n2) throws IOException {
        this.scheduleInterrupt(n2, false);
        try {
            this.socketChannel = SocketChannel.open(socketAddress);
            this.socketChannel.configureBlocking(true);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
    }

    private void doHTTPTunneling(InetSocketAddress inetSocketAddress) throws IOException {
        String string = inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CONNECT " + string + " HTTP/1.0\r\n");
        stringBuilder.append("Host: " + string + "\r\n");
        stringBuilder.append("\r\n");
        ByteBuffer byteBuffer = ByteBuffer.wrap(stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1));
        while (byteBuffer.hasRemaining()) {
            this.socketChannel.write(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(512);
        this.socketChannel.read(byteBuffer2);
        byteBuffer2.flip();
        String string2 = new String(byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit(), StandardCharsets.US_ASCII);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
        String string3 = bufferedReader.readLine();
        Matcher matcher = this.PAT_STATUS_LINE.matcher(string3);
        if (!matcher.matches()) {
            throw new IOException("HTTP proxy tunneling failed [" + string3 + "]");
        }
        int n2 = Integer.parseInt(matcher.group(1));
        String string4 = matcher.group(2);
        if (n2 != 200) {
            throw new IOException("HTTP proxy tunneling failed [" + n2 + ":" + string3 + "]");
        }
    }

    void setNetStat(NetStatImpl netStatImpl) {
        this.netStat = netStatImpl;
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public void setSoTimeout(int n2) {
        this.soTimeout = n2;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout(), true);
        try {
            int n2 = this.socketChannel.read(byteBuffer);
            if (this.netStat != null) {
                this.netStat.incrementBytesReceived(n2);
            }
            int n3 = n2;
            return n3;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return -1;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout(), false);
        try {
            if (this.socketChannel == null) {
                throw new IOException("Socket channel is closed");
            }
            int n2 = this.socketChannel.write(byteBuffer);
            if (this.netStat != null) {
                this.netStat.incrementBytesSent(n2);
            }
            int n3 = n2;
            return n3;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return -1;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    @DisableTrace
    public String toString() {
        return "TimeoutSocketChannel[" + this.socket().toString() + "]";
    }

    private void scheduleInterrupt(int n2, boolean bl) {
        if (n2 > 0) {
            this.interruptTask = bl ? TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, n2, Thread.currentThread(), this) : TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, n2, Thread.currentThread());
        }
    }

    private void handleInterrupt() throws InterruptedIOException {
        Thread.interrupted();
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interruptTask != null && this.interruptTask.isInterrupted()) {
            throw new TimeoutInterruptHandler.IOReadTimeoutException("Socket read timed out");
        }
        throw new InterruptedIOException("Socket read interrupted");
    }

    private void cleanup() {
        this.socketChannel = null;
    }

    private void cancelTimeout() {
        if (this.interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
            if (this.interruptTask.isInterrupted()) {
                Thread.interrupted();
            }
            this.interruptTask = null;
        }
    }
}

