/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.TextRandomProvider;

public final class RandomStringGenerator {
    private final int minimumCodePoint;
    private final int maximumCodePoint;
    private final Set<CharacterPredicate> inclusivePredicates;
    private final TextRandomProvider random;

    private RandomStringGenerator(int minimumCodePoint, int maximumCodePoint, Set<CharacterPredicate> inclusivePredicates, TextRandomProvider random) {
        this.minimumCodePoint = minimumCodePoint;
        this.maximumCodePoint = maximumCodePoint;
        this.inclusivePredicates = inclusivePredicates;
        this.random = random;
    }

    private int generateRandomNumber(int minInclusive, int maxInclusive) {
        if (this.random != null) {
            return this.random.nextInt(maxInclusive - minInclusive + 1) + minInclusive;
        }
        return ThreadLocalRandom.current().nextInt(minInclusive, maxInclusive + 1);
    }

    public String generate(int length) {
        if (length == 0) {
            return "";
        }
        Validate.isTrue((length > 0 ? 1 : 0) != 0, (String)"Length %d is smaller than zero.", (long)length);
        StringBuilder builder = new StringBuilder(length);
        long remaining = length;
        block3: do {
            int codePoint = this.generateRandomNumber(this.minimumCodePoint, this.maximumCodePoint);
            switch (Character.getType(codePoint)) {
                case 0: 
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    if (this.inclusivePredicates != null) {
                        boolean matchedFilter = false;
                        for (CharacterPredicate predicate : this.inclusivePredicates) {
                            if (!predicate.test(codePoint)) continue;
                            matchedFilter = true;
                            break;
                        }
                        if (!matchedFilter) continue block3;
                    }
                    builder.appendCodePoint(codePoint);
                    --remaining;
                }
            }
        } while (remaining != 0L);
        return builder.toString();
    }

    public static class Builder
    implements org.apache.commons.text.Builder<RandomStringGenerator> {
        public static final int DEFAULT_MAXIMUM_CODE_POINT = 0x10FFFF;
        public static final int DEFAULT_LENGTH = 0;
        public static final int DEFAULT_MINIMUM_CODE_POINT = 0;
        private int minimumCodePoint = 0;
        private int maximumCodePoint = 0x10FFFF;
        private Set<CharacterPredicate> inclusivePredicates;
        private TextRandomProvider random;

        public Builder withinRange(int minimumCodePoint, int maximumCodePoint) {
            Validate.isTrue((minimumCodePoint <= maximumCodePoint ? 1 : 0) != 0, (String)"Minimum code point %d is larger than maximum code point %d", (Object[])new Object[]{minimumCodePoint, maximumCodePoint});
            Validate.isTrue((minimumCodePoint >= 0 ? 1 : 0) != 0, (String)"Minimum code point %d is negative", (long)minimumCodePoint);
            Validate.isTrue((maximumCodePoint <= 0x10FFFF ? 1 : 0) != 0, (String)"Value %d is larger than Character.MAX_CODE_POINT.", (long)maximumCodePoint);
            this.minimumCodePoint = minimumCodePoint;
            this.maximumCodePoint = maximumCodePoint;
            return this;
        }

        public Builder filteredBy(CharacterPredicate ... predicates) {
            if (predicates == null || predicates.length == 0) {
                this.inclusivePredicates = null;
                return this;
            }
            if (this.inclusivePredicates == null) {
                this.inclusivePredicates = new HashSet<CharacterPredicate>();
            } else {
                this.inclusivePredicates.clear();
            }
            for (CharacterPredicate predicate : predicates) {
                this.inclusivePredicates.add(predicate);
            }
            return this;
        }

        public Builder usingRandom(TextRandomProvider random) {
            this.random = random;
            return this;
        }

        @Override
        public RandomStringGenerator build() {
            return new RandomStringGenerator(this.minimumCodePoint, this.maximumCodePoint, this.inclusivePredicates, this.random);
        }
    }
}

