/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.impl.DSIErrorResult;
import com.amazon.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResults;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.ExpectedResult;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.List;

public class PGExecutionResults
extends ExecutionResults {
    private final ILogger m_log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PGExecutionResults(List<PGMessagingContext> list, int n, ILogger iLogger, ExpectedResult expectedResult, int n2, boolean bl, boolean bl2) throws ErrorException {
        this.m_log = iLogger;
        ArrayList<ExecutionResult> arrayList = null;
        try {
            for (PGMessagingContext pGMessagingContext : list) {
                try {
                    boolean bl3 = false;
                    while (!bl3) {
                        try {
                            IInboundMessage iInboundMessage;
                            if (pGMessagingContext.m_totalMessageCount > pGMessagingContext.m_currentMessageCount && (iInboundMessage = pGMessagingContext.peekNextMessage(n2)) instanceof ErrorResponse) {
                                pGMessagingContext.getErrorResponse();
                            }
                            if (pGMessagingContext.m_isPreparedStatement && null == pGMessagingContext.m_readyForQueryFromPipelineForPrepare) {
                                pGMessagingContext.getReadyForQuery();
                            }
                            if (null != pGMessagingContext.getNoData()) {
                                if (bl2) {
                                    this.addExecutionResult(new ExecutionResult(new DSISimpleRowCountResult(0L)));
                                    bl3 = true;
                                    continue;
                                }
                                pGMessagingContext.getReadyForQuery();
                                if (!bl) {
                                    if (null == arrayList) {
                                        arrayList = new ArrayList();
                                    }
                                    arrayList.add(this.buildRowCount(expectedResult, pGMessagingContext));
                                    bl3 = true;
                                    continue;
                                }
                                this.addExecutionResult(this.buildRowCount(expectedResult, pGMessagingContext));
                                bl3 = true;
                                continue;
                            }
                            if (null != pGMessagingContext.getRowDescription() && pGMessagingContext.getRowDescription().getNumberOfFields() > 0) {
                                this.addExecutionResult(this.buildResultSet(expectedResult, pGMessagingContext));
                                bl3 = true;
                                continue;
                            }
                            if (!bl) {
                                if (null == arrayList) {
                                    arrayList = new ArrayList<ExecutionResult>();
                                }
                                arrayList.add(this.buildRowCount(expectedResult, pGMessagingContext));
                                bl3 = true;
                                continue;
                            }
                            this.addExecutionResult(this.buildRowCount(expectedResult, pGMessagingContext));
                            bl3 = true;
                        }
                        catch (ErrorException errorException) {
                            DSIErrorResult dSIErrorResult = new DSIErrorResult(errorException);
                            if (expectedResult == ExpectedResult.SingleRowCount || null != pGMessagingContext.getNoData()) {
                                this.addExecutionResult(new ExecutionResult(dSIErrorResult, false));
                                bl3 = true;
                                throw errorException;
                            } else {
                                this.addExecutionResult(new ExecutionResult(dSIErrorResult, true));
                                bl3 = true;
                            }
                            throw errorException;
                        }
                    }
                }
                catch (Exception exception) {
                    ErrorException errorException = pGMessagingContext.receivedFatalExeption();
                    if (null != errorException) {
                        throw errorException;
                    }
                    if (!(exception instanceof ErrorException)) throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), (Throwable)exception);
                    throw (ErrorException)exception;
                    return;
                }
            }
        }
        finally {
            if (bl2) {
                return;
            }
            if (!bl && null != arrayList) {
                long l = 0L;
                for (ExecutionResult executionResult : arrayList) {
                    if (!(executionResult.getResult() instanceof DSISimpleRowCountResult)) continue;
                    DSISimpleRowCountResult dSISimpleRowCountResult = (DSISimpleRowCountResult)executionResult.getResult();
                    long l2 = dSISimpleRowCountResult.getRowCount();
                    if (PGCoreUtils.willAdditionOverflow(l, l2)) {
                        l = Long.MAX_VALUE;
                        continue;
                    }
                    l += l2;
                }
                this.addExecutionResult(new ExecutionResult(new DSISimpleRowCountResult(l)));
            }
        }
    }

    private ExecutionResult buildResultSet(ExpectedResult expectedResult, PGMessagingContext pGMessagingContext) {
        if (null != expectedResult && ExpectedResult.SingleRowCount == expectedResult) {
            return new ExecutionResult(new DSIErrorResult(PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(JDBCMessageKey.NO_ROWCOUNT_GENERATED.name(), pGMessagingContext.m_query, ExceptionType.DEFAULT)), false);
        }
        PGResultSet pGResultSet = new PGResultSet(pGMessagingContext, this.m_log);
        return new ExecutionResult(pGResultSet);
    }

    private ExecutionResult buildRowCount(ExpectedResult expectedResult, PGMessagingContext pGMessagingContext) throws ErrorException {
        if (null != expectedResult && ExpectedResult.SingleResult == expectedResult) {
            return new ExecutionResult(new DSIErrorResult(PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(JDBCMessageKey.NO_RESULTSET_GENERATED.name(), pGMessagingContext.m_query, ExceptionType.DEFAULT)), true);
        }
        CommandComplete commandComplete = pGMessagingContext.getCommandCompleteMessage();
        if (null == commandComplete) {
            LogUtilities.logFatal("CommandComplete is null", this.m_log);
            return new ExecutionResult(new DSIErrorResult(PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(JDBCMessageKey.NO_ROWCOUNT_GENERATED.name(), pGMessagingContext.m_query, ExceptionType.DEFAULT)), true);
        }
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("DSISimpleRowCountResult set to " + commandComplete.getNumRows(), this.m_log);
        }
        return new ExecutionResult(new DSISimpleRowCountResult(commandComplete.getNumRows()));
    }
}

