/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.beans.Anchor;
import com.install4j.api.beans.Bean;
import com.install4j.api.context.WizardIndex;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.screens.BackButtonType;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.FormComponentContainerBeanConfig;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ScreenBeanConfig
extends FormComponentContainerBeanConfig {
    private Screen instance;
    private List<AbstractBeanConfig> actionConfigs;
    private String preActivationClassName = "";
    private String postActivationClassName = "";
    private String validationClassName = "";
    private BackButtonType backButtonType = BackButtonType.SAFE;
    private boolean finishScreen = false;
    private int wizardIndexChangeType = 1;
    private String wizardIndexKey = "";
    private String styleId = "";
    private WizardIndex wizardIndex;

    public Screen getOrInstantiateScreen(boolean suppressErrors) {
        if (this.instance == null) {
            this.instance = (Screen)this.instantiateBean(suppressErrors);
        }
        return this.instance;
    }

    public BackButtonType getBackButtonType() {
        return this.backButtonType;
    }

    public boolean isFinishScreen() {
        return this.finishScreen;
    }

    public String getPreActivationClassName() {
        return this.preActivationClassName;
    }

    public String getPostActivationClassName() {
        return this.postActivationClassName;
    }

    public String getValidationClassName() {
        return this.validationClassName;
    }

    public List<AbstractBeanConfig> getActionConfigs() {
        return this.actionConfigs;
    }

    public int getWizardIndexChangeType() {
        return this.wizardIndexChangeType;
    }

    public String getWizardIndexKey() {
        return this.wizardIndexKey;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public WizardIndex getWizardIndex() {
        return this.wizardIndex;
    }

    @Override
    public boolean isInstantiated() {
        return this.instance != null;
    }

    @Override
    protected void clearInstance() {
        this.instance = null;
    }

    @Override
    protected void setBean(Bean bean) {
        this.instance = (Screen)bean;
    }

    @Override
    protected void read(Element element) {
        super.read(element);
        this.backButtonType = this.readAttribute(element, "backButtonType", this.backButtonType);
        this.finishScreen = ScreenBeanConfig.readAttribute(element, "finishScreen", this.finishScreen);
        this.validationClassName = ScreenBeanConfig.readAttribute(element, "validationClass", this.validationClassName);
        this.preActivationClassName = ScreenBeanConfig.readAttribute(element, "preActivationClass", this.preActivationClassName);
        this.postActivationClassName = ScreenBeanConfig.readAttribute(element, "postActivationClass", this.postActivationClassName);
        this.wizardIndexChangeType = ScreenBeanConfig.readAttribute(element, "wizardIndexChangeType", this.wizardIndexChangeType);
        this.wizardIndexKey = ScreenBeanConfig.readAttribute(element, "wizardIndexKey", this.wizardIndexKey);
        this.styleId = ScreenBeanConfig.readAttribute(element, "styleId", this.styleId);
        this.readWizardIndex(element);
        this.readActionConfigs(element);
    }

    private void readActionConfigs(Element element) {
        LinkedList<AbstractBeanConfig> actionConfigs = new LinkedList<AbstractBeanConfig>();
        Element actionsElement = ScreenBeanConfig.findChild(element, "actions");
        if (actionsElement != null) {
            for (Element beanElement : ScreenBeanConfig.childElements(actionsElement)) {
                AbstractBeanConfig beanConfig = ScreenBeanConfig.readNestedBeanConfig(beanElement);
                if (beanConfig == null) continue;
                actionConfigs.add(beanConfig);
            }
        }
        this.actionConfigs = Collections.unmodifiableList(actionConfigs);
    }

    private void readWizardIndex(Element element) {
        String initialKey;
        Anchor anchor;
        Element wizardElement = XmlHelper.findChild(element, "wizardIndex");
        if (wizardElement == null) {
            return;
        }
        LinkedHashMap<String, String> steps = this.readWizardSteps(wizardElement);
        if (steps == null) {
            return;
        }
        int stepCount = steps.size();
        if (stepCount == 0) {
            return;
        }
        String[] keys = new String[stepCount];
        String[] stepNames = new String[stepCount];
        int i = 0;
        for (Map.Entry<String, String> entry : steps.entrySet()) {
            keys[i] = entry.getKey();
            stepNames[i] = entry.getValue();
            ++i;
        }
        this.wizardIndex = new WizardIndex(stepNames, keys);
        this.wizardIndex.partiallyDefined(ScreenBeanConfig.readAttribute(wizardElement, "partiallyDefined", this.wizardIndex.isPartiallyDefined()));
        this.wizardIndex.maxWidth(ScreenBeanConfig.readAttribute(wizardElement, "maxWidth", this.wizardIndex.getMaxWidth()));
        this.wizardIndex.minWidth(ScreenBeanConfig.readAttribute(wizardElement, "minWidth", this.wizardIndex.getMinWidth()));
        this.wizardIndex.numbered(ScreenBeanConfig.readAttribute(wizardElement, "numbered", this.wizardIndex.isNumbered()));
        this.wizardIndex.background(ScreenBeanConfig.readAttribute(wizardElement, "background", this.wizardIndex.getBackground()));
        this.wizardIndex.foreground(ScreenBeanConfig.readAttribute(wizardElement, "foreground", this.wizardIndex.getForeground()));
        String backgroundImage = ScreenBeanConfig.readFileAttribute(wizardElement, "backgroundImage", null);
        if (backgroundImage != null && backgroundImage.length() > 0) {
            this.wizardIndex.backgroundImage(new File(backgroundImage));
        }
        if ((anchor = Anchor.getByValue(ScreenBeanConfig.readAttribute(wizardElement, "backgroundImageAnchor", this.wizardIndex.getBackgroundImageAnchor().getValue()))) != null) {
            this.wizardIndex.backgroundImageAnchor(anchor);
        }
        if ((initialKey = ScreenBeanConfig.readAttribute(wizardElement, "initialKey", "")).length() > 0) {
            this.wizardIndex.initialKey(initialKey);
        }
    }

    private LinkedHashMap<String, String> readWizardSteps(Element wizardElement) {
        Element stepsElement = XmlHelper.findChild(wizardElement, "steps");
        LinkedHashMap<String, String> steps = new LinkedHashMap<String, String>();
        if (stepsElement != null) {
            for (Element stepElement : ScreenBeanConfig.childElements(stepsElement)) {
                String key = ScreenBeanConfig.readAttribute(stepElement, "key", "");
                String name = ScreenBeanConfig.readAttribute(stepElement, "name", "");
                if (key.length() <= 0 || name.length() <= 0) continue;
                steps.put(key, name);
            }
        }
        return steps;
    }

    @Override
    public void addAllTo(Map<String, AbstractBeanConfig> id2BeanConfig) {
        super.addAllTo(id2BeanConfig);
        for (AbstractBeanConfig actionConfig : this.actionConfigs) {
            actionConfig.addAllTo(id2BeanConfig);
        }
    }
}

