/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.windows.WinUser;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.platform.win32.ObjectPicker;
import com.install4j.runtime.util.StandardDialog;
import com.install4j.runtime.util.TextAndButtonPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class CreateUserDialog
extends StandardDialog {
    private JTextField txtUserName;
    private JTextField txtPassword;
    private JTextField txtRepeatPassword;
    private JTextField txtDescription;
    private JTextField txtGroupName;
    private JButton btnSelectGroup;
    private WinUser.AddUserResult result;

    public CreateUserDialog(Window parentWindow) {
        super(parentWindow);
        this.init();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.btnSelectGroup) {
            this.doSelectGroup();
        } else {
            super.actionPerformed(event);
        }
    }

    public WinUser.AddUserResult getResult() {
        return this.result;
    }

    public String getPassword() {
        return this.txtPassword.getText().trim();
    }

    @Override
    protected int getFrameHeight() {
        return -1;
    }

    @Override
    protected int getFrameWidth() {
        return 450;
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.txtUserName = new JTextField();
        this.txtPassword = new JPasswordField(20);
        this.txtRepeatPassword = new JPasswordField(20);
        this.txtDescription = new JTextField();
        this.txtGroupName = new JTextField();
        this.btnSelectGroup = GUIHelper.adjustButton(new JButton(Messages.getString(".ButtonBrowse")));
    }

    @Override
    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.btnSelectGroup.addActionListener(this);
    }

    @Override
    protected void setupComponent() {
        super.setupComponent();
        this.setTitle(Messages.getString(".ButtonCreateUser"));
    }

    @Override
    protected void doOk() {
        if (this.checkTextField(this.txtUserName) && this.checkTextField(this.txtPassword) && this.checkPasswordsMatch()) {
            try {
                this.result = WinUser.addUser(this.txtUserName.getText().trim(), this.getPassword(), this.txtDescription.getText().trim(), WinUser.GroupCreationMode.CREATE_IF_NECESSARY, this.txtGroupName.getText().trim(), "");
                if (this.result.getType() != WinUser.AddUserResultType.SUCCESS) {
                    this.showCreationError();
                    return;
                }
            }
            catch (Exception e) {
                this.showCreationError();
                return;
            }
            GUIHelper.showMessage(this, Messages.getString(".CreateUserSuccess"), 1);
            super.doOk();
        }
    }

    private boolean checkPasswordsMatch() {
        if (!Objects.equals(this.txtPassword.getText(), this.txtRepeatPassword.getText())) {
            GUIHelper.showMessage(this.getOwner(), Messages.getString(".PasswordsDoNotMatch"), 2);
            this.txtPassword.requestFocus();
            return false;
        }
        return true;
    }

    private void showCreationError() {
        String message = null;
        if (this.result.getType() == WinUser.AddUserResultType.ERROR_ACCESS_DENIED) {
            message = Messages.getString(".CreateUserErrorAccessDenied");
        } else if (this.result.getType() == WinUser.AddUserResultType.ERROR_GROUP_EXISTS) {
            message = Messages.getString(".CreateUserErrorGroupExists");
        } else if (this.result.getType() == WinUser.AddUserResultType.ERROR_GROUP_NOT_FOUND) {
            message = Messages.getString(".CreateUserErrorGroupNotFound");
        } else if (this.result.getType() == WinUser.AddUserResultType.ERROR_PASSWORD_REQUIREMENTS) {
            message = Messages.getString(".CreateUserErrorPasswordRequirements");
        } else if (this.result.getType() == WinUser.AddUserResultType.ERROR_USER_EXISTS) {
            message = Messages.getString(".CreateUserErrorUserExists");
        } else if (this.result.getType() == WinUser.AddUserResultType.ERROR_BAD_USER_NAME) {
            message = Messages.getString(".CreateUserErrorBadUserName");
        }
        String fullMessage = Messages.getString(".CreateUserError");
        if (message != null) {
            fullMessage = fullMessage + "\n\n" + message;
        }
        GUIHelper.showMessage(this, fullMessage, 0);
    }

    @Override
    protected void addScreenContent(JPanel panel) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 21;
        gc.insets = new Insets(0, 0, 5, 0);
        gc.gridwidth = 2;
        gc.insets.bottom = 15;
        panel.add((Component)new JLabel(Messages.getString(".CreateUserHeader")), gc);
        ++gc.gridy;
        gc.gridwidth = 1;
        gc.insets.bottom = 5;
        gc.insets.right = 5;
        panel.add((Component)new JLabel(Messages.getString(".UserNameLabel")), gc);
        ++gc.gridy;
        panel.add((Component)new JLabel(Messages.getString(".DescriptionLabel")), gc);
        ++gc.gridy;
        panel.add((Component)new JLabel(Messages.getString(".LocalGroupNameLabel")), gc);
        ++gc.gridy;
        panel.add((Component)new JLabel(Messages.getString(".PasswordLabel")), gc);
        ++gc.gridy;
        panel.add((Component)new JLabel(Messages.getString(".RepeatPasswordLabel")), gc);
        gc.insets.right = 0;
        gc.gridy -= 4;
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        panel.add((Component)this.txtUserName, gc);
        ++gc.gridy;
        panel.add((Component)this.txtDescription, gc);
        ++gc.gridy;
        panel.add((Component)new TextAndButtonPanel(this.txtGroupName, this.btnSelectGroup), gc);
        ++gc.gridy;
        gc.fill = 0;
        panel.add((Component)this.txtPassword, gc);
        ++gc.gridy;
        panel.add((Component)this.txtRepeatPassword, gc);
    }

    @Override
    protected boolean isFillVertical() {
        return false;
    }

    private void doSelectGroup() {
        ObjectPicker.Result[] results = ObjectPicker.show(false, true, false, false, true);
        if (results != null && results.length > 0) {
            this.txtGroupName.setText(results[0].getName());
        }
    }
}

