/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.alert.InputPopup;
import com.jidesoft.animation.CustomAnimation;
import com.jidesoft.grid.QuickFilterField;
import com.jidesoft.list.QuickListFilterField;
import com.jidesoft.list.SortableListModel;
import com.jidesoft.shortcut.A;
import com.jidesoft.shortcut.B;
import com.jidesoft.shortcut.C;
import com.jidesoft.shortcut.CommandListCellRenderer;
import com.jidesoft.shortcut.D;
import com.jidesoft.shortcut.Shortcut;
import com.jidesoft.shortcut.ShortcutField;
import com.jidesoft.shortcut.ShortcutSchema;
import com.jidesoft.shortcut.ShortcutSchemaManager;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class ShortcutEditor
extends JPanel {
    private ShortcutSchemaManager \u0107;
    private String[] \u0104;
    private String \u0103;
    private ShortcutSchema \u0101;
    protected JList _schemaList;
    protected JButton _setActiveButton;
    protected JButton _copyButton;
    protected JButton _deleteButton;
    protected JLabel _parentSchemaLabel;
    protected QuickFilterField _filterField;
    protected JList _commandsList;
    protected JCheckBox _overriddenOnlyCheckBox;
    protected JComboBox _shortcutsComboBox;
    protected B _shortcutLabel;
    protected JButton _removeButton;
    protected ShortcutField _shortcutField;
    protected JButton _assignButton;
    protected JComboBox _contextComboBox;
    protected DefaultListModel _schemaListModel;
    private boolean \u0105 = true;
    private boolean \u0106 = true;
    private boolean \u0102;

    public ShortcutEditor(ShortcutSchemaManager shortcutSchemaManager) {
        this(shortcutSchemaManager, null);
    }

    public ShortcutEditor(ShortcutSchemaManager shortcutSchemaManager, boolean bl) {
        this(shortcutSchemaManager, null, bl);
    }

    public ShortcutEditor(ShortcutSchemaManager shortcutSchemaManager, String[] stringArray) {
        this(shortcutSchemaManager, stringArray, true);
    }

    public ShortcutEditor(ShortcutSchemaManager shortcutSchemaManager, String[] stringArray, boolean bl) {
        this.setLayout(new JideBoxLayout(this, 1, 10));
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.\u0105 = bl;
        this.\u0107 = shortcutSchemaManager;
        this.\u0104 = stringArray;
        this.initComponents();
        this.initData(false);
        this.updateEditable();
    }

    protected void initComponents() {
        this.add((Component)this.createSchemaPanel(), "fix");
        this.add((Component)this.createShortcutFilterPanel(), "fix");
        this.add((Component)this.createShortcutListPanel(), "flexible");
        this.add((Component)this.createExistingShortcutPanel(), "fix");
        this.add((Component)this.createEditingShortcutPanel(), "fix");
        this.add((Component)this.createConflictingShortcutPanel(), "fix");
    }

    protected JPanel createSchemaPanel() {
        final ResourceBundle resourceBundle = this.getResourceBundle();
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 4, 4));
        this._setActiveButton = new JButton(resourceBundle.getString("Shortcut.setActive.text"));
        this._setActiveButton.setMnemonic(resourceBundle.getString("Shortcut.setActive.mnemonic").charAt(0));
        jPanel2.add(this._setActiveButton);
        this._setActiveButton.addActionListener(new AbstractAction(){
            private static final long \u0102 = 5800581241532011134L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ShortcutEditor.this.getSelectedShortcutSchema() != null) {
                    ShortcutEditor.this.\u0107.setActiveShortcutSchemaName(ShortcutEditor.this.getSelectedShortcutSchema().getName());
                    ShortcutEditor.this._schemaList.repaint();
                }
            }
        });
        this._copyButton = new JButton(resourceBundle.getString("Shortcut.copy.text"));
        this._copyButton.setMnemonic(resourceBundle.getString("Shortcut.copy.mnemonic").charAt(0));
        jPanel2.add(this._copyButton);
        this._copyButton.addActionListener(new AbstractAction(){
            private static final long \u0103 = 3985706300940359099L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final InputPopup inputPopup = new InputPopup(resourceBundle.getString("Shortcut.schemaName.text"), resourceBundle.getString("Shortcut.input.enter"), ShortcutEditor.this.\u0101.getName());
                inputPopup.setOwner(ShortcutEditor.this._copyButton);
                inputPopup.removeExcludedComponent(ShortcutEditor.this._copyButton);
                Point point = ShortcutEditor.this._copyButton.getLocationOnScreen();
                inputPopup.getTextField().addActionListener(new AbstractAction(){
                    private static final long \u0103 = -6247202070430491504L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JTextField jTextField = (JTextField)actionEvent.getSource();
                        String string = jTextField.getText();
                        if (string != null && string.trim().length() > 0) {
                            inputPopup.getStatusLabel().setForeground(null);
                            inputPopup.getStatusLabel().setText(resourceBundle.getString("Shortcut.schemaName.text"));
                            inputPopup.getStatusLabel().setDisplayedMnemonic(resourceBundle.getString("Shortcut.schemaName.mnemonic").charAt(0));
                            String string2 = string.trim();
                            ShortcutSchema[] shortcutSchemaArray = ShortcutEditor.this.\u0107.getShortcutSchemas();
                            for (ShortcutSchema object : shortcutSchemaArray) {
                                if (!object.getName().equals(string2)) continue;
                                inputPopup.getStatusLabel().setForeground(Color.RED);
                                inputPopup.getStatusLabel().setText(MessageFormat.format(resourceBundle.getString("Shortcut.nameIsUsed.text"), string2));
                                return;
                            }
                            ShortcutSchema shortcutSchema = new ShortcutSchema(string2);
                            shortcutSchema.setParent(ShortcutEditor.this.\u0101);
                            ShortcutEditor.this.\u0107.addShortcutSchema(shortcutSchema);
                            ShortcutEditor.this.\u0107.setActiveShortcutSchemaName(string2);
                            int n2 = ShortcutEditor.this._schemaList.getModel().getSize() - 1;
                            if (n2 != -1) {
                                CustomAnimation customAnimation = new CustomAnimation(1, 101, 5, 10);
                                Rectangle rectangle = ShortcutEditor.this._schemaList.getCellBounds(n2, n2);
                                Point point = ShortcutEditor.this._schemaList.getLocationOnScreen();
                                point.y += rectangle.y + rectangle.height + rectangle.height / 2;
                                point.x += rectangle.x + 10;
                                customAnimation.setEndLocation(point);
                                inputPopup.setHideAnimation(customAnimation);
                            }
                            inputPopup.hidePopup();
                            ShortcutEditor.this.initData(false);
                        } else {
                            inputPopup.getStatusLabel().setForeground(Color.RED);
                            inputPopup.getStatusLabel().setText(resourceBundle.getString("Shortcut.nameIsEmpty.text"));
                        }
                    }
                });
                inputPopup.setTimeout(0);
                CustomAnimation customAnimation = new CustomAnimation(0, 101, 5, 10);
                customAnimation.setStartLocation(new Point(point.x + ShortcutEditor.this._copyButton.getWidth() / 2, point.y + ShortcutEditor.this._copyButton.getHeight() / 2));
                inputPopup.setShowAnimation(customAnimation);
                inputPopup.showPopup(point.x - inputPopup.getPreferredSize().width + ShortcutEditor.this._copyButton.getWidth(), point.y + 30);
            }
        });
        this._deleteButton = new JButton(resourceBundle.getString("Shortcut.delete.text"));
        this._deleteButton.setMnemonic(resourceBundle.getString("Shortcut.delete.mnemonic").charAt(0));
        jPanel2.add(this._deleteButton);
        this._deleteButton.addActionListener(new AbstractAction(){
            private static final long \u0102 = 7267931183237330300L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ShortcutEditor.this.getSelectedShortcutSchema() != null) {
                    ShortcutEditor.this.\u0107.removeShortcutSchema(ShortcutEditor.this.getSelectedShortcutSchema().getName());
                    ShortcutEditor.this.initData(false);
                }
            }
        });
        jPanel.add((Component)JideSwingUtilities.createTopPanel(jPanel2), "After");
        ShortcutSchema[] shortcutSchemaArray = this.\u0107.getShortcutSchemas();
        this._schemaListModel = new DefaultListModel();
        for (ShortcutSchema shortcutSchema : shortcutSchemaArray) {
            this._schemaListModel.addElement(shortcutSchema);
        }
        this._schemaList = new JList(){

            @Override
            public int getNextMatch(String string, int n2, Position.Bias bias) {
                return -1;
            }
        };
        this._schemaList.setSelectionMode(0);
        this._schemaList.setCellRenderer(new C());
        this._schemaList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ShortcutEditor.this.selectedSchemaChanged();
            }
        });
        this._schemaList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n2;
                if (mouseEvent.getClickCount() == 2 && (n2 = ShortcutEditor.this._schemaList.getSelectedIndex()) != -1) {
                    final InputPopup inputPopup = new InputPopup(resourceBundle.getString("Shortcut.schemaName.text"), resourceBundle.getString("Shortcut.input.enter"), ShortcutEditor.this.\u0101.getName());
                    inputPopup.setOwner(ShortcutEditor.this._schemaList);
                    inputPopup.removeExcludedComponent(ShortcutEditor.this._schemaList);
                    inputPopup.getTextField().addActionListener(new AbstractAction(){
                        private static final long \u0103 = -7637647542192041126L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            JTextField jTextField = (JTextField)actionEvent.getSource();
                            String string = jTextField.getText();
                            if (string != null && string.trim().length() > 0) {
                                ShortcutSchema[] shortcutSchemaArray;
                                inputPopup.getStatusLabel().setForeground(null);
                                String string2 = string.trim();
                                for (ShortcutSchema object : shortcutSchemaArray = ShortcutEditor.this.\u0107.getShortcutSchemas()) {
                                    if (!object.getName().equals(string2)) continue;
                                    inputPopup.getStatusLabel().setForeground(Color.RED);
                                    inputPopup.getStatusLabel().setText(MessageFormat.format(resourceBundle.getString("Shortcut.nameIsUsed.text"), string2));
                                    return;
                                }
                                ShortcutEditor.this.\u0107.renameSchema(ShortcutEditor.this.\u0101.getName(), string2);
                                int n2 = ShortcutEditor.this._schemaList.getSelectedIndex();
                                if (n2 != -1) {
                                    CustomAnimation customAnimation = new CustomAnimation(1, 101, 5, 10);
                                    Rectangle rectangle = ShortcutEditor.this._schemaList.getCellBounds(n2, n2);
                                    Point point = ShortcutEditor.this._schemaList.getLocationOnScreen();
                                    point.y += rectangle.y + rectangle.height / 2;
                                    point.x += rectangle.x + 10;
                                    customAnimation.setEndLocation(point);
                                    inputPopup.setHideAnimation(customAnimation);
                                }
                                inputPopup.hidePopup();
                                ShortcutEditor.this.initData(true);
                            } else {
                                inputPopup.getStatusLabel().setForeground(Color.RED);
                                inputPopup.getStatusLabel().setText(resourceBundle.getString("Shortcut.nameIsEmpty.text"));
                            }
                        }
                    });
                    inputPopup.setTimeout(0);
                    CustomAnimation customAnimation = new CustomAnimation(0, 101, 5, 10);
                    int n3 = ShortcutEditor.this._schemaList.getSelectedIndex();
                    Rectangle rectangle = ShortcutEditor.this._schemaList.getCellBounds(n3, n3);
                    Point point = ShortcutEditor.this._schemaList.getLocationOnScreen();
                    point.y += rectangle.y + rectangle.height + 5;
                    point.x += rectangle.x + 10;
                    customAnimation.setStartLocation(point);
                    inputPopup.setShowAnimation(customAnimation);
                    inputPopup.showPopup(point.x, point.y);
                }
            }
        });
        this._schemaList.setVisibleRowCount(5);
        jPanel.add(new JScrollPane(this._schemaList));
        JLabel jLabel = new JLabel(resourceBundle.getString("Shortcut.schemas.text"));
        jLabel.setDisplayedMnemonic(resourceBundle.getString("Shortcut.schemas.mnemonic").charAt(0));
        jLabel.setLabelFor(this._schemaList);
        jPanel.add((Component)jLabel, "First");
        this._parentSchemaLabel = new JLabel();
        jPanel.add((Component)this._parentSchemaLabel, "Last");
        return jPanel;
    }

    protected void selectedSchemaChanged() {
        ShortcutSchema shortcutSchema;
        int n2 = this._schemaList.getSelectedIndex();
        if (n2 != -1) {
            shortcutSchema = (ShortcutSchema)this._schemaList.getModel().getElementAt(n2);
            this._copyButton.setEnabled(true);
            this._setActiveButton.setEnabled(!shortcutSchema.isActive());
        } else {
            shortcutSchema = null;
            this._copyButton.setEnabled(false);
            this._setActiveButton.setEnabled(false);
        }
        if (shortcutSchema != null && !shortcutSchema.equals(this.getSelectedShortcutSchema()) || shortcutSchema == null && this.getSelectedShortcutSchema() != null) {
            this.setSelectedShortcutSchema(shortcutSchema);
            this.updateCommandList();
            if (this._parentSchemaLabel != null) {
                if (shortcutSchema != null && shortcutSchema.getParent() != null) {
                    this._parentSchemaLabel.setText(MessageFormat.format(this.getResourceBundle().getString("Shortcut.basedOn.text"), shortcutSchema.getParent().getName()));
                } else {
                    this._parentSchemaLabel.setText(MessageFormat.format(this.getResourceBundle().getString("Shortcut.basedOn.text"), "<none>"));
                }
            }
        }
    }

    protected JPanel createShortcutFilterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        this._overriddenOnlyCheckBox = new JCheckBox(this.getResourceBundle().getString("Shortcut.overriddenOnly.text"));
        this._overriddenOnlyCheckBox.setMnemonic(this.getResourceBundle().getString("Shortcut.overriddenOnly.mnemonic").charAt(0));
        this._overriddenOnlyCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ShortcutEditor.this.updateCommandList();
            }
        });
        jPanel.add((Component)this._overriddenOnlyCheckBox, "After");
        this._filterField = this.createFilterField();
        jPanel.add((Component)this._filterField, "Center");
        JLabel jLabel = new JLabel(this.getResourceBundle().getString("Shortcut.fitler.text"));
        jLabel.setDisplayedMnemonic(this.getResourceBundle().getString("Shortcut.fitler.mnemonic").charAt(0));
        jLabel.setLabelFor(this._filterField);
        jPanel.add((Component)jLabel, "First");
        return jPanel;
    }

    protected QuickFilterField createFilterField() {
        QuickListFilterField quickListFilterField = new QuickListFilterField();
        quickListFilterField.setFromStart(true);
        return quickListFilterField;
    }

    protected void initData(boolean bl) {
        Object e2 = this._schemaList.getSelectedValue();
        this._schemaList.setListData(this.\u0107.getShortcutSchemas());
        if (bl && e2 != null) {
            this._schemaList.setSelectedValue(e2, true);
        } else {
            this._schemaList.setSelectedValue(this.\u0107.getActiveShortcutSchema(), true);
        }
    }

    protected void updateCommandList() {
        QuickFilterField quickFilterField = this.getFilterField();
        if (quickFilterField != null && this._commandsList != null) {
            this.updateFilterField(quickFilterField, this.\u0101());
            this._commandsList.clearSelection();
            quickFilterField.applyFilter();
            this.updateCommandListModel(quickFilterField);
            this._commandsList.putClientProperty("shortcutSchema", this.getSelectedShortcutSchema());
        }
        this.updateEditable();
    }

    protected void updateCommandListModel(QuickFilterField quickFilterField) {
        if (quickFilterField instanceof QuickListFilterField && ((QuickListFilterField)quickFilterField).getDisplayListModel() != null) {
            this._commandsList.setModel(((QuickListFilterField)quickFilterField).getDisplayListModel());
        }
    }

    protected void updateFilterField(QuickFilterField quickFilterField, ListModel listModel) {
        if (quickFilterField instanceof QuickListFilterField) {
            ((QuickListFilterField)quickFilterField).setListModel(listModel);
        }
    }

    protected JPanel createShortcutListPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        this._commandsList = new JList();
        SearchableUtils.installSearchable(this._commandsList);
        this._commandsList.setVisibleRowCount(8);
        this._commandsList.setCellRenderer(this.createListCellRenderer());
        this._commandsList.setSelectionMode(0);
        this.updateCommandListModel(this.getFilterField());
        jPanel.add(new JScrollPane(this._commandsList));
        this._commandsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ShortcutEditor.this.selectedCommandChanged(false);
            }
        });
        return jPanel;
    }

    protected ListCellRenderer createListCellRenderer() {
        return new CommandListCellRenderer(this);
    }

    protected void selectedCommandChanged(boolean bl) {
        if (this._commandsList != null && this.getSelectedShortcutSchema() != null) {
            int n2 = this._commandsList.getSelectedIndex();
            if (this._shortcutsComboBox != null) {
                if (n2 != -1) {
                    this.setSelectedCommand((String)this._commandsList.getModel().getElementAt(n2));
                    Shortcut[] shortcutArray = this.getSelectedShortcutSchema().getShortcuts(this.getSelectedCommand());
                    this._shortcutsComboBox.setModel(new DefaultComboBoxModel<Shortcut>(shortcutArray));
                    if (bl) {
                        this._shortcutsComboBox.setSelectedIndex(this._shortcutsComboBox.getModel().getSize() - 1);
                    }
                } else {
                    this.setSelectedCommand(null);
                    this._shortcutsComboBox.setModel(new DefaultComboBoxModel());
                }
            } else if (this._shortcutLabel != null) {
                if (n2 != -1) {
                    this.setSelectedCommand((String)this._commandsList.getModel().getElementAt(n2));
                    Shortcut[] shortcutArray = this.getSelectedShortcutSchema().getShortcuts(this.getSelectedCommand());
                    if (shortcutArray.length > 0) {
                        this._shortcutLabel.\u0101(shortcutArray[0]);
                    } else {
                        this._shortcutLabel.\u0101(null);
                    }
                } else {
                    this.setSelectedCommand(null);
                    this._shortcutLabel.\u0101(null);
                }
            }
            this._shortcutField.clearShortcut();
            this._commandsList.repaint();
            this.updateEditable();
        }
    }

    ListModel \u0101() {
        if (this.getSelectedShortcutSchema() != null) {
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            List<String> list = this._overriddenOnlyCheckBox != null && !this._overriddenOnlyCheckBox.isSelected() ? this.getSelectedShortcutSchema().getShortcutKeys() : this.getSelectedShortcutSchema().getLocalShortcutKeys();
            for (String string : list) {
                defaultListModel.addElement(string);
            }
            return new SortableListModel(defaultListModel);
        }
        return new DefaultListModel();
    }

    protected JPanel createExistingShortcutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        if (this.\u0105) {
            this._shortcutsComboBox = new JComboBox();
            this._shortcutsComboBox.setRenderer(new D(this._shortcutsComboBox.getRenderer()));
            jPanel.add(this._shortcutsComboBox);
        } else {
            this._shortcutLabel = new B();
            jPanel.add(this._shortcutLabel);
        }
        this._removeButton = new JButton(this.getResourceBundle().getString("Shortcut.remove.text"));
        this._removeButton.setMnemonic(this.getResourceBundle().getString("Shortcut.remove.mnemonic").charAt(0));
        this._removeButton.addActionListener(new AbstractAction(){
            private static final long \u0102 = -7301524924528255252L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Shortcut shortcut = null;
                if (ShortcutEditor.this._shortcutsComboBox != null) {
                    shortcut = (Shortcut)ShortcutEditor.this._shortcutsComboBox.getSelectedItem();
                } else if (ShortcutEditor.this._shortcutLabel != null) {
                    shortcut = ShortcutEditor.this._shortcutLabel.\u0102();
                }
                if (shortcut != null && ShortcutEditor.this.getSelectedCommand() != null) {
                    ShortcutEditor.this.getSelectedShortcutSchema().removeShortcut(ShortcutEditor.this.getSelectedCommand(), shortcut);
                    ShortcutEditor.this.selectedCommandChanged(false);
                }
            }
        });
        jPanel.add((Component)this._removeButton, "After");
        JLabel jLabel = new JLabel(this.getResourceBundle().getString("Shortcut.existing.text"));
        jLabel.setDisplayedMnemonic(this.getResourceBundle().getString("Shortcut.existing.mnemonic").charAt(0));
        if (this._shortcutsComboBox != null) {
            jLabel.setLabelFor(this._shortcutsComboBox);
        }
        jPanel.add((Component)jLabel, "First");
        return jPanel;
    }

    protected JPanel createEditingShortcutPanel() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0, 6, 6));
        if (this.\u0104 != null && this.\u0104.length > 0) {
            jPanel = new JPanel(new BorderLayout(6, 6));
            this._contextComboBox = new JComboBox<String>(this.\u0104);
            jPanel.add(this._contextComboBox);
            jLabel = new JLabel(this.getResourceBundle().getString("Shortcut.context.text"));
            jLabel.setDisplayedMnemonic(this.getResourceBundle().getString("Shortcut.context.mnemonic").charAt(0));
            jLabel.setLabelFor(this._contextComboBox);
            jPanel.add((Component)jLabel, "First");
            jPanel2.add(jPanel);
        }
        jPanel = new JPanel(new BorderLayout(6, 6));
        this._shortcutField = this.createShortcutField();
        jPanel.add(this._shortcutField);
        jLabel = new JLabel(this.getResourceBundle().getString("Shortcut.pressNew.text"));
        jLabel.setDisplayedMnemonic(this.getResourceBundle().getString("Shortcut.pressNew.mnemonic").charAt(0));
        jLabel.setLabelFor(this._shortcutField);
        jPanel.add((Component)jLabel, "First");
        jPanel2.add(jPanel);
        this._assignButton = new JButton(this.getResourceBundle().getString("Shortcut.assign.text"));
        this._removeButton.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                ShortcutEditor.this._assignButton.setPreferredSize(((Component)componentEvent.getSource()).getSize());
                ShortcutEditor.this._assignButton.setSize(((Component)componentEvent.getSource()).getSize());
                ShortcutEditor.this.revalidate();
                ShortcutEditor.this.doLayout();
            }
        });
        this._assignButton.setMnemonic(this.getResourceBundle().getString("Shortcut.assign.mnemonic").charAt(0));
        this._assignButton.addActionListener(new AbstractAction(){
            private static final long \u0102 = -1557832884751036087L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ShortcutEditor.this.getSelectedShortcutSchema() != null && ShortcutEditor.this.getSelectedCommand() != null) {
                    Shortcut shortcut = ShortcutEditor.this._shortcutField.getShortcut();
                    if (ShortcutEditor.this._contextComboBox != null && ShortcutEditor.this._contextComboBox.getSelectedIndex() != 0) {
                        shortcut.setContext("" + ShortcutEditor.this._contextComboBox.getSelectedItem());
                    } else {
                        shortcut.setContext(null);
                    }
                    List<String> list = ShortcutEditor.this.getSelectedShortcutSchema().findConflicts(ShortcutEditor.this.\u0103, shortcut);
                    if (list.size() != 0) {
                        int n2 = ShortcutEditor.this.isConflictedShortcutsAllowed() ? JOptionPane.showConfirmDialog(ShortcutEditor.this, ShortcutEditor.this.getResourceBundle().getString("Shortcut.configs.message1"), ShortcutEditor.this.getResourceBundle().getString("Shortcut.configs.title"), 1, 3) : JOptionPane.showConfirmDialog(ShortcutEditor.this, ShortcutEditor.this.getResourceBundle().getString("Shortcut.configs.message2"), ShortcutEditor.this.getResourceBundle().getString("Shortcut.configs.title"), 2, 2);
                        if (n2 == 2 || n2 == -1) {
                            return;
                        }
                        if (n2 == 0) {
                            ShortcutEditor.this.getSelectedShortcutSchema().removeConflicts(ShortcutEditor.this.\u0103, shortcut);
                        }
                    }
                    if (!ShortcutEditor.this.\u0105) {
                        ShortcutEditor.this.getSelectedShortcutSchema().clearShortcuts(ShortcutEditor.this.getSelectedCommand());
                    }
                    ShortcutEditor.this.getSelectedShortcutSchema().\u0101(ShortcutEditor.this.getSelectedCommand(), shortcut, !ShortcutEditor.this.\u0105, ShortcutEditor.this.isNewShortcutOnTop());
                    ShortcutEditor.this.selectedCommandChanged(!ShortcutEditor.this.isNewShortcutOnTop());
                }
            }
        });
        jPanel = new JPanel(new BorderLayout(6, 6));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)JideSwingUtilities.createBottomPanel(this._assignButton), "After");
        return jPanel;
    }

    protected ShortcutField createShortcutField() {
        return new ShortcutField();
    }

    protected JPanel createConflictingShortcutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        final JComboBox jComboBox = new JComboBox();
        jComboBox.setEnabled(false);
        jPanel.add(jComboBox);
        final JLabel jLabel = new JLabel(this.getResourceBundle().getString("Shortcut.usedBy.text"));
        jLabel.setDisplayedMnemonic(this.getResourceBundle().getString("Shortcut.usedBy.mnemonic").charAt(0));
        jLabel.setLabelFor(jComboBox);
        jPanel.add((Component)jLabel, "First");
        jLabel.setEnabled(false);
        this._shortcutField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ShortcutEditor.this.\u0101(jComboBox, jLabel);
            }
        });
        if (this._contextComboBox != null) {
            this._contextComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ShortcutEditor.this.\u0101(jComboBox, jLabel);
                }
            });
        }
        return jPanel;
    }

    private void \u0101(JComboBox jComboBox, JLabel jLabel) {
        Shortcut shortcut = this._shortcutField.getShortcut();
        if (this.getSelectedShortcutSchema() != null && shortcut != null && !shortcut.\u0101()) {
            if (this._contextComboBox != null && this._contextComboBox.getSelectedIndex() != 0) {
                shortcut.setContext("" + this._contextComboBox.getSelectedItem());
            } else {
                shortcut.setContext(null);
            }
            List<String> list = this.getSelectedShortcutSchema().findConflicts(this.\u0103, shortcut);
            if (list.size() != 0) {
                jComboBox.setModel(new DefaultComboBoxModel<String>(new Vector<String>(list)));
                jComboBox.setEnabled(true);
                jLabel.setEnabled(true);
            } else {
                jComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{this.getResourceBundle().getString("Shortcut.noConflicts.text")}));
                jComboBox.setEnabled(false);
                jLabel.setEnabled(false);
            }
        } else {
            jComboBox.setModel(new DefaultComboBoxModel());
            jComboBox.setEnabled(false);
            jLabel.setEnabled(false);
        }
        this.updateEditable();
    }

    protected void updateEditable() {
        boolean bl;
        boolean bl2 = bl = this.getSelectedShortcutSchema() != null && this.getSelectedShortcutSchema().isEditable();
        if (this._overriddenOnlyCheckBox != null) {
            this._overriddenOnlyCheckBox.setEnabled(this.getSelectedShortcutSchema() != null && this.getSelectedShortcutSchema().getParent() != null);
        }
        if (this._deleteButton != null) {
            this._deleteButton.setEnabled(bl);
        }
        if (this._removeButton != null) {
            this._removeButton.setEnabled(bl && (this._shortcutsComboBox != null && this._shortcutsComboBox.getSelectedItem() != null || this._shortcutLabel != null && this._shortcutLabel.\u0102() != null));
        }
        if (this._shortcutField != null) {
            this._shortcutField.setEnabled(bl && this.getSelectedCommand() != null);
        }
        if (this._contextComboBox != null) {
            this._contextComboBox.setEnabled(bl && this.getSelectedCommand() != null);
        }
        if (this._assignButton != null && this._shortcutField != null) {
            Shortcut shortcut = this._shortcutField.getShortcut();
            if (bl && shortcut != null && !shortcut.\u0101() && this.getSelectedCommand() != null) {
                this._assignButton.setEnabled(bl);
            } else {
                this._assignButton.setEnabled(false);
            }
        }
    }

    public ShortcutSchema getSelectedShortcutSchema() {
        return this.\u0101;
    }

    public void setSelectedShortcutSchema(ShortcutSchema shortcutSchema) {
        this.\u0101 = shortcutSchema;
    }

    public String getSelectedCommand() {
        return this.\u0103;
    }

    public void setSelectedCommand(String string) {
        this.\u0103 = string;
    }

    public QuickFilterField getFilterField() {
        return this._filterField;
    }

    public boolean isMultipleShortcutsAllowed() {
        return this.\u0105;
    }

    public boolean isConflictedShortcutsAllowed() {
        return this.\u0106;
    }

    public void setConflictedShortcutsAllowed(boolean bl) {
        this.\u0106 = bl;
    }

    public ShortcutField getShortcutField() {
        return this._shortcutField;
    }

    public ShortcutSchemaManager getShortcutSchemaManager() {
        return this.\u0107;
    }

    protected ResourceBundle getResourceBundle() {
        return A.\u0101(this.getLocale());
    }

    public boolean isNewShortcutOnTop() {
        return this.\u0102;
    }

    public void setNewShortcutOnTop(boolean bl) {
        this.\u0102 = bl;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(64)) {
            Lm.showInvalidProductMessage(ShortcutEditor.class.getName(), 64);
        }
    }
}

