/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.xml;

import com.nuodb.impl.util.StringUtils;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;

public class LogTags {
    private static final String[] MASK_STRINGS = new String[]{"debug", "info", "warn", "error", "dump", "stats", "tx", "net", "records", "atoms", "archive", "threads", "gc", "msgs", "security", "scheduler", "sql", "services", "journal", "validate", "ping", "i18n", "failure-detection", "opt-joins", "opt-index-selection", "sql-statements", "sql-params", "histograms", "client-msgs", "bootstrap", "table-events", "flush"};

    public static int encodeMask(String logList) {
        if (StringUtils.isBlank(logList)) {
            return 0;
        }
        int mask = 0;
        for (String logStr : logList.split(",")) {
            if ((logStr = logStr.trim()).equals("")) continue;
            for (int i = 0; i < MASK_STRINGS.length; ++i) {
                if (!MASK_STRINGS[i].equals(logStr)) continue;
                mask |= 1 << i;
            }
        }
        return mask;
    }

    public static String decodeMask(int mask) {
        if (mask == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < MASK_STRINGS.length; ++i) {
            if ((mask & 1 << i) == 0) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(MASK_STRINGS[i]);
        }
        return builder.toString();
    }

    public static Tag createLogMonitorRequest(String options) {
        Tag tag = TagFactory.createTag("Request");
        tag.addAttribute("Service", "Monitor");
        tag.addAttribute("Action", "log");
        if (StringUtils.isBlank(options)) {
            tag.addAttribute("Options", "");
            tag.addAttribute("Mask", 0);
        } else {
            tag.addAttribute("Options", options);
            tag.addAttribute("Mask", LogTags.encodeMask(options));
        }
        return tag;
    }
}

