/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.core;

import com.ibm.db2.cmx.internal.controller.ControllerServerImpl;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastServer {
    String slpServiceURL_;
    MulticastSocket socket_;
    final String ADDRESS = "239.255.255.253";
    int ttl_;
    int port_;
    Thread thread_;
    private static Logger logger__ = Log.getCMXServerLogger();
    private ControllerServerImpl controller_;
    private String jsonURL_;
    private Runnable runnable_ = new MulticastServerRunnable();
    private volatile boolean isShutDown_ = true;

    public MulticastServer(String string, int n2, ControllerServerImpl controllerServerImpl) {
        this.slpServiceURL_ = string;
        this.port_ = n2;
        this.controller_ = controllerServerImpl;
        this.initializeMulticastTtl();
        this.jsonURL_ = "[\"multicastserver\",\"" + this.slpServiceURL_ + "\"]";
    }

    private void initializeMulticastTtl() {
        this.ttl_ = DataProperties.getPropertyInteger(null, "pdq.cmx.multicastTimeToLive", false);
    }

    public void startServer() {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "startServer", "ENTRY " + Arrays.deepToString(new Object[]{this.port_}));
        }
        if (this.thread_ == null || !this.thread_.isAlive()) {
            this.isShutDown_ = false;
            this.thread_ = new Thread(this.runnable_);
            this.thread_.setDaemon(true);
            this.thread_.setName("multicastserver:" + DataLogger.getShortName(this));
            this.thread_.start();
        }
    }

    public void shutDown() {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.enter(logger__, this, "shutDown");
        }
        this.isShutDown_ = true;
        if (this.socket_ != null) {
            this.socket_.close();
        }
        this.thread_ = null;
    }

    public boolean isMulticastServiceActive() {
        return this.socket_ != null ? !this.socket_.isClosed() : false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutDown();
    }

    class MulticastServerRunnable
    implements Runnable {
        MulticastServerRunnable() {
        }

        @Override
        public void run() {
            if (logger__.isLoggable(Level.CONFIG)) {
                DataLogger.logConfigHighVis(logger__, this, "run", "pureQuery controller multicast service started on port: " + MulticastServer.this.port_ + " advertising: " + MulticastServer.this.jsonURL_, false);
            }
            try {
                MulticastServer.this.socket_ = new MulticastSocket(MulticastServer.this.port_);
            }
            catch (IOException iOException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, iOException.getMessage(), iOException, 10642);
            }
            try {
                MulticastServer.this.socket_.setTimeToLive(MulticastServer.this.ttl_);
                InetAddress inetAddress = InetAddress.getByName("239.255.255.253");
                MulticastServer.this.socket_.joinGroup(inetAddress);
                byte[] byArray = new byte[300];
                while (true) {
                    String string;
                    JSONArray jSONArray;
                    String string2;
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    MulticastServer.this.socket_.receive(datagramPacket);
                    String string3 = new String(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength(), "UTF-8");
                    if (string3 == null || !(string2 = (jSONArray = JSONArray.parse(string3)).get(0).toString()).equals("multicastclient")) continue;
                    if (logger__.isLoggable(Level.FINE)) {
                        DataLogger.logConnectedComponents(logger__, this, "run", "pureQuery SLP service received a discovery request from client: " + datagramPacket.getAddress().getHostAddress() + " message: " + string3);
                    }
                    String string4 = string = jSONArray.get(1) == null ? null : jSONArray.get(1).toString();
                    if (string != null && !((MulticastServer)MulticastServer.this).controller_.processor_.registry_.containsKey(string)) continue;
                    String string5 = MulticastServer.this.jsonURL_;
                    byte[] byArray2 = string5.getBytes("UTF-8");
                    DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length, inetAddress, MulticastServer.this.port_);
                    if (logger__.isLoggable(Level.FINE)) {
                        DataLogger.logConnectedComponents(logger__, this, "run", "pureQuery SLP service is replying to a discovery request with message: " + MulticastServer.this.jsonURL_);
                    }
                    MulticastServer.this.socket_.send(datagramPacket2);
                }
            }
            catch (Throwable throwable) {
                if (!MulticastServer.this.isShutDown_) {
                    DataLogger.logTrappedMonitoringException(logger__, this, "run", throwable, "Error running multicast server");
                }
                return;
            }
        }
    }
}

