/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.document.FloatingDocumentContainer;
import com.jidesoft.document.IDocumentGroup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.utils.PersistenceUtilsCallback;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocumentPanePersistenceUtils {
    private static final String \u010d = "DocumentGroup";
    private static final String \u0106 = "FloatingDocumentContainer";
    private static final String \u0111 = "Document";
    private static final String \u0105 = "Bounds";
    private static final String \u010b = "orientation";
    private static final String \u0110 = "proportionLayout";
    private static final String \u0103 = "initiallyEven";
    private static final String \u0104 = "proportion";
    private static final String \u0107 = "activeDocument";
    private static final String \u0102 = "preferredWidth";
    private static final String \u0101 = "preferredHeight";
    private static final String \u010a = "selectedComponent";
    private static final String \u010e = "name";
    private static final String \u010c = "x";
    private static final String \u0109 = "y";
    private static final String \u0108 = "width";
    private static final String \u010f = "height";

    public static void save(DocumentPane documentPane, String string) throws ParserConfigurationException, IOException {
        DocumentPanePersistenceUtils.save(documentPane, string, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DocumentPane documentPane, String string, String string2) throws ParserConfigurationException, IOException {
        DocumentPanePersistenceUtils.save(documentPane, string, string2, null);
    }

    public static void save(final DocumentPane documentPane, final String string, final String string2, final PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = DocumentPanePersistenceUtils.save(documentPane, save);
            PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Document document = DocumentPanePersistenceUtils.save(documentPane, save);
                            PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static void save(DocumentPane documentPane, OutputStream outputStream) throws ParserConfigurationException, IOException {
        DocumentPanePersistenceUtils.save(documentPane, outputStream, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DocumentPane documentPane, OutputStream outputStream, String string) throws ParserConfigurationException, IOException {
        DocumentPanePersistenceUtils.save(documentPane, outputStream, string, null);
    }

    public static void save(DocumentPane documentPane, OutputStream outputStream, String string, PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        Document document = DocumentPanePersistenceUtils.save(documentPane, save);
        PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
    }

    public static Document save(DocumentPane documentPane, PersistenceUtilsCallback.Save save) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        DocumentPanePersistenceUtils.\u0101(documentPane, document, save);
        return document;
    }

    static void \u0101(DocumentPane documentPane, Document document, PersistenceUtilsCallback.Save save) {
        Object object;
        if (documentPane == null || documentPane.getLayoutPersistence() == null) {
            return;
        }
        LayoutPersistence layoutPersistence = documentPane.getLayoutPersistence();
        Node node = document.getElementsByTagName("LayoutPersistence").item(0);
        if (node == null) {
            node = document.createElement("LayoutPersistence");
            document.appendChild(node);
        }
        Element element = document.createElement("DocumentPane");
        node.appendChild(element);
        element.setAttribute("version", "" + layoutPersistence.getVersion());
        if (layoutPersistence.getLayoutPersistenceName() != null) {
            element.setAttribute("persistenceName", layoutPersistence.getLayoutPersistenceName());
        }
        element.setAttribute(\u010b, "" + documentPane.getOrientation());
        element.setAttribute(\u0110, documentPane.isProportionalLayout() ? "1" : "0");
        element.setAttribute(\u0103, documentPane.isInitiallyEven() ? "1" : "0");
        if (documentPane.getProportions() != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (double d2 : documentPane.getProportions()) {
                stringBuffer.append(d2).append(';');
            }
            element.setAttribute(\u0104, "" + stringBuffer.substring(0, stringBuffer.length() - 1));
        }
        element.setAttribute(\u0107, "" + documentPane.getActiveDocumentName());
        for (int i2 = 0; i2 < documentPane.getPaneCount(); ++i2) {
            object = documentPane.getDocumentGroupAt(i2);
            DocumentPanePersistenceUtils.\u0101(document, element, documentPane, (IDocumentGroup)object, save);
        }
        List<FloatingDocumentContainer> list = documentPane.getFloatingContainers();
        if (list != null && list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                FloatingDocumentContainer floatingDocumentContainer = (FloatingDocumentContainer)object.next();
                DocumentPanePersistenceUtils.\u0101(document, element, documentPane, floatingDocumentContainer, save);
            }
        }
    }

    private static void \u0101(Document document, Element element, DocumentPane documentPane, FloatingDocumentContainer floatingDocumentContainer, PersistenceUtilsCallback.Save save) {
        Object object;
        if (floatingDocumentContainer == null) {
            return;
        }
        Element element2 = document.createElement(\u0106);
        element.appendChild(element2);
        Rectangle rectangle = floatingDocumentContainer.getBounds();
        if (rectangle != null) {
            object = document.createElement(\u0105);
            element2.appendChild((Node)object);
            object.setAttribute(\u010c, "" + rectangle.x);
            object.setAttribute(\u0109, "" + rectangle.y);
            object.setAttribute(\u0108, "" + rectangle.width);
            object.setAttribute(\u010f, "" + rectangle.height);
        }
        object = floatingDocumentContainer.getDocumentGroup();
        DocumentPanePersistenceUtils.\u0101(document, element2, documentPane, (IDocumentGroup)object, save);
        if (save != null) {
            save.save(document, element2, floatingDocumentContainer);
        }
    }

    private static void \u0101(Document document, Element element, DocumentPane documentPane, IDocumentGroup iDocumentGroup, PersistenceUtilsCallback.Save save) {
        if (iDocumentGroup == null) {
            return;
        }
        Element element2 = document.createElement(\u010d);
        element.appendChild(element2);
        Dimension dimension = ((JComponent)((Object)iDocumentGroup)).getPreferredSize();
        element2.setAttribute(\u0102, "" + dimension.width);
        element2.setAttribute(\u0101, "" + dimension.height);
        element2.setAttribute(\u010a, "" + documentPane.getNameOf(iDocumentGroup.getSelectedDocument()));
        int n2 = iDocumentGroup.getDocumentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = iDocumentGroup.getDocumentAt(i2);
            if (component == null) continue;
            Element element3 = document.createElement(\u0111);
            element2.appendChild(element3);
            String string = documentPane.getNameOf(component);
            element3.setAttribute(\u010e, string);
            if (save == null) continue;
            save.save(document, element3, iDocumentGroup);
        }
        if (save != null) {
            save.save(document, element2, iDocumentGroup);
        }
    }

    public static void load(DocumentPane documentPane, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentPanePersistenceUtils.load(documentPane, inputStream, null);
    }

    public static void load(DocumentPane documentPane, InputStream inputStream, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        DocumentPanePersistenceUtils.load(documentPane, PersistenceUtils.getDocument(inputStream), load);
    }

    public static void load(DocumentPane documentPane, String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentPanePersistenceUtils.load(documentPane, string, null);
    }

    public static void load(DocumentPane documentPane, String string, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        DocumentPanePersistenceUtils.load(documentPane, PersistenceUtils.getDocument(string), load);
    }

    public static void load(final DocumentPane documentPane, final Document document, final PersistenceUtilsCallback.Load load) {
        if (SwingUtilities.isEventDispatchThread()) {
            DocumentPanePersistenceUtils.\u0101(documentPane, document, load);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentPanePersistenceUtils.\u0101(documentPane, document, load);
                }
            });
        }
    }

    static boolean \u0101(DocumentPane documentPane, Document document, PersistenceUtilsCallback.Load load) {
        if (documentPane == null || documentPane.getLayoutPersistence() == null) {
            return false;
        }
        if (document == null) {
            documentPane.getLayoutPersistence().resetToDefault();
            return false;
        }
        try {
            Object object;
            int n2;
            Object object2;
            Object object3;
            String string;
            Object object4;
            Object object5;
            Node node = document.getElementsByTagName("LayoutPersistence").item(0);
            Node node2 = null;
            if (node != null) {
                object5 = node.getChildNodes();
                for (int i2 = 0; i2 < object5.getLength(); ++i2) {
                    object4 = object5.item(i2);
                    if (!"DocumentPane".equals(object4.getNodeName())) continue;
                    string = null;
                    object3 = object4.getAttributes();
                    for (int i3 = 0; i3 < object3.getLength(); ++i3) {
                        object2 = object3.item(i3);
                        if (!"persistenceName".equals(object2.getNodeName())) continue;
                        string = object2.getNodeValue();
                        break;
                    }
                    if (!JideSwingUtilities.equals(string, documentPane.getLayoutPersistence().getLayoutPersistenceName())) continue;
                    node2 = object4;
                    break;
                }
            }
            if (node2 == null) {
                documentPane.getLayoutPersistence().resetToDefault();
                return false;
            }
            object5 = null;
            String string2 = null;
            object4 = null;
            string = null;
            object3 = null;
            String string3 = null;
            object2 = node2.getAttributes();
            for (n2 = 0; n2 < object2.getLength(); ++n2) {
                object = object2.item(n2);
                if ("version".equals(object.getNodeName())) {
                    object5 = object.getNodeValue();
                    continue;
                }
                if (\u010b.equals(object.getNodeName())) {
                    string2 = object.getNodeValue();
                    continue;
                }
                if (\u0107.equals(object.getNodeName())) {
                    object4 = object.getNodeValue();
                    continue;
                }
                if (\u0104.equals(object.getNodeName())) {
                    string = object.getNodeValue();
                    continue;
                }
                if (\u0110.equals(object.getNodeName())) {
                    object3 = object.getNodeValue();
                    continue;
                }
                if (!\u0103.equals(object.getNodeName())) continue;
                string3 = object.getNodeValue();
            }
            if (object5 != null) {
                documentPane.getLayoutPersistence().setVersion(Short.valueOf((String)object5));
            }
            if (string2 != null) {
                documentPane.setOrientation(Integer.valueOf(string2));
            }
            documentPane.setProportionalLayout("1".equals(object3));
            if (documentPane.isProportionalLayout()) {
                documentPane.setInitiallyEven("1".equals(string3));
                if (string != null) {
                    String[] stringArray = string.split(";");
                    object = new double[stringArray.length];
                    for (int i4 = 0; i4 < ((Object)object).length; ++i4) {
                        object[i4] = Double.valueOf(stringArray[i4]);
                    }
                    documentPane.setProportions((double[])object);
                }
            }
            if (documentPane.\u01ad == null) {
                documentPane.\u01ad = new ArrayList<DocumentComponent>();
                for (n2 = 0; n2 < documentPane.getDocumentCount(); ++n2) {
                    documentPane.\u01ad.add(documentPane.getDocumentAt(n2));
                }
            }
            documentPane.\u0108(true);
            NodeList nodeList = node2.getChildNodes();
            for (int i5 = 0; i5 < nodeList.getLength(); ++i5) {
                Node node3 = nodeList.item(i5);
                if (\u010d.equals(node3.getNodeName())) {
                    IDocumentGroup iDocumentGroup = documentPane.createDocumentGroup();
                    DocumentPanePersistenceUtils.\u0101(document, documentPane, iDocumentGroup, node3, load);
                    if (iDocumentGroup.getDocumentCount() <= 0) continue;
                    documentPane.add((Component)((JComponent)((Object)iDocumentGroup)), "flexible");
                    continue;
                }
                if (!\u0106.equals(node3.getNodeName())) continue;
                documentPane.\u01bc.add(DocumentPanePersistenceUtils.\u0101(document, documentPane, node3, load));
            }
            if (object4 != null && documentPane.isDocumentOpened((String)object4)) {
                documentPane.setActiveDocument((String)object4);
            }
            documentPane.\u010f();
            return true;
        }
        catch (Exception exception) {
            documentPane.getLayoutPersistence().resetToDefault();
            return false;
        }
    }

    private static Rectangle \u0101(Node node) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            Node node2 = namedNodeMap.item(i2);
            if (\u010c.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (\u0109.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (\u0108.equals(node2.getNodeName())) {
                string3 = node2.getNodeValue();
                continue;
            }
            if (!\u010f.equals(node2.getNodeName())) continue;
            string4 = node2.getNodeValue();
        }
        Rectangle rectangle = new Rectangle();
        if (string != null) {
            rectangle.x = Integer.valueOf(string);
        }
        if (string2 != null) {
            rectangle.y = Integer.valueOf(string2);
        }
        if (string3 != null) {
            rectangle.width = Integer.valueOf(string3);
        }
        if (string4 != null) {
            rectangle.height = Integer.valueOf(string4);
        }
        return rectangle;
    }

    private static FloatingDocumentContainer \u0101(Document document, DocumentPane documentPane, Node node, PersistenceUtilsCallback.Load load) {
        FloatingDocumentContainer floatingDocumentContainer = documentPane.createFloatingDocumentContainer();
        IDocumentGroup iDocumentGroup = floatingDocumentContainer.getDocumentGroup();
        Rectangle rectangle = null;
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            if (\u0105.equals(node2.getNodeName())) {
                rectangle = DocumentPanePersistenceUtils.\u0101(node2);
                continue;
            }
            if (!\u010d.equals(node2.getNodeName())) continue;
            DocumentPanePersistenceUtils.\u0101(document, documentPane, iDocumentGroup, node2, load);
        }
        if (iDocumentGroup.getDocumentCount() > 0) {
            floatingDocumentContainer.pack();
            if (rectangle != null) {
                floatingDocumentContainer.setBounds(rectangle);
            }
            floatingDocumentContainer.setVisible(true);
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, floatingDocumentContainer);
        }
        return floatingDocumentContainer;
    }

    private static DocumentComponent \u0102(Document document, DocumentPane documentPane, Node node, PersistenceUtilsCallback.Load load) {
        Object object;
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            object = namedNodeMap.item(i2);
            if (!\u010e.equals(object.getNodeName())) continue;
            string = object.getNodeValue();
        }
        if (string == null || string.length() <= 0) {
            return null;
        }
        DocumentComponent documentComponent = documentPane.\u0101(string);
        if (documentComponent == null && (object = documentPane.getDocumentComponentFactory()) != null && (documentComponent = object.create(string)) != null) {
            documentPane.\u01ad.add(documentComponent);
        }
        if (documentComponent != null) {
            documentComponent.setDocumentPane(documentPane);
            documentPane.\u0101(documentComponent);
            documentComponent.\u0101(5999);
            documentComponent.\u0101(6006);
            documentComponent.getComponent().setPreferredSize(new Dimension(200, 200));
            if (load != null && node instanceof Element) {
                load.load(document, (Element)node, documentComponent);
            }
        }
        return documentComponent;
    }

    private static void \u0101(Document document, DocumentPane documentPane, IDocumentGroup iDocumentGroup, Node node, PersistenceUtilsCallback.Load load) {
        DocumentComponent documentComponent;
        String string = null;
        String string2 = null;
        String string3 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            Node node2 = namedNodeMap.item(i2);
            if (\u0102.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (\u0101.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (!\u010a.equals(node2.getNodeName())) continue;
            string3 = node2.getNodeValue();
        }
        if (string != null && string2 != null) {
            ((JComponent)((Object)iDocumentGroup)).setPreferredSize(new Dimension(Integer.valueOf(string), Integer.valueOf(string2)));
        }
        NodeList nodeList = node.getChildNodes();
        for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
            DocumentComponent documentComponent2;
            Node node3 = nodeList.item(i3);
            if (!\u0111.equals(node3.getNodeName()) || (documentComponent2 = DocumentPanePersistenceUtils.\u0102(document, documentPane, node3, load)) == null) continue;
            iDocumentGroup.addDocument(documentComponent2);
        }
        if (string3 != null && (documentComponent = documentPane.\u0101(string3)) != null) {
            iDocumentGroup.setSelectedDocument(documentComponent.getComponent());
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, iDocumentGroup);
        }
    }
}

