/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.controller;

import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.internal.controller.ControlDataSource;
import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import java.util.concurrent.locks.ReentrantLock;

public class CompositeControlDataSourceImpl
implements ControlDataSource {
    private ControlDataSourceImpl cds_ = null;
    private ControlDataSourceImpl httpcds_ = null;
    private int version_ = 0;
    private int lastKnownCDSVersion_ = 0;
    private int lastKnownHttpCDSVersion_ = 0;
    private ReentrantLock lock_ = new ReentrantLock();

    @Override
    public ControllerAgent getControllerAgent() {
        if (this.httpcds_ != null) {
            return this.httpcds_.getControllerAgent();
        }
        if (this.cds_ != null) {
            return this.cds_.getControllerAgent();
        }
        return null;
    }

    public void updateControlDataSources(ControlDataSourceImpl controlDataSourceImpl, ControlDataSourceImpl controlDataSourceImpl2) {
        ControlDataSourceImpl controlDataSourceImpl3 = null;
        this.lock_.lock();
        if (this.cds_ != null) {
            controlDataSourceImpl3 = this.cds_;
            controlDataSourceImpl3.lock();
            this.cds_ = controlDataSourceImpl;
            controlDataSourceImpl3.unlock();
        } else {
            this.cds_ = controlDataSourceImpl;
        }
        if (this.httpcds_ != null) {
            controlDataSourceImpl3 = this.httpcds_;
            controlDataSourceImpl3.lock();
            this.httpcds_ = controlDataSourceImpl2;
            controlDataSourceImpl3.unlock();
        } else {
            this.httpcds_ = controlDataSourceImpl2;
        }
        this.lock_.unlock();
    }

    @Override
    public void doInitialLookup(boolean bl2) throws Exception {
        if (bl2 || !this.cds_.hasInitialLookupOccurred()) {
            this.cds_.doInitialLookup(true);
        }
        ControlDriver.getInstance().doRegisterDriverLookup(bl2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVersion() {
        boolean bl2 = false;
        int n2 = 0;
        ReentrantLock reentrantLock = this.lock_;
        synchronized (reentrantLock) {
            n2 = this.cds_.getVersion();
            if (n2 > this.lastKnownCDSVersion_) {
                this.lastKnownCDSVersion_ = n2;
                bl2 = true;
            }
            if (this.httpcds_ != null && (n2 = this.httpcds_.getVersion()) > this.lastKnownHttpCDSVersion_) {
                this.lastKnownHttpCDSVersion_ = n2;
                bl2 = true;
            }
            if (bl2) {
                ++this.version_;
            }
        }
        return this.version_;
    }

    @Override
    public String getPropertyValue(String string, String string2) {
        String string3 = this.cds_.getPropertyValue(string, string2);
        if (this.httpcds_ != null && this.httpcds_.containsPropertyValue(string)) {
            string3 = this.httpcds_.getPropertyValue(string, string2);
        }
        return string3;
    }

    @Override
    public int getPropertyValue(String string, int n2) {
        int n3 = this.cds_.getPropertyValue(string, n2);
        if (this.httpcds_ != null && this.httpcds_.containsPropertyValue(string)) {
            n3 = this.httpcds_.getPropertyValue(string, n2);
        }
        return n3;
    }

    @Override
    public int getMatchingKeySet() {
        int n2 = this.cds_.getMatchingKeySet();
        if (this.httpcds_ != null && n2 <= 0) {
            n2 = this.httpcds_.getMatchingKeySet();
        }
        return n2;
    }

    @Override
    public boolean hasInitialLookupOccurred() {
        boolean bl2 = false;
        boolean bl3 = true;
        bl2 = this.cds_.hasInitialLookupOccurred();
        if (this.httpcds_ != null) {
            bl3 = this.httpcds_.hasInitialLookupOccurred();
        }
        return bl2 && bl3;
    }

    @Override
    public void updateCDS(String string, String string2, String string3, String string4, String string5) {
        if (this.httpcds_ != null) {
            this.httpcds_.updateCDS(string, string2, string3, string4, string5);
        }
    }

    @Override
    public void lock() {
        this.lock_.lock();
        this.cds_.lock();
        if (this.httpcds_ != null) {
            this.httpcds_.lock();
        }
    }

    @Override
    public void unlock() {
        if (this.httpcds_ != null) {
            this.httpcds_.unlock();
        }
        this.cds_.unlock();
        this.lock_.unlock();
    }

    @Override
    public void sendDeregisterDataSource(String string) {
        if (this.httpcds_ != null) {
            this.httpcds_.sendDeregisterDataSource(string);
        }
    }

    @Override
    public Profile.DataSource getDataSourceProfile() {
        if (this.httpcds_ != null) {
            return this.httpcds_.getDataSourceProfile();
        }
        return null;
    }

    @Override
    public String getDataSourceId() {
        if (this.httpcds_ != null) {
            return this.httpcds_.getDataSourceId();
        }
        return null;
    }

    @Override
    public int getOPMControllerVersion() {
        return this.cds_.getControllerAgent().getNegotiatedVersion();
    }

    @Override
    public void updateCDSWithMonitorDataFromSP(String string) {
        this.cds_.updateCDSWithMonitorDataFromSP(string);
    }

    @Override
    public int getMonitorEnabledFromCmxDirectives(int n2) {
        if (this.httpcds_ != null) {
            return this.httpcds_.getMonitorEnabledFromCmxDirectives(n2);
        }
        return n2;
    }

    @Override
    public int getMonitorCollectionIntervalFromCmxDirectives(int n2) {
        if (this.httpcds_ != null) {
            return this.httpcds_.getMonitorCollectionIntervalFromCmxDirectives(n2);
        }
        return n2;
    }
}

