/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.formcomponents.LogFileTailer;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.util.MinimumSizeTextArea;
import com.install4j.runtime.util.TextAreaScrollPane;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class LogFileViewerComponent
extends LeadingLabelComponent
implements LogFileTailer.TailListener {
    private File file;
    private String encoding = "";
    private int rows = 5;
    private boolean fillVertical = false;
    private boolean useLabelFont = false;
    private int maxLines = 1000;
    private JTextArea textArea;
    private LogFileTailer logFileTailer;

    public File getFile() {
        return this.replaceWithTextOverride("file", LogFileViewerComponent.replaceVariables(this.file), File.class);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getEncoding() {
        return LogFileViewerComponent.replaceVariables(LogFileViewerComponent.replaceVariables(this.encoding));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getRows() {
        return this.replaceWithTextOverride("rows", this.rows);
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public boolean isFillVertical() {
        return this.replaceWithTextOverride("fillVertical", this.fillVertical);
    }

    public void setFillVertical(boolean fillVertical) {
        this.fillVertical = fillVertical;
    }

    public boolean isUseLabelFont() {
        return this.replaceWithTextOverride("useLabelFont", this.useLabelFont);
    }

    public void setUseLabelFont(boolean useLabelFont) {
        this.useLabelFont = useLabelFont;
    }

    public int getMaxLines() {
        return this.replaceWithTextOverride("maxLines", this.maxLines);
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    @Override
    public JComponent createCenterComponent() {
        this.textArea = new MinimumSizeTextArea();
        this.textArea.setEditable(false);
        if (this.getRows() > 0) {
            this.textArea.setRows(this.getRows());
        }
        if (this.isUseLabelFont()) {
            this.textArea.setFont(UIManager.getFont("Label.font"));
        }
        return new TextAreaScrollPane(this.textArea, false);
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public boolean isFillCenterVertical() {
        return this.isFillVertical();
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JTextArea.class;
    }

    @Override
    protected boolean isLeadingLabelTopAligned() {
        return true;
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        this.logFileTailer = new LogFileTailer(this.getContext().getDestinationFile(this.getFile()), this.getCharset(), this.getMaxLines(), this);
        this.logFileTailer.start();
    }

    @NotNull
    private Charset getCharset() {
        return this.getEncoding().isEmpty() ? Charset.defaultCharset() : Charset.forName(this.getEncoding());
    }

    @Override
    public void formDeactivated() {
        super.formDeactivated();
        if (this.logFileTailer != null) {
            this.logFileTailer.interrupt();
            this.logFileTailer = null;
        }
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.textArea != null && formEnvironment != null) {
            this.textArea.setName(formEnvironment.getId(this));
        }
    }

    private File getUsedFile() {
        return this.getContext().getDestinationFile(this.getFile());
    }

    @Override
    public void setText(final @NotNull String text) {
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogFileViewerComponent.this.textArea.setText(text);
                LogFileViewerComponent.this.scrollToBottom();
            }
        });
    }

    @Override
    public void addText(final @NotNull String text) {
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                Document document = LogFileViewerComponent.this.textArea.getDocument();
                try {
                    document.insertString(document.getLength(), text, null);
                    LogFileViewerComponent.this.scrollToBottom();
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void removeFirstLine() {
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlainDocument document = (PlainDocument)LogFileViewerComponent.this.textArea.getDocument();
                Element firstLine = document.getDefaultRootElement().getElement(0);
                try {
                    document.remove(firstLine.getStartOffset(), firstLine.getEndOffset());
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void scrollToBottom() {
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }
}

